{$A+,B-,D-,F-,G+,I+,K+,L-,N+,P+,Q-,R-,S+,T+,V-,W-,X+,Y-}
unit UUCode;
(*
  UUCODE 1.0 (Public Domain)
  Borland Pascal (Objects) 7.01
  Copr. (c) 1995-04-27 Robert E. Swart (100434.2072@compuserve.com)
                       P.O. box 799
                       5702 NP  Helmond
                       The Netherlands
  -----------------------------------------------------------------
  This DLL implements 4 functions; UUEncode, UUDecode and UUEncoder
  and UUDecoder for usage with Delphi or Borland Pascal for Windows
  or DPMI programs.
  The UU-routines are capable of working in other environments like
  C/C++ and VB, but remember to declare them as FAR PASCAL.
  NB: PChar is just a null-terminated string (LPSTR in C/C++).

  Example Usage:
    UUEncode('MyFile.Ext'); { result in ',MyFile.UUE' }
    UUDecode('MyFile.UUE'); { original back in 'MyFile.Ext' }
    UUEncoder('MyFile.Ext','Other.XXX',0644,False,CallBack);
*)
interface
Type
  TCallBack = procedure (Position, Size: LongInt); { export; }

Const
  UUCodeLoaded: Boolean = False; { presume nothing! }

var UUEncode: function(FileName: PChar): Word;
    {
     UUEncodes the file FileName, replacing the extension of FileName
     with .UUE for the uuencoded output file.

     Return Codes:
        0: OK
        1: input file is output file
        2: input file does not exist
        3: output file exists
        4: could not create output file
        5: DLL bussy, try again later (shared buffers)
    }

    UUDecode: function(FileName: PChar): Word;
    {
     UUDecodes every uuencoded file in file FileName (you must supply
     the .UUE extension for the input file yourself).  Reading from a
     Unix-style uuencoded file is transparent.

     Return Codes:
        0: OK
        1: input file is output file
        2: input file does not exist
        3: output file exists
        4: could not create output file
        5: DLL bussy, try again later (shared buffers)
    }

    UUEncoder: function(InFile,OutFile: PChar; Flag: Word; Unix: Boolean;
                        CallBack: TCallBack): Word;
    {
     UUEncodes the file InFile, placing the output in OutFile. Uses flag
     for 'begin 0xxx' code. If Unix is true, then LF will be used as end-
     of-line character (instead of CR-LF).
     UUEncode (see above) is just a default shell around UUEncoder.
     During the UUDecoding process, the CallBack routine is called.

     Return Codes:
        0: OK
        1: input file is output file
        2: input file does not exist
        3: output file exists
        4: could not create output file
        5: DLL bussy, try again later (shared buffers)
    }

    UUDecoder: function(FileName: PChar;
                        CallBack: TCallBack): Word;
    {
     UUDecodes every uuencoded file in file FileName (you must supply
     the .UUE extension for the input file yourself).  Reading from a
     Unix-style uuencoded file is transparent.
     During the UUDecoding process, the CallBack routine is called.

     Return Codes:
        0: OK
        1: input file is output file
        2: input file does not exist
        3: output file exists
        4: could not create output file
        5: DLL bussy, try again later (shared buffers)
    }

implementation
{$IFDEF WINDOWS}
uses WinProcs;
Const SEM_NoOpenFileErrorBox = $8000;
{$ELSE}
uses WinAPI;
{$ENDIF}

var SaveExit: pointer;
    DLLHandle: Word;

    procedure NewExit; far;
    begin
      ExitProc := SaveExit;
      FreeLibrary(DLLHandle)
    end {NewExit};

begin
  {$IFDEF WINDOWS}
  SetErrorMode(SEM_NoOpenFileErrorBox);
  {$ENDIF}
  DLLHandle := LoadLibrary('UUCODE.DLL');
  if DLLHandle >= 32 then
  begin
    UUCodeLoaded := True;
    SaveExit := ExitProc;
    ExitProc := @NewExit;
    @UUEncode := GetProcAddress(DLLHandle,'UUENCODE');
    @UUDecode := GetProcAddress(DLLHandle,'UUDECODE');
    @UUEncoder := GetProcAddress(DLLHandle,'UUENCODER');
    @UUDecoder := GetProcAddress(DLLHandle,'UUDECODER')
  end
end.
