unit TDosEnv;
interface
uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DrBob;

type
  TDosEnvironment = class(TDrBob)
  public
  { Public class declarations (override) }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

  private
  { Private field declarations }
    FDosEnvList: TStringList;
    procedure DoNothing(Const Value: TStringList);

  protected
  { Protected method declarations }
    Dummy: Word;
    function GetDosEnvCount: Word;

  public
  { Public interface declarations }
    function GetDosEnvStr(Const Name: String): String;
    { This function is a modified version of the GetEnvVar function that
      appears in the WinDos unit that comes with Delphi. This function's
      interface uses Pascal strings instead of null-terminated strings.
    }

  published
  { Published design declarations }
    property DosEnvCount: Word read GetDosEnvCount write Dummy;
    property DosEnvList: TStringList read FDosEnvList write DoNothing;
  end;

implementation

  constructor TDosEnvironment.Create(AOwner: TComponent);
  var P: PChar;
      i: Integer;
  begin
    inherited Create(AOwner);
    FDosEnvList := TStringList.Create;
    P := GetDosEnvironment; { Win API }
    i := 0;
    while P^ <> #0 do
    begin
      Inc(i);
      FDosEnvList.Add(StrPas(P));
      Inc(P, StrLen(P)+1) { Fast Jump to Next Var }
    end;
    FAbout := 'TDosEnvironment (c) 1996 by Bob Swart (aka Dr.Bob - 100434,2072)'
  end {Create};

  destructor TDosEnvironment.Destroy;
  begin
    FDosEnvList.Free;
    FDosEnvList := nil;
    inherited Destroy
  end {Destroy};

  procedure TDosEnvironment.DoNothing(Const Value: TStringList);
  begin
    MessageDlg('TDosEnvironment.DosEnvList is read-only!', mtInformation, [mbOk], 0)
  end {DoNothing};


  function TDosEnvironment.GetDosEnvCount: Word;
  { Returns the number of environment variables.
  }
  begin
    if Assigned(FDosEnvList) then {!!} Result := FDosEnvList.Count
    else
      Result := 0;
  end {GetDosEnvCount};

  function TDosEnvironment.GetDosEnvStr(Const Name: String): String;
  { This function is a modified version of the GetEnvVar function that
    appears in the WinDos unit that comes with Delphi. This function's
    interface uses Pascal strings instead of null-terminated strings.
  }
  var i: Integer;
      Tmp: String;
      Len: Byte absolute Name;
  begin
    i := 0;
    Result := '';
    if Assigned(FDosEnvList) then {!!} while i < FDosEnvList.Count do
    begin
      Tmp := FDosEnvList[i];
      Inc(i);
      if Pos(Name,Tmp) = 1 then
      begin
        Delete(Tmp,1,Len);
        if Tmp[1] = '=' then
        begin
          Delete(Tmp,1,1);
          Result := Tmp;
          i := FDosEnvList.Count { end while-loop }
        end
      end
    end
  end {GetDosEnvStr};
end.
