unit TBUUCode;
{ TBUUCode version 2.1 }
interface
uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls, Forms,
  DrBob;

type
  EUUCode = class(Exception);

  TErrorEvent = procedure(Error: Word) of Object;
  TSuccessEvent = procedure of Object;


  TBUUEncode = class(TDrBob)
  public
  { Public class declarations (override) }
    constructor Create(AOwner: TComponent); override;

  private
  { Private field declarations }
    FActivate: Boolean;
    FOnError: TErrorEvent;
    FOnSuccess: TSuccessEvent;
    FInputFileName: TFileName;
    FOutputFileName: TFileName;

  protected
  { Protected method declarations }
    function InputFilePChar: PChar;
    function OutputFilePChar: PChar;

  protected
  { Protected activation methods }
    procedure Activation(Engage: Boolean);

  public
  { Public interface declarations }
    procedure UUEncode;

  published
  { Published design declarations }
    property InputFile:  TFileName read FInputFileName write FInputFileName;
    property OutputFile: TFileName read FOutputFileName write FOutputFileName;

  published
  { Published activation properties }
    property Activate: Boolean read FActivate write Activation;

  published
  { Published Event properties }
    property OnError: TErrorEvent read FOnError write FOnError;
    property OnSuccess: TSuccessEvent read FOnSuccess write FOnSuccess;
  end;


  TBUUDeCode = class(TDrBob)
  public
  { Public class declarations (override) }
    constructor Create(AOwner: TComponent); override;

  private
  { Private field declarations }
    FActivate: Boolean;
    FOnError: TErrorEvent;
    FOnSuccess: TSuccessEvent;
    FInputFileName: TFileName;

  protected
  { Protected method declarations }
    function InputFilePChar: PChar;

  protected
  { Protected activation methods }
    procedure Activation(Engage: Boolean);

  public
  { Public interface declarations }
    procedure UUDecode;

  published
  { Published design declarations }
    property InputFile:  TFileName read FInputFileName write FInputFileName;

  published
  { Published activation properties }
    property Activate: Boolean read FActivate write Activation;

  published
  { Published Event properties }
    property OnError: TErrorEvent read FOnError write FOnError;
    property OnSuccess: TSuccessEvent read FOnSuccess write FOnSuccess;
  end;

implementation
uses UUCode, FileName, DsgnIntf;


  constructor TBUUEnCode.Create(AOwner: TComponent);
  begin
    if not UUCodeLoaded then
      raise EUUCode.Create('TBUUEnCode: UUCode.DLL not loaded');
    inherited Create(AOwner);
    FActivate := False;
    FAbout := 'TBUUEnCode 2.1 (c) 1996 by Bob Swart (aka Dr.Bob - 100434,2072)'
  end {Create};

  function TBUUEnCode.InputFilePChar: PChar;
  begin
    Result := StrPCopy(@FInputFileName[1],FInputFileName)
  end {InputFilePChar};

  function TBUUEnCode.OutputFilePChar: PChar;
  begin
    Result := StrPCopy(@FOutputFileName[1],FOutputFileName)
  end {OutputFilePChar};

  procedure TBUUEnCode.Activation(Engage: Boolean);
  begin
    if Engage then
    begin
      FActivate := True;
      Application.ProcessMessages;
      UUEncode;
      FActivate := False
    end
  end {Activate};

  procedure TBUUEnCode.UUEncode;
  var Error: Word;
  begin
    if FInputFileName = '' then raise EUUCode.Create('InputFileName is empty');
    if FOutputFileName = '' then raise EUUCode.Create('OutputFileName is empty');
    Error := UUEncoder(InputFilePChar,OutputFilePChar,664,False,nil);
    if Error <> 0 then
    begin
      if Assigned(FOnError) then FOnError(Error)
      else
      begin
        case Error of
          1: raise EUUCode.Create('UUEnCode: input file is output file');
          2: raise EUUCode.Create('UUEnCode: input file does not exist');
          3: raise EUUCode.Create('UUEnCode: output file exists');
          4: raise EUUCode.Create('UUEnCode: could not create output file');
          5: raise EUUCode.Create('UUEnCode: DLL bussy, try again later (shared buffers)')
        end
      end
    end
    else { sucess! }
      if Assigned(FOnSuccess) then FOnSuccess
  end {UUEncode};



  constructor TBUUDeCode.Create(AOwner: TComponent);
  begin
    if not UUCodeLoaded then
      raise EUUCode.Create('TBUUDeCode: UUCode.DLL not loaded');
    inherited Create(AOwner);
    FActivate := False;
    FAbout := 'TBUUDeCode 2.1 (c) 1996 by Bob Swart (aka Dr.Bob - 100434,2072)'
  end {Create};

  function TBUUDeCode.InputFilePChar: PChar;
  begin
    Result := StrPCopy(@FInputFileName[1],FInputFileName)
  end {InputFilePChar};

  procedure TBUUDeCode.Activation(Engage: Boolean);
  begin
    if Engage then
    begin
      FActivate := True;
      Application.ProcessMessages;
      UUDecode;
      FActivate := False
    end
  end {Activate};

  procedure TBUUDeCode.UUDecode;
  var WorkDir: String;
      Error: Word;
  begin
    if FInputFileName = '' then raise EUUCode.Create('InputFileName is empty');
    WorkDir := ExtractFilePath(FInputFileName);
    if WorkDir[Length(WorkDir)] = '\' then Delete(WorkDir,Length(WorkDir),1);
    ChDir(WorkDir);
    Error := UUDecoder(InputFilePChar,nil);
    if Error <> 0 then
    begin
      if Assigned(FOnError) then FOnError(Error)
      else
      begin
        case Error of
          1: raise EUUCode.Create('UUDeCode: input file is output file');
          2: raise EUUCode.Create('UUDeCode: input file does not exist');
          3: raise EUUCode.Create('UUDeCode: output file exists');
          4: raise EUUCode.Create('UUDeCode: could not create output file');
          5: raise EUUCode.Create('UUDeCode: DLL bussy, try again later (shared buffers)')
        end
      end
    end
    else { sucess! }
      if Assigned(FOnSuccess) then FOnSuccess
  end {UUDecode};
end.
