unit PictEdit;
interface
uses DsgnIntf;

Type
  TPictureEditor = class(TClassProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

  procedure Register;

implementation
uses SysUtils, Controls, Graphics, TypInfo, ImageFrm;

  function TPictureEditor.GetAttributes: TPropertyAttributes;
  begin
    Result := [paDialog]
  end {GetAttributes};

  procedure TPictureEditor.Edit;
  begin
    with TImageForm.Create(nil) do
    try
      ImageDrBob.Picture := TPicture(GetOrdValue);
      if ShowModal = mrOk then
      begin
        if (GetPropType^.Name = 'TPicture') then
          SetOrdValue(LongInt(ImageDrBob.Picture))
        else { Bitmap }
          SetOrdValue(LongInt(ImageDrBob.Picture.Bitmap))
      end
    finally
      Free
    end
  end {Edit};

  procedure Register;
  begin
    RegisterPropertyEditor(TypeInfo(TPicture), nil,
                           '', TPictureEditor);
    RegisterPropertyEditor(TypeInfo(TBitmap), nil,
                           '', TPictureEditor)
  end;
end.