unit Imagefrm;
interface
uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinTypes, WinProcs,
{$ENDIF}
  SysUtils, Messages, Classes, Graphics, Controls, Forms, Dialogs, ExtCtrls,
  StdCtrls, Buttons, Outline, DirOutln, FileCtrl, Grids;

type
  TImageForm = class(TForm)
    LabelDrives: TLabel;
    DriveComboBox: TDriveComboBox;
    LabelDirs: TLabel;
    DirectoryOutline: TDirectoryOutline;
    LabelFiles: TLabel;
    FileListBox: TFileListBox;
    Path: TLabel;
    OkBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    ImageDrBob: TImage;
    Stretch: TCheckBox;
    procedure DirectoryOutlineChange(Sender: TObject);
    procedure DriveComboBoxChange(Sender: TObject);
    procedure FileListBoxDblClick(Sender: TObject);
    procedure FileListBoxChange(Sender: TObject);
    procedure StretchClick(Sender: TObject);
  end;

Const
  ImageForm: TImageForm = nil;

implementation
{$R *.DFM}

procedure TImageForm.DriveComboBoxChange(Sender: TObject);
begin
  DirectoryOutline.Drive := DriveComboBox.Drive
end;

procedure TImageForm.DirectoryOutlineChange(Sender: TObject);
begin
  Path.Caption := DirectoryOutline.Directory;
  FileListBox.Directory := DirectoryOutline.Directory
end;

procedure TImageForm.StretchClick(Sender: TObject);
begin
  ImageDrBob.Stretch := (Sender AS TCheckBox).Checked
end;

procedure TImageForm.FileListBoxChange(Sender: TObject);
begin
  if (FileListBox.ItemIndex >= 0) then
  begin
    OkBitBtn.Enabled := True;
    try
      Screen.Cursor := crHourGlass;
      try
        with FileListBox do
          ImageDrBob.Picture.LoadFromFile(Items[ItemIndex])
      except
        ImageDrBob.Picture.Free
      end
    finally
      Screen.Cursor := crDefault;
    end
  end
  else
    OkBitBtn.Enabled := False
end;

procedure TImageForm.FileListBoxDblClick(Sender: TObject);
begin
  ModalResult := mrOk
end;

end.
