{DragBlotter - by Casey Charlton

This component is a modified version of meiBlotter by Michael Isbell.

I have modified it by adding the routines from my component TMovingPanel.

When I first saw meiBlotter I was gobsmacked, it was by far the simplest
component I have seen, and yet one of the most effective (at least visually).
All credit to Michael Isbell for the initial component.

The added code enables the blotter to be dragged around at run time, or
to drag it's Parent around. Set MoveWho to change it's behaviour.

The initial component was Freeware, and therefore so is this one.

Enjoy!
}

unit Dragblot;

interface

uses
SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
Forms, Dialogs, ExtCtrls;

type
  TWhoToMove = (mwNone, mwSelf, mwParent);
  TmeiDragBlotter = class(TPanel)
private
    OldX,
    OldY,
    OldLeft,
    OldTop             : Integer;
    ScreenDC           : HDC;
    MoveRect           : TRect;
    Moving             : Boolean;
    FMoveWho           : TWhoToMove;
protected
    procedure Paint; override;
public
    constructor Create(AOwner: TComponent); override;
    procedure MouseDown(Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer); override;

	published
    property MoveWho : TWhoToMove  read FMoveWho write FMoveWho;
end;

procedure Register;

implementation

{
1. A way to get the component to know what events should
trigger it
2. A way to get it to paint at design time
3. A color property
4. A way to publish the PaintBlotter method.
}

constructor TmeiDragBlotter.Create(AOwner: TComponent);
Begin
Inherited Create(Aowner);
if (csDesigning in ComponentState) then
begin
	BorderWidth := 8;
	Color := clGreen;
        {Align := alClient   removed by Casey Charlton}
end;
End;

procedure TmeiDragBlotter.Paint;
Begin

With Canvas Do
	Begin

	Brush.Color := Color; {BlotterColor;}
	Rectangle(0,0,Width,Height);

{**************************************************}
	{draw vertical lines on left side of form}
	Pen.Color := clBlack;
	Moveto(0,0);                {column,row}
	Lineto(0,Height);

	Pen.Color := clSilver;
	Moveto(0+1,0);                {column,row}
	Lineto(0+1,Height);

	Pen.Color := clBlack;
	Moveto(0+4,0);                {column,row}
	Lineto(0+4,Height);

	{draw vertical line on right side of form}
	Pen.Color := clSilver;
	Moveto(Width-4,0);
	Lineto(Width-4,Height);

	Pen.Color := clBlack;
	Moveto(Width-1,0);
	Lineto(Width-1,Height);

	{draw horizontal line on top side of form}
	Pen.Color := clBlack;
	Moveto(0,0);
	Lineto(Width,0);

	Pen.Color := clSilver;
	Moveto(0,0+1);
	Lineto(Width,0+1);

	Pen.Color := clBlack;
	Moveto(0,0+4);
	Lineto(Width,0+4);

	{draw horizontal line on bottom side of form}
	Pen.Color := clSilver;
	Moveto(0,Height-4);
	Lineto(Width,Height-4);

	Pen.Color := clBlack;
	Moveto(0,Height-1);
	Lineto(Width,Height-1);

	{***************************************************}
	{draw blotter outer corners}
	Pen.Color := clYellow;
	{Upper Left vertical and horizontal}
	MoveTo(0+1,0+1);
	LineTo(0+1,15);
	Moveto(0+1,0+1);
	LineTo(15,0+1);
	{Lower Left vertical only }
	MoveTo(0+1,Height-1);
	LineTo(0+1,Height-16);
	{Lower Right}
  Pen.Color := clBlack;
	MoveTo(Width-2,Height-1);
	LineTo(Width-15,Height-1);
	MoveTo(Width-1,Height-1);
	LineTo(Width-1,Height-15);
	Pen.Color := clYellow;
	MoveTo(Width-15,Height-1);
	LineTo(Width-16,Height-1);
	MoveTo(Width-1,Height-15);
	LineTo(Width-1,Height-16);
	{Upper Right, horizontal only}
	MoveTo(Width-15, 1);
  LineTo(Width-1, 1);

{************************************************}
	{draw blotter inner corners}
	Pen.Color := clBlack;
	Brush.Color := clBlack;
	{Upper Left}
	MoveTo(0+5,0+5);
	LineTo(0+5,6+6);
	Moveto(0+5,0+5);
	LineTo(6+6,0+5);

	{Lower Left}
	MoveTo(0+5,Height-5);
	LineTo(0+5,(Height-5)-7);    {draw vert}
	Moveto(0+5,Height-5);
	LineTo(12,Height-5);    {draw horiz}

	Pen.Color := clYellow;
	MoveTo(0+6,Height-5);
	LineTo(11,Height-5);
	Pen.Color := clBlack;

		{lower right}
	Pen.Color := clYellow;
	MoveTo(Width-5,Height-5);
	LineTo(Width-5,Height-12);
	MoveTo(Width-5,Height-5);
	LineTo(Width-12,Height-5);

	{Upper Right}
  Pen.Color := clBlack;
	MoveTo(Width-11,5);
	LineTo(Width-5,5);
	Pen.Color := clYellow;
	MoveTo(Width-5,5);
  LineTo(Width-5,13);

{************************************************}
	{draw the staircase pixels}
	Pen.Color := clBlack;

	{upper left}
			{lower pixels}
	MoveTo(0+1,15);
	LineTo(0+4,12);

	Moveto(2,Height-13);
	LineTo(3,Height-12);
	Moveto(4,Height-11);
	LineTo(4,Height-11);

			{upper pixels}
	MoveTo(15,0+1);
	LineTo(12,0+4);


	{lower left}
			{upper pixels}
	Pen.Color := clYellow;
	Moveto(2,Height-14);
	LineTo(5,Height-11);

	Pen.Color := clBlack;
	MoveTo(11,Height-5);
	LineTo(15,Height-1);

	{lower right}
	Pen.Color := clYellow;
	MoveTo(Width-15,Height-1);
	LineTo(Width-10,Height-6);
	MoveTo(Width-1,Height-15);
	LineTo(Width-6,Height-10);

	{ Upper Right}
  Pen.Color := clBlack;
	MoveTo(Width-1,16);
	LineTo(Width-5,12);

	MoveTo(Width-14,2);
	LineTo(Width-12,4);

{****************************************************}
	{fill in "brass" areas for corners}
	Brush.Color := clOlive;
	Pen.Color := clOlive;

	{upper left}
	{fill in large areas}
	Rectangle(2,2,5,12);
	Rectangle(2,2,12,5);

	{fill in upper pixels}
	Moveto(12,2);
	LineTo(14,2);
	Moveto(12,3);
	LineTo(13,3);
	{fill in lower pixels}
	MoveTo(2,12);
	LineTo(2,14);
	MoveTo(3,12);
	LineTo(3,13);

{------------------------}
	{lower left}
	{fill in large areas}
	Rectangle(2,Height-1,12,Height-4);
	Rectangle(2,Height-2,5,Height-11);

	{fill in upper pixels}
	Moveto(2,Height-13);
	LineTo(3,Height-12);
	Moveto(2,Height-12);
	LineTo(4,Height-12);
	Moveto(4,Height-11);
	LineTo(4,Height-11);
	{fill in lower pixels}
	MoveTo(12,Height-3);
	LineTo(13,Height-2);
	MoveTo(14,Height-1);
	LineTo(14,Height-1);
	MoveTo(12,Height-2);
	LineTo(14,Height-2);

  {-----------------------}
		{lower right}

		{fill in large areas}
	Rectangle(Width-1,Height-1,Width-11,
																					Height-4);
	Rectangle(Width-1,Height-1,Width-4,Height-11);

	{fill in upper pixels}
	MoveTo(Width-3,Height-12);
	LineTo(Width-1,Height-12);
	MoveTo(Width-2,Height-13);
	LineTo(Width-1,Height-13);

	{fill in lower pixels}
	MoveTo(Width-12,Height-3);
	LineTo(Width-12,Height-1);
	MoveTo(Width-13,Height-2);
	LineTo(Width-13,Height-1);

	{-----------------------}
		{upper right}

		{fill in large areas}
	Rectangle(Width-11,2,Width-1,5);
	Rectangle(Width-1,13,Width-4,2);

		{fill in upper pixels}
		MoveTo(Width-12,2);
		LineTo(Width-12,4);
		MoveTo(Width-13,2);
    LineTo(Width-13,1);

		{fill in lower pixels}
		MoveTo(Width-2,13);
		LineTo(Width-4,13);
		MoveTo(Width-2,14);
		LineTo(Width-1,14);

{***************************************************}
	{cleanup corner pixels}
	Pen.Color := clBlack;
	Moveto(0,0);
	LineTo(0,10);

	{Lower Left}
	MoveTo(0,Height-1);
	LineTo(13,Height-1);
	MoveTo(0,Height-1);
	LineTo(0,Height-14);

		{Upper Right}
	Moveto(Width-1,0);
	LineTo(Width-14,0);
	Moveto(Width-1,0);
	LineTo(Width-1,13);

	{Lower Right}
	MoveTo(Width-1,Height-1);
	LineTo(Width-14,Height-1);
	MoveTo(Width-1,Height-1);
	LineTo(Width-1,Height-14);

   end;
end;

{Following code is by Casey Charlton 1/12/95}
procedure TmeiDragBlotter.MouseDown(Button: TMouseButton;
                    Shift: TShiftState; X, Y: Integer);
var
   TempRect : TRect;
begin
  inherited MouseDown(Button,Shift,X,Y);
  if (MoveWho <> mwNone) and (Button = mbLeft) then begin
    SetCapture(Self.Handle);
    if MoveWho = mwParent then
       if Parent = Screen.ActiveForm then
          ScreenDC := GetDC(0)
       else
            ScreenDC := GetDC(Parent.Parent.Handle)
    else
        ScreenDC := GetDC(Parent.Handle);

    OldX := X;
    OldY := Y;
    OldLeft := X;
    OldTop := Y;
    if MoveWho = mwParent then
      MoveRect := Rect(Parent.Left, Parent.Top,
                     Parent.Left + Parent.Width, Parent.Top + Parent.Height)
    else
      MoveRect := Rect(Self.Left, Self.Top,
                     Self.Left + Self.Width, Self.Top + Self.Height);
    DrawFocusRect(ScreenDC,MoveRect);
    Moving := True;
  end;
end;

procedure TmeiDragBlotter.MouseMove(Shift: TShiftState; X,Y: Integer);
begin
  inherited MouseMove(Shift,X,Y);
  if (MoveWho <> mwNone) and Moving then begin
    DrawFocusRect(ScreenDC,MoveRect);
    OldX := X;
    OldY := Y;
    if MoveWho = mwParent then
      MoveRect := Rect(Parent.Left+OldX-OldLeft,Parent.Top+OldY-OldTop,
                     Parent.Left+Parent.Width+OldX-OldLeft,Parent.Top+Parent.Height+OldY-OldTop)
    else
      MoveRect := Rect(Self.Left+OldX-OldLeft,Self.Top+OldY-OldTop,
                     Self.Left+Self.Width+OldX-OldLeft,Self.Top+Self.Height+OldY-OldTop);
    DrawFocusRect(ScreenDC,MoveRect);
  end;

end;

procedure TmeiDragBlotter.MouseUp(Button: TMouseButton;
              Shift: TShiftState; X, Y: Integer);
begin
  inherited MouseUp(Button,Shift,X,Y);
  if (MoveWho <> mwNone) and (Button = mbLeft) then begin
    ReleaseCapture;
    DrawFocusRect(ScreenDC,MoveRect);
    if MoveWho = mwParent then
     begin
     if (Parent.Left <> Parent.Left+X+OldLeft) or
       (Parent.Top <> Parent.Top+Y-OldTop) then
       begin
         Parent.Visible := False;
         Parent.Left := Parent.Left+X-OldLeft;
         Parent.Top := Parent.Top+Y-OldTop;
         Parent.Visible := True;
       end
     end
    else
    begin
    if (Self.Left <> Self.Left+X+OldLeft) or
       (Self.Top <> Self.Top+Y-OldTop) then
      begin
      Self.Visible := False;
      Self.Left := Self.Left+X-OldLeft;
      Self.Top := Self.Top+Y-OldTop;
      Self.Visible := True;
      end
    end;
    ReleaseDC(0,ScreenDC);
    Moving := False;
  end;
end;


procedure Register;
begin
	RegisterComponents('Samples', [TmeiDragBlotter]);
end;

end.
