unit Maindb;
{
  DEDBDEMO
  --------
  Demonstration of the DLDBDateEdit component
  Copyright  1999 by David Leeding
  http://www.ozemail.com.au/~davidml/delphi

  This example shows how the TDLDBDateEdit component is typically implemented
  in a database application.

  Requires the TDLDBDateEdit component be installed before opening!

  Refer to order.txt for information on ordering the full
  version of the DL DateEdit components

}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, Dlde16, DB, DBTables, ExtCtrls, DBCtrls,
  Mask;

type

  TfrmMain = class(TForm)
    btnClose: TButton;
    tbl: TTable;
    ds: TDataSource;
    nav: TDBNavigator;
    pnlStatus: TPanel;
    gbDates: TGroupBox;
    Label5: TLabel;
    dbdeJoined: TDLDBDateEdit;
    dbdeResigned: TDLDBDateEdit;
    Label6: TLabel;
    gbName: TGroupBox;
    Label1: TLabel;
    dbedId: TDBEdit;
    dbedName: TDBEdit;
    Label7: TLabel;
    Label2: TLabel;
    dbedAddr: TDBEdit;
    dbedCity: TDBEdit;
    Label3: TLabel;
    Label4: TLabel;
    dbedPostcode: TDBEdit;
    procedure btnCloseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure dbdeJoinedOpenCalendar(Sender: TObject);
    procedure dbdeJoinedCloseCalendar(Sender: TObject);
    procedure dbdeResignedOpenCalendar(Sender: TObject);
    procedure dbdeJoinedInvalidDate(Sender: TObject);
    procedure dbdeResignedInvalidDate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.btnCloseClick(Sender: TObject);
begin
  try
    tbl.Cancel
  except
  end;
  Close;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
var
  s: String;
begin
  ShortDateFormat := 'dd/mm/yyyy';       {Select the ShortDateFormat you prefer}
(*  ShortDateFormat := 'mm/dd/yyyy'; *)
(*  ShortDateFormat := 'yyyy/dd/mm'; *)
  dbdeJoined.DateFormat := ShortDateFormat;
  dbdeResigned.DateFormat := ShortDateFormat;

  GetDir(0, s);
  with tbl do
  begin
    if Active then Close;
    DatabaseName := s;
    Active := TRUE;
  end;
end;

procedure TfrmMain.dbdeJoinedOpenCalendar(Sender: TObject);
begin
  pnlStatus.Caption := 'Select the date the member joined. Press Esc to close the calendar without selecting a date';
end;

procedure TfrmMain.dbdeJoinedCloseCalendar(Sender: TObject);
begin
  pnlStatus.Caption  := '';
end;

procedure TfrmMain.dbdeResignedOpenCalendar(Sender: TObject);
begin
  pnlStatus.Caption := 'Select the date the member resigned. Press Esc to close the calendar without selecting a date';
end;

procedure TfrmMain.dbdeJoinedInvalidDate(Sender: TObject);
begin
  pnlStatus.Caption := dbdeJoined.Text + ' is not  a valid date. Please re-enter the date the member joined.';
end;

procedure TfrmMain.dbdeResignedInvalidDate(Sender: TObject);
begin
  pnlStatus.Caption := dbdeResigned.Text + ' is not  a valid date. Please re-enter the date the member resigned.';
end;

procedure TfrmMain.Button1Click(Sender: TObject);
begin
  tbl.Post

end;

end.
