unit Main;
{
  DEDEMO
  ------
  Demonstration of the DLDateEdit component
  Copyright  1999 by David Leeding
  http://www.ozemail.com.au/~davidml/delphi

  This example shows the range of properties and methods available
  in the TDLDateEdit and TDLDBDateEdit components.

  Requires the TDLDateEdit component be installed before opening!

  Refer to order.txt for information on ordering the full
  version of the DL DateEdit components

}
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, Dlde16, DBCtrls, DBLookup, ExtCtrls;

type

  TfrmMain = class(TForm)
    btnClose: TButton;
    Label1: TLabel;
    de: TDLDateEdit;
    GroupBox1: TGroupBox;
    chkCalEnabled: TCheckBox;
    chkUseCentury: TCheckBox;
    lblCusp: TLabel;
    edCusp: TEdit;
    sbCusp: TSpinButton;
    Label5: TLabel;
    cbDateFormat: TComboBox;
    cbGlyphs: TComboBox;
    Label6: TLabel;
    Label7: TLabel;
    edErrMsg: TEdit;
    cbErrMsgType: TComboBox;
    Label10: TLabel;
    gbCal: TGroupBox;
    lblWEColr: TLabel;
    lblWeekStart: TLabel;
    chkFillPage: TCheckBox;
    cbWeekendColor: TComboBox;
    cbWeekStart: TComboBox;
    Label2: TLabel;
    edErrMsgTitle: TEdit;
    chkAllowKeyEntry: TCheckBox;
    Label3: TLabel;
    lblNum: TLabel;
    edNum: TEdit;
    sbNum: TSpinButton;
    btnLoad: TButton;
    lblBitmap: TLabel;
    dlg: TOpenDialog;
    pnlStatus: TPanel;
    btnOpen: TButton;
    btnEnable: TButton;
    procedure btnCloseClick(Sender: TObject);
    procedure chkCalEnabledClick(Sender: TObject);
    procedure chkUseCenturyClick(Sender: TObject);
    procedure sbCuspDownClick(Sender: TObject);
    procedure sbCuspUpClick(Sender: TObject);
    procedure edCuspKeyPress(Sender: TObject; var Key: Char);
    procedure edCuspExit(Sender: TObject);
    procedure chkFillPageClick(Sender: TObject);
    procedure cbDateFormatChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cbGlyphsChange(Sender: TObject);
    procedure edErrMsgExit(Sender: TObject);
    procedure cbWeekendColorChange(Sender: TObject);
    procedure cbWeekStartChange(Sender: TObject);
    procedure cbErrMsgTypeChange(Sender: TObject);
    procedure btnEnableClick(Sender: TObject);
    procedure deOpenCalendar(Sender: TObject);
    procedure btnOpenClick(Sender: TObject);
    procedure deInvalidDate(Sender: TObject);
    procedure btnLoadClick(Sender: TObject);
    procedure edErrMsgTitleExit(Sender: TObject);
    procedure chkAllowKeyEntryClick(Sender: TObject);
    procedure sbNumUpClick(Sender: TObject);
    procedure sbNumDownClick(Sender: TObject);
    procedure edNumChange(Sender: TObject);
    procedure deCloseCalendar(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  {Set property controls to match what has been set via the Object Inspector}
  cbGlyphs.ItemIndex := Ord(de.GlyphType);
  cbErrMsgType.ItemIndex := Ord(de.ErrorMessageType);
  cbWeekStart.ItemIndex := Ord(de.CalendarWeekStart);
  cbDateFormat.Text := de.DateFormat;
  cbDateFormat.ItemIndex := cbDateFormat.Items.IndexOf(de.DateFormat);
  edErrMsg.Text := de.ErrorMessage;
  edErrMsgTitle.Text := de.ErrorMessageTitle;
  edCusp.Text := IntToStr(de.CuspYear);
  edNum.Text := IntToStr(de.GlyphNum);
  chkCalEnabled.Checked := de.CalendarEnabled;
  chkAllowKeyEntry.Checked := de.AllowKeyEntry;
  chkUseCentury.Checked := de.UseCentury;
  chkFillPage.Checked := de.CalendarFillPage;
  if de.CalendarWeekendColor <> clBtnText then
    cbWeekendColor.ItemIndex := -1
  else
    cbWeekendColor.ItemIndex := 0;
end;

procedure TfrmMain.btnCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmMain.chkCalEnabledClick(Sender: TObject);
var
  colr: TColor;
begin
  de.CalendarEnabled := chkCalEnabled.Checked;

  chkFillPage.Enabled := chkCalEnabled.Checked;
  lblWEColr.Enabled := chkCalEnabled.Checked;
  cbWeekendColor.Enabled := chkCalEnabled.Checked;
  lblWeekStart.Enabled := chkCalEnabled.Checked;
  cbWeekStart.Enabled := chkCalEnabled.Checked;

  if chkCalEnabled.Checked then
    colr := clBtnText
  else
    colr := clGrayText;
  chkFillPage.Font.Color := colr;
  lblWEColr.Font.Color := colr;
  cbWeekendColor.Font.Color := colr;
  lblWeekStart.Font.Color := colr;
  cbWeekStart.Font.Color := colr;
  gbCal.Font.Color := colr;

  if not (chkCalEnabled.Checked) and
     not (chkAllowKeyEntry.Checked) then
    chkAllowkeyEntry.Checked := TRUE;
end;

procedure TfrmMain.chkUseCenturyClick(Sender: TObject);
begin
  de.UseCentury := chkUseCentury.Checked;
  edCusp.Enabled := not chkUseCentury.Checked;
  sbCusp.Enabled := not chkUseCentury.Checked;
  lblCusp.Enabled := not chkUseCentury.Checked;
end;

procedure TfrmMain.sbCuspDownClick(Sender: TObject);
var
  i: Integer;
begin
  i := StrToInt(edCusp.Text) - 1;
  if i < 10 then i := 10;
  edCusp.Text := IntToStr(i);
end;

procedure TfrmMain.sbCuspUpClick(Sender: TObject);
var
  i: Integer;
begin
  i := StrToInt(edCusp.Text) + 1;
  if i > 90 then i := 90;
  edCusp.Text := IntToStr(i);
end;

procedure TfrmMain.edCuspKeyPress(Sender: TObject; var Key: Char);
begin
  if not (Key in [#48..#57]) and
     not (Key in [#8, #22, #24, #3]) then {Backspace, Ctrl-V, Ctrl-X, and Ctrl-C}
  begin
    Key := #0;
    MessageBeep(0);
  end;
end;

procedure TfrmMain.edCuspExit(Sender: TObject);
begin
  de.CuspYear := StrToInt(edCusp.Text);
end;

procedure TfrmMain.chkFillPageClick(Sender: TObject);
begin
  de.CalendarFillPage := chkFillPage.Checked;
end;

procedure TfrmMain.cbDateFormatChange(Sender: TObject);
begin
  de.Text := '';
  de.DateFormat := cbDateFormat.Text;
end;

procedure TfrmMain.cbGlyphsChange(Sender: TObject);
begin
  case cbGlyphs.ItemIndex of
    0: de.GlyphType := gtCustom;
    1: de.GlyphType := gtNone;
    2: de.GlyphType := gtEllipsis;
    3: de.GlyphType := gtDropArrow;
    4: de.GlyphType := gtDropArrowSml;
    5: de.GlyphType := gtCalendar1;
    6: de.GlyphType := gtCalendar2;
    7: de.GlyphType := gtCalendar3;
  end;
  lblNum.Enabled := (cbGlyphs.ItemIndex = 0);
  edNum.Enabled := lblNum.Enabled;
  sbNum.Enabled := lblNum.Enabled;
  if lblNum.Enabled then
    lblNum.Font.Color := clBtnText
  else
    lblNum.Font.Color := clGrayText;
end;

procedure TfrmMain.edErrMsgExit(Sender: TObject);
begin
  de.ErrorMessage := edErrMsg.Text;
end;

procedure TfrmMain.cbWeekendColorChange(Sender: TObject);
begin
  case cbWeekendColor.ItemIndex of
    0: de.CalendarWeekendColor := clBtnText;
    1: de.CalendarWeekendColor := clBtnHighlight;
    2: de.CalendarWeekendColor := clBtnShadow;
    3: de.CalendarWeekendColor := clRed;
    4: de.CalendarWeekendColor := clWhite;
    5: de.CalendarWeekendColor := clBlack;
    6: de.CalendarWeekendColor := clGreen;
    7: de.CalendarWeekendColor := clMaroon;
    8: de.CalendarWeekendColor := clTeal;
    9: de.CalendarWeekendColor := clNavy;
  end;
end;

procedure TfrmMain.cbWeekStartChange(Sender: TObject);
begin
  case cbWeekStart.ItemIndex of
    0: de.CalendarWeekStart := wsSunday;
    1: de.CalendarWeekStart := wsMonday;
    2: de.CalendarWeekStart := wsTuesday;
    3: de.CalendarWeekStart := wsWednesday;
    4: de.CalendarWeekStart := wsThursday;
    5: de.CalendarWeekStart := wsFriday;
    6: de.CalendarWeekStart := wsSaturday;
  end;
end;

procedure TfrmMain.cbErrMsgTypeChange(Sender: TObject);
begin
  case cbErrMsgType.ItemIndex of
    0: de.ErrorMessageType := mtDelphi;
    1: de.ErrorMessageType := mtWindows;
    2: de.ErrorMessageType := mtBeep;
    3: de.ErrorMessageType := mtSilent;
  end;
end;

procedure TfrmMain.btnEnableClick(Sender: TObject);
begin
  de.Enabled := not de.Enabled;
  if de.Enabled then
    btnEnable.Caption := '&Disable'
  else
    btnEnable.Caption := '&Enable';
end;

procedure TfrmMain.btnOpenClick(Sender: TObject);
begin
  de.OpenCalendar;
end;

procedure TfrmMain.btnLoadClick(Sender: TObject);
begin
  if dlg.Execute then
  begin
    lblBitmap.Caption := dlg.FileName;
    de.Glyph.LoadFromFile(dlg.FileName);
    cbGlyphs.ItemIndex := 0;
    lblNum.Enabled := TRUE;
    edNum.Enabled := TRUE;
    sbNum.Enabled := TRUE;
  end;
end;

procedure TfrmMain.edErrMsgTitleExit(Sender: TObject);
begin
  de.ErrorMessageTitle := edErrMsgTitle.Text;
end;

procedure TfrmMain.chkAllowKeyEntryClick(Sender: TObject);
begin
  de.AllowKeyEntry := chkAllowKeyEntry.Checked;
  if not (chkCalEnabled.Checked) and
     not (chkAllowKeyEntry.Checked) then
    chkCalEnabled.Checked := TRUE;
end;

procedure TfrmMain.sbNumUpClick(Sender: TObject);
var
  i: Integer;
begin
  i := StrToInt(edNum.Text) + 1;
  if i > 3 then i := 3;
  edNum.Text := IntToStr(i);
end;

procedure TfrmMain.sbNumDownClick(Sender: TObject);
var
  i: Integer;
begin
  i := StrToInt(edNum.Text) - 1;
  if i < 1 then i := 1;
  edNum.Text := IntToStr(i);
end;

procedure TfrmMain.edNumChange(Sender: TObject);
begin
  de.GlyphNum := StrToInt(edNum.Text);
end;

procedure TfrmMain.deInvalidDate(Sender: TObject);
begin
  pnlStatus.Caption := 'The date ' + #39 + de.Text + #39 +
                       ' is not valid. Please re-enter!';
end;

procedure TfrmMain.deOpenCalendar(Sender: TObject);
begin
  pnlStatus.Caption := 'Select a date from the calendar. Press ESC to cancel.';
end;

procedure TfrmMain.deCloseCalendar(Sender: TObject);
begin
  pnlStatus.Caption := '';
end;

end.
