unit main;

//
//  Demo 2
//  ------
//  Demonstration of the properties of the DLLED component
//  Copyright  1997-2002 by David Leeding
//  www.ozemail.com.au/~davidml/dlcomp
//
//  Requires that the TDLLED component be installed before opening!
//
//  This demo allows you to change properties of the DLLED component at
//  run-time to see the effects of your changes. Simply compile and run
//  the demo program, then change the available properties.
// 

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DLLED, ExtCtrls;

type
  TfrmMain = class(TForm)
    led: TDLLED;
    gbLedProps: TGroupBox;
    cbLEDColour: TComboBox;
    cbLEDSize: TComboBox;
    cbLEDState: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    pnlStatus: TPanel;
    led1: TDLLED;
    led2: TDLLED;
    led3: TDLLED;
    led4: TDLLED;
    led5: TDLLED;
    led6: TDLLED;
    led7: TDLLED;
    led8: TDLLED;
    led9: TDLLED;
    led15: TDLLED;
    led14: TDLLED;
    led13: TDLLED;
    led12: TDLLED;
    led11: TDLLED;
    led10: TDLLED;
    led18: TDLLED;
    led17: TDLLED;
    led16: TDLLED;
    btnClose: TButton;
    Timer1: TTimer;
    chkEnabled: TCheckBox;
    procedure cbLEDStateChange(Sender: TObject);
    procedure cbLEDSizeChange(Sender: TObject);
    procedure cbLEDColourChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure chkEnabledClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;
  nLED: Short;
  nDirection: Short;

implementation

{$R *.DFM}

procedure TfrmMain.cbLEDColourChange(Sender: TObject);
var
  i: Integer;
  lc: TLEDColor;
begin

  case cbLEDColour.ItemIndex of
    0: lc := lcAmber;
    1: lc := lcBlue;
    2: lc := lcGreen;
    3: lc := lcLBlue;
    4: lc := lcLime;
    5: lc := lcPink;
    6: lc := lcPurple;
    7: lc := lcRed;
    8: lc := lcTeal;
  else
    lc := lcRed;
  end;
  for i := 0 to ComponentCount - 1 do
    if Components[i] is TDLLED then
      TDLLED(Components[i]).LEDColor := lc;

end;

procedure TfrmMain.cbLEDSizeChange(Sender: TObject);
var
  i: Integer;
  lz: TLEDSize;
begin
  case cbLEDSize.ItemIndex of
    0: lz := lzSmall;
    1: lz := lzLarge;
  else
    lz := lzSmall;
  end;

  for i := 0 to ComponentCount - 1 do
    if Components[i] is TDLLED then
      TDLLED(Components[i]).LEDSize := lz;
end;


procedure TfrmMain.cbLEDStateChange(Sender: TObject);
begin
  case cbLEDState.ItemIndex of
    0: led.LEDState := lsOff;
    1: led.LEDState := lsOn;
    2: led.LEDState := lsBright;
  end;
end;


procedure TfrmMain.FormCreate(Sender: TObject);
begin
  cbLEDColour.ItemIndex := Ord(led.LEDColor);
  cbLEDSize.ItemIndex := Ord(led.LEDSize);
  cbLEDState.ItemIndex := Ord(led.LEDState);
  chkEnabled.Checked := led.Enabled;
  nLED := 0;
  nDirection := 1;
end;


procedure TfrmMain.FormShow(Sender: TObject);
begin
  Timer1.Enabled := True;
end;


procedure TfrmMain.btnCloseClick(Sender: TObject);
begin
  Close;
end;


procedure TfrmMain.Timer1Timer(Sender: TObject);
begin

  nLED := nLED + nDirection;
  TDLLED(FindComponent('led' + IntToStr(nLED))).LEDState := led.LEDState;

  case nLED of
    1:  begin
          nDirection := 1;
          TDLLED(FindComponent('led2')).LEDState := lsOff;
        end;

    18: begin
          nDirection := -1;
          TDLLED(FindComponent('led17')).LEDState := lsOff;
        end;

    else
      if nDirection = 1 then
        TDLLED(FindComponent('led'+IntToStr(nLED - 1))).LEDState := lsOff
      else
        TDLLED(FindComponent('led'+IntToStr(nLED + 1))).LEDState := lsOff;

  end;

end;

procedure TfrmMain.chkEnabledClick(Sender: TObject);
var
  i: Integer;
begin
  for i := 0 to ComponentCount - 1 do
    if Components[i] is TDLLED then
      TDLLED(Components[i]).Enabled := chkEnabled.Checked;
end;

end.
