unit main;

//
//  Demo 1
//  ------
//  Demonstration of the properties of the DLDateEdit, DLDBDateEdit and
//  TDLCalendar components
//  Copyright  1997-2002 by David Leeding
//  www.ozemail.com.au/~davidml/dlcomp
//
//  Requires that the TDLDateEdit component be installed before opening!
//
//  This demo allows you to change properties of the TDLDateEdit component
//  at run-time to see the effects of your changes. Simply compile and run
//  the demo program, then change the available properties. The special 
//  properties of this component also apply to the DLDBDateEdit component,
//  and the calendar-related properties apply to the TDLCalendar component.
//
//  Calendar.bmp is provided to demonstrate loading a custom glyph; you may
//  want to edit this yourself and try loading it into the TDLDateEdit component.
//

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, DBCtrls, DBLookup, ExtCtrls, Dlde;

type

  TfrmMain = class(TForm)
    btnClose: TButton;
    Label1: TLabel;
    de: TDLDateEdit;
    gbCalProps: TGroupBox;
    lblWEColr: TLabel;
    lblWeekStart: TLabel;
    chkFillPage: TCheckBox;
    cbWeekendColor: TComboBox;
    cbWeekStart: TComboBox;
    dlg: TOpenDialog;
    pnlStatus: TPanel;
    Label4: TLabel;
    cbCalStyle: TComboBox;
    lblCalStyle: TLabel;
    edCaption: TEdit;
    chkAllowKeyEntry: TCheckBox;
    chkCalEnabled: TCheckBox;
    lblCusp: TLabel;
    edCusp: TEdit;
    sbCusp: TSpinButton;
    Label5: TLabel;
    cbDateFormat: TComboBox;
    Label7: TLabel;
    edErrMsg: TEdit;
    Label2: TLabel;
    edErrMsgTitle: TEdit;
    Label10: TLabel;
    cbErrMsgType: TComboBox;
    Label3: TLabel;
    btnLoad: TButton;
    edNum: TEdit;
    lblNum: TLabel;
    Label6: TLabel;
    cbGlyphs: TComboBox;
    chkUseCentury: TCheckBox;
    sbNum: TSpinButton;
    lblBitmap: TLabel;
    Label8: TLabel;
    btnOpen: TButton;
    procedure btnCloseClick(Sender: TObject);
    procedure chkCalEnabledClick(Sender: TObject);
    procedure chkUseCenturyClick(Sender: TObject);
    procedure sbCuspDownClick(Sender: TObject);
    procedure sbCuspUpClick(Sender: TObject);
    procedure edCuspKeyPress(Sender: TObject; var Key: Char);
    procedure edCuspExit(Sender: TObject);
    procedure chkFillPageClick(Sender: TObject);
    procedure cbDateFormatChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cbGlyphsChange(Sender: TObject);
    procedure edErrMsgExit(Sender: TObject);
    procedure cbWeekendColorChange(Sender: TObject);
    procedure cbWeekStartChange(Sender: TObject);
    procedure cbErrMsgTypeChange(Sender: TObject);
    procedure deOpenCalendar(Sender: TObject);
    procedure btnOpenClick(Sender: TObject);
    procedure deInvalidDate(Sender: TObject);
    procedure btnLoadClick(Sender: TObject);
    procedure edErrMsgTitleExit(Sender: TObject);
    procedure chkAllowKeyEntryClick(Sender: TObject);
    procedure sbNumUpClick(Sender: TObject);
    procedure sbNumDownClick(Sender: TObject);
    procedure edNumChange(Sender: TObject);
    procedure deCloseCalendar(Sender: TObject);
    procedure cbCalStyleChange(Sender: TObject);
    procedure edErrMsgTitleChange(Sender: TObject);
    procedure edErrMsgChange(Sender: TObject);
    procedure edCaptionChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  cbGlyphs.ItemIndex := Ord(de.GlyphType);
  cbErrMsgType.ItemIndex := Ord(de.ErrorMessageType);
  cbWeekStart.ItemIndex := Ord(de.CalendarWeekStart);
  cbCalStyle.ItemIndex := Ord(de.CalendarStyle);
  cbDateFormat.Text := de.DateFormat;
  cbDateFormat.ItemIndex := cbDateFormat.Items.IndexOf(de.DateFormat);
  edErrMsg.Text := de.ErrorMessage;
  edErrMsgTitle.Text := de.ErrorMessageTitle;
  edCaption.Text := de.CalendarCaption;
  edCusp.Text := IntToStr(de.CuspYear);
  edNum.Text := IntToStr(de.GlyphNum);
  chkCalEnabled.Checked := de.CalendarEnabled;
  chkAllowKeyEntry.Checked := de.AllowKeyEntry;
  chkUseCentury.Checked := de.UseCentury;
  chkFillPage.Checked := de.CalendarFillPage;
  if de.CalendarWeekendColor <> clBtnText then
    cbWeekendColor.ItemIndex := -1
  else
    cbWeekendColor.ItemIndex := 0;
end;


procedure TfrmMain.btnCloseClick(Sender: TObject);
begin
  Close;
end;


procedure TfrmMain.chkCalEnabledClick(Sender: TObject);
begin
  de.CalendarEnabled := chkCalEnabled.Checked;

  chkFillPage.Enabled := chkCalEnabled.Checked;
  cbWeekendColor.Enabled := chkCalEnabled.Checked;
  cbWeekStart.Enabled := chkCalEnabled.Checked;
  cbCalStyle.Enabled := chkCalEnabled.Checked;
  edCaption.Enabled := chkCalEnabled.Checked;

  if not (chkCalEnabled.Checked) and
     not (chkAllowKeyEntry.Checked) then
    chkAllowkeyEntry.Checked := TRUE;
end;


procedure TfrmMain.chkUseCenturyClick(Sender: TObject);
begin
  de.UseCentury := chkUseCentury.Checked;
  edCusp.Enabled := not chkUseCentury.Checked;
  sbCusp.Enabled := not chkUseCentury.Checked;
  lblCusp.Enabled := not chkUseCentury.Checked;
end;


procedure TfrmMain.sbCuspDownClick(Sender: TObject);
var
  i: Integer;
begin
  i := StrToInt(edCusp.Text) - 1;
  if i < 10 then i := 10;
  edCusp.Text := IntToStr(i);
end;


procedure TfrmMain.sbCuspUpClick(Sender: TObject);
var
  i: Integer;
begin
  i := StrToInt(edCusp.Text) + 1;
  if i > 90 then i := 90;
  edCusp.Text := IntToStr(i);
end;


procedure TfrmMain.edCuspKeyPress(Sender: TObject; var Key: Char);
begin
  if not (Key in [#48..#57]) and
     not (Key in [#8, #22, #24, #3]) then {Backspace, Ctrl-V, Ctrl-X, and Ctrl-C}
  begin
    Key := #0;
    MessageBeep(0);
  end;
end;


procedure TfrmMain.edCuspExit(Sender: TObject);
begin
  de.CuspYear := StrToInt(edCusp.Text);
end;


procedure TfrmMain.chkFillPageClick(Sender: TObject);
begin
  de.CalendarFillPage := chkFillPage.Checked;
end;


procedure TfrmMain.cbDateFormatChange(Sender: TObject);
begin
  de.Text := '';
  de.DateFormat := cbDateFormat.Text;
end;


procedure TfrmMain.cbGlyphsChange(Sender: TObject);
begin
  case cbGlyphs.ItemIndex of
    0: de.GlyphType := gtCustom;
    1: de.GlyphType := gtNone;
    2: de.GlyphType := gtEllipsis;
    3: de.GlyphType := gtDropArrow;
    4: de.GlyphType := gtDropArrowSml;
    5: de.GlyphType := gtCalendar1;
    6: de.GlyphType := gtCalendar2;
    7: de.GlyphType := gtCalendar3;
  end;
  lblNum.Enabled := (cbGlyphs.ItemIndex = 0);
  edNum.Enabled := lblNum.Enabled;
  sbNum.Enabled := lblNum.Enabled;
  if lblNum.Enabled then
    lblNum.Font.Color := clBtnText
  else
    lblNum.Font.Color := clGrayText;
end;


procedure TfrmMain.edErrMsgExit(Sender: TObject);
begin
  de.ErrorMessage := edErrMsg.Text;
end;


procedure TfrmMain.cbWeekendColorChange(Sender: TObject);
begin
  case cbWeekendColor.ItemIndex of
    0: de.CalendarWeekendColor := clBtnText;
    1: de.CalendarWeekendColor := clBtnHighlight;
    2: de.CalendarWeekendColor := clBtnShadow;
    3: de.CalendarWeekendColor := clRed;
    4: de.CalendarWeekendColor := clWhite;
    5: de.CalendarWeekendColor := clBlack;
    6: de.CalendarWeekendColor := clGreen;
    7: de.CalendarWeekendColor := clMaroon;
    8: de.CalendarWeekendColor := clTeal;
    9: de.CalendarWeekendColor := clNavy;
  end;
end;


procedure TfrmMain.cbWeekStartChange(Sender: TObject);
begin
  case cbWeekStart.ItemIndex of
    0: de.CalendarWeekStart := wsSunday;
    1: de.CalendarWeekStart := wsMonday;
    2: de.CalendarWeekStart := wsTuesday;
    3: de.CalendarWeekStart := wsWednesday;
    4: de.CalendarWeekStart := wsThursday;
    5: de.CalendarWeekStart := wsFriday;
    6: de.CalendarWeekStart := wsSaturday;
  end;
end;


procedure TfrmMain.cbErrMsgTypeChange(Sender: TObject);
begin
  case cbErrMsgType.ItemIndex of
    0: de.ErrorMessageType := mtDelphi;
    1: de.ErrorMessageType := mtWindows;
    2: de.ErrorMessageType := mtBeep;
    3: de.ErrorMessageType := mtSilent;
  end;
end;


procedure TfrmMain.btnOpenClick(Sender: TObject);
begin
  de.OpenCalendar;
end;


procedure TfrmMain.btnLoadClick(Sender: TObject);
begin
  if dlg.Execute then
  begin
    lblBitmap.Caption := dlg.FileName;
    de.Glyph.LoadFromFile(dlg.FileName);
    cbGlyphs.ItemIndex := 0;
    lblNum.Enabled := TRUE;
    edNum.Enabled := TRUE;
    sbNum.Enabled := TRUE;
  end;
end;


procedure TfrmMain.edErrMsgTitleExit(Sender: TObject);
begin
  de.ErrorMessageTitle := edErrMsgTitle.Text;
end;


procedure TfrmMain.chkAllowKeyEntryClick(Sender: TObject);
begin
  de.AllowKeyEntry := chkAllowKeyEntry.Checked;
  if not (chkCalEnabled.Checked) and
     not (chkAllowKeyEntry.Checked) then
    chkCalEnabled.Checked := TRUE;
end;


procedure TfrmMain.sbNumUpClick(Sender: TObject);
var
  i: Integer;
begin
  i := StrToInt(edNum.Text) + 1;
  if i > 3 then i := 3;
  edNum.Text := IntToStr(i);
end;


procedure TfrmMain.sbNumDownClick(Sender: TObject);
var
  i: Integer;
begin
  i := StrToInt(edNum.Text) - 1;
  if i < 1 then i := 1;
  edNum.Text := IntToStr(i);
end;


procedure TfrmMain.edNumChange(Sender: TObject);
begin
  de.GlyphNum := StrToInt(edNum.Text);
end;


procedure TfrmMain.deInvalidDate(Sender: TObject);
begin
  pnlStatus.Caption := 'The date ' + #39 + de.Text + #39 +
                       ' is not valid. Please re-enter!';
end;


procedure TfrmMain.deOpenCalendar(Sender: TObject);
begin
  pnlStatus.Caption := 'Select a date from the calendar. Press ESC to cancel.';
end;


procedure TfrmMain.deCloseCalendar(Sender: TObject);
begin
  pnlStatus.Caption := '';
end;


procedure TfrmMain.cbCalStyleChange(Sender: TObject);
begin
  case cbCalStyle.ItemIndex of
    0: de.CalendarStyle := csStandard;
    1: de.CalendarStyle := csDialog;
  end;
end;


procedure TfrmMain.edErrMsgTitleChange(Sender: TObject);
begin
  de.ErrorMessageTitle := edErrMsgTitle.Text;
end;


procedure TfrmMain.edErrMsgChange(Sender: TObject);
begin
  de.ErrorMessage := edErrMsg.Text;
end;


procedure TfrmMain.edCaptionChange(Sender: TObject);
begin
  de.CalendarCaption := edCaption.Text;
end;


end.
