unit Search;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DBTables, StdCtrls, Buttons, Grids, DBGrids, RXDBCtrl, DB,
  DBCtrls;

type
  TSearchForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    SCombo: TComboBox;
    SFor: TEdit;
    Query1: TQuery;
    RxDBGrid1: TRxDBGrid;
    BitBtn1: TBitBtn;
    DataSource4: TDataSource;
    Query1TopicName: TStringField;
    Query1CatagoryName: TStringField;
    Query1ArchiveName: TStringField;
    Query1ArchiveStorage: TStringField;
    Query1Size: TIntegerField;
    Query1Date: TDateField;
    Query1Description: TMemoField;
    Query1Importance: TSmallintField;
    memo: TDBMemo;
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SForKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure RxDBGrid1GetCellParams(Sender: TObject; Field: TField;
      AFont: TFont; var Background: TColor; Highlight: Boolean);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SearchForm: TSearchForm;
  clienth : integer;
  clientw : integer;

implementation

{$R *.DFM}

procedure GridResize;
begin
  with SearchForm do begin
      if ClientWidth > ClientW then begin
          RXDBGrid1.Width := RxDBGrid1.Width  + (ClientWidth - ClientW);
          Memo.Width      := Memo.Width + (ClientWidth - ClientW);
          end
      else begin
          RxDBGrid1.Width := RXDBGrid1.Width - (ClientW - ClientWidth);
          Memo.Width      := Memo.Width - (ClientW - ClientWidth);
          end;

      if ClientHeight > ClientH then begin
          RXDBGrid1.Height := RxDBGrid1.Height  + (ClientHeight - ClientH);
          Memo.Top      := Memo.Top + (ClientHeight - ClientH);
          end
      else begin
          RxDBGrid1.Height := RXDBGrid1.Height - (ClientH - ClientHeight);
          Memo.Top      := Memo.Top - (ClientH - ClientHeight);
          end;

      ClientW := SearchForm.ClientWidth;
      ClientH := SearchForm.ClientHeight;
    end;
end;

procedure TSearchForm.BitBtn1Click(Sender: TObject);
var
   SearchBy, SearchFor : string;
begin
  if scombo.text = '' then
    messagedlg('Select Search By first',mtinformation,[mbok],0)
  else
    begin
      {get search by condition}
      case scombo.itemindex of
         0: searchby := 'f."archive name"';
         1: searchby := 'f."archive storage"';
         2: searchby := 'f."description"';
         3: searchby := 'f."importance"';
      end;

      SearchFor := '''%'+SFor.text+'%''';

      query1.close;

      query1.sql.clear;
      query1.sql.add('select t."topic name", c."catagory name",');
      query1.sql.add('f."archive name", f."archive storage", f."size", f."date",');
      query1.sql.add('f."description", f."importance"');
      query1.sql.add('from topic t, catagory c, "file" f');
      query1.sql.add('where (t."topic id" = c."topic id") and');
      query1.sql.add('(f."catagory id" = c."catagory id") and');
      query1.sql.add('('+searchby+' like '+searchfor+')');

      try
        screen.cursor := crHourGlass;
        query1.open;
        screen.cursor := crdefault;
      except
        screen.cursor := crdefault;
      raise;
    end;
  end;
end;

procedure TSearchForm.FormCreate(Sender: TObject);
begin
  clientW := ClientWidth;
  clientH := ClientHeight;

  if mdichildcount > 0 then
    cascade
  else
    begin
      top := 0;
      left := 0;
    end;
end;

procedure TSearchForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  action := cafree;
end;

procedure TSearchForm.SForKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = VK_RETURN then
    bitbtn1.click;
end;

procedure TSearchForm.RxDBGrid1GetCellParams(Sender: TObject;
  Field: TField; AFont: TFont; var Background: TColor; Highlight: Boolean);
var
   num : integer;
begin
  num := (Sender as TrxDBGrid).DataSource.DataSet.FieldByName('Importance').AsInteger;
  case num of
       1: Background := clRed;
       2: Background := clYellow;
  end;

  if Highlight then begin
    AFont.Color := clHighlightText;
    Background := clHighlight;
  end;
end;

procedure TSearchForm.FormResize(Sender: TObject);
begin
  GridResize;
end;

end.
