unit Earc;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, DBTables, Mask, Spin, StdCtrls, Buttons, DBCtrls,
  ExtCtrls;

type
  TEditForm = class(TForm)
    Bevel1: TBevel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    EDescription: TMemo;
    ArchName: TDBEdit;
    ArchStorage: TDBEdit;
    ArchDate: TDBEdit;
    ArchSize: TDBEdit;
    ArchDescription: TDBMemo;
    ArchImportance: TDBEdit;
    EName: TEdit;
    EStorage: TEdit;
    ESize: TEdit;
    BitBtn2: TBitBtn;
    ELevel: TSpinEdit;
    BitBtn1: TBitBtn;
    EDate: TMaskEdit;
    Table3: TTable;
    Table3ArchiveName: TStringField;
    Table3ArchiveStorage: TStringField;
    Table3Size: TIntegerField;
    Table3Date: TDateField;
    Table3Description: TMemoField;
    Table3Importance: TSmallintField;
    Table3FileID: TIntegerField;
    Table3CatagoryID: TIntegerField;
    DataSource3: TDataSource;
    OpenDialog1: TOpenDialog;
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ELevelChange(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  EditForm: TEditForm;

implementation
uses
    arcview;
{$R *.DFM}

procedure TEditForm.FormCreate(Sender: TObject);
var
   N : integer;
begin
  table3.open;
  N := arcview.editkey;
  table3.findkey([N]);

  EName.Text             := ArchName.Text;
  EStorage.Text          := ArchStorage.Text ;
  EDate.Text             := ArchDate.Text ;
  ESize.Text             := ArchSize.Text;
  ELevel.value           := StrToInt(Archimportance.Text);
  EDescription.Text      := ArchDescription.Text;

  {table3.close;}
end;

procedure TEditForm.BitBtn1Click(Sender: TObject);
begin
  close;
end;

procedure TEditForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  table3.close;
  action := cafree;
end;

procedure TEditForm.ELevelChange(Sender: TObject);
begin
  case ELevel.value of
       1: ELevel.color := clRed;
       2: ELevel.color := clYellow;
       3: ELevel.color := clBtnFace;
  end;
end;

procedure TEditForm.BitBtn2Click(Sender: TObject);
begin
  if EName.text = '' then
    messagedlg('Specify Archive Name first',mtinformation,[mbok],0)
  else
    if messagedlg('Edit '+EName.text+' ?.',mtconfirmation,[mbYes,mbNo],0) =
                  mrYes then begin
      table3.open;
      table3.edit;
      ArchName.Text        := EName.Text;
      ArchStorage.Text     := EStorage.Text;
      ArchDate.Text        := EDate.Text;
      ArchSize.Text        := ESize.Text;
      Archimportance.Text  := IntToStr(ELevel.value);
      ArchDescription.Text := EDescription.Text;
      table3.post;
      table3.close;

      messagedlg(EName.text+' edited.',mtconfirmation,[mbok],0);
      end;
end;

end.
