unit Dtopic;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Mask, DBCtrls, Buttons, DB, DBTables, Grids,
  DBGrids, RXDBCtrl;

type
  TDeleteTopic = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    RxDBGrid1: TRxDBGrid;
    RxDBGrid2: TRxDBGrid;
    Table1: TTable;
    Table1TopicName: TStringField;
    Table1TopicID: TIntegerField;
    DataSource1: TDataSource;
    Table2: TTable;
    Table2CatagoryName: TStringField;
    Table2TopicID: TIntegerField;
    DataSource2: TDataSource;
    BitBtn1: TBitBtn;
    Label3: TLabel;
    BitBtn2: TBitBtn;
    DBEdit1: TDBEdit;
    Table3: TTable;
    Table3CatagoryID: TIntegerField;
    Table2CatagoryID: TIntegerField;
    Table3FileID: TIntegerField;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure Table1BeforeDelete(DataSet: TDataset);
    procedure Table2BeforeDelete(DataSet: TDataset);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DeleteTopic: TDeleteTopic;

implementation
uses
    main;
{$R *.DFM}

procedure TDeleteTopic.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  table1.close;
  table2.close;
  table3.close;
  mainform.Delete1.enabled := true;
  action := cafree;
end;

procedure TDeleteTopic.FormCreate(Sender: TObject);
begin
  if mdichildcount > 0 then
    cascade
  else
    begin
      top := 0;
      left := 0;
    end;
  table1.active := true;
  table2.active := true;

end;

procedure TDeleteTopic.BitBtn2Click(Sender: TObject);
begin
  if messagedlg('!!WARNING!!'+#13+
                'Deleting Topic '+DBEdit1.Text+
                ', will also delete associated catagories'+
                ' and Archive Records.'+#13+#13+
                'Do you wish to Continue ??',mtconfirmation,[mbYes,mbNo],0)
                = mrYes then
    begin
      if messagedlg('please reconfirm Topic Deletion.'+#13+#13+
                    'Delete '+DBEdit1.Text+' ?',mtconfirmation,
                    [mbYes,mbNo],0) = mrYes then
        begin
          table3.open;
          table1.delete;
          table3.close;
        end;
    end;
end;

procedure TDeleteTopic.Table1BeforeDelete(DataSet: TDataset);
begin
  with Table2 do begin
    DisableControls;
    FindKey([Table1.Fields[1].AsString]);
    while (Fields[1].AsString = Table1.Fields[1].AsString) and
      (not Eof) do
      Delete;
    EnableControls;
  end;
end;

procedure TDeleteTopic.Table2BeforeDelete(DataSet: TDataset);
begin
  with Table3 do begin
    DisableControls;
    FindKey([Table2.Fields[2].AsString]);
    while (Fields[1].AsString = Table2.Fields[2].AsString) and
      (not Eof) do
      Delete;
    EnableControls;
  end;
end;

procedure TDeleteTopic.BitBtn1Click(Sender: TObject);
begin
  close;
end;

end.
