unit Arcview;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, DB, DBTables, RXLookup,
  Grids, DBGrids, RXDBCtrl, RxDBComb, Outline, Mask, DBCtrls, ShellAPI,
  Menus,earc;

type
  TArchiveView = class(TForm)
    Table1: TTable;
    DataSource1: TDataSource;
    Table2: TTable;
    DataSource2: TDataSource;
    Outline1: TOutline;
    TopicID: TDBEdit;
    catTopicID: TDBEdit;
    Outline2: TOutline;
    CatagoryID: TDBEdit;
    RxDBGrid1: TRxDBGrid;
    Table3: TTable;
    DataSource3: TDataSource;
    FileID: TDBEdit;
    Table2CatagoryID: TIntegerField;
    Table2TopicID: TIntegerField;
    Table2CatagoryName: TStringField;
    Topic: TDBEdit;
    Catagory: TDBEdit;
    Memo: TDBMemo;
    ItemText: TMemo;
    Table3FileID: TIntegerField;
    Table3CatagoryID: TIntegerField;
    Table3ArchiveName: TStringField;
    Table3ArchiveStorage: TStringField;
    Table3Size: TIntegerField;
    Table3Date: TDateField;
    Table3Description: TMemoField;
    Table3Importance: TSmallintField;
    DBEdit1: TDBEdit;
    DBEdit2: TDBEdit;
    PopArchMenu: TPopupMenu;
    RunArch: TMenuItem;
    N1: TMenuItem;
    DelArch: TMenuItem;
    EdArch: TMenuItem;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Outline1Click(Sender: TObject);
    procedure Outline1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormResize(Sender: TObject);
    procedure RxDBGrid1GetCellParams(Sender: TObject; Field: TField;
      AFont: TFont; var Background: TColor; Highlight: Boolean);
    procedure RxDBGrid1DblClick(Sender: TObject);
    procedure DelArchClick(Sender: TObject);
    procedure EdArchClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ArchiveView: TArchiveView;
  clientW : integer;
  clientH : integer;
  editkey : integer;
  
implementation
uses
    main;
{$R *.DFM}

procedure runprog(s : string);
var
 FName : array[ 0..255 ] of Char;
 handle : thandle;
begin
  StrPCopy(FName,s);
  ShellExecute(0, nil, fname, nil,nil, SW_SHOWNORMAL);
end;

procedure GridResize;
begin
  with ArchiveView do begin
      if ClientWidth > ClientW then begin
          RXDBGrid1.Width := RxDBGrid1.Width  + (ClientWidth - ClientW);
          Memo.Width      := Memo.Width + (ClientWidth - ClientW);
          end
      else begin
          RxDBGrid1.Width := RXDBGrid1.Width - (ClientW - ClientWidth);
          Memo.Width      := Memo.Width - (ClientW - ClientWidth);
          end;

      if ClientHeight > ClientH then begin
          RXDBGrid1.Height := RxDBGrid1.Height  + (ClientHeight - ClientH);
          Memo.Top      := Memo.Top + (ClientHeight - ClientH);
          Outline1.Height := Outline1.height + (ClientHeight - ClientH);
          ItemText.Top := Itemtext.Top + (ClientHeight - ClientH);
          end
      else begin
          RxDBGrid1.Height := RXDBGrid1.Height - (ClientH - ClientHeight);
          Memo.Top      := Memo.Top - (ClientH - ClientHeight);
          Outline1.Height := Outline1.height - (ClientH - ClientHeight);
          ItemText.Top := Itemtext.Top - (ClientH - ClientHeight);
          end;

      ClientW := ArchiveView.ClientWidth;
      ClientH := ArchiveView.ClientHeight;
    end;
end;

procedure TArchiveView.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  action := cafree;
end;

procedure TArchiveView.BitBtn1Click(Sender: TObject);
begin
  table1.close;
  table2.close;
  table3.close;
  close;
end;

procedure TArchiveView.FormCreate(Sender: TObject);
var
   i : integer;
begin
  clientW := ClientWidth;
  clientH := ClientHeight;

  if mdichildcount > 0 then
    cascade
  else
    begin
      top := 0;
      left := 0;
    end;

  table2.mastersource := Datasource1;
  table2.indexfieldNames := 'Topic ID';
  table2.masterfields := 'Topic ID';

  table1.open;
  table2.open;
  table1.First;

  while not table1.eof do
  begin
    i := Outline1.add(0,Topic.Text);
    Outline2.add(0,TopicID.Text);
    table2.first;
    {loop the Catagory Table to get children}
    while not table2.eof do
    begin
      Outline1.addchild(i,Catagory.text);
      Outline2.addchild(i,CatagoryID.text);
      table2.next;
    end;
    table1.next;
    i := i + 1;
  end;

  table1.close;
  table2.close;

  {size the rxgrid}
  GridResize;
end;

procedure TArchiveView.Outline1Click(Sender: TObject);
var
   SelectedID, CatID : integer;
begin
  ItemText.Text := outline1.items[outline1.selecteditem].text;

  SelectedID  := outline1.items[outline1.selecteditem].index;
  CatID       := StrToInt(outline2.items[SelectedID].text);

  {see if it's a parent}
  if outline1.items[SelectedID].level = 2 then
    {it's a child}
    begin
      table2.mastersource := nil;
      table2.indexfieldNames := 'Catagory ID';
      table2.masterfields := '';

      table2.open;
      table3.open;
      table2.findkey([CatID]);

      if FileID.Text = '' then
        begin
          table2.close;
          table3.close;
          RxDBGrid1.datasource := nil;
          RXDBGrid1.TitleButtons := false;
          RxDBGrid1.enabled := false;
        end
      else
        begin
          RxDBGrid1.datasource := datasource3;
          RXDBGrid1.TitleButtons := true;
          RxDBGrid1.enabled := true;
          Table3.open;
        end;
    end
  else if FileID.Text <> '' then
    begin
      table2.close;
      table3.close;
      RXDBGrid1.TitleButtons := false;
      RxDBGrid1.enabled := false;
    end;
end;

procedure TArchiveView.Outline1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
   chindex,child : integer;
begin
  with outline1 do
  begin
    if (key = VK_UP) or (key = VK_DOWN) then
      click;

    if (key = VK_RIGHT) then
      begin
        if items[selecteditem].hasitems then
          items[selecteditem].expand;
      end
    else if (key = VK_LEFT) then
        items[selecteditem].collapse;
  end;
end;

procedure TArchiveView.FormResize(Sender: TObject);
begin
  GridResize;
end;

procedure TArchiveView.RxDBGrid1GetCellParams(Sender: TObject;
  Field: TField; AFont: TFont; var Background: TColor; Highlight: Boolean);
var
   num : integer;
begin
  num := (Sender as TrxDBGrid).DataSource.DataSet.FieldByName('Importance').AsInteger;
  case num of
       1: Background := clRed;
       2: Background := clYellow;
  end;

  if Highlight then begin
    AFont.Color := clHighlightText;
    Background := clHighlight;
  end;
end;

procedure TArchiveView.RxDBGrid1DblClick(Sender: TObject);
var
   s : string;
   s1 : string;
begin
  s :=  dbedit2.text + dbedit1.text;
  if not fileexists(s) then
    messagedlg(s+' does not exist',mtinformation,[mbok],0)
  else
    s1 := extractfilepath(s);
    Chdir(s1);
    runprog(s);
end;

procedure TArchiveView.DelArchClick(Sender: TObject);
begin
  if messagedlg('Delete '+DBEdit1.text+' ?.',
                mtconfirmation,[mbYes,mbNo],0) = mrYes then
    begin
      table3.delete;
    end;
end;

procedure TArchiveView.EdArchClick(Sender: TObject);
begin
  editkey := StrToInt(FileID.Text);
  application.createform(TEditForm,EditForm);
  EditForm.Showmodal;
  table3.refresh;
end;

end.
