unit Aarc;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DBCtrls, Mask, DBTables, DB, Grids, DBGrids,
  RXDBCtrl, RXSpin, Buttons, Spin, ExtCtrls;

type
  TAddArchive = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    RxDBGrid1: TRxDBGrid;
    RxDBGrid2: TRxDBGrid;
    Table1: TTable;
    Table1TopicName: TStringField;
    Table1TopicID: TIntegerField;
    DataSource1: TDataSource;
    Table2: TTable;
    Table2CatagoryName: TStringField;
    Table2TopicID: TIntegerField;
    DataSource2: TDataSource;
    Table3: TTable;
    Table3ArchiveName: TStringField;
    Table3ArchiveStorage: TStringField;
    Table3Size: TIntegerField;
    Table3Date: TDateField;
    Table3Description: TMemoField;
    Table3Importance: TSmallintField;
    Table3FileID: TIntegerField;
    Table3CatagoryID: TIntegerField;
    DataSource3: TDataSource;
    ArchName: TDBEdit;
    ArchStorage: TDBEdit;
    ArchDate: TDBEdit;
    ArchSize: TDBEdit;
    ArchDescription: TDBMemo;
    ArchImportance: TDBEdit;
    ArchCatagoryID: TDBEdit;
    CatagoryID: TDBEdit;
    Table2CatagoryID: TIntegerField;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Button1: TButton;
    EName: TEdit;
    EStorage: TEdit;
    ESize: TEdit;
    EDescription: TMemo;
    BitBtn2: TBitBtn;
    ELevel: TSpinEdit;
    BitBtn1: TBitBtn;
    Bevel1: TBevel;
    CatagoryName: TDBEdit;
    TopicName: TDBEdit;
    DBText1: TDBText;
    DBText2: TDBText;
    Label9: TLabel;
    Label10: TLabel;
    OpenDialog1: TOpenDialog;
    EDate: TMaskEdit;
    procedure ELevelChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AddArchive: TAddArchive;

implementation

{$R *.DFM}

procedure TAddArchive.ELevelChange(Sender: TObject);
begin
  case ELevel.value of
       1: ELevel.color := clRed;
       2: ELevel.color := clYellow;
       3: ELevel.color := clBtnFace;
  end;
end;

procedure TAddArchive.FormCreate(Sender: TObject);
begin
  if mdichildcount > 0 then
    cascade
  else
    begin
      top := 0;
      left := 0;
    end;
  table1.active := true;
  table2.active := true;

end;

procedure TAddArchive.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  table1.close;
  table2.close;
  table3.close;
  action := cafree;
end;

procedure TAddArchive.BitBtn2Click(Sender: TObject);
begin
  if EName.text = '' then
    messagedlg('Specify an Archive Name first',mtinformation,[mbok],0)
  else
    if messagedlg('Add '+EName.text+' to Topic '+TopicName.text+' - '+
                  CatagoryName.text+' ?.',mtconfirmation,[mbYes,mbNo],0) =
                  mrYes then begin
      table3.open;
      table3.append;
      ArchName.Text        := EName.Text;
      ArchStorage.Text     := EStorage.Text;
      ArchDate.Text        := EDate.Text;
      ArchSize.Text        := ESize.Text;
      Archimportance.Text  := IntToStr(ELevel.value);
      ArchDescription.Text := EDescription.Text;
      ArchCatagoryID.Text  := CatagoryID.Text;
      table3.post;
      table3.close;

      if messagedlg(EName.text+' has been added, would you like to add another ?',
                    mtconfirmation,[mbYes,mbNo],0) = mryes then
        begin
          EName.text := '';
          EStorage.text := '';
          EDate.text := '';
          Esize.text := '';
          Elevel.value := 3;
          EDescription.text := '';
        end
      else
        begin
          close;
        end;
      end;
end;

procedure TAddArchive.BitBtn1Click(Sender: TObject);
begin
  close;
end;

procedure TAddArchive.Button1Click(Sender: TObject);
var
   F : file;
   Fname : string;
   Fhnd : THandle;
   Fdate : string;
   SearchRec: TSearchRec;

begin
  if opendialog1.execute then
    begin
      Fname := opendialog1.filename;
      {get filename}
      EName.text    := ExtractFilename(Fname);
      EStorage.text := ExtractFilePath(Fname);

      try
        FHnd          := FileOpen(fname,0);
        EDate.text    := DateToStr(FileDateToDateTime(FileGetDate(FHnd)));
        FileClose(fhnd);
      except
        messagedlg('Could''nt get Date from File',mterror,[mbok],0);
        FileClose(fhnd);
      end;



      try
        FindFirst(Fname, faAnyFile, SearchRec);
        ESize.text := IntToStr(SearchRec.Size);
        ELevel.value := 3;
        EDescription.text := '';
      except
        messagedlg('Could''nt get File Size',mterror,[mbok],0);
      end;

   end;
end;

end.
