unit Main;

interface

uses WinTypes, WinProcs, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls,
  atopic, etopic, dtopic, acat, ecat, dcat, arcview, aarc, search, Mask,
  DBCtrls, DB, DBTables, Lmdabout, Statbaru;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Help1: TMenuItem;
    FileExitItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    OpenDialog: TOpenDialog;
    Edit1: TMenuItem;
    CutItem: TMenuItem;
    CopyItem: TMenuItem;
    PasteItem: TMenuItem;
    SpeedPanel: TPanel;
    CutBtn: TSpeedButton;
    CopyBtn: TSpeedButton;
    PasteBtn: TSpeedButton;
    ExitBtn: TSpeedButton;
    Add1: TMenuItem;
    Edit2: TMenuItem;
    Delete1: TMenuItem;
    Add2: TMenuItem;
    Edit3: TMenuItem;
    Delete2: TMenuItem;
    Archive1: TMenuItem;
    Add3: TMenuItem;
    Tools1: TMenuItem;
    Search1: TMenuItem;
    Setup1: TMenuItem;
    Topic2: TMenuItem;
    Catagory2: TMenuItem;
    N1: TMenuItem;
    View1: TMenuItem;
    N2: TMenuItem;
    Importance1: TMenuItem;
    PurgeAll1: TMenuItem;
    ShiftUP1: TMenuItem;
    ShiftDOWN1: TMenuItem;
    N3: TMenuItem;
    Table3: TTable;
    DataSource1: TDataSource;
    DBEdit1: TDBEdit;
    Level11: TMenuItem;
    Level21: TMenuItem;
    Level31: TMenuItem;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    LMDAboutDlg1: TLMDAboutDlg;
    Table1: TTable;
    DataSource2: TDataSource;
    TopicID: TDBEdit;
    EStatusBar1: TEStatusBar;
    procedure FormCreate(Sender: TObject);
    procedure WindowCascadeItemClick(Sender: TObject);
    procedure WindowTileItemClick(Sender: TObject);
    procedure WindowArrangeItemClick(Sender: TObject);
    procedure FileExitItemClick(Sender: TObject);
    procedure CutItemClick(Sender: TObject);
    procedure CopyItemClick(Sender: TObject);
    procedure PasteItemClick(Sender: TObject);
    procedure WindowMinimizeItemClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Add1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Edit2Click(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure Add2Click(Sender: TObject);
    procedure Edit3Click(Sender: TObject);
    procedure Delete2Click(Sender: TObject);
    procedure View1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Add3Click(Sender: TObject);
    procedure Delete3Click(Sender: TObject);
    procedure Search1Click(Sender: TObject);
    procedure Level11Click(Sender: TObject);
    procedure Level21Click(Sender: TObject);
    procedure Level31Click(Sender: TObject);
    procedure ShiftUP1Click(Sender: TObject);
    procedure ShiftDOWN1Click(Sender: TObject);
    procedure HelpAboutItemClick(Sender: TObject);
  private
    { Private declarations }
    procedure ShowHint(Sender: TObject);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;


implementation

{$R *.DFM}

function FormCanOpen : boolean;
begin
  mainform.table1.open;

  if mainform.topicID.text = '' then
    begin
      messagedlg('There are no Topics available.'+#13+
                 'Topics are the top level groups that hold '+
                 'Catagories and Archives.',mtinformation,[mbok],0);
      FormCanOpen := False;
    end
  else
    FormCanOpen := True;

  mainform.table1.close;
end;


procedure changelevel(t : string;l : integer);
var
   count : integer;
   continue : boolean;
begin
  count := 0;
  continue := false;

  if t = 'purge' then
    begin
      if messagedlg('This function will place all archives at'+#13+
                    'Importance level - '+intTostr(l)+', Continue ?',
                    mtconfirmation,[mbyes,mbno],0) = mryes then
        begin
          continue := true
        end;
    end
  else if t = 'shiftup' then
    begin
      if messagedlg('This function will place all archive'+#13+
                    'Importance levels up 1 level, Continue ?',
                    mtconfirmation,[mbyes,mbno],0) = mryes then
        begin
          continue := true
        end;
    end
  else if t = 'shiftdown' then
    begin
      if messagedlg('This function will place all archive'+#13+
                    'Importance levels down 1 level, Continue ?',
                    mtconfirmation,[mbyes,mbno],0) = mryes then
        begin
          continue := true
        end;
    end;

  if continue then
    begin
      mainform.table3.open;
      mainform.table3.first;

      while not mainform.table3.eof do
        begin
          mainform.table3.edit;

          if t = 'purge' then
            mainform.dbedit1.text := IntToStr(l)
          else if (t = 'shiftup') and (mainform.dbedit1.text <> '1') then
            mainform.dbedit1.text := IntToStr(StrToInt(mainform.dbedit1.text) - 1)
          else if (t = 'shiftdown') and (mainform.dbedit1.text <> '3') then
            mainform.dbedit1.text := IntToStr(StrToInt(mainform.dbedit1.text) + 1);

          mainform.table3.post;
          count := count + 1;
          mainform.table3.next;
        end;
      mainform.table3.close;
      messagedlg(IntToStr(count)+' archives updated',mtinformation,[mbok],0);
    end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnHint := ShowHint;
  
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  Estatusbar1.Caption := Application.Hint;
end;

procedure TMainForm.FileExitItemClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.CutItemClick(Sender: TObject);
begin
  if GetFocus <> 0 then
    SendMessage( GetFocus, WM_CUT, 0, 0);
end;

procedure TMainForm.CopyItemClick(Sender: TObject);
begin
  if GetFocus <> 0 then
    SendMessage( GetFocus, WM_COPY, 0, 0);
end;

procedure TMainForm.PasteItemClick(Sender: TObject);
begin
  if GetFocus <> 0 then
    SendMessage( GetFocus, WM_PASTE, 0, 0);
end;

procedure TMainForm.WindowCascadeItemClick(Sender: TObject);
begin
  Cascade;
end;

procedure TMainForm.WindowTileItemClick(Sender: TObject);
begin
  Tile;
end;

procedure TMainForm.WindowArrangeItemClick(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TMainForm.WindowMinimizeItemClick(Sender: TObject);
var
  I: Integer;
begin
  { Must be done backwards through the MDIChildren array }
  for I := MDIChildCount - 1 downto 0 do
    MDIChildren[I].WindowState := wsMinimized;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  Screen.OnActiveFormChange := nil;
  close;
end;

procedure TMainForm.Add1Click(Sender: TObject);
var
   i : integer;
begin
  if mdichildcount > 0  then
    begin
      for i := MDIChildCount - 1 downto 0 do
        begin
          mdichildren[i].Close;
        end;
    end;

  application.createform(Taddtopic,addtopic);
  
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
var
   i : integer;
begin
  if mdichildcount > 0 then
  begin
    for i := 1 to mdichildcount-1 do
      begin
        mdichildren[i].close;
      end;
  end;
  action := cafree;
end;

procedure TMainForm.Edit2Click(Sender: TObject);
var
   i : integer;
begin
  if FormCanOpen then
  begin

  if mdichildcount > 0  then
    begin
      for i := MDIChildCount - 1 downto 0 do
        begin
          mdichildren[i].Close;
        end;
    end;

  application.createform(Tedittopic,edittopic);
  end;
end;

procedure TMainForm.Delete1Click(Sender: TObject);
var
   i : integer;
begin
  if FormCanOpen then
  begin

  if mdichildcount > 0  then
    begin
      for i := MDIChildCount - 1 downto 0 do
        begin
          mdichildren[i].Close;
        end;
    end;

  application.createform(Tdeletetopic,deletetopic);
  end;
end;

procedure TMainForm.Add2Click(Sender: TObject);
var
   i : integer;
begin
  if FormCanOpen then
  begin

  if mdichildcount > 0  then
    begin
      for i := MDIChildCount - 1 downto 0 do
        begin
          mdichildren[i].Close;
        end;
    end;

  application.createform(Taddcatagory,addcatagory);
  end;

end;

procedure TMainForm.Edit3Click(Sender: TObject);
var
   i : integer;
begin
  if FormCanOpen then
  begin

  if mdichildcount > 0  then
    begin
      for i := MDIChildCount - 1 downto 0 do
        begin
          mdichildren[i].Close;
        end;
    end;

  application.createform(Teditcatagory,editcatagory);
  end;
end;

procedure TMainForm.Delete2Click(Sender: TObject);
var
   i : integer;
begin
  if FormCanOpen then
  begin

  if mdichildcount > 0  then
    begin
      for i := MDIChildCount - 1 downto 0 do
        begin
          mdichildren[i].Close;
        end;
    end;

  application.createform(Tdeletecatagory,deletecatagory);
  end;
end;

procedure TMainForm.View1Click(Sender: TObject);
var
   i : integer;
begin
  if FormCanOpen then
  begin

  if mdichildcount > 0  then
    begin
      for i := MDIChildCount - 1 downto 0 do
        begin
          mdichildren[i].Close;
        end;
    end;

  application.createform(Tarchiveview,archiveview);
  end;
end;

procedure TMainForm.FormActivate(Sender: TObject);
begin
  if FormCanOpen then
  begin
    application.createform(Tarchiveview,Archiveview);
  end;
end;

procedure TMainForm.Add3Click(Sender: TObject);
var
   i : integer;
begin
  if FormCanOpen then
  begin

  if mdichildcount > 0  then
    begin
      for i := MDIChildCount - 1 downto 0 do
        begin
          mdichildren[i].Close;
        end;
    end;

  application.createform(Taddarchive,addarchive);
  end;
end;

procedure TMainForm.Delete3Click(Sender: TObject);
var
   i : integer;
begin
  if mdichildcount > 0  then
    begin
      for i := MDIChildCount - 1 downto 0 do
        begin
          mdichildren[i].Close;
        end;
    end;

  application.createform(Tarchiveview,archiveview);
  view1.enabled := false;
end;

procedure TMainForm.Search1Click(Sender: TObject);
var
   i : integer;
begin
  if FormCanOpen then
  begin
  if mdichildcount > 0  then
    begin
      for i := MDIChildCount - 1 downto 0 do
        begin
          mdichildren[i].Close;
        end;
    end;

  application.createform(Tsearchform,searchform);
  end;
end;

procedure TMainForm.Level11Click(Sender: TObject);
begin
  changelevel('purge',1);
end;

procedure TMainForm.Level21Click(Sender: TObject);
begin
  changelevel('purge',2);
end;

procedure TMainForm.Level31Click(Sender: TObject);
begin
  changelevel('purge',3);
end;

procedure TMainForm.ShiftUP1Click(Sender: TObject);
begin
  changelevel('shiftup',0);
end;

procedure TMainForm.ShiftDOWN1Click(Sender: TObject);
begin
  changelevel('shiftdown',0);
end;

procedure TMainForm.HelpAboutItemClick(Sender: TObject);
begin
  lmdaboutdlg1.execute;
end;

end.
