unit Tstdirec;

interface

uses
  Classes,
  Forms,
  Director,
  StdCtrls,
  Controls,
  ExtCtrls,
  TabNotBk,
  FileCtrl;


type
	T_Selection = (FilesSelection, SearchDirSelection);
  TForm1 = class(TForm)
    LbxResults: TListBox;
	 BtnFind: TButton;
	 BtnQuit: TButton;
	 BtnCancel: TButton;
    EdFileMask: TEdit;
	 TbNbSelections: TTabbedNotebook;
    ChkbxWithSubDir: TCheckBox;
    PnlInclusions: TPanel;
    PnlExclusions: TPanel;
    LblVersion: TLabel;
    Chkbxfilehidden: TCheckBox;
    Chkbxfilesystem: TCheckBox;
    ChkbxfileVolume: TCheckBox;
    Chkbxfileexcarchive: TCheckBox;
    ChkbxfileExcNormal: TCheckBox;
    Chkbxdirhidden: TCheckBox;
    Chkbxdirsystem: TCheckBox;
    Chkbxdirexcreadonly: TCheckBox;
    Chkbxdirexcarchive: TCheckBox;
    ChkbxdirexcNormal: TCheckBox;
    Chkbxexcfilereadonly: TCheckBox;
    Chkbxfiledirectory: TCheckBox;
    ChkbxOnlyDir: TCheckBox;
    DirectoryListBox1: TDirectoryListBox;
    LblInitialDir: TLabel;
    LblDirMask: TLabel;
    EdDirMask: TEdit;
    LblFileMask: TLabel;
    LblSearch: TLabel;
    LblCurrentDir: TLabel;
    EdCurrentDir: TEdit;
    Directory1: TDirectory;
	 procedure BtnFindClick(Sender: TObject);
	 procedure BtnCancelClick(Sender: TObject);
	 procedure BtnQuitClick(Sender: TObject);
	 procedure CHkbxSubDirOnlyClick(Sender: TObject);
	 procedure FormCreate(Sender: TObject);
	 procedure EdFileMaskExit(Sender: TObject);
    procedure Directory1Found(Sender: TObject);
    procedure Directory1SearchStatus(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure ChkbxWithSubDirClick(Sender: TObject);
    procedure ChkbxexcfilereadonlyClick(Sender: TObject);
    procedure ChkbxfilehiddenClick(Sender: TObject);
    procedure ChkbxfilesystemClick(Sender: TObject);
    procedure ChkbxfileVolumeClick(Sender: TObject);
    procedure ChkbxfiledirectoryClick(Sender: TObject);
    procedure chkbxfileExcReadOnlyClick(Sender: TObject);
    procedure ChkbxfileexcarchiveClick(Sender: TObject);
    procedure ChkbxfileExcNormalClick(Sender: TObject);
    procedure chkbxdirreadonlyClick(Sender: TObject);
    procedure ChkbxdirhiddenClick(Sender: TObject);
    procedure ChkbxdirsystemClick(Sender: TObject);
    procedure ChkbxdirexcreadonlyClick(Sender: TObject);
    procedure chkbxdirexchiddenClick(Sender: TObject);
    procedure chkbxdirexcsystemClick(Sender: TObject);
    procedure ChkbxdirexcarchiveClick(Sender: TObject);
    procedure ChkbxdirexcNormalClick(Sender: TObject);
    procedure ChkbxOnlyDirClick(Sender: TObject);
    procedure DirectoryListBox1Change(Sender: TObject);
    procedure EdDirMaskExit(Sender: TObject);
  private
	 { Private-declarations }
  public
	 { Public-declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
{$R *.res}

	uses
   	WinProcs;


	procedure TForm1.BtnFindClick(Sender: TObject);
	begin
		LbxResults.clear;
      BtnFind.Enabled:=False;
      BtnCancel.Enabled:=True;
      ActiveControl := BtnCancel;
      EdCurrentDir.Text:=Directory1.Initialdir;
      TbNbSelections.enabled := false;
      ChkbxWithSubDir.enabled := false;
      ChkbxOnlyDir.enabled := false;
      DirectoryListBox1.enabled := false;
      EdFileMask.enabled := false;
      EdDirMask.enabled := false;
		Directory1.Execute;
	end;

	procedure TForm1.Directory1Found(Sender: TObject);
	begin
		LbxResults.Items.Add(Directory1.SelectedFileName);
      IF EdCurrentDir.Text <> Directory1.DirectoryInTreatment THEN
      	EdCurrentDir.Text:= Directory1.DirectoryInTreatment;
	end;

	procedure TForm1.BtnCancelClick(Sender: TObject);
	begin
		Directory1.DoStop;
	end;

	procedure TForm1.Directory1SearchStatus(Sender: TObject);

	begin
		IF Directory1.Stopped THEN
		BEGIN
			BtnFind.Enabled := TRUE;
			ActiveControl := BtnFind;
         TbNbSelections.enabled := true;
         ChkbxWithSubDir.enabled := true;
         ChkbxOnlyDir.enabled := true;
         DirectoryListBox1.enabled := true;
         EdFileMask.enabled := true;
         EdDirMask.enabled := true;
			BtnCancel.Enabled := FALSE;
		END;
 	end;

	procedure TForm1.BtnQuitClick(Sender: TObject);
	begin
		PostquitMessage(0);
	end;

	procedure TForm1.CHkbxSubDirOnlyClick(Sender: TObject);
	begin
 		Directory1.InSubDirectories:=ChkBxWithSubDir.checked
	end;

   procedure TForm1.ChkbxOnlyDirClick(Sender: TObject);
   begin
   	try
	    	Directory1.OnlyDirectories := (Sender AS TCheckbox).Checked;
      except
      	(Sender As TCheckbox).Checked := false;
  	      Raise;
      END;
   end;

	procedure TForm1.FormCreate(Sender: TObject);
	begin
      LblVersion.caption := 'Version '+Directory1.Version;
		WITH Directory1 DO
		begin
			EdFileMask.Text:=Directory1.FileFilter;
         EdDirMask.Text :=Directory1.DirectoryFilter;
			TbNbSelections.PageIndex:=0;
			chkbxfilehidden.checked := IncludeHiddenFiles;
         chkbxfilesystem.checked := IncludeSystemFiles;
         chkbxfileVolume.checked := IncludeVolumeId;
         chkbxfiledirectory.checked := IncludeDirectoryFiles;
         chkbxexcfilereadonly.checked := ExcludeReadOnlyFiles;
         chkbxfileexcarchive.checked := ExcludeArchiveFiles;
			ChkBxfileExcNormal.checked := ExcludeNormalFiles;
         chkbxdirhidden.checked := IncludeHiddenDir;
         chkbxdirsystem.checked := IncludeSystemDir;
         chkbxdirexcreadonly.checked := ExcludeReadOnlyDir;
         chkbxdirexcarchive.checked := ExcludeArchiveDir;
         chkbxdirexcNormal.checked := ExcludeNormalDir;
			ChkBxWithSubDir.Checked := InSubDirectories;
         ChkbxOnlyDir.Checked := OnlyDirectories;
         DirectoryListBox1.Directory := InitialDir;
         EdCurrentDir.Text:=InitialDir;
		end;
 	end;

	procedure TForm1.EdFileMaskExit(Sender: TObject);

	begin
		try
			Directory1.FileFilter:=EdFileMask.text;
		except
			EdFileMask.text:=Directory1.FileFilter;
			Raise
		end
 	end;

procedure TForm1.FormResize(Sender: TObject);

VAR
	Indice : INTEGER;
   Decalage : INTEGER;
begin
	IF Height < 500 THEN
   	Height:= 500;
   IF Width < 567 THEN
	   Width:=567;
	Indice := 0;
   Decalage := Height-EdCurrentDir.Top-58;
	FOR Indice := 0 TO ControlCount-1 DO
   	WITH Controls[Indice] AS TControl DO
	      Top := Top+ Decalage;
   LbxResults.Top := 8;
   LbxResults.Height:= TbNbSelections.top-16;
   LbxResults.Width := Width - 28;
   EdCurrentDir.Width := Width - 141;
end;

procedure TForm1.ChkbxWithSubDirClick(Sender: TObject);
begin
	Directory1.InSubDirectories:=ChkBxWithSubDir.Checked;
end;


procedure TForm1.ChkbxexcfilereadonlyClick(Sender: TObject);

begin
	Directory1.ExcludeReadOnlyFiles := (Sender AS TCheckBox).Checked;
end;

procedure TForm1.ChkbxfilehiddenClick(Sender: TObject);
begin
	Directory1.IncludeHiddenFiles := (Sender AS TCheckBox).Checked;
end;

procedure TForm1.ChkbxfilesystemClick(Sender: TObject);
begin
	Directory1.IncludeSystemFiles := (Sender AS TCheckBox).Checked;
end;

procedure TForm1.ChkbxfileVolumeClick(Sender: TObject);
begin
	Directory1.IncludeVolumeId := (Sender AS TCheckBox).Checked;
end;

procedure TForm1.ChkbxfiledirectoryClick(Sender: TObject);
begin
	TRY
		Directory1.IncludeDirectoryFiles := (Sender AS TCheckBox).Checked;
   Except
		(Sender AS TCheckBox).Checked:=True;
      Raise;
   END;
end;

procedure TForm1.chkbxfileExcReadOnlyClick(Sender: TObject);
begin
	Directory1.ExcludeReadOnlyFiles := (Sender AS TCheckBox).Checked;
end;

procedure TForm1.ChkbxfileExcNormalClick(Sender: TObject);
begin
  	Directory1.ExcludeNormalFiles:=ChkBxfileExcNormal.checked
end;

procedure TForm1.ChkbxfileexcarchiveClick(Sender: TObject);
begin
	Directory1.ExcludeArchiveFiles := (Sender AS TCheckBox).Checked;
end;

procedure TForm1.chkbxdirreadonlyClick(Sender: TObject);

begin
	Directory1.ExcludeReadOnlyDir := (Sender AS TCheckBox).Checked;
end;

procedure TForm1.ChkbxdirhiddenClick(Sender: TObject);
begin
	Directory1.IncludeHiddenDir:=(Sender AS TCheckBox).Checked;
end;

procedure TForm1.ChkbxdirsystemClick(Sender: TObject);
begin
	Directory1.IncludeSystemDir := (Sender AS TCheckBox).Checked;
end;

procedure TForm1.ChkbxdirexcreadonlyClick(Sender: TObject);
begin
	Directory1.ExcludeReadOnlyDir := (Sender AS TCheckBox).Checked;
end;

procedure TForm1.chkbxdirexchiddenClick(Sender: TObject);
begin
	Directory1.IncludeHiddenDir := (Sender AS TCheckBox).Checked;
end;

procedure TForm1.chkbxdirexcsystemClick(Sender: TObject);
begin
	Directory1.IncludeSystemDir := (Sender AS TCheckBox).Checked;
end;

procedure TForm1.ChkbxdirexcarchiveClick(Sender: TObject);
begin
	Directory1.ExcludeArchiveDir := (Sender AS TCheckBox).Checked;
end;

procedure TForm1.ChkbxdirexcNormalClick(Sender: TObject);

begin
  	Directory1.ExcludeNormalDir := (Sender AS TCheckBox).Checked;;
end;

procedure TForm1.DirectoryListBox1Change(Sender: TObject);
begin
	Directory1.InitialDir := DirectoryListBox1.Directory;
	EdCurrentDir.Text:=Directory1.Initialdir;
end;

	procedure TForm1.EdDirMaskExit(Sender: TObject);

	begin
		try
			Directory1.DirectoryFilter:=EdDirMask.text;
		except
			EdDirMask.text:=Directory1.DirectoryFilter;
			Raise
		end
 	end;

end.
