Unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    Button1: TButton;
    Memo1: TMemo;
    Image: TImage;
    CheckBox1: TCheckBox;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
		Buff   : PChar;
	  width  : Integer;
	  height : Integer;
    { Public declarations }
		procedure DisplayImage;
  end;

(***********************************************************)
type
	int32  = LongInt;
	uint32 = Cardinal;
	int16  = SmallInt;
	uint16 = Word;
	int8   = ShortInt;
	uint8  = Byte;

function read16( var fp : File ): uint16;
function read32 ( var fp : File ): uint32;
procedure read_dicom_data( var buff : PChar; var width:Integer;
                           var height:Integer; var fp:File );
procedure flip_16bit_data ( var buff : PChar; width : Integer; height:Integer);
procedure scale16to8( var buff : PChar; width : Integer; height:Integer);


var
	little_endian   : Integer = 1;  //1 for pre-swapped
	bytes_per_pixel : Integer = 1;
	scale_flag      : Integer = 0;  //scale 16 bits to 8
	flip_flag       : Integer = 0;  //flip 16 bit data values
	no_flip_flag    : Integer = 0;  //no flip no matter what!
	invert_flag     : Integer = 0;	//invert data values

	infp  : File;  	//DICOM file
	textfp : Text;  //text file containing DICOM header info

var
  Form1: TForm1;

implementation

{$R *.DFM}

(***********************************************************)
procedure TForm1.Button1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
			// open the input DICOM file
		AssignFile(infp, OpenDialog1.FileName);
	  Reset(infp, 1);

			// open the DICOM text file
		AssignFile(textfp, 'text.txt');
	  Rewrite(textfp);

		read_dicom_data(buff, width, height, infp);

		if CheckBox1.Checked then
		begin
    	flip_flag := 1;
    	flip_16bit_data ( buff, width, height);
		end;

		scale16to8( buff, width, height );

    CloseFile(infp);
    CloseFile(textfp);

    Memo1.Lines.LoadFromFile('text.txt');

// Display Image
    DisplayImage;
  end;
end;


procedure TForm1.DisplayImage;
var
  I       : Integer;
	hBmp    : HBITMAP;
  BI      : PBitmapInfo;
  BIH     : TBitmapInfoHeader;
  Bmp     : TBitmap;
  TmpDC   : hDC;
  ImagoDC : hDC;
begin
		// Fill BitmapInfoHeader structure
	BIH.biSize   		 	 	:= Sizeof(BIH);
	BIH.biWidth  		 	 	:= width;
  BIH.biHeight 		 	 	:= -height;
	BIH.biPlanes 		 	 	:= 1;
  BIH.biBitCount 	 	 	:= 8;
	BIH.biCompression 	:= BI_RGB;
  BIH.biSizeImage	 	 	:= 0;
	BIH.biXPelsPerMeter := 0;
  BIH.biYPelsPerMeter := 0;
	BIH.biClrUsed       := 0;
  BIH.biClrImportant  := 0;

{$P+,S-,W-,R-}

 		// Create DIB Bitmap Info with actual color table
	BI := AllocMem(SizeOf(TBitmapInfoHeader) + 256*Sizeof(TRGBQuad));
	try
	  BI^.bmiHeader := BIH;
	  for I:=0 to 255 do begin
  		BI^.bmiColors[I].rgbBlue     := Byte( I );
    	BI^.bmiColors[I].rgbGreen    := Byte( I );
	    BI^.bmiColors[I].rgbRed      := Byte( I );
		  BI^.bmiColors[I].rgbReserved := 0;
    end;

	  Bmp        := TBitmap.Create;
  	Bmp.Height := width;
	  Bmp.Width  := height;

	  ImagoDC := GetDC(Form1.Handle);
	  hBmp :=  CreateDIBitmap(
    				ImagoDC,		// handle of device context
    				BIH,									// address of bitmap size and format data
    				CBM_INIT,							// initialization flag
	    			buff,									// address of initialization data
  	  			BI^,									// address of bitmap color-format data
    				DIB_RGB_COLORS ); 		// color-data usage
	  Bmp.Handle := hBmp;

			// Draw bitmap proportional into the given Image
//  	Image.Canvas.Brush.Color := clRED;
//	  Image.Canvas.FillRect(Image.BoundsRect);
//		Image.Canvas.StretchDraw(ImgRect, Bmp);
Image.Picture.Bitmap.Assign( Bmp );
Image.Refresh;

	  Bmp.Free;
	except
//		showmessage(MainForm.MultiLanguage1.GetMsg('XOutOfMemory'));
	  exit;
  end;
  FreeMem( BI, SizeOf(TBitmapInfoHeader) + 256*Sizeof(TRGBQuad));

{$P-,S+,W+,R+}
end;











(***********************************************************)
function read16( var fp : File ): uint16;
var
	t1, t2 : uint8;
  n      : Integer;
begin
	BlockRead(fp, t1, SizeOf(uint8), n);
	BlockRead(fp, t2, SizeOf(uint8), n);

  if little_endian <> 0
  	then Result := (t1 + t2*256) AND $FFFF
  	else Result := (t1*256 + t2) AND $FFFF;
end;

(***********************************************************)
function read32 ( var fp : File ): uint32;
var
	t1, t2, t3, t4 : uint8;
  n : Integer;
begin
	BlockRead(fp, t1, SizeOf(uint8), n);
	BlockRead(fp, t2, SizeOf(uint8), n);
	BlockRead(fp, t3, SizeOf(uint8), n);
	BlockRead(fp, t4, SizeOf(uint8), n);

  if little_endian <> 0
  	then Result := (t1 + t2*256 + t3*256*256 + t4*256*256*256) AND $FFFFFFFF
    else Result := (t1*256*256*256 + t2*256*256 + t3*256 + t4) AND $FFFFFFFF;
end;

(***********************************************************)
procedure read_dicom_data( var buff : PChar; var width:Integer;
                           var height:Integer; var fp:File );
type
  dicom_types = (unknown, i8, i16, i32, ui8, ui16, ui32, _string );
var
	first_one    : Boolean;
  time_to_quit : Boolean;

	group, element, dummy, e_len, remaining, tmp : uint32;
  info   : string;
  t      : dicom_types;
  where  : LongInt;
  tx     : array [0..3] of Char;
  n, i   : Integer;
begin
  info := '';
  t := unknown;

		// try DICOM part 10 i.e. a 128 byte file preamble followed by "DICM"
  seek(fp, 0);
	where := FilePos(fp);
	BlockRead(fp, tx, 4*SizeOf(Char), n);
  if (tx[0] <> 'D') OR (tx[1] <> 'I') OR (tx[2] <> 'C') OR (tx[3] <> 'M') then
	begin
	  seek(fp, 128); //skip the preamble - next 4 bytes should be 'DICM'
  	where := FilePos(fp);
		BlockRead(fp, tx, 4*SizeOf(Char), n);
		if (tx[0] <> 'D') OR (tx[1] <> 'I') OR (tx[2] <> 'C') OR (tx[3] <> 'M') then
		begin
//    	showmessage('not a proper DICOM file');

      	// try DICOM without header
	  	seek(fp, 0);
	   	group   := read16(fp);
	    element := read16(fp);
      if NOT (group in [$0000, $0002, $0004, $0008]) then
				exit;
	  	seek(fp, 0);
		end;
	end;

		// Read DICOM Tags
	time_to_quit := FALSE;
	while NOT time_to_quit do
  begin
  	where     := FilePos(fp);
   	group     := read16(fp);
    element   := read16(fp);
    if group = $0002 then
    begin
   		dummy := read16(fp);
   		e_len := read16(fp);
      if element = $0001 then
      begin
   			dummy := read32(fp);
   			dummy := read16(fp);
        e_len := 0;
      end;
    end
    else e_len := read32(fp);
	  remaining := e_len;

		info := 'unknown';
    case group of
    	$0002 :
      	case element of
        	$00 :  info := 'file meta elements group len';
          $01 :  info := 'file meta info version';
          $02 :  info := 'media storage SOP class uid';
          $03 :  info := 'media storage SOP inst uid';
          $10 :  info := 'transfer syntax uid';
          $12 :  info := 'implementation class uid';
          $13 :  info := 'implementation version name';
          $16 :  info := 'source app entity title';
          $100:  info := 'private info creator uid';
          $102:  info := 'private info';
				end;
      $0008 :
        case element of
          $00 :  info := 'identifying group';
          $01 :  info := 'length to end';
          $08 :  info := 'image type';
          $10 :  info := 'recognition code';
          $16 :  info := 'SOP Class UID';
          $18 :  info := 'SOP Instance UID';
          $20 :  info := 'study date';
          $21 :  info := 'series date';
          $22 :  info := 'acquisition date';
          $23 :  info := 'image date';
          $30 :  info := 'study time';
          $31 :  info := 'series time';
          $32 :  info := 'acquisition time';
          $33 :  info := 'image time';
          $40 :  info := 'data set type';
          $41 :  info := 'data set subtype';
          $50 :  info := 'accession number';
          $60 :  begin info := 'modality';  t := _string; end;
          $70 :  info := 'manufacturer';
          $80 :  info := 'institution name';
          $90 :  info := 'referring physician''s name';
          $1010: info := 'station name';
          $103e: info := 'series description';
          $1030: info := 'study description';
          $1040: info := 'institutional dept. name';
          $1060: info := 'name phys(s) read stdy';
          $1070: begin info := 'operator''s name';  t := _string; end;
          $1090: info := 'manufacturer''s model name';
        end;
    	$0010 :
        case element of
        	$00 :  info := 'patient group';
          $10 :  begin info := 'patient name'; t := _string; end;
          $20 :  info := 'patient ID';
          $30 :  info := 'patient date of birth';
          $40 :  begin info := 'patient sex';  t := _string; end;
          $1010: info := 'patient age';
          $1030: info := 'patient weight';
          $21b0: info := 'additional patient history';
				end;
			$0018 :
        case element of
					$00 :  info := 'acquisition group';
          $10 :  begin info := 'contrast/bolus agent'; t := _string; end;
          $20 :  info := 'scanning sequence';
          $21 :  info := 'Sequence Variant';
          $22 :  info := 'Scan Options';
          $23 :  begin info := 'MR Acquisition Type'; t := _string; end;
          $24 :  info := 'Sequence Name';
          $25 :  info := 'Angio Flag';
          $30 :  info := 'radionuclide';
          $50 :  info := 'slice thickness';
          $80 :  info := 'repetition time';
          $81 :  info := 'echo time';
          $82 :  info := 'inversion time';
          $83 :  info := 'Number of Averages';
          $84 :  info := 'Imaging Frequency';
          $85 :  begin info := 'Imaged Nucleus';  t := _string; end;
          $86 :  info := 'Echo Number';
          $87 :  info := 'Magnetic Field Strength';
          $88 :  info := 'Spacing Between Slices';
          $91 :  info := 'Echo Train Length';
          $95 :  info := 'Pixel Bandwidth';
          $1020: info := 'software version';
          $1030: info := 'protocol name';
          $1088: info := 'Heart Rate';
          $1090: info := 'Cardiac Number of Images';
          $1094: info := 'Trigger Window';
          $1100: info := 'Reconstruction Diameter';
          $1120: info := 'gantry tilt';
          $1250: info := 'Receiving Coil';
          $1251: info := 'Transmitting Coil';
          $1310: info := 'Acquisition Matrix';
          $1314: info := 'Flip Angle';
          $1316: info := 'SAR';
          $5100: info := 'Patient Position';
				end;
			$0020 :
        case element of
					$00 :  info := 'relationship group';
          $0d :  info := 'Study Instance UID';
          $0e :  info := 'Series Instance UID';
          $10 :  info := 'study id';
          $11 :  begin info := 'series number';       t := _string; end;
          $12 :  begin info := 'acquisition number';  t := _string; end;
          $13 :  begin info := 'image number';        t := _string; end;
          $20 :  begin info := 'patient orientation'; t := _string; end;
          $30 :  info := 'image position';
          $32 :  info := 'Image Position Patient';
          $35 :  info := 'image orientation';
          $37 :  info := 'Image Orientation (Patient)';
          $50 :  info := 'location';
          $52 :  info := 'Frame of Reference UID';
          $60 :  info := 'Laterality';
          $1002: info := 'images in acquisition';
          $1040: info := 'position reference';
          $1041: info := 'slice location';
          $3401: info := 'modifying device id';
          $3402: info := 'modified image id';
          $3403: info := 'modified image date';
          $3404: info := 'modifying device mfg.';
          $3405: info := 'modified image time';
          $3406: info := 'modified image desc.';
          $5000: info := 'original image id';
				end;
			$0028 :
        case element of
        	$00 :  info := 'image presentation group';
          $02 :  info := 'samples per pixel';
          $04 :  info := 'Photometric Interpretation';
          $05 :  info := 'image dimensions';
          $10 :  begin info := 'rows';
          				height := read16(fp);
          				tmp := height;
                  remaining := 0;
                 end;
					$11 :  begin info := 'columns';
          				width := read16(fp);
          				tmp := height;
                  remaining := 0;
                 end;
          $30 :  info := 'pixel size';
          $50 :  info := 'manipulated image';
          $0100: begin info := 'bits allocated';
									tmp := read16(fp);
                  if tmp = 8 then bytes_per_pixel := 1
                  else if tmp = 16 then bytes_per_pixel := 2
                  else
                  begin
                  	writeln(textfp, IntToStr(tmp));
                    exit;
									end;
                  remaining := 0;
                 end;
        	$0101: begin info := 'bits stored';
          				tmp := read16(fp);
                  if tmp <= 8 then bytes_per_pixel := 1
                  else if tmp <= 16 then bytes_per_pixel := 2
                  else
                  begin
                  	writeln(textfp, IntToStr(tmp));
                  end;
                  remaining := 0;
          			 end;
          $0102: begin info := 'high bit';
          				tmp := read16(fp);
                                 (*
                                 could be 11 for 12 bit cr images so just
                                 skip checking it
                                 assert(tmp == 7 || tmp == 15);
                                 *)
                  remaining := 0;
                 end;
					$0103: info := 'pixel representation';
          $1050: info := 'window center';
          $1051: info := 'window width';
          $1052: info := 'rescale intercept';
          $1053: info := 'rescale slope';
				end;
      $4000 : info := 'text';
      $7FE0 :
        case element of
        	$00 :  info := 'pixel data';
          $10 :  begin info := 'pixel data'; time_to_quit := TRUE; end;
				end;
      else
      	begin
        	if (group >= $6000) AND (group <= $601e) AND ((group AND 1) = 0)
          	then  info := 'overlay';
          if element = $0000 then info := 'group length';
          if element = $4000 then info := 'comments';
				end;
    end;

    Write(textfp, IntToHex(where,4)+': ('+IntToHex(group,4)+','+IntToHex(element,4)+')');
    if info <> ''
    	then write(textfp, ' '+ info)
      else write(textfp, ' unrecognized');

    if time_to_quit then writeln(textfp);

        //skip unused data
    Write(textfp, ': '+IntToStr(e_len)+' ');

    if (NOT time_to_quit) AND (remaining > 0) then
    begin
    	GetMem( buff, e_len);
			BlockRead(fp, buff^, e_len, n);

      case t of
       	unknown :
       		case e_len of
           	1 : Write(textfp, IntToStr(Integer(buff[0])));
            2 : Begin
                 	if little_endian <> 0
                   	then i := Integer(buff[0]) + 256*Integer(buff[1])
                    else i := Integer(buff[0])*256 + Integer(buff[1]);
                  Write(textfp, IntToStr(i));
		  					end;
            4 : Begin
                 	if little_endian <> 0
                   	then i :=               Integer(buff[0])
                              +         256*Integer(buff[1])
                              +     256*256*Integer(buff[2])
                              + 256*256*256*Integer(buff[3])
                    else i :=   Integer(buff[0])*256*256*256
                              + Integer(buff[1])*256*256
                              + Integer(buff[2])*256
                              + Integer(buff[3]);
                  Write(textfp, IntToStr(i));
                end;
						else
             		begin
									for i := 0 to e_len-1 do
                  begin
                   	if Char(buff[i]) in [' ', '0'..'9','a'..'z','A'..'Z']
                     	then Write(textfp, Char(buff[i]))
                      else Write(textfp, '.');
									end;
                end;
					end;

        i8, i16, i32, ui8, ui16, ui32,
        _string  : for i := 0 to e_len-1 do
                   	if Char(buff[i]) in [' ', '0'..'9','a'..'z','A'..'Z']
                     	then Write(textfp, Char(buff[i]))
                      else Write(textfp, '.');
      end;
      FreeMem(buff);
    end
		else if e_len > 0 then Write(textfp, IntToStr(tmp));
    Writeln(textfp);
  end;	// end for

		//read the actual pixel data
	GetMem( buff, height * width * bytes_per_pixel);
	BlockRead(fp, buff^, height * width * bytes_per_pixel, n);
end;

(****************************************************************************)
procedure flip_16bit_data ( var buff : PChar; width : Integer; height:Integer);
var
i   : Integer;
tmp : Char;
begin
	if bytes_per_pixel <> 2 then exit;
  if flip_flag <> 0 then
  begin
    i := 0;
    while i < 2*width*height do
    begin
    	tmp       := buff[i];
      buff[i]   := buff[i+1];
      buff[i+1] := tmp;
      i := i + 2;
		end;

    Writeln(textfp);
    Writeln(textfp, 'Flipped 16-bit data.');
    exit;
	end;

  if (little_endian <> 0) OR (no_flip_flag <> 0) then exit;
  i := 0;
  while i < 2*width*height do
  begin
  	tmp       := buff[i];
    buff[i]   := buff[i+1];
    buff[i+1] := tmp;
    i := i + 2;
	end;
  Writeln(textfp);
  Writeln(textfp,'Flipped 16-bit data.');
end;

(**************************************************************)
procedure scale16to8( var buff : PChar; width : Integer; height:Integer);
var
  max16 : LongInt;
  min16 : LongInt;
  i,j   : Integer;
  new_buff : PChar;
  value : LongInt;
begin
	if bytes_per_pixel <> 2 then exit;

  value := Integer(buff[0]) + Integer(buff[1])*256;
  max16 := value;
  min16 := value;

    //first find the min and max of the 16-bit data
	i:=0;
  while I < 2*width*height do
  begin
    value := Integer(buff[i+1]);
    value := Integer(buff[i]) + value*256;
		if value < min16 then min16 := value;
    if value > max16 then max16 := value;
    i := i+2;
	end;
  Writeln(textfp);
  Writeln(textfp, 'Pixel value range: min= '+Inttostr(min16)+', max= '+Inttostr(max16));
  Writeln(textfp);


  GetMem( new_buff, width * height);

  	//now scale the 16-bit data to 8-bits
  for i := 0 to width*height-1 do
  begin
  	new_buff[i] := CHAR(Trunc(255*(Integer(Buff[i])-min16) / (max16-min16)));
	end;

	i:=0;
  j := 0;
  while I < 2*width*height do
  begin
    value := Integer(buff[i]) + Integer(buff[i+1])*256;
  	new_buff[j] := CHAR(Trunc( 255*(value-min16) / (max16-min16)));
    j:=j+1;
    i := i+2;
	end;



	FreeMem( buff );
  buff := new_buff;

  Writeln(textfp);
  Writeln(textfp, 'Scaled 16-bit data to 8-bit data.');
  Writeln(textfp);
end;


end.
