unit isd_srchunit;
{*******************************************************}
{                                                       }
{               Delphi Search Engine                    }
{                                                       }
{       Copyright  1998-99 Martin Woods                }
{                                                       }
{                   Freeware                            }
{                                                       }
{*******************************************************}



interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls,LinkLabel, Buttons,ShellAPI;

type

  TSearchFrm = class(TForm)
    PageControl1: TPageControl;
    Page_Yahoo: TTabSheet;
    Edit_Keys: TEdit;
    param_Logic: TRadioGroup;
    param_Word: TRadioGroup;
    param_Time: TRadioGroup;
    param_Number: TRadioGroup;
    Label_Keys: TLabel;
    param_Search: TRadioGroup;
    Search_Yahoo: TButton;
    Clear_Yahoo: TButton;
    Page_Lycos: TTabSheet;
    Edit_query: TEdit;
    param_cat: TRadioGroup;
    param_matchmode: TRadioGroup;
    param_minscore: TRadioGroup;
    param_maxhits: TRadioGroup;
    param_terse: TRadioGroup;
    Search_Lycos: TButton;
    Clear_Lycos: TButton;
    Label_Terms: TLabel;
    Page_Files: TTabSheet;
    GroupBox1: TGroupBox;
    ServersFiles: TComboBox;
    Edit1: TEdit;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    GroupBox2: TGroupBox;
    ServersPeople: TComboBox;
    Edit2: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Button2: TButton;
    Page_Web: TTabSheet;
    GroupBox3: TGroupBox;
    Label5: TLabel;
    Label6: TLabel;
    ServersWeb: TComboBox;
    Edit3: TEdit;
    Button3: TButton;
    GroupBox4: TGroupBox;
    Label7: TLabel;
    Label8: TLabel;
    ServersOther: TComboBox;
    Edit4: TEdit;
    Button4: TButton;
    Page_Words: TTabSheet;
    GroupBox5: TGroupBox;
    Label9: TLabel;
    Label10: TLabel;
    ServersDictionary: TComboBox;
    Edit5: TEdit;
    GroupBox6: TGroupBox;
    Label11: TLabel;
    Label12: TLabel;
    ServersNews: TComboBox;
    Edit6: TEdit;
    Button5: TButton;
    Button6: TButton;
    About_Page: TTabSheet;
    TabSheet1: TTabSheet;
    GroupBox7: TGroupBox;
    Alta_Lang: TComboBox;
    Label13: TLabel;
    Alta_Text: TEdit;
    SpeedButton1: TSpeedButton;
    Alta_Boolean: TEdit;
    Label14: TLabel;
    CheckBox1: TCheckBox;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    AltaDateFrom: TEdit;
    Label18: TLabel;
    AltaDateTo: TEdit;
    Label19: TLabel;
    Label20: TLabel;
    GroupBox8: TGroupBox;
    GroupBox9: TGroupBox;
    LinkLabel2: TLinkLabel;
    LinkLabel3: TLinkLabel;
    LinkLabel4: TLinkLabel;
    LinkLabel5: TLinkLabel;
    LinkLabel6: TLinkLabel;
    LinkLabel7: TLinkLabel;
    LinkLabel8: TLinkLabel;
    LinkLabel9: TLinkLabel;
    LinkLabel10: TLinkLabel;
    LinkLabel11: TLinkLabel;
    LinkLabel12: TLinkLabel;
    LinkLabel13: TLinkLabel;
    LinkLabel14: TLinkLabel;
    LinkLabel15: TLinkLabel;
    LinkLabel16: TLinkLabel;
    CheckBox2: TCheckBox;
    Label21: TLabel;
    Image1: TImage;
    LinkLabel1: TLinkLabel;
    Animate1: TAnimate;


    procedure Clear_YahooClick(Sender: TObject);
    procedure Search_YahooClick(Sender: TObject);
    procedure Search_LycosClick(Sender: TObject);
    procedure SearchWebClick(Sender: TObject);
    procedure initcombo(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure DocCountClick(Sender: TObject);
    procedure UsenetToggle(Sender: TObject);


  private
    
    { Private declarations }
  public

    { Public declarations }
  end;

var
  SearchFrm: TSearchFrm;
  searchstring,_keyword_,server:string;
  FileName : string;
  DocCount : Boolean;
  SearchUsenet : Boolean;
  implementation

{uses test2;}

{$R *.DFM}



procedure SendQuery(var searchstring:string);
  begin

   ShellExecute(GetDesktopWindow,'open',PChar(searchstring),nil,nil,SW_SHOWNORMAL);
 end;

  procedure TSearchFrm.Clear_YahooClick(Sender: TObject);
begin
  Edit_Keys.Text := '';
  param_Logic.ItemIndex := 0;
  param_Number.ItemIndex := 0;
  param_Search.ItemIndex := 0;
  param_Word.ItemIndex := 0;
  param_Time.ItemIndex := 3;
end;

procedure TSearchFrm.Search_YahooClick(Sender: TObject);
const
  base : string = 'http://search.yahoo.com/bin/search';
var
  p, d, g, s, w, n : string;
  foo : string;
  x : integer;
begin
  { copy keys into buffer }
  foo := Edit_Keys.Text;
  { Check for the existance of a space }
  x := Pos(' ', foo);
  { if space exists, convert to plus }
  while x > 0 do begin
    Delete(foo, x, 1);
    Insert('+', foo, x);
    // ShowMessage(foo);
    x := Pos(' ', foo);
  end;

  { add key terms }
  p := '?p=' + foo;

  { add 'd' paramater }
  case param_Search.ItemIndex of
    0 : d := '&d=y';
    1 : d := '&d=d';
    2 : d := '&d=f';
  end;

  { add 'g' paramater }
  case param_Time.ItemIndex of
    0 : g := '&g=1';
    1 : g := '&g=7';
    2 : g := '&g=31';
    3 : g := '&g=0';
  end;

  { add 's' paramater }
  case param_Logic.ItemIndex of
    0 : s := '&s=a';
    1 : s := '&s=o';
  end;

  { add 'w' paramater }
  case param_Word.ItemIndex of
    0 : w := '&w=s';
    1 : w := '&w=w';
  end;

  { add 'n' paramater }
  case param_Number.ItemIndex of
    0 : n := '&n=10';
    1 : n := '&n=25';
    2 : n := '&n=50';
    3 : n := '&n=100';
  end;

  { build string }
{  action := base + p + d + g + s + w + n;  }
  searchstring:=  base + p + d + g + s + w + n;
  SendQuery(searchstring);
 end;

procedure TSearchFrm.Search_LycosClick(Sender: TObject);
const
  base : string = 'http://www.lycos.com/cgi-bin/pursuit';
var
  cat, query, matchmode, minscore, maxhits, terse : string;
  foo : string;
  x : integer;
begin
  { copy keys into buffer }
  foo := Edit_query.Text;
  { Check for the existance of a space }
  x := Pos(' ', foo);
  { if space exists, convert to plus }
  while x > 0 do begin
    Delete(foo, x, 1);
    Insert('+', foo, x);
    // ShowMessage(foo);
    x := Pos(' ', foo);
  end;

  { add query terms }
  query := '&query=' + foo;

  { add 'cat' paramater }
  case param_cat.ItemIndex of
    0 : cat := '?cat=lycos';
    1 : cat := '?cat=sounds';
    2 : cat := '?cat=graphics';
    3 : cat := '?cat=a2z';
  end;

  { add 'matchmode' paramater }
  case param_matchmode.ItemIndex of
    0 : matchmode := '&matchmode=and';
    1 : matchmode := '&matchmode=or';
    2 : matchmode := '&matchmode=2';
    3 : matchmode := '&matchmode=3';
    4 : matchmode := '&matchmode=4';
    5 : matchmode := '&matchmode=5';
    6 : matchmode := '&matchmode=6';
    7 : matchmode := '&matchmode=7';
  end;

  { add 'minscore' paramater }
  case param_minscore.ItemIndex of
    0 : minscore := '&minscore=.1';
    1 : minscore := '&minscore=.3';
    2 : minscore := '&minscore=.5';
    3 : minscore := '&minscore=.7';
    4 : minscore := '&minscore=.9';
  end;

  { add 'maxhits' paramater }
  case param_maxhits.ItemIndex of
    0 : maxhits := '&maxhits=10';
    1 : maxhits := '&maxhits=20';
    2 : maxhits := '&maxhits=30';
    3 : maxhits := '&maxhits=40';
  end;

  { add 'terse' paramater }
  case param_terse.ItemIndex of
    0 : terse := '&terse=terse';
    1 : terse := '&terse=standard';
    2 : terse := '&terse=verbose';
  end;

  { build string }
{  action := base + cat + query + matchmode + minscore + maxhits + terse;}
  searchstring := base + cat + query + matchmode + minscore + maxhits + terse;
  SendQuery(searchstring);
end;

procedure TSearchFrm.SearchWebClick(Sender: TObject);
begin
_keyword_:=Edit1.text;
 server:= ServersFiles.Text;
 if Edit1.text='' then
       begin
       showmessage('You must insert a search string') ;
       exit ;
       end  ;
 case ServersFiles.ItemIndex of
 -1 : begin
       server :='' ;
        showmessage('Please Choose an Engine')
       end;
 0 : begin
    searchstring:='http://filez.com/cgi/filez.cgi?query='+_keyword_+'&doit=Search&unique=1&filetype=&domain=&archive=amug.org&company=apple.com&hits=100';
    SendQuery(searchstring);
     end;
 1:  begin
   searchstring:= 'http://ftpsearch.ntnu.no/ftpsearch?query='+_keyword_+'&doit=Search&type=Case+insensitive+substring+search&hits=100&matches=&hitsprmatch=&limdom=&limpath=&f1=Count&f2=Type&f3=Name&f4=Size&f5=Host&f6=Path&header=none&sort=none&trlen=20';
   SendQuery(searchstring);
     end ;
 2 : begin
    searchstring:= 'http://www.windows95.com/cgi-bin/search?keywords='+_keyword_+'&selection=Search+the+32-bit+Shareware+Library';
    SendQuery(searchstring);
     end ;
 3: begin
   searchstring:= 'http://search.shareware.com/code/engine/Find?logop=and&cfrom=quick&orfile=True&hits=25&search='+_keyword_+'&category=MS-Windows95';
   SendQuery(searchstring);
    end ;
 4: begin
   searchstring:= 'http://micros.hensa.ac.uk/cgi-bin/searchdb?keywords='+_keyword_+'&section=m_ibmpc/win95';
   SendQuery(searchstring);
   end ;
 5: begin
   searchstring:= 'http://search.tucows.com/cgi-bin/webglimpse/webhome/server/htdocs/search?maxlines=20&maxfiles=50&whole=off&errors=0&case=off&query='+_keyword_;
   SendQuery(searchstring);
    end ;
 6: begin
    searchstring:= 'http://ms3.dogpile.com/search?q='+_keyword_+'&fs=ftp&ss=stop&to=twenty';
    SendQuery(searchstring);
    end;
  end;
end;

procedure TSearchFrm.initcombo(Sender: TObject);
begin
ServersFiles.ItemIndex := 0 ;
ServersPeople.ItemIndex := 0  ;
ServersWeb.ItemIndex := 0  ;
ServersOther.ItemIndex := 0  ;
ServersDictionary.ItemIndex := 0  ;
ServersNews.ItemIndex := 0  ;
Alta_Lang.ItemIndex := 0;
end;


procedure TSearchFrm.Button2Click(Sender: TObject);

 begin
_keyword_:=Edit2.text;
 server:= ServersPeople.Text;
 if Edit2.text='' then
       begin
       showmessage('You must insert a search string') ;
       exit ;
       end  ;
 case ServersPeople.ItemIndex of
 -1 : begin
       server :='' ;
        showmessage('Please Choose an Engine')
       end;
 0 : begin
    searchstring:='http://query1.whowhere.com/jwz/name.wsrch?name='+_keyword_+'&org=&match=inexact';
    SendQuery(searchstring);
        end;
 1 : begin
     searchstring:='http://query1.whowhere.com/jwz/org.wsrch?org='+_keyword_+'&match=inexact';
     SendQuery(searchstring);
      end;
 2 :  begin
   searchstring:='http://ibc.wustl.edu/htbin/domain_search?Field='+_keyword_;
   SendQuery(searchstring);
      end;
 3 : begin
   searchstring:='http://www.bigfoot.com/SEARCH?FormName=LOOKUP&SearchName='+_keyword_;
   SendQuery(searchstring);
     end;

 4 : begin
   searchstring:='http://www.switchboard.com/bin/cgiqa.dll?SR=&L='+_keyword_;
   SendQuery(searchstring);
    end ;

  5:  begin
   searchstring:='http://www.switchboard.com/bin/cgiqa.dll?SR=&BUS=&L='+_keyword_;
   SendQuery(searchstring);
     end;

 6 :  begin
   searchstring:='http://rs.internic.net/cgi-bin/whois?'+_keyword_;
   SendQuery(searchstring);
   end;
   end;
 end;


procedure TSearchFrm.Button3Click(Sender: TObject);

begin

_keyword_:=Edit3.text;
 server:= ServersWeb.Text;
 if Edit3.text='' then
       begin
       showmessage('You must insert a search string') ;
       exit ;
       end  ;
 case ServersWeb.ItemIndex of
  -1 : begin
       server :='' ;
        showmessage('Please Choose an Engine');
        exit;
       end;
 0 : begin
    searchstring:='http://www.excite.com/search.gw?search='+_keyword_+'&collection=web&display=html2%2Clb&x=19&y=6';
    SendQuery(searchstring);
    end;

 1 : begin
    searchstring :='http://webcrawler.com/cgi-bin/WebQuery?searchText='+_keyword_;
    SendQuery(searchstring);
    end;
 2 : begin
    searchstring :='http://www.hotbot.com/search.html?_v=1.0&OP=0&SM=MC&MT='+_keyword_+'&SW=&MOD=0&date=WH&DR=newer&DM=1&DD=1&DY=96&DV=10&DU=years&smiley=&RD=AN&RG=NA&domain=&DC=10&FJA=off&FJS=off&FRA=off&FAC=off&FSW=off&FVR=off&FSU=off&FSM=off&OP=0&MOD=0&search.x=59&search.y=18';
    SendQuery(searchstring);
    end;
 3 : begin
     searchstring :='http://query3.lycos.cs.cmu.edu/cgi-bin/pursuit?'+_keyword_;
     SendQuery(searchstring);
     end;
 4 : begin
     searchstring := 'http://altavista.digital.com/cgi-bin/query?pg=q&what=web&fmt=.&q='+_keyword_;
     SendQuery(searchstring);
     end;
 5 : begin
     searchstring := 'http://galaxy.einet.net/www/www.html?'+_keyword_;
     SendQuery(searchstring);
     end;
 6 : begin
     searchstring := 'http://www2.infoseek.com/Titles?qt='+_keyword_;
     SendQuery(searchstring);
     end;
 7 : begin
     searchstring := 'http://ultra.infoseek.com/Titles?qt='+_keyword_+'&nh=20&sv=US&lk=1';
     SendQuery(searchstring);
    end;
 8 : begin
     searchstring := 'http://www.mckinley.com/search.gw?search='+_keyword_+' &c=web&look=magellan&sorig=rpage';
     SendQuery(searchstring);
     end;
 9 : begin
     searchstring :='http://www.metacrawler.com/cgi-bin/nph-metaquery?general=$'+_keyword_+'&method=0&type=Fast+Search&sort=relevance&ltarget=window&useFrames=1&iface=int1';
     SendQuery(searchstring);
     end;
 10 : begin
      searchstring := 'http://ms1.dogpile.com/search?q='+_keyword_+'&fs=web&ss=stop&to=twenty';
      SendQuery(searchstring);
      end;
 11 : begin
      searchstring := 'http://google.stanford.edu/search?num=50&query='+_keyword_;
      SendQuery(searchstring);
      end;
 12 : begin
      searchstring := 'http://search.thunderstone.com/texis/websearch/?q='+_keyword_+'&c=&max=20&dsbu=1';
      SendQuery(searchstring);
      end;
    end;
   end;

procedure TSearchFrm.Button4Click(Sender: TObject);
begin
_keyword_:=Edit4.text;
 server:= ServersOther.Text;
 if Edit4.text='' then
       begin
       showmessage('You must insert a search string') ;
       exit ;
       end  ;
 case ServersOther.ItemIndex of
  -1 : begin
       server :='' ;
        showmessage('Please Choose an Engine');
        exit;
       end;
 0 : begin
     searchstring :='http://xp8.dejanews.com/dnquery.xp?query='+_keyword_+'&defaultOp=AND&svcclass=dncurrent&maxhits=50&format=verbose&threaded=0&showsort=newsgroup&agesign=1&ageweight=1';
     SendQuery(searchstring);
     end;
 1 : begin
      searchstring :='http://www.findlaw.com/scripts/lc.pl?entry='+_keyword_+' &sites=wlegal';
     SendQuery(searchstring);
     end;
 2 : begin
     searchstring :='http://catalog.com/cgibin/htgrep/file=/vivian/lists.html,/vivian/newlists.html&grab=yes?'+_keyword_;
     SendQuery(searchstring);
     end;
 3 : begin
     searchstring :='http://www.nova.edu/Inter-Links/cgi-bin/news-lists.pl?'+_keyword_;
     SendQuery(searchstring);
     end;
 4 : begin
     searchstring :='http://www.rand.org/cgi-bin/Genea/rsl?'+_keyword_;
     SendQuery(searchstring);
     end;
 5 : begin
     searchstring :='http://www.lycos.com/cgi-bin/pursuit?cat=graphics&query='+_keyword_+'&ab=the_catalog&x=20&y=10';
     SendQuery(searchstring);
     end;
 6 : begin
     searchstring :='http://www.lycos.com/cgi-bin/pursuit?cat=sounds&query='+_keyword_+'&ab=the_catalog&x=36&y=9';
     SendQuery(searchstring);
     end;
 7 : begin
     searchstring :='http://www.gamesdomain.co.uk/cgi-bin/wwwwais?keywords='+_keyword_+'&Submit.x=21&Submit.y=18';
     SendQuery(searchstring);
     end;
 8 : begin
     searchstring :='http://infoplease.com/cgi-bin/isearch?DwebQuery='+_keyword_+'&in=all&type=quick&go=Go%21';
     SendQuery(searchstring);
     end;
 9 : begin
     searchstring :='http://quoteserver.dogpile.com/texis/stock/dogpile?cmd=tick&query='+_keyword_;
     SendQuery(searchstring);
     end;
   end;
end;



procedure TSearchFrm.Button5Click(Sender: TObject);
begin
 _keyword_:=Edit5.text;
 server:= ServersDictionary.Text;
 if Edit5.text='' then
       begin
       showmessage('You must insert a search string') ;
       exit ;
       end  ;
 case ServersDictionary.ItemIndex of
  -1 : begin
       server :='' ;
        showmessage('Please Choose an Engine');
        exit;
       end;
 0 : begin
     searchstring :='http://c.gp.cs.cmu.edu:5103/prog/webster?'+_keyword_;
     SendQuery(searchstring);
    end;
 1 : begin
     searchstring :='http://work.ucsd.edu:5141/cgi-bin/thesaurus?'+_keyword_;
     SendQuery(searchstring);
    end;
 2 : begin
     searchstring :='http://wombat.doc.ic.ac.uk/?'+_keyword_;
     SendQuery(searchstring);
    end;
 3 : begin
     searchstring :='gopher://info.mcc.ac.uk:70/77/miscellany/acronyms/.index/index?'+_keyword_;
     SendQuery(searchstring);
    end;
 4 : begin
     searchstring :='http://www.cnam.fr/Jargon/?'+_keyword_;
     SendQuery(searchstring);
    end;
 5 : begin
     searchstring :='http://www.leo.org/cgi-bin/dict-search?search='+_keyword_+'&hits=20';
     SendQuery(searchstring);
    end;
 6 : begin
     searchstring :='http://humanities.uchicago.edu/cgi-bin/FR-ENG.sh?word='+_keyword_;
     SendQuery(searchstring);
    end;
 7 : begin
     searchstring :='http://humanities.uchicago.edu/cgi-bin/ENG-FR.sh?word='+_keyword_;
     SendQuery(searchstring);
     end;
   end;
 end;
procedure TSearchFrm.Button6Click(Sender: TObject);
begin
 _keyword_:=Edit6.text;
 server:= ServersNews.Text;
 if Edit6.text='' then
       begin
       showmessage('You must insert a search string') ;
       exit ;
       end  ;
 case ServersNews.ItemIndex of
-1 : begin
        server :='' ;
        showmessage('Please Choose an Engine');
        exit;
       end;
 0 : begin
     searchstring :='http://www.cs.indiana.edu:800/cstr/search?'+_keyword_;
     SendQuery(searchstring);
     end;
 1 : begin
     searchstring :='http://www.lpac.ac.uk/bin/bibtexSearch?.@@'+_keyword_;
     SendQuery(searchstring);
     end;
 2 : begin
     searchstring :='http://www.bsdi.com/bsdi-man/?'+_keyword_;
     SendQuery(searchstring);
     end;
 3 : begin
     searchstring :='gopher://gopher.lib.ncsu.edu:3001/7?'+_keyword_;
     SendQuery(searchstring);
     end;
 4 : begin
     searchstring :='http://www.leo.org/cgi-bin/rfc-search?search='+_keyword_+'&hits=50';
     SendQuery(searchstring);
     end;
 5 : begin
     searchstring :='http://www.leo.org/cgi-bin/SFgate?database=ien&database=internet-drafts&database=ietf&text='+_keyword_+'&maxhits=50&directget=0&convert=&dmpenv=no&debug=off';
     SendQuery(searchstring);
     end;
 6 : begin
     searchstring :='http://www.discovery.com/cgi-bin/searcher/-?search='+_keyword_;
     SendQuery(searchstring);
     end;
 7 : begin
     searchstring :='http://cgi.pathfinder.com/cgi-bin/altavista/pshell?venue=pathfinder&q='+_keyword_+'&pg=q&date=all&x=12&y=9';
     SendQuery(searchstring);
     end;
 8 : begin
     searchstring :='http://search.cnn.com:8765/query.html?rq=0&col=cnni&qt='+_keyword_+'&qc=&qm=0&st=1&nh=10&lk=1&rf=1&go=go';
     SendQuery(searchstring);
     end;
 9 : begin
     searchstring :='http://www.newslink.org/cgi/search.cgi?terms='+_keyword_+'&type=Entire+site';
     SendQuery(searchstring);
     end;
 10 : begin
     searchstring :='http://www.mojones.com/cgi-bin/kidofwais.pl?'+_keyword_;
     SendQuery(searchstring);
     end;
 11 : begin
     searchstring :='http://www.latimes.com/bin/iatoc?NS-query='+_keyword_+'&NS-adv-search=0&NS-search-type=boolean&NS-max-records=20&NS-collection=DailyNews&NS-collection=APOnline';
     SendQuery(searchstring);
     end;
   end;
 end;

procedure TSearchFrm.SpeedButton1Click(Sender: TObject);
const
  base : string = 'http://altavista.digital.com/cgi-bin/query?pg=aq';
var boolean_expression,DateFrom,DateTo,Language :string;
begin
 _keyword_:=Alta_Text.text;
 DateFrom :=AltaDateFrom.Text ;
 DateTo :=  AltaDateTo.Text ;

 if Alta_Text.text='' then
       begin
       showmessage('You must insert a search string') ;
       exit ;
       end  ;

     case Alta_Lang.ItemIndex of
     0 : Language := 'XX'; {any language}
     1 : Language := 'zh'; {chinese}
     2 : Language := 'cs'; {Czech}
     3 : Language := 'da'; {Danish}
     4 : Language := 'nl'; {Dutch}
     5 : Language := 'en'; {English}
     6 : Language := 'et'; {Estonian}
     7 : Language := 'fi'; {Finnish}
     8 : Language := 'fr'; {French}
     9 : Language := 'de'; {German}
     10 : Language := 'el'; {Greek}
     11 : Language := 'he'; {Hebrew}
     12 : Language := 'hu'; {Hungarian}
     13 : Language := 'is'; {Icelandic}
     14 : Language := 'it'; {Italian}
     15 : Language := 'ja'; {Japanese}
     16 : Language := 'ko'; {Korean}
     17 : Language := 'lv'; {Latvian}
     18 : Language := 'lt'; {Lithuanian}
     19 : Language := 'no'; {Norwegian}
     20 : Language := 'pl'; {Polish}
     21 : Language := 'pt'; {Portuguese}
     22 : Language := 'ro'; {Romanian}
     23 : Language := 'ru'; {Russian}
     24 : Language := 'es'; {Spanish}
     25 : Language := 'sv'; {Swedish}
     end;
     if SearchUseNet = true then
     begin
     searchstring := base + '&what=news&r=' + _keyword_ + '&q=' + boolean_expression + '&d0=' + DateFrom + '&d1=' + DateTo + '&search=Search';
     SendQuery(searchstring)
     end
      else begin
      if DocCount = true then
      begin
      searchstring:= base + '&kl=' + Language + '&r='+_keyword_+'&q=' + boolean_expression + '&d0=' + DateFrom + '&d1=' + DateTo + '&fmt=n&search=Search';
      SendQuery(searchstring)
      end
         else
         begin
           searchstring:= base + '&kl=' + Language + '&r='+_keyword_+'&q=' + boolean_expression + '&d0=' + DateFrom + '&d1=' + DateTo + '&search=Search';
            SendQuery(searchstring);
         end
       end
end;

procedure TSearchFrm.DocCountClick(Sender: TObject);

begin
  DocCount := False;
  if CheckBox1.Checked then
  begin
    DocCount := true
  end
     else
        exit
      end;



procedure TSearchFrm.UsenetToggle(Sender: TObject);
begin
   SearchUsenet := False;
  if CheckBox2.Checked then
  begin
    SearchUsenet := true
  end
     else
        exit
end;

end.
