unit LinkLabel;

{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{                                                       }
{       Copyright  1996-97 Vitaly Zayko                }
{                                                       }
{                   TLinkLabel                          }
{                                                       }
{*******************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, StdCtrls, ShellAPI, Forms;

const
     URLCursor = 1;

type
  TLinkLabel = class(TCustomLabel)
  private
    FLinkColor:TColor;
    FLinkTo:String;
    procedure SetLinkColor(Value:TColor);
  protected
    procedure WMClick(var Msg:TMessage); message WM_LBUTTONDOWN;
  public
    constructor Create(AOwner:TComponent);override;
    destructor Destroy;override;
  published
    property Caption;
    property Font;
    property Color;
    property Visible;
    property ShowHint;
    property AutoSize;
    property WordWrap;
    property Align;
    property Alignment;
    property Enabled;
    property Transparent;
    property LinkColor:TColor read FLinkColor write SetLinkColor default clBlue;
    property LinkTo: String read FLinkTo write FLinkTo;
  end;

procedure Register;

implementation

constructor TLinkLabel.Create(AOwner:TComponent);
var
   WinSys:Array [0..255] of Char;
begin
     inherited Create(AOwner);
     Font.Style:=[fsUnderline];
     Font.Color:=clBlue;
     FLinkColor:=clBlue;
     GetSystemDirectory(WinSys,sizeof(WinSys));
     Screen.Cursors[URLCursor]:=LoadCursor(LoadLibrary(StrCopy(WinSys,PChar('comctl32.dll'))),MakeIntResource(108));
     Cursor:=URLCursor;
end;

destructor TLinkLabel.Destroy;
begin
     Font.Style:=[];
     inherited Destroy;
end;

procedure TLinkLabel.SetLinkColor(Value:TColor);
begin
     FLinkColor:=Value;
     Font.Color:=Value;
     Refresh;
end;

procedure TLinkLabel.WMClick(var Msg:TMessage);
begin
     ShellExecute(GetDesktopWindow,'open',PChar(FLinkTo),nil,nil,SW_SHOWNORMAL);
end;

procedure Register;
begin
  RegisterComponents('Additional', [TLinkLabel]);
end;

end.
