unit Clkunit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, CClock, StdCtrls, ExtCtrls, Spin, Tabs, ColorGrd;

type
  TColorArray = array[ 0..6] of TColor;

const
  BallColors : TColorArray =
      ( clBlack, clMaroon, clGreen, clOlive, clNavy, clPurple, clTeal);
  BkgColors : TColorArray =
      ( clSilver, clRed, clLime, clBlue, clFuchsia, clAqua, clWhite);

type
  TClkForm = class(TForm)
    SysPanel: TPanel;
    SysLabel: TLabel;
    Panel2: TPanel;
    LDay: TLabel;
    LMonth: TLabel;
    LYear: TLabel;
    Panel1: TPanel;
    SysClock: TClock;
    NBPannel: TPanel;
    ClkNotebook: TNotebook;
    ClkTabSet: TTabSet;
    Panel4: TPanel;
    PWClock: TClock;
    PWLabel2: TLabel;
    PWLabel1: TLabel;
    Panel3: TPanel;
    TDClock: TClock;
    Panel6: TPanel;
    TDMLabel: TLabel;
    TDMSpin: TSpinButton;
    Panel5: TPanel;
    TDHLabel: TLabel;
    TDHSpin: TSpinButton;
    Label1: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Panel7: TPanel;
    ACCClock: TClock;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Panel8: TPanel;
    Image1: TImage;
    Label3: TLabel;
    ColorGrid1: TColorGrid;
    CheckBox1: TCheckBox;
    Label2: TLabel;
    Panel9: TPanel;
    Panel10: TPanel;
    EvClock: TClock;
    Panel11: TPanel;
    Shape1: TShape;
    Shape2: TShape;
    Label12: TLabel;
    Label13: TLabel;
    procedure SysClockHour(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PWClockMinute(Sender: TObject);
    procedure TDHSpinDownClick(Sender: TObject);
    procedure TDHSpinUpClick(Sender: TObject);
    procedure TDMSpinDownClick(Sender: TObject);
    procedure TDMSpinUpClick(Sender: TObject);
    procedure ClkTabSetClick(Sender: TObject);
    procedure ColorGrid1Change(Sender: TObject);
    procedure EvClockSecond(Sender: TObject);
    procedure EvClockMinute(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
  private
    { Private declarations }
    ColorCounter : word;

    procedure UpdateDate;
  public
    { Public declarations }
  end;

var
  ClkForm: TClkForm;

implementation

{$R *.DFM}

{ Update system date on the system clock}
procedure TClkForm.UpdateDate;
var
  CurDate : TDateTime;
  Y, M, D, DoW : word;
begin
  CurDate := Date;
  DecodeDate( CurDate, Y, M, D);
  DoW := DayOfWeek( CurDate);

  {LDayOfWeek.Caption := LongDayNames[ DoW];}
  LDay.Caption := IntToStr( D);
  LMonth.Caption := LongMonthNames[ M];
  LYear.Caption := IntToStr( Y);

end;

{ Update dates every hour}
procedure TClkForm.SysClockHour(Sender: TObject);
begin
  UpdateDate;
end;

procedure TClkForm.FormCreate(Sender: TObject);
begin

  ClkTabSet.Tabs := ClkNotebook.Pages;

  UpdateDate; { update system date}
  PWClock.SetClkTime( EncodeTime( 0, 0, 0, 0)); { Reset "Program work" clock}
  { Draw time difference labels}
  TDHLabel.Caption := IntToStr( TDClock.DifHour);
  TDMLabel.Caption := IntToStr( TDClock.DifMinute);

  { Load main icon into image}
  Image1.Picture.Icon.Handle := LoadIcon( HInstance, 'MAINICON');

  ACCClock.SecArrow := CheckBox1.Checked;

  ColorCounter := 0;
end;

procedure TClkForm.PWClockMinute(Sender: TObject);
var H, M, S : word; St : string;
begin
  PWClock.ClkTime( H, M, S);
  St := IntToStr( M);
  if length( St) < 2 then St := '0' + St;
  PWLabel2.Caption := IntToStr( H {MOD 12}) + ' : ' + St;
end;

{ Set time difference on the "Time difference" clock}
procedure TClkForm.TDHSpinDownClick(Sender: TObject);
begin
  with TDClock do if DifHour > -11 then DifHour := DifHour - 1;
  TDHLabel.Caption := IntToStr( TDClock.DifHour);
end;

procedure TClkForm.TDHSpinUpClick(Sender: TObject);
begin
  with TDClock do if DifHour < 11 then DifHour := DifHour + 1;
  TDHLabel.Caption := IntToStr( TDClock.DifHour);
end;

procedure TClkForm.TDMSpinDownClick(Sender: TObject);
begin
  with TDClock do if DifMinute > -59 then DifMinute := DifMinute - 1;
  TDMLabel.Caption := IntToStr( TDClock.DifMinute);
end;

procedure TClkForm.TDMSpinUpClick(Sender: TObject);
begin
  with TDClock do if DifMinute < 59 then DifMinute := DifMinute + 1;
  TDMLabel.Caption := IntToStr( TDClock.DifMinute);
end;

procedure TClkForm.ClkTabSetClick(Sender: TObject);
begin
  ClkNotebook.PageIndex := ClkTabSet.TabIndex;
end;

procedure TClkForm.ColorGrid1Change(Sender: TObject);
begin
  with ACCClock, ColorGrid1 do begin
    ClkArrowColor := ForegroundColor;
    ClkFaceColor  := BackgroundColor;
    end;
end;

procedure TClkForm.EvClockSecond(Sender: TObject);
begin
  Shape1.Visible := NOT Shape1.Visible;
  Shape2.Visible := NOT Shape2.Visible;
end;

procedure TClkForm.EvClockMinute(Sender: TObject);
begin
  inc( ColorCounter);
  if ColorCounter >6 then ColorCounter := 0;
  Shape1.Brush.Color := BallColors[ ColorCounter];
  Shape2.Brush.Color := BallColors[ ColorCounter];
end;

procedure TClkForm.CheckBox1Click(Sender: TObject);
begin
  ACCClock.SecArrow := CheckBox1.Checked;
end;

end.
