{    Paradox DB info & pack/restructure utility
     - G.Thomas (CompuServe 73621,3401) Nov. 1995  }
unit Dbutform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Grids, DBGrids,
  Classes, Graphics, Controls, Forms, Dialogs, StdCtrls, About,
  DB, DBTables, DBIProcs, DBITypes, DBIErrs, ExtCtrls, Menus;

type

  TDatabaseList = class(TDBDataSet)
  protected
    function CreateHandle: HDBICur; override;
  end;

  TTableList = class(TDBDataSet)
  private
    FExtended: Boolean;
    FSystemTables: Boolean;
  protected
    function CreateHandle: HDBICur; override;
  published
    property ExtendedInfo: Boolean read FExtended write FExtended;
    property SystemTables: Boolean read FSystemTables write FSystemTables;
  end;

  TDbUtltyForm = class(TForm)
    CloseBtn: TButton;
    PackBtn: TButton;
    MainMenu1: TMainMenu;
    MnuAbout: TMenuItem;
    MnuClose: TMenuItem;
    MnuDoPack: TMenuItem;
    MnuFile: TMenuItem;
    MnuOptions: TMenuItem;
    MnuPromptOpt: TMenuItem;
    MnuView: TMenuItem;
    MnuViewAlias: TMenuItem;
    MnuViewTable: TMenuItem;
    SelectionSource: TDataSource;
    SelectionGrid: TDBGrid;
    ShowBtn: TButton;
    StatusLine: TPanel;
    TargetDB: TDatabase;
    TargetTable: TTable;
    procedure CloseBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure MnuAboutClick(Sender: TObject);
    procedure MnuDoPackClick(Sender: TObject);
    procedure MnuCloseClick(Sender: TObject);
    procedure MnuPromptOptClick(Sender: TObject);
    procedure MnuViewAliasClick(Sender: TObject);
    procedure MnuViewTableClick(Sender: TObject);
    procedure PackBtnClick(Sender: TObject);
    procedure ShowBtnClick(Sender: TObject);
    procedure SelectionGridDblClick(Sender: TObject);
  private
    { Private declarations }
    AliasList: TDatabaseList;
    DbTableList: TTableList;
    function PackTable(tbl:TTable): Boolean;
    procedure SetCurrentDb;
    procedure ShowStatus(StatusText: string);
public
    { Public declarations }
  end;

var
    DbUtltyForm: TDbUtltyForm;
    AboutBox: TAboutBox;

implementation

{$R *.DFM}

{ TDatabaseList }

function TDatabaseList.CreateHandle: HDBICur;
begin
{  Check(DbiOpenDatabaseList(Result));}
  if (DbiOpenDatabaseList(Result)) <> DBIERR_NONE then
  begin
      ShowMessage('DB alias list creation failed');
      Close;
  end;
end;

function TTableList.CreateHandle: HDBICur;
begin
{  Check(DbiOpenTableList(DBHandle, ExtendedInfo, SystemTables, nil, Result));}
  if (DbiOpenTableList(DBHandle, ExtendedInfo, SystemTables, nil, Result))
                                                      <> DBIERR_NONE then
  begin
      ShowMessage('DB table list creation failed');
      Close;
  end;
end;

procedure TDbUtltyForm.FormCreate(Sender: TObject);
begin
     if hPrevinst <> 0 then  {If I am already running}
     begin
          ShowMessage('DbUtlty is already running!');
          halt; {Stop this instance}
     end;

     AliasList := TDatabaseList.Create(NULL);
     SelectionSource.Dataset := AliasList;
     AliasList.Active := True;

     DbTableList := TTableList.Create(NULL);
end;

procedure TDbUtltyForm.FormShow(Sender: TObject);
begin
     AliasList.Fields[0].DisplayWidth := 20;  { Name }
     AliasList.Fields[1].Visible := False;    { Description }
     AliasList.Fields[2].DisplayWidth := 30;  { PhyName }
     AliasList.Fields[3].DisplayWidth := 30;  { DBtype }

     SetCurrentDb;
     MnuViewAlias.Enabled := False;
     MnuViewTable.Enabled := True;
end;

procedure TDbUtltyForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
     DbTableList.Active := False;
     DbTableList.Free;

     AliasList.Active := False;
     AliasList.Free;
end;

procedure TDbUtltyForm.MnuAboutClick(Sender: TObject);
begin
     AboutBox := TAboutBox.Create(Self);
     AboutBox.ShowModal;
     AboutBox.Hide;
     AboutBox.Destroy;
end;

procedure TDbUtltyForm.MnuPromptOptClick(Sender: TObject);
begin
     MnuPromptOpt.Checked := (MnuPromptOpt.Checked = False);
end;

procedure TDbUtltyForm.PackBtnClick(Sender: TObject);
begin
     MnuDoPackClick(Sender);
end;

procedure TDbUtltyForm.ShowBtnClick(Sender: TObject);
begin
     if SelectionSource.Dataset = AliasList then
          MnuViewTableClick(Sender)
     else
          MnuViewAliasClick(Sender);
end;

procedure TDbUtltyForm.MnuViewAliasClick(Sender: TObject);
begin
     ShowStatus('All aliases listed');
     SelectionSource.Dataset := AliasList;
     ShowBtn.Caption := '&Show Tables';
     PackBtn.Caption := '&Pack Tables';
     mnuDoPack.Caption := PackBtn.Caption;
     mnuPromptOpt.Enabled := True;
     MnuViewAlias.Enabled := False;
     MnuViewTable.Enabled := True;
end;

procedure TDbUtltyForm.MnuViewTableClick(Sender: TObject);
begin
     ShowStatus('Tables listed for alias "' +
         SelectionGrid.Fields[SelectionGrid.SelectedIndex].Text + '"');
     SetCurrentDb;
     SelectionSource.Dataset := DbTableList;
     DbTableList.Fields[0].DisplayWidth := 15;  { Name }
     DbTableList.Fields[1].DisplayWidth := 15;  { Filename }
     DbTableList.Fields[2].DisplayWidth := 10;  { Extension }
     DbTableList.Fields[3].DisplayWidth := 15;  { Type }
     DbTableList.Fields[4].DisplayWidth := 10;  { Date }
     DbTableList.Fields[5].DisplayWidth := 15;  { Time }
     DbTableList.Fields[6].DisplayWidth := 10;  { View }
     ShowBtn.Caption := '&Show Aliases';
     PackBtn.Caption := '&Pack Table';
     mnuDoPack.Caption := PackBtn.Caption;
     mnuPromptOpt.Enabled := False;
     MnuViewAlias.Enabled := True;
     MnuViewTable.Enabled := False;
end;

procedure TDbUtltyForm.SelectionGridDblClick(Sender: TObject);
begin
     if SelectionSource.Dataset = AliasList then
         MnuViewTableClick(Sender)   { Drill down to tables... }
     else
         MnuDoPackClick(Sender);   { Pack selected table... }
end;

procedure TDbUtltyForm.SetCurrentDb;
begin
      TargetDB.AliasName := SelectionGrid.Fields[SelectionGrid.SelectedIndex].Text;

      DbTableList.Active := False;
      DbTableList.DatabaseName := TargetDB.AliasName;
      DbTableList.ExtendedInfo := False;
      DbTableList.SystemTables := False;      
      DbTableList.Active := True;
end;

procedure TDbUtltyForm.MnuDoPackClick(Sender: TObject);
var
   i: integer;
   PromptLine: string;
   TableExt: string;
   Response: Word;
   DbTableNAME: string;
   DbTableEXTENSION: string;
{  Description: string; }
begin
     if SelectionSource.Dataset = AliasList then
     begin
{       If the grid is displaying the alias names, we must obtain the current
        selection and its list of tables. If table names are shown however,
        then we already have identified the selected alias and just need to
        identify the selected table...
}
          SetCurrentDb;
          PromptLine := 'All tables for the "' + TargetDB.AliasName
              + '" alias';
      end
      else
      begin
          DbTableNAME         := SelectionGrid.Fields[0].Text;
          DbTableEXTENSION    := SelectionGrid.Fields[2].Text;
          if DbTableEXTENSION = '' then
              TableExt := DbTableNAME
          else
              TableExt := Format ('%s.%s', [DbTableNAME,
                               DbTableEXTENSION]);
          PromptLine := 'The selected table "' + TableExt + '"';
      end;

      if MessageDlg(PromptLine + ' will be packed!' + Chr(10) +
          'Be certain to make backups of all data before continuing!'
          + Chr(10) + 'Are you ready to proceed?', mtWarning, [mbYes,MbNo], 0)
                            <> mrYes then
          Exit;

      ShowStatus('Pack in progress... please wait');

      if SelectionSource.Dataset = DbTableList then
      begin
           ShowStatus('Packing table ' + TableExt);
           TargetTable.TableName := TableExt;
           if PackTable(TargetTable) = True then
              ShowStatus(TableExt + ' - successful')
           else
               ShowMessage('Pack failed for table ' + TableExt);
           Exit;
      end;

      try
{         This will display the 7 columns in the tables list:
         NAME, FILENAME, EXTENSION, TYPE, DATE, TIME, VIEW }

{         ShowMessage(IntToStr(DbTableList.FieldCount));
         for i := 0 to (DbTableList.FieldCount - 1) do
         begin
              ShowMessage(DbTableList.Fields[i].FieldName);
         end;
 }
         while not DbTableList.EOF do
           begin
{                for i := 0 to (DbTableList.FieldCount - 1) do
                begin
                     ShowMessage(DbTableList.Fields[i].Text);
                end;
 }
                DbTableNAME         := DbTableList.Fields[0].Text;
                DbTableEXTENSION    := DbTableList.Fields[2].Text;
                if DbTableEXTENSION = '' then
                    TableExt := DbTableNAME
                else
                    TableExt := Format ('%s.%s', [DbTableNAME,
                                     DbTableEXTENSION]);

               if MnuPromptOpt.Checked = True then
                   Response := MessageDlg('Pack ' + TableExt + ' table?',
                                          mtConfirmation, [mbYes,MbNo], 0)
               else
                   Response := mrYes;
               if Response = mrYes then
               begin
                    ShowStatus('Packing table ' + TableExt);
                    TargetTable.TableName := TableExt;
                    if PackTable(TargetTable) = True then
                        ShowStatus(TableExt + ' - successful')
                    else
                        ShowMessage('Pack failed for table ' + TableExt);
               end
               else
                   ShowStatus(TableExt + ' not packed');
               DbTableList.Next;
           end;
      finally
          ShowStatus('Pack procedure completed');
      end;
end;

procedure TDbUtltyForm.ShowStatus(StatusText: string);
begin
    StatusLine.Caption := StatusText;
    StatusLine.Update;
end;

function TDbUtltyForm.PackTable(tbl:TTable): Boolean;
var
   crtd: CRTblDesc;
begin
     Screen.Cursor := crHourglass;

     try
        Result := True;
      with tbl do
        begin
           If Active then
               Active := False;
           if not TargetDB.Connected then
               TargetDB.Connected := True;
           FillChar( crtd, SizeOf( CRTblDesc ), 0 );
           StrPCopy( crtd.szTblName, TableName );
           crtd.bPack := True;

           If DbiDoRestructure(TargetDB.Handle, 1, @crtd, nil, nil, nil, False)
                                          <> DBIERR_NONE then
               Result := False;
        end; {with}
      except
            on Exception do {any exception}
               Result := False;
      end; {try..except}

      Screen.Cursor := crDefault;
      TargetDB.Connected := False;
end; {procedure}

procedure TDbUtltyForm.CloseBtnClick(Sender: TObject);
begin
     Close;
end;

procedure TDbUtltyForm.MnuCloseClick(Sender: TObject);
begin
     Close;
end;

end.
