unit Dbprintt;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, DsgnIntF;

type
  TTranslation=class(TPersistent)
  private
    FDisplayText:Array[1..20] of string[30];
    FReadData:TReaderProc;
    FWriteData:TWriterProc;
    Procedure ReadData(Reader:TReader);
    procedure WriteData(Writer:TWriter);
    procedure DefineProperties(Filer:TFiler); override;
  public
    function  GetText(Index:Integer):String;
    procedure SetEnglishText;
    procedure SetNorskText;
    constructor Create;
    destructor Destroy;
  end;

  TTranslationDialog = class(TForm)
    Panel3: TPanel;
    Panel2: TPanel;
    Bevel1: TBevel;
    Label1: TLabel;
    Label3: TLabel;
    FieldScrollbox: TScrollBox;
    ButtonPanel: TPanel;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Label4: TLabel;
    Edit1: TEdit;
    Label6: TLabel;
    Edit2: TEdit;
    Label8: TLabel;
    Edit3: TEdit;
    Label10: TLabel;
    Edit4: TEdit;
    Label12: TLabel;
    Edit5: TEdit;
    Label14: TLabel;
    Edit6: TEdit;
    Label16: TLabel;
    Edit7: TEdit;
    Label18: TLabel;
    Edit8: TEdit;
    Label20: TLabel;
    Edit9: TEdit;
    Label22: TLabel;
    Edit10: TEdit;
    Label24: TLabel;
    Edit11: TEdit;
    Label26: TLabel;
    Edit12: TEdit;
    Label28: TLabel;
    Edit13: TEdit;
    Label30: TLabel;
    Edit14: TEdit;
    Label32: TLabel;
    Edit15: TEdit;
    Label34: TLabel;
    Edit16: TEdit;
    Label36: TLabel;
    Edit17: TEdit;
    Label38: TLabel;
    Edit18: TEdit;
    Label40: TLabel;
    Edit19: TEdit;
    Label42: TLabel;
    Edit20: TEdit;
    EnglishButton: TButton;
    NorskButton: TButton;
    Label2: TLabel;
    procedure FormShow(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure EnglishButtonClick(Sender: TObject);
    procedure NorskButtonClick(Sender: TObject);
  private
    Procedure UpdateText;
  public
    Translation:TTranslation;
  end;

  TTranslationProperty = class( TClassProperty )
       function GetAttributes: TPropertyAttributes; override;
       function GetValue:String; override;
       procedure SetValue(const Value:String); override;
       procedure Edit; override;
  end;

implementation

{$R *.DFM}

procedure TTranslation.ReadData(Reader:TReader);

var i:integer;

begin
  Reader.ReadListBegin;
  for i:=1 to 20 do FDisplayText[i]:=Reader.ReadString;
  Reader.ReadListEnd;
end;

procedure TTranslation.WriteData(Writer:TWriter);

var i:integer;

begin
  Writer.WriteListBegin;
  for i:=1 to 20 do Writer.WriteString(FDisplayText[i]);
  Writer.WriteListEnd;
end;

procedure TTranslation.DefineProperties(Filer:TFiler);

begin
  Inherited DefineProperties(Filer);
  Filer.DefineProperty('Translations',FReadData,FWriteData,True);
end;

Function TTranslation.GetText(Index:Integer):String;

begin
  Result:=FDisplayText[Index];
end;

Constructor TTranslation.Create;

begin
  Inherited Create;
  SetEnglishText;
  FReadData:=ReadData;
  FWriteData:=WriteData;
end;

Procedure TTranslation.SetEnglishText;

begin
  FDisplayText[1]:='Field print spesifications';
  FDisplayText[2]:='FieldName';
  FDisplayText[3]:='PrintTitle';
  FDisplayText[4]:='Print';
  FDisplayText[5]:='Totals';
  FDisplayText[6]:='Average';
  FDisplayText[7]:='Size';
  FDisplayText[8]:='Decimals';
  FDisplayText[9]:='Alignment';
  FDisplayText[10]:='Left';
  FDisplayText[11]:='Center';
  FDisplayText[12]:='Right';
  FDisplayText[13]:='Printing datasource ...';
  FDisplayText[14]:='Printing';
  FDisplayText[15]:='On';
  FDisplayText[16]:='&OK';
  FDisplayText[17]:='&Cancel';
  FDisplayText[18]:='&Abort';
  FDisplayText[19]:='True';
  FDisplayText[20]:='False';
end;

Procedure TTranslation.SetNorskText;

begin
  FDisplayText[1]:='Utskriftsspesifikasjon';
  FDisplayText[2]:='FeltNavn';
  FDisplayText[3]:='Tittel';
  FDisplayText[4]:='Skriv ut';
  FDisplayText[5]:='Total';
  FDisplayText[6]:='Snitt';
  FDisplayText[7]:='Lengde';
  FDisplayText[8]:='Desimaler';
  FDisplayText[9]:='Justering';
  FDisplayText[10]:='Venstre';
  FDisplayText[11]:='Senter';
  FDisplayText[12]:='Hyre';
  FDisplayText[13]:='Skriver ut datakilde ...';
  FDisplayText[14]:='Skriver ut';
  FDisplayText[15]:='P';
  FDisplayText[16]:='&OK';
  FDisplayText[17]:='&Avbryt';
  FDisplayText[18]:='&Avbryt';
  FDisplayText[19]:='Ja';
  FDisplayText[20]:='Nei';
end;

destructor TTranslation.Destroy;

begin
  Inherited Destroy;
end;

function TTranslationProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog,paReadOnly];
end;

function TTranslationProperty.GetValue:String;
begin
  Result:=Inherited GetValue;
end;

procedure TTranslationProperty.SetValue(const Value:String);
begin
  Inherited SetValue(Value);
end;

procedure TTranslationProperty.Edit;

var TranslationDialog: TTranslationDialog;

begin
  TranslationDialog := TTranslationDialog.Create(Application);
  try
    TranslationDialog.Translation:=TTranslation(GetOrdValue);
    if TranslationDialog.ShowModal=idOK then SetOrdValue(Longint(TranslationDialog.Translation));
  finally
    TranslationDialog.Free
  end;
end;

procedure TTranslationDialog.UpdateText;

begin
  Edit1.Text:=Translation.FDisplayText[1];
  Edit2.Text:=Translation.FDisplayText[2];
  Edit3.Text:=Translation.FDisplayText[3];
  Edit4.Text:=Translation.FDisplayText[4];
  Edit5.Text:=Translation.FDisplayText[5];
  Edit6.Text:=Translation.FDisplayText[6];
  Edit7.Text:=Translation.FDisplayText[7];
  Edit8.Text:=Translation.FDisplayText[8];
  Edit9.Text:=Translation.FDisplayText[9];
  Edit10.Text:=Translation.FDisplayText[10];
  Edit11.Text:=Translation.FDisplayText[11];
  Edit12.Text:=Translation.FDisplayText[12];
  Edit13.Text:=Translation.FDisplayText[13];
  Edit14.Text:=Translation.FDisplayText[14];
  Edit15.Text:=Translation.FDisplayText[15];
  Edit16.Text:=Translation.FDisplayText[16];
  Edit17.Text:=Translation.FDisplayText[17];
  Edit18.Text:=Translation.FDisplayText[18];
  Edit19.Text:=Translation.FDisplayText[19];
  Edit20.Text:=Translation.FDisplayText[20];
end;

procedure TTranslationDialog.FormShow(Sender: TObject);
begin
  UpdateText;
end;

procedure TTranslationDialog.OKBtnClick(Sender: TObject);
begin
  Translation.FDisplayText[1]:=Edit1.Text;
  Translation.FDisplayText[2]:=Edit2.Text;
  Translation.FDisplayText[3]:=Edit3.Text;
  Translation.FDisplayText[4]:=Edit4.Text;
  Translation.FDisplayText[5]:=Edit5.Text;
  Translation.FDisplayText[6]:=Edit6.Text;
  Translation.FDisplayText[7]:=Edit7.Text;
  Translation.FDisplayText[8]:=Edit8.Text;
  Translation.FDisplayText[9]:=Edit9.Text;
  Translation.FDisplayText[10]:=Edit10.Text;
  Translation.FDisplayText[11]:=Edit11.Text;
  Translation.FDisplayText[12]:=Edit12.Text;
  Translation.FDisplayText[13]:=Edit13.Text;
  Translation.FDisplayText[14]:=Edit14.Text;
  Translation.FDisplayText[15]:=Edit15.Text;
  Translation.FDisplayText[16]:=Edit16.Text;
  Translation.FDisplayText[17]:=Edit17.Text;
  Translation.FDisplayText[18]:=Edit18.Text;
  Translation.FDisplayText[19]:=Edit19.Text;
  Translation.FDisplayText[20]:=Edit20.Text;
end;

procedure TTranslationDialog.EnglishButtonClick(Sender: TObject);
begin
  Translation.SetEnglishText;
  UpdateText;
end;

procedure TTranslationDialog.NorskButtonClick(Sender: TObject);
begin
  Translation.SetNorskText;
  UpdateText;
end;

end.
