unit Dbprintf;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, SysUtils, DB, DsgnIntF, DBPrintT;

type
  TFieldSpesification=class(TPersistent)
  public
    FieldTotals:Double;
    PrintPos:Integer;

    FieldName:String;
    FieldTitle:String;
    PrintField:Boolean;
    PrintTotals:Boolean;
    PrintAverage:Boolean;
    FieldSize:Integer;
    FieldDecimals:Integer;
    FieldAlignment:Integer;
    Constructor Create;
    Destructor Destroy;
  end;

  TFieldSpesifications=class(TPersistent)
  private
    IsReading:Boolean;
    FReadData:TReaderProc;
    FWriteData:TWriterProc;
    Procedure ReadData(Reader:TReader);
    procedure WriteData(Writer:TWriter);
    procedure DefineProperties(Filer:TFiler); override;
  public
    FDataSource:TDataSource;
    FPrintTitle:String;
    FOutputHeading:String;
    FOutputInfo:TStringList;
    FPageNumbering:Boolean;
    FOutputHeadingFont:TFont;
    FOutputInfoFont:TFont;
    FDataTitleFont:TFont;
    FDataListFont:TFont;
    FPrintTotals:Boolean;
    FPrintAverage:Boolean;
    FColLines:Boolean;
    FRowLines:Boolean;
    FRowLineStep:Integer;
    FieldSpesification:Array[0..255] of TFieldSpesification;
    Constructor Create;
    Destructor Destroy;
    Procedure SetDataSource(Value:TDataSource);
  end;

  TFieldEditors=class(TObject)
  private
    FieldNameLabel:TLabel;
    FieldTitleEdit:TEdit;
    PrintFieldCheckbox:TCheckbox;
    PrintTotalsCheckbox:TCheckbox;
    PrintAverageCheckbox:TCheckbox;
    FieldSizeEdit:TEdit;
    FieldDecimalsEdit:TEdit;
    FieldAlignmentCombo:TCombobox;
  public
    Constructor Create(AOwner:TScrollbox;Top:Integer;FieldType:TFieldType;Translation:TTranslation);
    Destructor  Destroy;
  end;

  TFieldSpesDialog = class(TForm)
    ButtonPanel: TPanel;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Panel1: TPanel;
    Panel3: TPanel;
    Panel2: TPanel;
    Bevel1: TBevel;
    FieldScrollbox: TScrollBox;
    FieldNameLabel: TLabel;
    PrintTitleLabel: TLabel;
    PrintLabel: TLabel;
    TotalsLabel: TLabel;
    AverageLabel: TLabel;
    SizeLabel: TLabel;
    AlignmentLabel: TLabel;
    DecimalsLabel: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    FieldEditors:Array[0..255] of TFieldEditors;
  public
    Translation:TTranslation;
    FieldSpesifications:TFieldSpesifications;
  end;

  TFieldSpesificationsProperty = class( TClassProperty )
       function GetAttributes: TPropertyAttributes; override;
       function GetValue:String; override;
       procedure SetValue(const Value:String); override;
       procedure Edit; override;
  end;


implementation

{$R *.DFM}

constructor TFieldSpesification.Create;

begin
  Inherited Create;
  FieldName:='';
  FieldTitle:='';
  PrintField:=True;
  PrintTotals:=False;
  PrintAverage:=False;
  FieldSize:=0;
  FieldDecimals:=0;
  FieldAlignment:=0;
end;

destructor TFieldSpesification.Destroy;

begin
  Inherited destroy;
end;

Procedure TFieldSpesifications.ReadData(Reader:TReader);

var i:integer;

begin
  IsReading:=True;
  for i:=0 to 255 do if FieldSpesification[i]<>nil then FieldSpesification[i].Free;
  Reader.ReadListBegin;
  i:=0;
  begin
    While not Reader.EndOfList do begin
      FieldSpesification[i]:=TFieldSpesification.Create;
      FieldSpesification[i].FieldName:=Reader.ReadString;
      FieldSpesification[i].FieldTitle:=Reader.ReadString;
      FieldSpesification[i].PrintField:=Reader.ReadBoolean;
      FieldSpesification[i].PrintTotals:=Reader.ReadBoolean;
      FieldSpesification[i].PrintAverage:=Reader.ReadBoolean;
      FieldSpesification[i].FieldSize:=Reader.ReadInteger;
      FieldSpesification[i].FieldDecimals:=Reader.ReadInteger;
      FieldSpesification[i].FieldAlignment:=Reader.ReadInteger;
      if not Reader.EndOfList then inc(i);
    end;
  end;
  Reader.ReadListEnd;
end;

procedure TFieldSpesifications.WriteData(Writer:TWriter);

var i:integer;

begin
  Writer.WriteListBegin;
  i:=0;
  While FieldSpesification[i]<>NIL do begin
    Writer.WriteString(FieldSpesification[i].FieldName);
    Writer.WriteString(FieldSpesification[i].FieldTitle);
    Writer.WriteBoolean(FieldSpesification[i].PrintField);
    Writer.WriteBoolean(FieldSpesification[i].PrintTotals);
    Writer.WriteBoolean(FieldSpesification[i].PrintAverage);
    Writer.WriteInteger(FieldSpesification[i].FieldSize);
    Writer.WriteInteger(FieldSpesification[i].FieldDecimals);
    Writer.WriteInteger(FieldSpesification[i].FieldAlignment);
    Inc(i);
  end;
  Writer.WriteListEnd;
end;

procedure TFieldSpesifications.DefineProperties(Filer:TFiler);

begin
  Inherited DefineProperties(Filer);
  Filer.DefineProperty('FieldSpesifications',FReadData,FWriteData,True);
end;

constructor TFieldSpesifications.Create;

var i:integer;

begin
  inherited Create;
  IsReading:=False;
  FDataSource:=TDataSource.Create(Application);
  FPrintTitle:='';
  FOutputHeading:='';
  FOutputInfo:=TStringList.Create;
  FPageNumbering:=False;
  FOutputHeadingFont:=TFont.Create;
  FOutputHeadingFont.Name:='Times New Roman';
  FOutputHeadingFont.Size:=20;
  FOutputHeadingFont.Style:=[fsBold];
  FOutputInfoFont:=TFont.Create;
  FOutputInfoFont.Name:='Times New Roman';
  FOutputInfoFont.Size:=12;
  FOutputInfoFont.Style:=[fsItalic];
  FDataTitleFont:=TFont.Create;
  FDataTitleFont.Name:='Arial';
  FDataTitleFont.Size:=10;
  FDataTitleFont.Style:=[fsBold];
  FDataListFont:=TFont.Create;
  FDataListFont.Name:='Arial';
  FDataListFont.Size:=10;
  FDataListFont.Style:=[];
  FPrintTotals:=False;
  FPrintAverage:=False;
  FColLines:=True;
  FRowLines:=True;
  FRowLineStep:=5;
  for i:=0 to 255 do FieldSpesification[i]:=NIL;
  FReadData:=ReadData;
  FWriteData:=WriteData;
end;

destructor TFieldSpesifications.Destroy;

var i:integer;

begin
  inherited Destroy;
  i:=0;
  While FieldSpesification[i]<>nil do begin
    FieldSpesification[i].Free;
    inc(i);
  end;
end;

procedure TFieldSpesifications.SetDataSource(Value:TDataSource);

var i:Integer;
    IsValid:Boolean;

begin
  IsValid:=True;
  FDataSource:=Value;
  if (FDataSource=NIL) or IsReading then begin
    IsReading:=False;
    exit;
  end;
  if FDataSource=NIL then IsValid:=False else begin
    if FDataSource.DataSet.FieldCount>0 then begin
      for i:=0 to FDataSource.DataSet.FieldCount-1 do begin
        if FieldSpesification[i]=NIL then IsValid:=False else begin
          if FieldSpesification[i].FieldName<>FDataSource.DataSet.Fields[i].FieldName then IsValid:=False;
        end;
      end;
    end
    else IsValid:=False;
  end;
  if not IsValid then begin
    for i:=0 to 255 do if FieldSpesification[i]<>NIL then begin
      FieldSpesification[i].Free;
      FieldSpesification[i]:=NIL;
    end;
    if FDataSource<>NIL then begin
      if FDataSource.DataSet.FieldCount>0 then for i:=0 to FDataSource.DataSet.FieldCount-1 do begin
        FieldSpesification[i]:=TFieldSpesification.Create;
        with FieldSpesification[i] do begin
          FieldName:=FDataSource.Dataset.Fields[i].FieldName;
          if FDataSource.Dataset.Fields[i].DisplayLabel='' then
            FieldTitle:=FDataSource.Dataset.Fields[i].FieldName
          else
            FieldTitle:=FDataSource.Dataset.Fields[i].DisplayLabel;
          PrintField:=FDataSource.Dataset.Fields[i].DataType in
                                          [ftString,ftSmallInt,ftInteger,ftWord,ftBoolean,
                                           ftFloat,ftCurrency,ftDate,ftTime,ftDateTime];
          PrintTotals:=False;
          PrintAverage:=False;
          FieldSize:=0;
          FieldDecimals:=0;
          FieldAlignment:=0;
          Case FDataSource.DataSet.Fields[i].DataType of
            ftString   :FieldSize:=FDataSource.Dataset.Fields[i].DataSize;
            ftSmallInt :Begin
                          FieldSize:=7;
                          FieldAlignment:=2;
                        end;
            ftInteger  :Begin
                          FieldSize:=12;
                          FieldAlignment:=2;
                        end;
            ftWord     :Begin
                          FieldSize:=6;
                          FieldAlignment:=2;
                        end;
            ftBoolean  :FieldSize:=6;
            ftFloat    :Begin
                          FieldSize:=13;
                          FieldDecimals:=1;
                          FieldAlignment:=2;
                        end;
            ftCurrency :begin
                          FieldSize:=15;
                          FieldDecimals:=2;
                          FieldAlignment:=2;
                        end;
            ftDate     :FieldSize:=9;
            ftTime     :FieldSize:=9;
            ftDateTime :FieldSize:=19;
          end;
        end;
      end;
    end;
  end;
end;

constructor TFieldEditors.Create(AOwner:TScrollbox;Top:Integer;FieldType:TFieldType;Translation:TTranslation);

var AllowPrint:Boolean;

begin
  inherited Create;
  FieldNameLabel:=TLabel.Create(AOwner);
  FieldNameLabel.Left:=8;
  FieldNameLabel.Top:=Top;
  FieldNameLabel.Width:=100;
  FieldNameLabel.Height:=26;
  FieldNameLabel.Font.Name:='MS Sans Serif';
  FieldNameLabel.Font.Style:=[];
  FieldNameLabel.Font.Size:=10;
  AOwner.InsertControl(FieldNameLabel);
  FieldNameLabel.Top:=Top;
  FieldTitleEdit:=TEdit.Create(AOwner);
  FieldTitleEdit.Parent:=AOwner;
  FieldTitleEdit.Left:=112;
  FieldTitleEdit.Top:=Top;
  FieldTitleEdit.width:=100;
  FieldTitleEdit.Font.Name:='MS Sans Serif';
  FieldTitleEdit.Font.Style:=[];
  FieldTitleEdit.Font.Size:=10;
  AOwner.InsertControl(FieldTitleEdit);
  FieldTitleEdit.TabOrder:=AOwner.Tag;
  AOwner.Tag:=AOwner.Tag+1;
  PrintFieldCheckbox:=TCheckbox.Create(AOwner);
  PrintFieldCheckbox.Parent:=AOwner;
  PrintFieldCheckbox.Left:=216;
  PrintFieldCheckbox.Top:=Top+2;
  PrintFieldCheckbox.Caption:='   ';
  PrintFieldCheckbox.Width:=17;
  AOwner.InsertControl(PrintFieldCheckbox);
  PrintFieldCheckbox.TabOrder:=AOwner.Tag;
  AOwner.Tag:=AOwner.Tag+1;
  PrintTotalsCheckbox:=TCheckbox.Create(AOwner);
  PrintTotalsCheckbox.Parent:=AOwner;
  PrintTotalsCheckbox.Left:=256;
  PrintTotalsCheckbox.Top:=Top+2;
  PrintTotalsCheckbox.Caption:='   ';
  PrintTotalsCheckbox.Width:=17;
  AOwner.InsertControl(PrintTotalsCheckbox);
  PrintTotalsCheckbox.TabOrder:=AOwner.Tag;
  AOwner.Tag:=AOwner.Tag+1;
  PrintAverageCheckbox:=TCheckbox.Create(AOwner);
  PrintAverageCheckbox.Parent:=AOwner;
  PrintAverageCheckbox.Left:=304;
  PrintAverageCheckbox.Top:=Top+2;
  PrintAverageCheckbox.Caption:='   ';
  PrintAverageCheckbox.Width:=17;
  AOwner.InsertControl(PrintAverageCheckbox);
  PrintAverageCheckbox.TabOrder:=AOwner.Tag;
  AOwner.Tag:=AOwner.Tag+1;
  FieldSizeEdit:=TEdit.Create(AOwner);
  FieldSizeEdit.Parent:=AOwner;
  FieldSizeEdit.Left:=360;
  FieldSizeEdit.Top:=Top;
  FieldSizeEdit.Width:=33;
  FieldSizeEdit.Text:='';
  FieldSizeEdit.Font.Name:='MS Sans Serif';
  FieldSizeEdit.Font.Style:=[];
  FieldSizeEdit.Font.Size:=10;
  AOwner.InsertControl(FieldSizeEdit);
  FieldSizeEdit.TabOrder:=AOwner.Tag;
  AOwner.Tag:=AOwner.Tag+1;
  FieldDecimalsEdit:=TEdit.Create(AOwner);
  FieldDecimalsEdit.Parent:=AOwner;
  FieldDecimalsEdit.Left:=400;
  FieldDecimalsEdit.Top:=Top;
  FieldDecimalsEdit.Width:=33;
  FieldDecimalsEdit.Text:='';
  FieldDecimalsEdit.Font.Name:='MS Sans Serif';
  FieldDecimalsEdit.Font.Style:=[];
  FieldDecimalsEdit.Font.Size:=10;
  AOwner.InsertControl(FieldDecimalsEdit);
  FieldDecimalsEdit.TabOrder:=AOwner.Tag;
  AOwner.Tag:=AOwner.Tag+1;
  FieldAlignmentCombo:=TCombobox.Create(AOwner);
  FieldAlignmentCombo.Parent:=AOwner;
  FieldAlignmentCombo.Top:=Top;
  FieldAlignmentCombo.Left:=464;
  FieldAlignmentCombo.Width:=65;
  FieldAlignmentCombo.Font.Name:='MS Sans Serif';
  FieldAlignmentCombo.Font.Style:=[];
  FieldAlignmentCombo.Font.Size:=10;
  FieldAlignmentCombo.Style:=csDropDownList;
  FieldAlignmentCombo.Items.Clear;
  FieldAlignmentCombo.Items.Add(Translation.GetText(10));
  FieldAlignmentCombo.Items.Add(Translation.GetText(11));
  FieldAlignmentCombo.Items.Add(Translation.GetText(12));
  AOwner.InsertControl(FieldAlignmentCombo);
  FieldAlignmentCombo.TabOrder:=AOwner.Tag;
  AOwner.Tag:=AOwner.Tag+1;

  AllowPrint:=FieldType in [ftString,ftSmallInt,ftInteger,ftWord,ftBoolean,
                            ftFloat,ftCurrency,ftDate,ftTime,ftDateTime];

  FieldTitleEdit.Enabled:=AllowPrint;
  PrintFieldCheckbox.Enabled:=AllowPrint;
  PrintTotalsCheckbox.Enabled:=AllowPrint and (FieldType in [ftSmallInt,ftInteger,ftWord,
                                                             ftFloat,ftCurrency,ftDate,ftTime,ftDateTime]);
  PrintAverageCheckbox.Enabled:=PrintTotalsCheckbox.Enabled;
  FieldSizeEdit.Enabled:=AllowPrint;
  FieldDecimalsEdit.Enabled:=AllowPrint and (FieldType in [ftSmallInt,ftInteger,ftWord,ftFloat,ftCurrency]);
  FieldAlignmentCombo.Enabled:=AllowPrint;
end;

destructor TFieldEditors.Destroy;

begin
  inherited destroy;
  FieldNameLabel.Free;
  FieldTitleEdit.Free;
  PrintFieldCheckbox.Free;
  PrintTotalsCheckbox.Free;
  PrintAverageCheckbox.Free;
  FieldSizeEdit.Free;
  FieldDecimalsEdit.Free;
  FieldAlignmentCombo.Free;
end;

procedure TFieldSpesDialog.FormShow(Sender: TObject);

var
    YPos:Integer;
    abuf:array[0..100] of char;
    i:integer;

Begin
  Caption:=Translation.GetText(1);
  FieldNameLabel.Caption:=Translation.GetText(2);
  PrintTitleLabel.Caption:=Translation.GetText(3);
  PrintLabel.Caption:=Translation.GetText(4);
  TotalsLabel.Caption:=Translation.GetText(5);
  AverageLabel.Caption:=Translation.GetText(6);
  SizeLabel.Caption:=Translation.GetText(7);
  DecimalsLabel.Caption:=Translation.GetText(8);
  AlignmentLabel.Caption:=Translation.GetText(9);
  OKBtn.Caption:=Translation.GetText(16);
  CancelBtn.Caption:=Translation.GetText(17);
  FieldSpesifications.SetDataSource(FieldSpesifications.FDataSource);
  FieldScrollBox.Tag:=0;  {Used to set tab orders on children controls}
  if FieldSpesifications.FieldSpesification[0]=NIL then begin
    Application.MessageBox('Missing FieldSpesification data! Probably missing DataSource property.',
                           'Field spesification',MB_OK or MB_ICONEXCLAMATION);
  end
  else with FieldSpesifications do begin
    YPos:=8;
    i:=0;
    While FieldSpesification[i]<>NIL do begin
      FieldEditors[i]:=TFieldEditors.Create(FieldScrollbox,YPos,FDataSource.DataSet.Fields[i].DataType,Translation);
      FieldEditors[i].FieldNameLabel.Caption:=FieldSpesification[i].FieldName;
      FieldEditors[i].FieldTitleEdit.Text:=FieldSpesification[i].FieldTitle;
      FieldEditors[i].PrintFieldCheckbox.Checked:=FieldSpesification[i].PrintField;
      FieldEditors[i].PrintTotalsCheckbox.Checked:=FieldSpesification[i].PrintTotals;
      FieldEditors[i].PrintAverageCheckbox.Checked:=FieldSpesification[i].PrintAverage;
      FieldEditors[i].FieldSizeEdit.Text:=IntToStr(FieldSpesification[i].FieldSize);
      FieldEditors[i].FieldDecimalsEdit.Text:=IntToStr(FieldSpesification[i].FieldDecimals);
      FieldEditors[i].FieldAlignmentCombo.ItemIndex:=FieldSpesification[i].FieldAlignment;
      Inc(YPos,27);
      Inc(i);
    end;
    FieldScrollbox.VertScrollBar.Range:=YPos+3;
    FieldScrollbox.VertScrollBar.Increment:=27;
  end;
end;

procedure TFieldSpesDialog.FormCreate(Sender: TObject);

var i:integer;

begin
  for i:=0 to 255 do FieldEditors[i]:=NIL;
end;

procedure TFieldSpesDialog.FormDestroy(Sender: TObject);

var i:integer;

begin
  i:=0;
  While FieldEditors[i]<>NIL do begin
    FieldScrollbox.RemoveControl(FieldEditors[i].FieldNameLabel);
    FieldScrollbox.RemoveControl(FieldEditors[i].FieldTitleEdit);
    FieldScrollbox.RemoveControl(FieldEditors[i].PrintFieldCheckbox);
    FieldScrollbox.RemoveControl(FieldEditors[i].PrintTotalsCheckbox);
    FieldScrollbox.RemoveControl(FieldEditors[i].PrintAverageCheckbox);
    FieldScrollbox.RemoveControl(FieldEditors[i].FieldSizeEdit);
    FieldScrollbox.RemoveControl(FieldEditors[i].FieldDecimalsEdit);
    FieldScrollbox.RemoveControl(FieldEditors[i].FieldAlignmentCombo);
    FieldEditors[i].Free;
    inc(i);
  end;
end;

procedure TFieldSpesDialog.OKBtnClick(Sender: TObject);

var i:integer;

begin
  i:=0;
  While FieldSpesifications.FieldSpesification[i]<>NIL do with FieldSpesifications do begin
    FieldSpesification[i].FieldTitle:=FieldEditors[i].FieldTitleEdit.Text;
    FieldSpesification[i].PrintField:=FieldEditors[i].PrintFieldCheckbox.Checked;
    FieldSpesification[i].PrintTotals:=FieldEditors[i].PrintTotalsCheckbox.Checked;
    FieldSpesification[i].PrintAverage:=FieldEditors[i].PrintAverageCheckbox.Checked;
    FieldSpesification[i].FieldSize:=StrToInt(FieldEditors[i].FieldSizeEdit.Text);
    FieldSpesification[i].FieldDecimals:=StrToInt(FieldEditors[i].FieldDecimalsEdit.Text);
    FieldSpesification[i].FieldAlignment:=FieldEditors[i].FieldAlignmentCombo.ItemIndex;
    inc(i);
  end;
end;

function TFieldSpesificationsProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog,paReadOnly];
end;

function TFieldSpesificationsProperty.GetValue:String;

begin
  Result:=Inherited GetValue;
end;

procedure TFieldSpesificationsProperty.SetValue(const Value:String);

begin
  Inherited SetValue(Value);
end;

procedure TFieldSpesificationsProperty.Edit;

var FieldspesDialog: TFieldSpesDialog;
    AFieldSpes:TFieldSpesifications;

begin
  AFieldSpes:=TFieldSpesifications(GetOrdValue);
  if AFieldSpes.FDataSource=NIL then begin
    Application.MessageBox('Missing DataSource property','DBPrint',MB_OK or MB_ICONEXCLAMATION);
    Exit;
  end;
  FieldSpesDialog := TFieldSpesDialog.Create(Application);
  try
    FieldSpesDialog.Translation:=TTranslation.Create;
    FieldSpesDialog.FieldSpesifications := TFieldSpesifications(GetOrdValue);
    if FieldSpesDialog.FieldSpesifications<>NIL then begin
      if FieldSpesDialog.ShowModal=idOK then SetOrdValue(Longint(FieldSpesDialog.FieldSpesifications));
    end
    else begin
      Application.MessageBox('Cannot assign NIL to FieldSpesDialog! DataSource probably not set.',
                             'Field spesification',MB_OK or MB_ICONEXCLAMATION);
    end;
  finally
    FieldSpesdialog.Translation.Free;
    FieldSpesDialog.Free
  end;
end;


end.
