unit Dbprint;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, Printers, DBPrintF, DBPrintD, DBPrintA, DBPrintT;

type
  Jakobsen=class(TObject)
  end;

  TDBPrint = class(TComponent)
  private
    FAboutBox:Jakobsen;
    FFieldSpesificationPopup:Boolean;
    FPrintDialogPopup:Boolean;
    FTranslation:TTranslation;
    FFieldSpesifications:TFieldSpesifications;
    FOnDrawData:TNotifyDrawDataEvent;
    procedure SetDataSource(Value:TDataSource);
    function  GetDataSource:TDataSource;
    procedure SetPrintTitle(Value:String);
    function  GetPrintTitle:String;
    procedure SetOutputHeading(Value:String);
    function  GetOutputHeading:String;
    procedure SetOutputInfo(Value:TStringList);
    function  GetOutputInfo:TStringList;
    procedure SetPageNumbering(Value:Boolean);
    function  GetPageNumbering:Boolean;
    procedure SetOutputHeadingFont(Value:TFont);
    function  GetOutputHeadingFont:TFont;
    procedure SetOutputInfoFont(Value:TFont);
    function  GetOutputInfoFont:TFont;
    procedure SetDataTitleFont(Value:TFont);
    function  GetDataTitleFont:TFont;
    procedure SetDataListFont(Value:TFont);
    function  GetDataListFont:TFont;
    procedure SetPrintTotals(Value:Boolean);
    function  GetPrintTotals:Boolean;
    procedure SetPrintAverage(Value:Boolean);
    function  GetPrintAverage:Boolean;
    procedure SetColLines(Value:Boolean);
    function  GetColLines:Boolean;
    procedure SetRowLines(Value:Boolean);
    function  GetRowLines:Boolean;
    procedure SetRowLineStep(Value:Integer);
    function  GetRowLineStep:Integer;
    procedure SetFieldSpesificationPopup(Value:Boolean);
    procedure SetPrintDialogPopup(Value:Boolean);
    procedure SetFieldSpesifications(Value:TFieldSpesifications);
  protected
    { Protected declarations }
  public
    Constructor Create(AOwner:TComponent); override;
    Destructor  Destroy; override;
    Function Execute:Boolean;
  published
    property About:Jakobsen read FAboutBox write FAboutBox;
    property Translation:TTranslation read FTranslation write FTranslation;
    property DataSource:TDataSource read GetDataSource write SetDataSource;
    property PrintTitle:String read GetPrintTitle write SetPrintTitle;
    property OutputHeading:String read GetOutputHeading write SetOutputHeading;
    property OutputInfo:TStringList read GetOutputInfo write SetOutputInfo;
    property PageNumbering:Boolean read GetPageNumbering write SetPageNumbering;
    property OutputHeadingFont:TFont read GetOutputHeadingFont write SetOutputHeadingFont;
    property OutputInfoFont:TFont read GetOutputInfoFont write SetOutputInfoFont;
    property DataTitleFont:TFont read GetDataTitleFont write SetDataTitleFont;
    property DataListFont:TFont read GetDataListFont write SetDataListFont;
    property PrintTotals:Boolean read GetPrintTotals write SetPrintTotals;
    property PrintAverage:Boolean read GetPrintAverage write SetPrintAverage;
    property ColLines:Boolean read GetColLines write SetColLines;
    property RowLines:Boolean read GetRowLines write SetRowLines;
    property RowLineStep:Integer read GetRowLineStep write SetRowLineStep;
    property FieldSpesificationPopup:Boolean read FFieldSpesificationPopup write SetFieldSpesificationPopup;
    property PrintDialogPopup:Boolean read FPrintDialogPopup write SetPrintDialogPopup;
    property FieldSpesifications:TFieldSpesifications read FFieldSpesifications write SetFieldSpesifications;
    property OnDrawData:TNotifyDrawDataEvent read FOnDrawData write FOnDrawData;
  end;

procedure Register;

implementation

uses DsgnIntf;

constructor TDBPrint.Create(AOwner:TComponent);

begin
  inherited Create(AOwner);
  FAboutBox:=Jakobsen.Create;
  FFieldSpesificationPopup:=False;
  FPrintDialogPopup:=True;
  FFieldSpesifications:=TFieldSpesifications.Create;
  FTranslation:=TTranslation.Create;
end;

Destructor TDBPrint.Destroy;

begin
  Inherited Destroy;
  FFieldSpesifications.Free;
  FAboutBox.Free;
end;

procedure TDBPrint.SetDataSource(Value:TDataSource);

begin
  FieldSpesifications.SetDataSource(Value);
end;

function TDBPrint.GetDataSource:TDataSource;
begin
  Result:=FFieldSpesifications.FDataSource;
end;

procedure TDBPrint.SetPrintTitle(Value:String);
begin
  FFieldSpesifications.FPrintTitle:=Value;
end;

function TDBPrint.GetPrintTitle:String;
begin
  Result:=FFieldSpesifications.FPrintTitle;
end;

procedure TDBPrint.SetOutputHeading(Value:String);
begin
  FFieldSpesifications.FOutputHeading:=Value;
end;

function TDBPrint.GetOutputHeading:String;
begin
  Result:=FFieldSpesifications.FOutputHeading;
end;

procedure TDBPrint.SetOutputInfo(Value:TStringList);
begin
  FFieldSpesifications.FOutputInfo.Assign(Value);
end;

function TDBPrint.GetOutputInfo:TStringList;
begin
  Result:=FFieldSpesifications.FOutputInfo;
end;

procedure TDBPrint.SetPageNumbering(Value:Boolean);
begin
  FFieldSpesifications.FPageNumbering:=Value;
end;

function TDBPrint.GetPageNumbering:Boolean;
begin
  Result:=FFieldSpesifications.FPageNumbering;
end;

procedure TDBPrint.SetOutputHeadingFont(Value:TFont);
begin
  FFieldSpesifications.FOutputHeadingFont.Assign(Value);
end;

function TDBPrint.GetOutputHeadingFont:TFont;
begin
  Result:=FFieldSpesifications.FOutputHeadingFont;
end;

procedure TDBPrint.SetOutputInfoFont(Value:TFont);
begin
  FFieldSpesifications.FOutputInfoFont.Assign(Value);
end;

function TDBPrint.GetOutputInfoFont:TFont;
begin
  Result:=FFieldSpesifications.FOutputInfoFont;
end;

procedure TDBPrint.SetDataTitleFont(Value:TFont);
begin
  FFieldSpesifications.FDataTitleFont.Assign(Value);
end;

function TDBPrint.GetDataTitleFont:TFont;
begin
  Result:=FFieldSpesifications.FDataTitleFont;
end;

procedure TDBPrint.SetDataListFont(Value:TFont);
begin
  FFieldSpesifications.FDataListFont.Assign(Value);
end;

function TDBPrint.GetDataListFont:TFont;
begin
  Result:=FFieldSpesifications.FDataListFont;
end;

procedure TDBPrint.SetPrintTotals(Value:Boolean);
begin
  FFieldSpesifications.FPrintTotals:=Value;
end;

function TDBPrint.GetPrintTotals:Boolean;
begin
  Result:=FFieldSpesifications.FPrintTotals;
end;

procedure TDBPrint.SetPrintAverage(Value:Boolean);
begin
  FFieldSpesifications.FPrintAverage:=Value;
end;

function TDBPrint.GetPrintAverage:Boolean;
begin
  Result:=FFieldSpesifications.FPrintAverage;
end;

procedure TDBPrint.SetColLines(Value:Boolean);
begin
  FFieldSpesifications.FColLines:=Value;
end;

function TDBPrint.GetColLines:Boolean;
begin
  Result:=FFieldSpesifications.FColLines;
end;

procedure TDBPrint.SetRowLines(Value:Boolean);
begin
  FFieldSpesifications.FRowLines:=Value;
end;

function TDBPrint.GetRowLines:Boolean;
begin
  Result:=FFieldSpesifications.FRowLines;
end;

procedure TDBPrint.SetRowLineStep(Value:Integer);
begin
  FFieldSpesifications.FRowLineStep:=Value;
end;

function TDBPrint.GetRowLineStep:Integer;
begin
  Result:=FFieldSpesifications.FRowLineStep;
end;

procedure TDBPrint.SetFieldSpesificationPopup(Value:Boolean);
begin
  FFieldSpesificationPopup:=Value;
end;

procedure TDBPrint.SetPrintDialogPopup(Value:Boolean);
begin
  FPrintDialogPopup:=Value;
end;

procedure TDBPrint.SetFieldSpesifications(Value:TFieldSpesifications);
begin
  FFieldSpesifications:=Value;
end;

function TDBPrint.Execute:Boolean;

var ARes:Boolean;
    AResult:Integer;
    FieldSpesDialog:TFieldSpesDialog;
    PrintDialog:TPrintDialog;
    PrintingDialog:TPrintingDialog;
    Copies:Integer;

begin
  Copies:=1;
  ARes:=FFieldSpesifications.FDataSource<>NIL;
  if not ARes then begin
    Application.MessageBox('Missing DataSource property!','DBPrint',MB_OK or MB_ICONEXCLAMATION);
    Exit;
  end;
  ARes:=FFieldSpesifications.FDataSource.DataSet.RecordCount>0;
  if not ARes then begin
    Application.MessageBox('DataSource contains no data!','DBPrint',MB_OK or MB_ICONEXCLAMATION);
    Exit;
  end;
  if FFieldSpesificationPopup then begin
    FieldSpesDialog:=TFieldSpesDialog.Create(Application);
    FieldSpesDialog.FieldSpesifications:=FFieldSpesifications;
    FieldSpesDialog.Translation:=Translation;
    AResult:=FieldSpesDialog.ShowModal;
    FieldSpesDialog.Free;
    if AResult<>idOK then exit;
  end;
  if FPrintDialogPopup then begin
    PrintDialog:=TPrintDialog.Create(Application);
    ARes:=PrintDialog.Execute;
    Copies:=PrintDialog.Copies;
    PrintDialog.Free;
  end;
  if ARes then begin
    PrintingDialog:=TPrintingDialog.Create(Application);
    PrintingDialog.FieldSpesifications:=FFieldSpesifications;
    PrintingDialog.Translation:=Translation;
    PrintingDialog.Copies:=Copies;
    PrintingDialog.FOnDrawData:=FOnDrawData;
    PrintingDialog.ShowModal;
    PrintingDialog.Free;
  end;
end;

procedure Register;
begin
  RegisterComponents('Data Controls', [TDBPrint]);
  RegisterPropertyEditor( TypeInfo(TFieldSpesifications),TDBPrint,'FieldSpesifications',TFieldSpesificationsProperty);
  RegisterPropertyEditor( TypeInfo(Jakobsen),TDBPrint,'About',TAboutDBPrintProperty);
  RegisterPropertyEditor( TypeInfo(TTranslation),TDBPrint,'Translation',TTranslationProperty);
end;

end.
