unit Lflabel;

interface

uses
  Classes, StdCtrls, Dsgnintf, Dialogs, Controls;

const
  DELIM_CHAR = '|';
  NEWLINE    = #13;

type
  TLabelWithLineBreaks = class(TLabel)
  private
    function GetCaption: String;
    procedure SetCaption(NewCaption: String);
  published
    property Caption: String read GetCaption write SetCaption;
  end;

  TLineBreakCaptionProperty = class (TCaptionProperty)
  public
    function GetValue: string; override;
    procedure SetValue(const Value: string); override;
  end;

implementation

function TLabelWithLineBreaks.GetCaption: String;
begin
    Result := inherited Caption;
end;

procedure TLabelWithLineBreaks.SetCaption(NewCaption: String);
begin
    inherited Caption := NewCaption;
end;

function TLineBreakCaptionProperty.GetValue: string;
var
    i: integer;
begin
    Result := inherited GetValue;

    for i:= 1 to Length(Result) do
        if (Result[i] = NEWLINE) then
            Result[i] := DELIM_CHAR;
end;

procedure TLineBreakCaptionProperty.SetValue(const Value: string);
var
    ConvertedValue: String;
    i: integer;
begin
    ConvertedValue := Value;

    for i:= 1 to Length(ConvertedValue) do
        if (ConvertedValue[i] = DELIM_CHAR) then
            ConvertedValue[i] := NEWLINE;

    inherited SetValue(ConvertedValue);
end;

end.
