unit Editenbl;
{
  EditEnbl.pas

  (c) 1996 Dwayne Mercredi

  declared class TCommonPropertyGroupEditor

  class TCommonPropertyGroupEditor:
    overrides double click action for all common property group components
    to display a dual list dialog with all grouped components in one
    list and all components that may be added to the group in the other
    list.
}
interface

uses
  Dllstdlg, CommnCmd, DsgnIntf, Classes, Forms;

type
  TCommonPropertyGroupEditor = class (TComponentEditor)
  public
    procedure Edit; override;
  end;


implementation

{
  procedure BuildLists(Group, InGroup, NotInGroup)
    builds strings lists from the given common property group.
    postconditions:
    InGroup contains 'ComponentName: Type', Component in the strings array
    and objects array of all components in Group

    NotInGroup contains 'ComponentName: Type', Component in the strings array
    and objects array of all components on Form that could be added to Group
    but are not currently in Group
}
procedure BuildLists(Group: TCommonPropertyGroup; InGroup, NotInGroup: TStrings);
var
  i: Integer;
  Owner, CurrentComponent: TComponent;
begin
  Owner := Group.Owner;

  { begin updates of lists }
  InGroup.BeginUpdate;
  NotInGroup.BeginUpdate;

  { clear lists }
  InGroup.Clear;
  NotInGroup.Clear;

  { for each component in group }
  for i := 0 to Group.Count - 1 do begin
    { add name and component to InGroup list }
    CurrentComponent := Group[i];
    InGroup.AddObject(CurrentComponent.Name +
                            ': ' + CurrentComponent.ClassName,
                            CurrentComponent);
  end;

  { for each component on form }
  for i := 0 to Owner.ComponentCount - 1 do begin
    CurrentComponent := Owner.Components[i];

    { if (not in group) and (can add to group) and (has name) }
    if ((not Group.Contains(CurrentComponent)) and
           Group.CanAdd(CurrentComponent) and
               (CurrentComponent.Name <> '')) then
      { add to NotInGroup list }
      NotInGroup.AddObject(CurrentComponent.Name + ': ' +
                              CurrentComponent.ClassName,
                              CurrentComponent);

  end;

  { end string list updates }
  InGroup.EndUpdate;
  NotInGroup.EndUpdate;
end;

{
  procedure StringsToPropertyGroup

  adds all objects in the Strings.Objects array to the given group as
  components
}
procedure StringsToPropertyGroup(Strings: TStrings; Group: TCommonPropertyGroup);
var
  i: Integer;
begin
  { clear group }
  Group.Clear;

  { for each string in list }
  for i := 0 to Strings.Count - 1 do
    { add object to group }
    if (Strings.Objects[i] <> Nil) then
      Group.Add(TComponent(Strings.Objects[i]));
end;

{--------------------------------------------------------------------
                    class TCommonPropertyGroup
 --------------------------------------------------------------------}

procedure TCommonPropertyGroupEditor.Edit;
var
  Group: TCommonPropertyGroup;
  Dialog: TDualListDialog;
begin
  Group := Component as TCommonPropertyGroup;

  { create dialog }
  Dialog := TDualListDialog.Create(Application);
  try
    with (Dialog) do begin
      { set dialog captions }
      FormCaption := 'Select a Group of Components';
      SrcListCaption := 'Components in Group:';
      DstListCaption := 'Other Components on Form:';

      {
        build lists; treat SrcList as list of contained components
        and DstList as list of remaining components
      }
      BuildLists(Group, SrcList, DstList);

      { execute dialog }
      { if all OK }
      if (Execute) then begin
        { retrieve components from SrcList }
        StringsToPropertyGroup(SrcList, Group);

        { tell form designer that change was made }
        Designer.Modified;
      end;
    end; { with }
  finally
    { free dialog }
    Dialog.Free;
  end;
end;
{--------------------------------------------------------------------
                    end class TCommonPropertyGroup
 --------------------------------------------------------------------}

end.
