{------------------------------------------------------------------------------
*
* module:			DBTABLUZ.PAS COPYRIGHT (C) by UZ
* description:	a DBTABLE descendant which is aware of dBASE III+ indexes
* OVL-level:
* neccessary:		DELPHI 1.0
* target OS:		WIN16
*
*------------------------------------------------------------------------------
* last upd.!	by	  	! reason
*------------------------------------------------------------------------------
* 04/05/95	! 	UZ		! design
*------------------------------------------------------------------------------
*
* contents:
* 	name						meaning/description
* -----------------------------------------------------------------------------
*
*		class TUZTable			derived TTable class with dbASE III+ index awareness
*									and associated procedures
*
*------------------------------------------------------------------------------}
{$define  __DBTABLUZ_PAS}											{ register ourself }
{$IFDEF LIBDEBUG}
   {$D+,L+,Y+}
{$ELSE}
   {$D-,L-,Y-}
{$ENDIF}
unit DBTablUZ;

{---------------------------------------------------------------------------
*	Defines
*---------------------------------------------------------------------------}
{$N+,P+,S-}

{===========================================================================
* 									INTERFACE
*===========================================================================}
interface

{---------------------------------------------------------------------------
*	USES
*---------------------------------------------------------------------------}
uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, DB, DBTables, DBIProcs, DBITypes, DBIErrs;


{---------------------------------------------------------------------------
*	TYPES/CLASSSES
*---------------------------------------------------------------------------}
type
	TUZTable = class(TTable)										{ our TTable derived class}
	{---------------------------------------------------------------------------
	*	PRIVATEs:	first redeclare all that stuff, that we'll need, but is
	*              private to our parent class
	*---------------------------------------------------------------------------}
	private
		FFieldsIndex: Boolean;										{ is private in TTable but needed }
		FIndexName: TIndexName;										{ is private in TTable but needed }

	{---------------------------------------------------------------------------
	*	PROTECTED members: we just move the TTable's private member we use, to
	*							 ensure, that deriving THIS class is easier
	*---------------------------------------------------------------------------}
	protected
		procedure EncodeIndexDesc(var IndexDesc: IDXDesc;	{ THIS IS WHERE THE CHAGES ARE !! }
										  const Name, Fields: string;
										  Options: TIndexOptions);
		function  GetIndexName: string;							{ must to get our IndexName property called }
		procedure GetIndexParams(const IndexName: string;	{ THIS IS WHERE THE CHAGES ARE !! }
										 FieldsIndex: Boolean;		{ is private in TTable but needed }
										 PIndexName, PIndexTag: PChar);
		function  GetTableTypeName: PChar;
		function  IsDBaseTable: Boolean;                   { is private in TTable but needed }
		procedure SetIndex(const Value: string;				{ must to get our GetIndexParams prac called }
								 FieldsIndex: Boolean);
		procedure SetIndexName(const Value: string);			{ must to get our IndexName property called }

	{---------------------------------------------------------------------------
	*	PUBLICs: just our constructors, in case another descedant should be built
	*---------------------------------------------------------------------------}
	public
		{---------------------------------------------------------------------------
		*	just constructor/destructor, in case another descendant should be built
		*---------------------------------------------------------------------------}
		constructor Create(AOwner: TComponent); override;
		destructor Destroy; override;

		{---------------------------------------------------------------------------
		*	the dbASEII+ AddIndex procedure
		*---------------------------------------------------------------------------}
		procedure AddIndex(const Name, Fields: string; Options: TIndexOptions);

	{---------------------------------------------------------------------------
	*	PUBLISHEDs:
	*---------------------------------------------------------------------------}
	published
		{---------------------------------------------------------------------------
		*	just insert our property to get things called here, nothing new
		*---------------------------------------------------------------------------}
		property IndexName: string read GetIndexName write SetIndexName;
	end;

{---------------------------------------------------------------------------
*	Consts
*---------------------------------------------------------------------------}

{---------------------------------------------------------------------------
*	Vars/Globals
*---------------------------------------------------------------------------}

{---------------------------------------------------------------------------
*	Prototyping/Forward-Declarations
*---------------------------------------------------------------------------}
procedure Register;


{===========================================================================
* 									IMPLEMENTATION
*===========================================================================}
implementation
{-----------------------------------------------------------------------------
*
* TUZTable.CREATE:	NOTHING changed
* 						just inherited cerate is called
*
*-----------------------------------------------------------------------------
* params:
* 	name				type						meaning
* 	AOwner			TComponent				Owner
*
* value:
*
*-----------------------------------------------------------------------------}
constructor TUZTable.Create(AOwner: TComponent);
begin
	inherited Create(AOwner);
end;
{-------------------------- EOP TUZTable.Create -------------------------------}

destructor TUZTable.Destroy;
begin
	inherited Destroy;
end;
{-------------------------- EOP TUZTable.Create -------------------------------}

procedure TUZTable.AddIndex(const Name, Fields: string;
	Options: TIndexOptions);
var
	STableName: array[0..SizeOf(TFileName) - 1] of Char;
	IndexDesc: IDXDesc;
begin
	FieldDefs.Update;
	EncodeIndexDesc(IndexDesc, Name, Fields, Options);
	if Active then begin
	  CheckBrowseMode;
	  CursorPosChanged;
	  if (IsDBaseTable) and
		  (Pos('.NDX',upperCase(Name)) > 0) then begin
		  Check(DbiAddIndex(DBHandle, Handle, nil, szDBASE, IndexDesc, nil));
		end else begin;
		  Check(DbiAddIndex(DBHandle, Handle, nil, nil, IndexDesc, nil));
		end;
	end else	begin
	  SetDBFlag(dbfTable, True);
	  try
			Check(DbiAddIndex(DBHandle, nil, AnsiToNative(DBLocale, TableName,
			STableName, SizeOf(STableName) - 1), GetTableTypeName,
			IndexDesc, nil));
	  finally
		 SetDBFlag(dbfTable, False);
	  end;
	end;
{	FIndexDefs.FUpdated := False;}
	DataEvent(dePropertyChange, 0);

end;

{-----------------------------------------------------------------------------
*
* TUZTable.EncodeIndexDesc:	CHANGED, build up the index-descriptor
*
*-----------------------------------------------------------------------------
* params:
* 	name				type						meaning
* 	IndexDesc		var IDXDesc				index descriptor, filled on return
*		Name				const string			index(file)name
* 	Fields			string					index fields
*		Options			TIndexOptions			see DBTABLES.PAS
*
* value:
*
*-----------------------------------------------------------------------------}
procedure TUZTable.EncodeIndexDesc(var IndexDesc: IDXDesc;
												const Name, Fields: string;
												Options: TIndexOptions);
var
	iPos: Integer;
begin
	{------------------------------------------------------------------------------
	* prework section, inits
	*------------------------------------------------------------------------------}
	FillChar(IndexDesc, SizeOf(IndexDesc), 0);

	{------------------------------------------------------------------------------
	* coding: nothing changed so far
	*------------------------------------------------------------------------------}
	with IndexDesc do	begin
		{------------------------------------------------------------------------------
		* ADDED: be aware of dBASE III+ indexes
		*------------------------------------------------------------------------------}
		if IsDBaseTable and NOT
			(Pos('.NDX',upperCase(Name)) > 0) then begin	 		{ index is a valid dBASE III+ index filename ? }
		{------------------------------------------------------------------------------
		* UNCHANGED derived again
		*------------------------------------------------------------------------------}
			AnsiToNative(DBLocale, Name, szTagName, SizeOf(szTagName) - 1)
		end else begin
			AnsiToNative(DBLocale, Name, szName, SizeOf(szName) - 1);
		end;

		bPrimary := ixPrimary in Options;
		bUnique := ixUnique in Options;
		bDescending := ixDescending in Options;

		{------------------------------------------------------------------------------
		* ADDED: be aware of dBASE III+ indexes
		*------------------------------------------------------------------------------}
		if (IsDBaseTable) and
			(Pos('.NDX',upperCase(Name)) > 0) then begin	 		{ index is a valid dBASE III+ index filename ? }
			bMaintained := False;										{ CANNOT be maintained }
			szTagName[0] := #0;											{ and has no tag }
		end else begin														{ ! either no dBASE tables or no dBIII+ index }
			bMaintained := True;											{ just emulate original behaviour }
		end;

		{------------------------------------------------------------------------------
		* UNCHANGED derived again
		*------------------------------------------------------------------------------}
		bCaseInsensitive := ixCaseInsensitive in Options;
		if ixExpression in Options then begin
			bExpIdx := True;
			AnsiToNative(DBLocale, Fields, szKeyExp, SizeOf(szKeyExp) - 1);
		end else begin
			iPos := 1;
			while (iPos <= Length(Fields)) and (iFldsInKey < 16) do begin
				aiKeyFld[iFldsInKey] := FieldDefs.Find(ExtractFieldName(Fields, iPos)).FieldNo;
				Inc(iFldsInKey);
			end;
		end;
	end;																		{ with Indexdesc }

	{------------------------------------------------------------------------------
	* postwork section
	*------------------------------------------------------------------------------}
end;
{-------------------------- EOP TUZTable.EndcodeIndexDesc ---------------------}

{-----------------------------------------------------------------------------
*
* TUZTable.GetIndexName:	nothing changed, just needed for the parent's method
*									is private, and we'll have to have this for our
*									property
*
*-----------------------------------------------------------------------------
* params:
* 	name				type						meaning
*
*
* value:
*
*-----------------------------------------------------------------------------}
function TUZTable.GetIndexName: string;
begin
	if FFieldsIndex then Result := '' else Result := FIndexName;
end;
{-------------------------- EOP TUZTable.GetIndexName -------------------------}

{-----------------------------------------------------------------------------
*
* TUZTable.GetIndexParams:	CHANGED
*										to be dBASE III+ aware
*
*-----------------------------------------------------------------------------
* input:
* 	name				type						meaning
*		IndexName		string					index(file)name
*		FieldsIndex		Boolean					TRUE	= index to be faound by fields
*
* ouput:
*		PIndexName		PChar						the ready to use index(file)name
*		PIndexTag		PChar						the ready to use index-tag (if one)
*
*-----------------------------------------------------------------------------}
procedure TUZTable.GetIndexParams(const IndexName: string;
											  FieldsIndex: Boolean;
											  PIndexName, PIndexTag: PChar);
var
	I: Integer;
	IndexStr: TIndexName;
begin
	{------------------------------------------------------------------------------
	* prework section, inits
	*------------------------------------------------------------------------------}
	PIndexName[0] := #0;
	PIndexTag[0] := #0;

	if (IndexName <> '') and not InfoQueryMode then	begin
		{------------------------------------------------------------------------------
		* ONLY do anything, if IndexName is filled and not a query
		*------------------------------------------------------------------------------}
		IndexStr := IndexName;
		if FieldsIndex then begin									{ on FIELDS index }
			if Database.IsSQLBased then begin
				for I := 1 to Length(IndexStr) do begin
					if IndexStr[I] = ';' then IndexStr[I] := '@';
				end;
				IndexStr := '@' + IndexStr;
			end else begin
				IndexStr := IndexDefs.FindIndexForFields(IndexName).Name;
			end;
		end;																{ ? FIELDS index }
		{-----------------------------------------------------------------------------
		* we changed the code HERE:
		* 		if the index' name value contains ',NDX' (a dBASE III index)
		*		we just cut of that nasty chage to .MDX, originally daone, and
		*		instead set the PIndexTag buffer to NIL, for that indexes do
		*		not have any tag
		*-----------------------------------------------------------------------------}
		if (IsDBaseTable) then begin								{ a dBASE table ? }
			AnsiToNative(DBLocale, IndexStr, PIndexTag, SizeOf(TSymbolStr) - 1);
			if(Pos('.NDX',upperCase(IndexName)) = 0) then begin	{ INDEX > dbIII+ ? }
				IndexStr := ChangeFileExt(TableName, '.MDX');{ original behaviour }
			end else begin												{ ! dbIII+ INDEX }
				PIndexTag[0] := #0;									{ for .NDX-files }
			end;															{ ? dbIII+/dbIV index }
		end;																{ ? dBASE table }

		{------------------------------------------------------------------------------
		* UNCHANGED code again
		*------------------------------------------------------------------------------}
		AnsiToNative(DBLocale, IndexStr, PIndexName, SizeOf(TIndexName) - 1);
	end;																	{ ? valid Indexname and not Query }

	{------------------------------------------------------------------------------
	* postwork section
	*------------------------------------------------------------------------------}
end;
{-------------------------- EOP TUZTable.GetIndexParams -----------------------}

function TUZTable.GetTableTypeName: PChar;
const
  Names: array[TTableType] of PChar =
    ('PARADOX', 'PARADOX', 'DBASE', 'ASCIIDRV');
begin
  Result := nil;
	if not Database.IsSQLBased and ((TableType <> ttDefault) or
	  (ExtractFileExt(TableName) = '')) then
    Result := Names[TableType];
end;

{-----------------------------------------------------------------------------
*
* TUZTable.IsDBaseTable:	just a copy from DBTables.PAS, determines, whether
*									the object is a dBASE-table
*
*-----------------------------------------------------------------------------
* params:
* 	name				type						meaning
*
*
* value:
*							Boolean					TRUE = is a dBASE-table (II/III+/IV)
*														FALSE= not a dABSE-table
*
*-----------------------------------------------------------------------------}
function TUZTable.IsDBaseTable: Boolean;
begin
	Result := (TableType = ttDBase) or
				 (CompareText(ExtractFileExt(TableName), '.DBF') = 0);
end;
{-------------------------- EOP TUZTable.IsDBaseTable -------------------------}

{-----------------------------------------------------------------------------
*
* TUZTable.SetIndex:	NOTHING changed
* 							but added, for parnet's equal method is priovate, and
*								we got to have the code here to be called and use our
*								private variables here
*
*-----------------------------------------------------------------------------
* params:
* name				type			meaning
* const Value		string		new index' name
* FieldsIndex		Boolean		TRUE = it's an index based on fieldnames
* 									FALSE= it's an index-file
*
* value:
*
*-----------------------------------------------------------------------------}
procedure TUZTable.SetIndex(const Value: string; FieldsIndex: Boolean);
var
	SIndexName: array[0..SizeOf(TIndexName) - 1] of Char;
	SIndexTag: array[0..SizeOf(TSymbolStr) - 1] of Char;
begin
	if Active then CheckBrowseMode;
	if (FIndexName <> Value) or (FFieldsIndex <> FieldsIndex) then	begin
	  if Active then begin
		 GetIndexParams(Value, FieldsIndex, SIndexName, SIndexTag);
		 SwitchToIndex(SIndexName, SIndexTag);
	  end;
	  FIndexName := Value;
	  FFieldsIndex := FieldsIndex;
	  if Active then Resync([]);
	end;
end;
{-------------------------- EOP TUZTable.SetIndex -----------------------------}

{-----------------------------------------------------------------------------
*
* TUZTable.SetIndexName:	nothing changed, just needed for the parent's method
*									is private, and we'll have to have this for our
*									property and to get our code called
*
*-----------------------------------------------------------------------------
* params:
* 	name				type						meaning
*		Value				cionst string			new index(file)'s name
*
* value:
*
*-----------------------------------------------------------------------------}
procedure TUZTable.SetIndexName(const Value: string);
begin
	SetIndex(Value, False);
end;
{-------------------------- EOP TUZTable.SetIndexName -------------------------}

{-----------------------------------------------------------------------------
*
* Register:	Component-Registration
*
*-----------------------------------------------------------------------------
* params:
* 	name				type						meaning
*
*
* value:
*
*-----------------------------------------------------------------------------}
procedure Register;
begin
	RegisterComponents('UZ', [TUZTable]);
end;
{-------------------------- EOP Register --------------------------------------}

end.
{************************** EOF DBTABLUZ.PAS **********************************}

