(*
////////////////////////////////////////////////////////////////////////////////
// FIELDGRD: A DBGrid with Defineable Fields, Column Titles and Widths        //
// This code is Copyright  1996-1999 Steve Flynn, All Rights Reserved.       //
////////////////////////////////////////////////////////////////////////////////

LICENSE AGREEMENT - MARCH 1999

USE OF THE SOFTWARE

Steven M. Flynn (the "Author") grants you, the end user, a non-exclusive
single-user license to use the supplied software program and all associated
materials including the Source Code (the "Software"). The Software and all
Intellectual Property embodied in the Software always remains the property of
the Author. Your use of the Software indicates your acceptance in full of the
terms and conditions of this agreement.


COPYING THE SOFTWARE

You may freely copy the Software provided that such copies do not infringe upon
any other part of this agreement.


DISTRIBUTION OF THE SOFTWARE

The Software may be re-distributed royalty free providing that it is not
modified in any way and that no charge is made for the Software itself. Only a
nominal fee for media and/or copying services is allowed. All files, including
the License Agreement, that are supplied by the Author with the Software must
also be included in any such distribution.


DERIVED WORKS

You may NOT use the Software to derive any works which are based substantially
in part or in full on the Software or any portion of the Software. Any such
derived works will remain the property of the Author.


MODIFIED VERSIONS OF THE SOFTWARE

All updated, revised, modified or improved versions of the Software are also
subject to the conditions of this license agreement and shall remain the
property of the Author. You are required under the terms of this agreement to
submit to the Author any and all improvements or additions made by you to the 
Software for future inclusion in the general distribution of the Software by
the Author.


TERMINATION OF THIS AGREEMENT

You may terminate this License Agreement at any time by destroying all copies
of the Software in your possession.


LIMITED WARRANTY

The Software is distributed and licensed "AS IS". The Author specifically
disclaims all other warranties, express or implied, including but not limited
to, implied warranties of merchantability and fitness for a particular purpose,
with regard to the Software.


DAMAGES

By using the Software you do so at your own risk. In no event shall the Author
be responsible for any damages whatsoever (including but not limited to,
damages for loss of business profits, business interruption, loss of business
information, or any other pecuniary loss or any other real or consequential 
damages) arising out of the use or inability to use this product.


LIABILITY

In the event of failure of the Software, for any reason, the Author's sole
liability shall be to refund to you the amount paid by you to the Author for
the use of the Software.


COPYRIGHT

The Software and the Intellectual Property embodied in the Software shall
always remain the property of the Author and is protected by Australian
Copyright Law and International Treaty Provisions.


AGREEMENT

Your use of the Software indicates your agreement with the above terms and
conditions. If you do not agree with these terms and conditions then you must
destroy all copies of the software in your possession.


CONSUMER RIGHTS

If any clause in the above Software License Agreement is in violation of your
rights under your local laws then you must cease using the Software
immediately. It is your own responsibility to be aware of your legal rights
under your own local laws.


END OF SOFTWARE LICENSE AGREEMENT

*)

unit FieldGrd;

{$A-,B-,D-,F-,G+,I-,L-,M-,N+,O+,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y-,Z-}
{$IFDEF WIN32}
{$H+,J+}
{$M 16384,1048576}
{$IMAGEBASE $00400000}
{$R FIELDGRD.R32}
{$ELSE}
{$K-}
{$M 16384,8192}
{$R FIELDGRD.R16}
{$ENDIF}
{$C PRELOAD}

interface

uses
	Classes, Controls, StdCtrls, Grids, DBGrids, Graphics, WinTypes, WinProcs;

type
	TDBFieldGrid = class(TDBGrid)
	private
		FFieldList: TStrings;
		FWidthList: TStrings;
		FTitleList: TStrings;

	protected
		procedure SetFieldList(Value: TStrings);
		procedure SetWidthList(Value: TStrings);
		procedure SetTitleList(Value: TStrings);
		procedure SetColumnAttributes; override;
		procedure Paint; override;
		procedure DefineFieldMap; override;

	public
		constructor Create(AOwner: TComponent); override;
		destructor Destroy; override;

	published
		property ColumnFields: TStrings read FFieldList write SetFieldList;
		property ColumnWidths: TStrings read FWidthList write SetWidthList;
		property ColumnTitles: TStrings read FTitleList write SetTitleList;
		property ScrollBars;
		end;

procedure Register;


implementation

uses
	SysUtils, DBConsts;

procedure Register;
	begin
	RegisterComponents('Data Controls', [TDBFieldGrid]);
	end;


function Min(a, b: integer): integer;
	begin
	if b < a then
		Result := b
	else
		Result := a;
	end;


procedure RaiseGridError(const S: string);
	begin
	raise EInvalidGridOperation.Create(S);
	end;


constructor TDBFieldGrid.Create(AOwner: TComponent);
	begin
	inherited Create(AOwner);
	FFieldList := TStringList.Create;
	FWidthList := TStringList.Create;
	FTitleList := TStringList.Create;
	end;


destructor TDBFieldGrid.Destroy;
	begin
	FTitleList.Free;
	FWidthList.Free;
	FFieldList.Free;
	inherited Destroy;
	end;


procedure TDBFieldGrid.SetFieldList(Value: TStrings);
	begin
	FFieldList.Assign(Value);
	LayoutChanged;
	end;


procedure TDBFieldGrid.SetWidthList(Value: TStrings);
	begin
	FWidthList.Assign(Value);
	LayoutChanged;
	end;


procedure TDBFieldGrid.SetTitleList(Value: TStrings);
	begin
	FTitleList.Assign(Value);
	LayoutChanged;
	end;


procedure TDBFieldGrid.DefineFieldMap;
	var
	i: integer;
	begin
	if not Visible then
		exit;
	for i := 0 to FFieldList.Count - 1 do
		if not (Datalink.AddMapping(FFieldList[i])) then
{$IFDEF VER100}
			RaiseGridError(Format(SFieldNotFound, [FFieldList[i]]));
{$ELSE}
{$IFDEF VER120}
			RaiseGridError(Format(SFieldNotFound, [FFieldList[i]]));
{$ELSE}
			RaiseGridError(FmtLoadStr(SFieldNotFound, [FFieldList[i]]));
{$ENDIF}
{$ENDIF}
	end;


procedure TDBFieldGrid.Paint;
	begin
	if not (ScrollBars in [ssVertical, ssBoth]) then
		SetScrollRange(Handle, SB_VERT, 0, 0, False);
	if not (ScrollBars in [ssHorizontal, ssBoth]) then
		SetScrollRange(Handle, SB_HORZ, 0, 0, False);
	inherited Paint;
	end;


procedure TDBFieldGrid.SetColumnAttributes;
	var
	i, CWidth: integer;
	begin
	for i := 0 to Min(FieldCount - 1, Min(FTitleList.Count - 1, FWidthList.Count - 1)) do
		begin
		Fields[i].DisplayLabel := FTitleList[i];
		Fields[i].DisplayWidth := StrToInt(FWidthList[i]);
		Canvas.Font := Font;
		CWidth := Fields[i].DisplayWidth * Canvas.TextWidth('0') + 4;
		ColWidths[I + Ord(dgIndicator in Options)] := CWidth;
		TabStops[I + Ord(dgIndicator in Options)] := not ReadOnly and not Fields[i].Calculated;
		end;
	end;

end.

