unit Dateedit;

{********************************************************************
DateEdit creates an instance of form CalPop dynamically, and displays
it using ShowModal.  The result is stored in the Date property of this
component.
********************************************************************}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, StdCtrls, Calpop, Buttons;

type

  TDateButton = class( TBitBtn )
  private
  protected
     procedure Click; override;
  public
  published
  end;

  TDateEdit = class( TEdit )
  private

     bmMemory: TBitmap;
     FDate: TDateTime;
  protected
     procedure WMSize( var Message: TWMSize ); message WM_SIZE;
     function GetDate: TDateTime;
     procedure SetDate( dtArg: TDateTime );
     procedure DoExit; override;
  public
     FButton: TDateButton;
     constructor Create( AOwner: TComponent ); override;
     destructor Destroy; override;
     procedure CreateParams( var Params: TCreateParams ); override;
     property Date: TDateTime read GetDate write SetDate;
  published
  end;

procedure Register;

var
  frmCalendar: TfrmCalPop;

implementation

{--- TDateButton ---}
procedure TDateButton.Click;
var
  editParent: TDateEdit;
begin
  editParent := TDateEdit( Parent );
  frmCalendar := TfrmCalPop.Create( editParent );
  if not EditParent.ReadOnly then frmCalendar.ShowModal;
  frmCalendar.Free;
  inherited Click;
end;

{--- TDateEdit ---}

constructor TDateEdit.Create( AOwner: TComponent );
begin
  inherited Create( AOwner );
  bmMemory := TBitmap.Create;
  FButton := TDateButton.Create( self );
  FButton.Width := 17;
  FButton.Height := 17;
  FButton.Visible := TRUE;
  FButton.Parent := self;
  ControlStyle := ControlStyle - [csSetCaption];
end;

procedure TDateEdit.CreateParams( var Params: TCreateParams );
begin
  inherited CreateParams( Params );
  Params.Style := Params.Style or WS_CLIPCHILDREN;
end;

destructor TDateEdit.Destroy;
begin
  bmMemory.Free;
  FButton := nil;
  inherited Destroy;
end;

procedure TDateEdit.WMSize( var Message: TWMSize );
var
  rectDraw: TRect;
  nHalfX, nHalfY: integer;
begin
  FButton.Height := Height;
  FButton.Width := Height;
  FButton.Left := Width - Height;
  rectDraw := FButton.ClientRect;
  bmMemory.Width := rectDraw.Right - rectDraw.Left - 4;
  bmMemory.Height := rectDraw.Bottom - rectDraw.Top - 4;
  nHalfX := bmMemory.Width div 2;
  nHalfY := bmMemory.Height div 2;
  rectDraw.Left := 0;
  rectDraw.Top := 0;
  rectDraw.Right := bmMemory.Width;
  rectDraw.Bottom := bmMemory.Height;
  with bmMemory.Canvas do
     begin
        Brush.Color := clSilver;
        Brush.Style := bsSolid;
        FillRect( rectDraw );
        Pen.Color := clWhite;
        MoveTo( nHalfX, 1 );
        LineTo( 1, nHalfY );
        LineTo( nHalfX, rectDraw.Bottom - 2 );
        Pen.Color := clGray;
        LineTo( rectDraw.Right - 2, nHalfY );
        LineTo( nHalfX, 1 );
     end;
  FButton.Glyph := bmMemory;
  FButton.Refresh;
end;

function TDateEdit.GetDate: TDateTime;
begin
  GetDate := FDate;
end;

procedure TDateEdit.SetDate( dtArg: TDateTime );
begin
  FDate := dtArg;
  Modified := TRUE;
  if FDate = 0 then
     Text := ''
  else
     Text := FormatDateTime( 'd/m/yyyy', FDate );
change;
end;

function MsgBox( const sMsg, sCaption: String; nFlags: integer ): integer;
var
  lpMsg, lpCaption: PChar;
begin
  lpMsg := StrAlloc( Length( sMsg ) + 1 );
  lpCaption := StrAlloc( Length( sCaption ) + 1 );
  StrPCopy( lpMsg, sMsg );
  StrPCopy( lpCaption, sCaption );
  MsgBox := MessageBox( 0, lpMsg, lpCaption, nFlags );
  StrDispose( lpCaption );
  StrDispose( lpMsg );
end;

procedure TDateEdit.DoExit;
begin
  inherited DoExit;
  try
     if Text <> '' then
        Date := StrToDate( Text );
  except
     MsgBox( 'Date non valide: ' + Text, '', MB_ICONEXCLAMATION );
     SetFocus;
  end;
end;

procedure Register;
begin
  RegisterComponents('Div2', [TDateEdit]);
end;

end.
