(******************************************************************************
               .__z-=~~~~~~~@zz__
            _z~~     _zr    `~-@b_
          .d~      .d@"        `@@z
         .%        a@[          `@@L
         d'       ]@@            ]@[                                  TM
         ]        a@[            ]@[   ___zz___  _zzz   )zL   .______,
         `L      )@@'            ]@[ ]d@~   .@[ )~.@@   `@@L ]ar'  ]@'
          `L     d@[             a@[e@@'    d@'   ]@P     "[ a@    d@
                 a@[            ]@@)@@'    _@@    a@'     d']@K---=~"
                ]@@           .z@@']@@   _d"@[ _ )@@    _/' ]@[     _
              ._a@[        __z~~'  `@@L_s~ `@L_' `@L__s-"   `@@____/"
            ~~~~~~~~~~---~~~        `~~"    "~'   `~~         ~~~~


              TDaveButton1 - nhrada za TButton
              ************ - hlavn rozdl je v designu
                           - m pevnou velikost Y a promnnou X

      (c) David Grudl, U Splavu 11, 690 02 Breclav, Czech Republic, 1998
***************************  email: daveg@email.cz  **************************)



unit DaveBtn1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Menus, Dialogs;

const
   constHeight = 41; { konstantni vyska tlacitka }

type
  TButtonState     = (bsOff, bsOn);              { stav tlatka - nezmkl, zmkl }
  TButtonStyle     = (bsOnGray, bsOnWhite);      { tvar a druh tlatka - zatm se li barvou podkladu }

TDaveButton1 = class(TCustomControl)
  private
    FLastFocus : boolean;
    FDefault : boolean;
    FCancel: Boolean;
    FModalResult: TModalResult;

    FPicture         : array [TButtonState,TButtonStyle] of TBitMap;  { Obrzek tlatka }
    FStatus          : TButtonState;
    FStyle           : TButtonStyle;
    FTemp            : boolean;                          { doasn stlaen - interakce myky }
    Procedure SetButtonStyle(Value : TButtonStyle);      { Nasteven stylu pro property }
    Procedure SetButtonState(Value : TButtonState);      { Nasteven stavu pro property }
    Procedure CMTextChanged(var Message : TMessage); message CM_TextChanged;

    procedure SetDefault(Value: Boolean);
    procedure CMDialogKey(var Message: TCMDialogKey); message CM_DIALOGKEY;
    procedure CMDialogChar(var Message: TCMDialogChar); message CM_DIALOGCHAR;
    procedure CMFocusChanged(var Message: TCMFocusChanged); message CM_FOCUSCHANGED;
    procedure CNCommand(var Message: TWMCommand); message CN_COMMAND;
  protected
    procedure Paint; override; {Called on WM_PAINT message}
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Click; override;
  published
    property Style : TButtonStyle read FStyle write SetButtonStyle default bsOnGray;
    property Status : TButtonState read FStatus write SetButtonState default bsOff;


    property Cancel: Boolean read FCancel write FCancel default False;
    property Caption;
    property Default: Boolean read FDefault write SetDefault default False;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property ModalResult: TModalResult read FModalResult write FModalResult default 0;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop default True;
    property Visible;
    property OnClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;



procedure Register;

implementation

{$IFDEF WIN32}
{$R dbtn32.res}
{$ELSE}
{$R dbtn16.res}
{$ENDIF}

procedure Register;
begin
  RegisterComponents('Dave Design', [TDaveButton1]);
end;

(* -------------------------------------------------------------------------- *)




constructor TDaveButton1.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle:=[csSetCaption, csFixedHeight, csOpaque, csDoubleClicks, csCaptureMouse];

  TabStop := True;
  Height := constHeight; { rozmry }
  Width := 91;
  FStatus := bsOff;
  FStyle  := bsOnGray;

  FPicture[bsOff,bsOnWhite] := TBitMap.Create;   { grafiku je teba nast z Resources }
  FPicture[bsOff,bsOnWhite].Handle:=LoadBitMap(hInstance,'BUTTON1A');
  FPicture[bsOn,bsOnWhite]  := TBitMap.Create;
  FPicture[bsOn,bsOnWhite].Handle:=LoadBitMap(hInstance,'BUTTON1B');
  FPicture[bsOff,bsOnGray] := TBitMap.Create;
  FPicture[bsOff,bsOnGray].Handle:=LoadBitMap(hInstance,'BUTTON2A');
  FPicture[bsOn,bsOnGray]  := TBitMap.Create;
  FPicture[bsOn,bsOnGray].Handle:=LoadBitMap(hInstance,'BUTTON2B');

  Canvas.Brush.Style:=bsClear;                { Pprava ttc, font, ... }
  Canvas.Pen.Color:=clGray;
  with Font do  begin Color:=clYellow; Size:=13; Style:=[fsBold]; Name:='Arial'; end;

  FLastFocus:=focused;
end;






(* -------------------------------------------------------------------------- *)

destructor TDaveButton1.Destroy;
var I : TButtonStyle;
    J : TButtonState;
BEGIN
  for i:=Low(TButtonStyle) to High(TButtonStyle) do { uvolnme Resources }
   for j:=Low(TButtonState) to High(TButtonState) do
   begin
     DeleteObject(FPicture[j,i].Handle);
     FPicture[j,i].Free;
   end;
  inherited Destroy;
END;





(* -------------------------------------------------------------------------- *)

procedure TDaveButton1.Click;
var
  Form: TCustomForm;
begin
  Form := GetParentForm(Self);
  if Form <> nil then Form.ModalResult := ModalResult;
  inherited Click;
end;



(* -------------------------------------------------------------------------- *)


procedure TDaveButton1.SetDefault(Value: Boolean);
begin
  FDefault := Value;
  if HandleAllocated then
    with GetParentForm(Self) do
      Perform(CM_FOCUSCHANGED, 0, Longint(ActiveControl));
end;



(* -------------------------------------------------------------------------- *)

procedure TDaveButton1.CNCommand(var Message: TWMCommand);
begin
  if Message.NotifyCode = BN_CLICKED then Click;
end;



(* -------------------------------------------------------------------------- *)

procedure TDaveButton1.CMDialogKey(var Message: TCMDialogKey);
begin
  with Message do
    if  (((CharCode = VK_RETURN) and (FLastFocus or FDefault)) or
      ((CharCode = VK_ESCAPE) and FCancel)) and
      (KeyDataToShiftState(Message.KeyData) = []) and CanFocus then
    begin
      Click;
      Result := 1;
    end else inherited;
end;



(* -------------------------------------------------------------------------- *)

procedure TDaveButton1.CMDialogChar(var Message: TCMDialogChar);
begin
  with Message do
    if IsAccel(CharCode, Caption) and CanFocus then
    begin
      Click;
      Result := 1;
    end else inherited;
end;



(* -------------------------------------------------------------------------- *)

procedure TDaveButton1.CMFocusChanged(var Message: TCMFocusChanged);
begin
  If Focused<>FLastFocus then begin FLastFocus:=not FLastFocus; Invalidate; end;
  inherited;
end;




(* -------------------------------------------------------------------------- *)

Procedure TDaveButton1.SetButtonStyle(Value : TButtonStyle); { zmna stylu }
begin
  If Value<>FStyle then  begin FStyle:=Value; Invalidate; end;
end;



(* -------------------------------------------------------------------------- *)

Procedure TDaveButton1.SetButtonState(Value : TButtonState); { zmna stavu }
begin
  FTemp:=false;
  If (Value<>FStatus) then  begin FStatus:=Value; Invalidate; end;
end;


(* -------------------------------------------------------------------------- *)

procedure TDaveButton1.Paint;
var I : integer;
    S : String;
    Rect : TRect;
BEGIN
  Height:=constHeight; { nemnn vka }
  with Canvas do
  begin
    I:=Width-36;   { ka prostedn sti }
    { Bltneme levou st }
    BitBlt(Handle,0,0,16,41, FPicture[FStatus,FStyle].Canvas.Handle,0,0, SRCCopy);
    if I>0 then StretchBlt(Handle, 16,0,I,41,   { podle poteby prothneme prostedn }
               FPicture[FStatus,FStyle].Canvas.Handle, 16,0,2,41, SRCCopy) else I:=0;
    { a nakonec bltneme pravou st tlatka se stnem }
    BitBlt(Handle,I+16,0,20,41, FPicture[FStatus,FStyle].Canvas.Handle,18,0, SRCCopy);

    Font:=Self.Font; { napeme Caption }
    If not Enabled then Font.Color:=clSilver;

    S:=Caption;
    if FStatus=bsOff then
       begin
         If FLastFocus then begin MoveTo(Width-16,4); LineTo(7,4); LineTo(7,Height-16); end;
         with Rect do begin Left:=0; Top:=0; Right:=Width-8; Bottom:=Height-11; end;
         DrawText(Handle, pchar(@S[1]), Length(S), Rect, DT_CENTER or DT_VCENTER or DT_SINGLELINE);
       end else
       begin
         If FLastFocus then begin MoveTo(Width-11,9); LineTo(12,9); LineTo(12,Height-11); end;
         with Rect do begin Left:=5; Top:=5; Right:=Width-3; Bottom:=Height-6; end;
         DrawText(Handle, pchar(@S[1]), Length(S), Rect, DT_CENTER or DT_VCENTER or DT_SINGLELINE);
       end;
  END;
END;




(* -------------------------------------------------------------------------- *)

Procedure TDaveButton1.CMTextChanged(var Message : TMessage);
begin
  InValidate;  { mn se text Caption }
end;



(* -------------------------------------------------------------------------- *)

procedure TDaveButton1.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
BEGIN
  inherited MouseDown(Button,Shift,X,Y);

  If Button=mbLeft then { stlaen tlatka }
     begin Status:=bsOn; FTemp:=true; end;
  If not Focused then SetFocus;
END;


(* -------------------------------------------------------------------------- *)

procedure TDaveButton1.MouseMove(Shift: TShiftState; X, Y: Integer);
BEGIN
  inherited MouseMove(Shift,X,Y);
  if not (ssLeft in Shift) then exit; { my se pohla }

  if FTemp then  { pokud je u tlatko stlaen jen podmnn (mykou) }
     if (X<0) or (X>Width) or (Y<0) or (Y>Height) then  { otestujeme, zda my nevyjela mimo }
       begin
         If FStatus<>bsOff then begin FStatus:=bsOff; invalidate end { pokud ano, nastavme bsOff }
       end else
       If FStatus<>bsOn then begin FStatus:=bsOn; invalidate end { jinak nastavme bsOn }
END;


(* -------------------------------------------------------------------------- *)

procedure TDaveButton1.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  inherited MouseUp(Button,Shift,X,Y);

  If Button=mbLeft then { putn tlatka }
     If FTemp then
       begin
         Status:=bsOff;
         if (X>=0) and (X<=Width) and (Y>=0) and (Y<=Height) then Click;
       end;
END;



(* -------------------------------------------------------------------------- *)

end. {End of File}
