unit U_termin;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, Kalender, ComCtrls, ExtCtrls, StdCtrls, ToolWin, Buttons;

type
  TForm1 = class(TForm)
    PanelOptions: TPanel;
    Splitter1: TSplitter;
    RGDisplay: TRadioGroup;
    Kalender1: TKalender;
    UpDownFont: TUpDown;
    EditFont: TEdit;
    DTPickerDate: TDateTimePicker;
    Panel1: TPanel;
    SBExit: TSpeedButton;
    ColorDialog1: TColorDialog;
    ButtonFreeColor: TButton;
    RGSpecialdays: TRadioGroup;
    procedure DTPickerDateChange (Sender: TObject);
    procedure FormCreate (Sender: TObject);
    procedure RGDisplayClick (Sender: TObject);
    procedure UpDownFontClick (Sender: TObject; Button: TUDBtnType);
    procedure Kalender1DblClick (Sender: TObject);
    procedure Kalender1Click (Sender: TObject);
    procedure Kalender1KeyPress (Sender: TObject; var Key: Char);
    procedure SBExitClick(Sender: TObject);
    procedure ButtonFreeColorClick(Sender: TObject);
    procedure Kalender1BeforeDateprinted(Sender: TObject;
      CompDate: TDateTime; var Bem: String);
    procedure Kalender1BeforeCellcolored(Sender: TObject; ARow,
      ACol: Integer; AState: TGridDrawState; ABrush: TBrush; AFont: TFont);
    procedure RGSpecialdaysClick(Sender: TObject);
    procedure Kalender1BeforeTimeprinted(Sender: TObject;
      CompTime: TDateTime; var Bem: String);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.DTPickerDateChange(Sender: TObject);
begin
  Kalender1.Date:=DTPickerDate.Date;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Kalender1.Date:=Sysutils.Date; DTPickerDate.Date:=Sysutils.Date;
  RGDisplay.ItemIndex:=2; Kalender1.Kind:=ktMonth;
end;

procedure TForm1.RGDisplayClick(Sender: TObject);
begin
  CASE RGDisplay.ItemIndex OF
    0 : Kalender1.Kind:=ktDay;   1 : Kalender1.Kind:=ktWeek;
    2 : Kalender1.Kind:=ktMonth; 3 : Kalender1.Kind:=ktYear;
  END;
end;


procedure TForm1.UpDownFontClick(Sender: TObject; Button: TUDBtnType);
begin
  Kalender1.Font.Size:=UpDownFont.Position;
end;

procedure TForm1.Kalender1DblClick(Sender: TObject);
begin
  DTPickerDate.Date:=Kalender1.Date;
  WITH Kalender1 DO CASE Kind OF
    ktYear  : RGDisplay.ItemIndex:=2;
    ktMonth : RGDisplay.ItemIndex:=1;
    ktWeek  : RGDisplay.ItemIndex:=0;
  END;
end;

procedure TForm1.Kalender1Click(Sender: TObject);
begin
  DTPickerDate.Date:=Kalender1.Date;
end;

procedure TForm1.Kalender1KeyPress(Sender: TObject; var Key: Char);
begin
  IF Key=#13 THEN Kalender1DblClick (Sender);
end;

procedure TForm1.SBExitClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.ButtonFreeColorClick(Sender: TObject);
begin
  ColorDialog1.Color:=Kalender1.FreeColor;
  if ColorDialog1.Execute then Kalender1.FreeColor:=ColorDialog1.Color;
end;

procedure TForm1.Kalender1BeforeDateprinted(Sender: TObject; CompDate: TDateTime; var Bem: String);
begin
  IF CompDate=EncodeDate (1998,1,1)  THEN Bem:='Test  1.1.98';
  IF CompDate=EncodeDate (1998,1,4)  THEN Bem:='Test  4.1.98'+#13+'Test  4.1.98';
  IF CompDate=EncodeDate (1998,1,10) THEN Bem:='Test 10.1.98';
  IF CompDate=EncodeDate (1998,1,31) THEN Bem:='Test 31.1.98';
  IF CompDate=EncodeDate (1998,2,15) THEN Bem:='Test 15.2.98';
end;

procedure TForm1.Kalender1BeforeTimeprinted(Sender: TObject; CompTime: TDateTime; var Bem: String);

   function Testtime (j,m,t,h,mi : WORD; CT : TDateTime) : BOOLEAN;
   var R,D : TDateTime;

   begin
      D:=EncodeDate (j,m,t)+EncodeTime (h,mi,0,0);
      R:=EncodeTime (2,0,0,0);
      IF (CT<D) AND (CT+R>D) THEN Result:=TRUE ELSE Result:=FALSE;
   end;

begin
  IF Testtime (1998,1,7,12,30,CompTime) THEN Bem:='Alarm';
end;

procedure TForm1.Kalender1BeforeCellcolored(Sender: TObject; ARow, ACol: Integer; AState: TGridDrawState; ABrush: TBrush; AFont: TFont);
var S : STRING;

begin
  if (sender is TKalender) then begin
    try
       S:=(Sender as TStringGrid).Cells[ACol, ARow];
    except
       S:='';
    end;
    if (ARow>0) AND (ACol>0) AND (S='') AND ((Kalender1.Kind=ktMonth) OR (Kalender1.Kind=ktYear))
    then ABrush.Color:=clSilver;
  end;
end;

procedure TForm1.RGSpecialdaysClick(Sender: TObject);
begin
  CASE RGSpecialdays.ItemIndex OF
     0 : Kalender1.SpecialDay:=sdaAll;
     1 : Kalender1.SpecialDay:=sdaGermany;
     2 : Kalender1.SpecialDay:=sdaAustria;
     3 : Kalender1.SpecialDay:=sdaSwitzerland;
     4 : Kalender1.SpecialDay:=sdaNone;
     ELSE Kalender1.SpecialDay:=sdaNone;
  END;
  Kalender1.UpdateCalendar (umShow);
end;

end.
