(*
////////////////////////////////////////////////////////////////////////////////
// DATASORC.PAS : DATASORCERER GLOBAL DATASOURCE COMPONENT                    //
// Copyright  1996-1999 Steve Flynn. All Rights Reserved                     //
//----------------------------------------------------------------------------//
// By using this source code you agree to be bound by the terms of the        //
// following Software License Agreement. Any breach of this agreement will be //
// prosecuted to the full extent of the law.                                  //
////////////////////////////////////////////////////////////////////////////////

LICENSE AGREEMENT - MARCH 1999

USE OF THE SOFTWARE

Steven M. Flynn (the "Author") grants you, the end user, a non-exclusive
single-user license to use the supplied software program and all associated
materials including the Source Code (the "Software"). The Software and all
Intellectual Property embodied in the Software always remains the property of
the Author. Your use of the Software indicates your acceptance in full of the
terms and conditions of this agreement.


COPYING THE SOFTWARE

You may freely copy the Software provided that such copies do not infringe upon
any other part of this agreement.


DISTRIBUTION OF THE SOFTWARE

The Software may be re-distributed royalty free providing that it is not
modified in any way and that no charge is made for the Software itself. Only a
nominal fee for media and/or copying services is allowed. All files, including
the License Agreement, that are supplied by the Author with the Software must
also be included in any such distribution.


DERIVED WORKS

You may NOT use the Software to derive any works which are based substantially
in part or in full on the Software or any portion of the Software. Any such
derived works will remain the property of the Author.


MODIFIED VERSIONS OF THE SOFTWARE

All updated, revised, modified or improved versions of the Software are also
subject to the conditions of this license agreement and shall remain the
property of the Author. You are required under the terms of this agreement to
submit to the Author any and all improvements or additions made by you to the 
Software for future inclusion in the general distribution of the Software by
the Author.


TERMINATION OF THIS AGREEMENT

You may terminate this License Agreement at any time by destroying all copies
of the Software in your possession.


LIMITED WARRANTY

The Software is distributed and licensed "AS IS". The Author specifically
disclaims all other warranties, express or implied, including but not limited
to, implied warranties of merchantability and fitness for a particular purpose,
with regard to the Software.


DAMAGES

By using the Software you do so at your own risk. In no event shall the Author
be responsible for any damages whatsoever (including but not limited to,
damages for loss of business profits, business interruption, loss of business
information, or any other pecuniary loss or any other real or consequential 
damages) arising out of the use or inability to use this product.


LIABILITY

In the event of failure of the Software, for any reason, the Author's sole
liability shall be to refund to you the amount paid by you to the Author for
the use of the Software.


COPYRIGHT

The Software and the Intellectual Property embodied in the Software shall
always remain the property of the Author and is protected by Australian
Copyright Law and International Treaty Provisions.


AGREEMENT

Your use of the Software indicates your agreement with the above terms and
conditions. If you do not agree with these terms and conditions then you must
destroy all copies of the software in your possession.


CONSUMER RIGHTS

If any clause in the above Software License Agreement is in violation of your
rights under your local laws then you must cease using the Software
immediately. It is your own responsibility to be aware of your legal rights
under your own local laws.


END OF SOFTWARE LICENSE AGREEMENT

*)

{$A-,B-,D-,F-,G+,I-,L-,M-,N+,O+,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y-,Z-}
{$IFDEF WIN32}
{$H+,J+}
{$M 16384,1048576}
{$IMAGEBASE $00400000}
{$R DATASORC.R32}
{$ELSE}
{$K-}
{$M 16384,8192}
{$R DATASORC.R16}
{$ENDIF}
{$C PRELOAD}

{$I DATASORC.INC}

unit DataSorc;


interface

uses
{$IFDEF INFPWR}
	wwTable, wwDatSrc, wwQuery, wwQBE, wwLocate, wwTypes,
{$ENDIF}
	SysUtils, WinTypes, Messages, Classes, DBiErrs, DBiTypes, DB, DBTables,
	Forms;

{// Constants /////////////////////////////////////////////////////////////////}
const
{$IFDEF INFPWR}
	SorcErrwwTable = 'wwTable';
	SorcErrwwQuery = 'wwQuery';
	SorcErrwwQBE = 'wwQBE';
	SorcErrwwQryQBE = 'wwQuery or wwQBE';
	SorcErrwwQryProc = 'Query, wwQuery or StoredProc';
	SorcErrInfPwr = 'Valid InfoPower';
{$ENDIF}
	SorcErrTable = 'Table';
	SorcErrQuery = 'Query';
	SorcErrProc = 'StoredProc';
	SorcErrQryProc = 'Query or StoredProc';
	SorcErrNone = 'Valid';


{// Class Definitions /////////////////////////////////////////////////////////}
type
	StackTrick = record
		case integer of
			0: (Ptr: pointer);
			1: (Prc: TExceptionEvent);
			end;
	EStackException = class(Exception);
	TStack = class(TList);

	TDataSorcerer = class;
	TTrapProc = procedure(DataSorcerer: TDataSorcerer; ErrCode: integer) of object;
	TAbility = (Sorcerer, Apprentice);
	TSorcDBDataSet = class(TDBDataSet);
	TDataSetType = (dtNone, dtTable, dtQuery, dtStoredProc, dtwwTable, dtwwQuery, dtwwQBE);

{$IFDEF INFPWR}
	TDataSorcerer = class(TwwDataSource)
{$ELSE}
	TDataSorcerer = class(TDataSource)
{$ENDIF}
	private
		FSorcerer: TDataSorcerer;
		FSorcererForm: string;
		FAbility: TAbility;
		FSetType: TDataSetType;
		FOwnerName: string;
		FFormList: TStrings;
		FTrapList: TStrings;
		FEMessage: string;
		FEToken: string;
		FETableName: string;
		FEFieldName: string;
		FEImageRow: string;
		FEUserName: string;
		FEFileName: string;
		FEIndexName: string;
		FEDirName: string;
		FEKeyName: string;
		FEAlias: string;
		FEDriveName: string;
		FENativeCode: string;
		FENativeMsg: string;
		FELineNumber: string;
		FECapability: string;
		FEFieldDisplayName: string;
		FEFieldNo: integer;
		FEField: TField;
		FEFieldMinValue: string;
		FEFieldMaxValue: string;
		FEFieldDefValue: string;
		FEFieldRequired: boolean;
{$IFDEF WIN32}
		FECDRName: string;
		FEUserErrMsg: string;
		FEInternalLimit: string;
{$ENDIF}
		FHandlingException: boolean;
		FOnLinked: TNotifyEvent;
		FOnUnLinked: TNotifyEvent;
		FOldAppException: TExceptionEvent;
		FAfterCancel: TDataSetNotifyEvent;
		FAfterClose: TDataSetNotifyEvent;
		FAfterDelete: TDataSetNotifyEvent;
		FAfterEdit: TDataSetNotifyEvent;
		FAfterInsert: TDataSetNotifyEvent;
		FAfterOpen: TDataSetNotifyEvent;
		FAfterPost: TDataSetNotifyEvent;
		FBeforeCancel: TDataSetNotifyEvent;
		FBeforeClose: TDataSetNotifyEvent;
		FBeforeDelete: TDataSetNotifyEvent;
		FBeforeEdit: TDataSetNotifyEvent;
		FBeforeInsert: TDataSetNotifyEvent;
		FBeforeOpen: TDataSetNotifyEvent;
		FBeforePost: TDataSetNotifyEvent;
		FOnCalcFields: TDataSetNotifyEvent;
		FOnNewRecord: TDataSetNotifyEvent;
{$IFDEF INFPWR}
		FOnFilter: TwwTableFilterEvent;
		FOnFilterEscape: TDataSetNotifyEvent;
		FOnInvalidValue: TwwInvalidValueEvent;
{$ENDIF}
{$IFDEF WIN32}
		FOnFilterRecord: TFilterRecordEvent;
		FOnServerYield: TOnServerYieldEvent;
		FOnUpdateError: TUpdateErrorEvent;
		FOnEditError: TDataSetErrorEvent;
		FOnPostError: TDataSetErrorEvent;
		FOnDeleteError: TDataSetErrorEvent;
{$ENDIF}
		procedure DoAfterCancel(Value: TDataSet);
		procedure DoAfterClose(Value: TDataSet);
		procedure DoAfterDelete(Value: TDataSet);
		procedure DoAfterEdit(Value: TDataSet);
		procedure DoAfterInsert(Value: TDataSet);
		procedure DoAfterOpen(Value: TDataSet);
		procedure DoAfterPost(Value: TDataSet);
		procedure DoBeforeCancel(Value: TDataSet);
		procedure DoBeforeClose(Value: TDataSet);
		procedure DoBeforeDelete(Value: TDataSet);
		procedure DoBeforeEdit(Value: TDataSet);
		procedure DoBeforeInsert(Value: TDataSet);
		procedure DoBeforeOpen(Value: TDataSet);
		procedure DoBeforePost(Value: TDataSet);
		procedure DoOnCalcFields(Value: TDataSet);
		procedure DoOnNewRecord(Value: TDataSet);
{$IFDEF WIN32}
		procedure DoOnFilterRecord(DS: TDataSet; var Accept: boolean);
		procedure DoOnServerYield(DS: TDataSet; var AbortQuery: boolean);
		procedure DoOnUpdateError(DS: TDataSet; E: EDatabaseError; UpdateKind: TUpdateKind;
									var UpdateAction: TUpdateAction);
		procedure DoOnEditError(DS: TDataSet; E: EDatabaseError; var Action: TDataAction);
		procedure DoOnPostError(DS: TDataSet; E: EDatabaseError; var Action: TDataAction);
		procedure DoOnDeleteError(DS: TDataSet; E: EDatabaseError; var Action: TDataAction);
{$ENDIF}
		procedure SetSorcererForm(Value: string);
		procedure SetAbility;
		procedure SetDataSetType;
		procedure SetFormList(const Value: TStrings);
		procedure SetDataSet(Value: TDataSet);
		procedure DummyAbility(Value: TAbility);
		procedure DummyDataSetType(Value: TDataSetType);
		procedure AddApprenticeTraps(Appren: TDataSorcerer);
		procedure DeleteApprenticeTraps(Appren: TDataSorcerer);
		procedure DeleteApprentice(Appren: TDataSorcerer);
		procedure FindApprentices;
		procedure UnLinkApprentice(Appren: TDataSorcerer);
		procedure SorcException(Sender: TObject; E: Exception);
		procedure ClearApprentices;
		procedure SorcererLink;
		function ValidDataSet: boolean;
		function IsSorcerer: boolean;
		function GetApprentice(const Index: integer): TDataSorcerer;
		function GetApprenticeCount: integer;
		function GetDataSet: TDataSet;
		function GetFld(const Name: string): string;
		procedure SetFld(const Name, Value: string);
		function GetIntegerFld(const Name: string): longint;
		procedure SetIntegerFld(const Name: string; Value: longint);
		function GetFloatFld(const Name: string): double;
		procedure SetFloatFld(const Name: string; Value: double);
		function GetBooleanFld(const Name: string): boolean;
		procedure SetBooleanFld(const Name: string; Value: boolean);
		function GetDateTimeFld(const Name: string): TDateTime;
		procedure SetDateTimeFld(const Name: string; Value: TDateTime);
		procedure AddTrapObject(ErrCode: integer; ErrProc: TTrapProc; Sorc: TDataSorcerer);
		function GetEMessage: string;
		function GetEToken: string;
		function GetETableName: string;
		function GetEFieldName: string;
		function GetEImageRow: string;
		function GetEUserName: string;
		function GetEFileName: string;
		function GetEIndexName: string;
		function GetEDirName: string;
		function GetEKeyName: string;
		function GetEAlias: string;
		function GetEDriveName: string;
		function GetENativeCode: string;
		function GetENativeMsg: string;
		function GetELineNumber: string;
		function GetECapability: string;
		function GetEFieldDisplayName: string;
		function GetEFieldNo: integer;
		function GetEField: TField;
		function GetEFieldMinValue: string;
		function GetEFieldMaxValue: string;
		function GetEFieldDefValue: string;
		function GetEFieldRequired: boolean;
{$IFDEF WIN32}
		function GetECDRName: string;
		function GetEUserErrMsg: string;
		function GetEInternalLimit: string;
{$ENDIF}
		procedure GetEFieldValChks;
		procedure GetEFieldDetails;
		function GetEValChkDesc(var ValChk: VCHKDesc): boolean;
		function StringFromPFV(Ptr: pointer): string;
		procedure PushTrap;
		procedure PopTrap;
{$IFDEF WIN32}
		function GetCurrencyFld(const Name: string): Currency;
		procedure SetCurrencyFld(const Name: string; Value: Currency);
		function GetVariantFld(const Name: string): Variant;
		procedure SetVariantFld(const Name: string; Value: Variant);
		procedure SetDetailFields(MasterFields: TList);
{$ENDIF}

{$IFDEF INFPWR}
		procedure SetLookupFields(Value: TStrings);
		procedure SetLookupLinks(Value: TStrings);
		procedure SetControltype(Value: TStrings);
		procedure SetFilt(Value: TStrings);
		procedure SetSyncSQLByRange(Value: boolean);
		procedure SetNarrowSearch(Value: boolean);
		procedure SetOnFilter(Value: TwwTableFilterEvent);
		procedure SetAnswerTable(Value: string);
		procedure SetQBE(Value: TStrings);
		procedure SetAuxiliaryTables(Value: boolean);
		procedure SetBlankAsZero(Value: boolean);
		function GetFilterCount: longint;
		function GetLookupFields: TStrings;
		function GetLookupLinks: TStrings;
		function GetControlType: TStrings;
		function GetFilt: TStrings;
		function GetSyncSQLByRange: boolean;
		function GetNarrowSearch: boolean;
{$IFDEF IP3}
		function GetNarrowSearchUpperChar: word;
		procedure SetNarrowSearchUpperChar(value: word);
		procedure SetOnFilterEscape(value: TDataSetNotifyEvent);
		function GetOnFilterOptions: TwwOnFilterOptions;
		procedure SetOnFilterOptions(value: TwwOnFilterOptions);
		procedure DoOnFilter(table: TwwTable; var accept: Boolean);
		procedure DoOnFilterEscape(DS: TDataSet);
{$ELSE}
		function DoOnFilter(table: TwwTable): boolean;
{$ENDIF}
		procedure DoOnInvalidValue(DataSet: TDataSet; Field: TField);
		function GetAnswerTable: string;
		function GetQBE: TStrings;
		function GetAuxiliaryTables: boolean;
		function GetBlankAsZero: boolean;
{$IFNDEF IP3}
		function GetInSetToIndexMethod: boolean;
{$ENDIF}
		function GetlookupTables: TList;
		function GetIndexFieldName: string;
		procedure SetIndexFieldName(IndexFieldName: string);
		function GetPictureMasks: TStrings;
		procedure SetPictureMasks(PictureMask: TStrings);
		function GetQuery: TStrings;
		procedure SetQuery(Qry: TStrings);
		function GetValidateWithMask: boolean;
		procedure SetValidateWithMask(Flag: boolean);
		procedure SetOnInvalidValue(Value: TwwInvalidValueEvent);
{$ENDIF}
		procedure SetField(Index: integer; Value: TField);
		procedure SetFieldDefs(Value: TFieldDefs);
		procedure SetActive(Value: boolean);
		procedure SetAutoCalcFields(Value: boolean);
		function GetBOF: boolean;
		function GetCanModify: boolean;
		function GetEOF: boolean;
		function GetFieldCount: integer;
		function GetFieldDefs: TFieldDefs;
		function GetField(Index: integer): TField;
		function GetHandle: HDBICur;
		function GetModified: boolean;
		function GetRecordCount: longint;
		function GetState: TDataSetState;
		function GetLocale: TLocale;
		function GetActive: boolean;
		function GetAutoCalcFields: boolean;
		procedure SetUpdateMode(Value: TUpdateMode);
		function GetUpdateMode: TUpdateMode;
		procedure SetIndexField(Index: integer; Field: TField);
		procedure SetKeyExclusive(Exclusive: boolean);
		procedure SetKeyFieldCount(Count: integer);
		procedure SetExclusive(Value: boolean);
		procedure SetIndexFieldNames(Value: string);
		procedure SetIndexName(Value: string);
		procedure SetMasterFields(Value: string);
		procedure SetMasterSource(Value: TDataSource);
		procedure SetReadOnly(Value: boolean);
		procedure SetTableName(Value: TFileName);
		procedure SetTableType(Value: TTableType);
		function GetIndexDefs: TIndexDefs;
		function GetIndexFieldCount: Integer;
		function GetIndexField(Index: integer): TField;
		function GetKeyExclusive: boolean;
		function GetKeyFieldCount: integer;
		function GetExclusive: boolean;
		function GetIndexFieldNames: string;
		function GetIndexName: string;
		function GetMasterFields: string;
		function GetMasterSource: TDataSource;
		function GetReadOnly: boolean;
		function GetTableName: TFileName;
		function GetTableType: TTableType;
		procedure SetSQL(Value: TStrings);
		procedure SetSQLBinary(Value: PChar);
		procedure SetUniDirectional(Value: boolean);
		procedure SetRequestLive(Value: boolean);
		function GetSQL: TStrings;
		function GetLocal: boolean;
{$IFDEF WIN32}
		function GetSQLText: string;
{$ELSE}
		function GetSQLText: PChar;
{$ENDIF}
		function GetSQLBinary: PChar;
		function GetUniDirectional: boolean;
		function GetRequestLive: boolean;
		procedure SetProcName(Value: string);
		procedure SetOverload(Value: word);
		procedure SetParamsList(Value: TParams);
		procedure SetBindMode(Value: TParamBindMode);
		procedure SetPrepared(Value: boolean);
		function GetParamsCount: word;
		function GetStmtHandle: HDBIStmt;
		function GetPrepared: boolean;
		function GetProcName: string;
		function GetOverload: word;
		function GetParamsList: TParams;
		function GetBindMode: TParamBindMode;
{$IFDEF WIN32}
		function GetBookmarkStr: TBookmarkStr;
		procedure SetBookmarkStr(Value: TBookmarkStr);
		function GetDataSource: TDataSource;
		procedure SetDataSource(Value: TDataSource);
		function GetDefaultFields: boolean;
		function GetDesigner: TDataSetDesigner;
		function GetExpIndex: boolean;
		function GetFieldValues(const Name: string): variant;
		procedure SetFieldValues(const Name: string; Value: variant);
		function GetFound: boolean;
		function GetKeySize: word;
		function GetRecNo: longint;
		function GetRecordSize: word;
		function GetUpdateObject: TDataSetUpdateObject;
		procedure SetUpdateObject(Value: TDataSetUpdateObject);
		function GetUpdateRecordTypes: TUpdateRecordTypes;
		procedure SetUpdateRecordTypes(Value: TUpdateRecordTypes);
		function GetUpdatesPending: boolean;
		function GetDBSession: TSession;
		function GetRowsAffected: integer;
		function GetCachedUpdates: boolean;
		procedure SetCachedUpdates(Value: boolean);
		function GetFilter: string;
		procedure SetFltr(Value: string);
		function GetFiltered: boolean;
		procedure SetFiltered(Value: boolean);
		function GetFilterOptions: TFilterOptions;
		procedure SetFilterOptions(Value: TFilterOptions);
		function GetSessionName: string;
		procedure SetSessionName(Value: string);
		function GetConstrained: boolean;
		procedure SetConstrained(Value: boolean);
		function GetParamCheck: boolean;
		procedure SetParamCheck(Value: boolean);
{$ENDIF}

	protected
		function FDBDataSet: TDBDataSet;
		function FDataSet: TDataSet;
		function FTable: TTable;
		function FQuery: TQuery;
		function FProc: TStoredProc;
{$IFDEF INFPWR}
		function FwwTable: TwwTable;
		function FwwQuery: TwwQuery;
		function FwwQBE: TwwQBE;
{$ENDIF}
		procedure Loaded; override;
		procedure SetName(const Value: TComponentName); override;
		property FApprentice[const Index: integer]: TDataSorcerer read GetApprentice;
		property FApprentices: integer read GetApprenticeCount;

	public
		{// TDataSorcerer /////////////////////////////////////////////////////}
		class function GetCopyright: string;
		constructor Create(AOwner: TComponent); override;
		destructor Destroy; override;
		procedure AddTrap(ErrCode: integer; ErrProc: TTrapProc);
		procedure RemoveTrap(ErrCode: integer);
		property Field[const Name: string]: string read GetFld write SetFld;
		property StringField[const Name: string]: string read GetFld write SetFld;
		property IntegerField[const Name: string]: longint read GetIntegerFld write SetIntegerFld;
		property FloatField[const Name: string]: double read GetFloatFld write SetFloatFld;
		property BooleanField[const Name: string]: boolean read GetBooleanFld write SetBooleanFld;
		property DateTimeField[const Name: string]: TDateTime read GetDateTimeFld write SetDateTimeFld;
		property EMessage: string read GetEMessage;
		property EToken: string read GetEToken;
		property ETableName: string read GetETableName;
		property EFieldName: string read GetEFieldName;
		property EImageRow: string read GetEImageRow;
		property EUserName: string read GetEUserName;
		property EFileName: string read GetEFileName;
		property EIndexName: string read GetEIndexName;
		property EDirName: string read GetEDirName;
		property EKeyName: string read GetEKeyName;
		property EAlias: string read GetEAlias;
		property EDriveName: string read GetEDriveName;
		property ENativeCode: string read GetENativeCode;
		property ENativeMsg: string read GetENativeMsg;
		property ELineNumber: string read GetELineNumber;
		property ECapability: string read GetECapability;
		property EFieldDisplayName: string read GetEFieldDisplayName;
		property EFieldNo: integer read GetEFieldNo;
		property EField: TField read GetEField;
		property EFieldMinValue: string read GetEFieldMinValue;
		property EFieldMaxValue: string read GetEFieldMaxValue;
		property EFieldDefValue: string read GetEFieldDefValue;
		property EFieldRequired: boolean read GetEFieldRequired;
{$IFDEF WIN32}
		property ECDRName: string read GetECDRName;
		property EUserErrMsg: string read GetEUserErrMsg;
		property EInternalLimit: string read GetEInternalLimit;
		property CurrencyField[const Name: string]: Currency read GetCurrencyFld write SetCurrencyFld;
		property VariantField[const Name: string]: Variant read GetVariantFld write SetVariantFld;
{$ENDIF}

		{// TDataSet Emulation ////////////////////////////////////////////////}
		procedure Append;
		procedure AppendRecord(const Values: array of const);
		procedure Cancel;
		procedure CheckBrowseMode;
		procedure ClearFields;
		procedure Close;
		procedure CursorPosChanged;
		procedure Delete;
		procedure DisableControls;
		procedure Edit;
		procedure EnableControls;
		procedure First;
		procedure FreeBookmark(Bookmark: TBookmark);
		procedure GetFieldNames(List: TStrings);
		procedure GotoBookmark(Bookmark: TBookmark);
		procedure Insert;
		procedure InsertRecord(const Values: array of const);
		procedure Last;
		procedure MoveBy(Distance: Integer);
		procedure Next;
		procedure Open;
		procedure Post;
		procedure Prior;
		procedure Refresh;
		procedure SetFields(const Values: array of const);
		procedure UpdateCursorPos;
		procedure UpdateRecord;
		function FieldByName(const FieldName: string): TField;
		function FindField(const FieldName: string): TField;
		function GetBookmark: TBookmark;
		function GetCurrentRecord(Buffer: PChar): Boolean;
		property BOF: Boolean read GetBOF;
		property CanModify: Boolean read GetCanModify;
		property EOF: Boolean read GetEOF;
		property FieldCount: Integer read GetFieldCount;
		property FieldDefs: TFieldDefs read GetFieldDefs write SetFieldDefs;
		property Fields[Index: Integer]: TField read GetField write SetField;
		property Handle: HDBICur read GetHandle;
		property Modified: Boolean read GetModified;
		property RecordCount: Longint read GetRecordCount;
		property State: TDataSetState read GetState;
		property Locale: TLocale read GetLocale;
{$IFDEF WIN32}
		function ActiveBuffer: pchar;
		function ControlsDisabled: boolean;
		procedure FetchAll;
		function FindFirst: boolean;
		function FindLast: boolean;
		function FindNext: boolean;
		function FindPrior: boolean;
		procedure GetFieldList(List: TList; const FieldNames: string);
		function IsLinkedTo(DataSource: TDataSource): boolean;
		function Locate(const KeyFields: string; const KeyValues: variant; Options: TLocateOptions): boolean;
		function Lookup(const KeyFields: string; const KeyValues: variant; const ResultFields: string): variant;
		procedure Resync(Mode: TResyncMode);
		procedure ApplyUpdates;
		procedure CommitUpdates;
		procedure CancelUpdates;
		procedure RevertRecord;
		function UpdateStatus: TUpdateStatus;
		property Bookmark: TBookmarkstr read GetBookmarkStr write SetBookmarkStr;
		property DefaultFields: boolean read GetDefaultFields;
		property Designer: TDataSetDesigner read GetDesigner;
		property ExpIndex: boolean read GetExpIndex;
		property FieldValues[const Name: string]: variant read GetFieldValues write SetFieldValues;
		property Found: boolean read GetFound;
		property KeySize: word read GetKeySize;
		property RecNo: longint read GetRecNo;
		property RecordSize: word read GetRecordSize;
		property UpdateRecordTypes: TUpdateRecordTypes read GetUpdateRecordTypes write SetUpdateRecordTypes;
		property UpdatesPending: boolean read GetUpdatesPending;
{$ENDIF}

		{// TDBDataSet Emulation //////////////////////////////////////////////}
		procedure SetDataBaseName(FileName: TFileName);
		function GetDatabase: TDataBase;
		function GetDBHandle: HDBIDB;
		function GetDBLocale: TLocale;
		function GetDatabaseName: TFileName;
		property Database: TDatabase read GetDatabase;
		property DBHandle: HDBIDB read GetDBHandle;
		property DBLocale: TLocale read GetDBLocale;
{$IFDEF WIN32}
		function CheckOpen(Status: DBIResult): boolean;
		property DBSession: TSession read GetDBSession;
{$ENDIF}

		{// TTable Emulation //////////////////////////////////////////////////}
		procedure AddIndex(const Name, Fields: string; Options: TIndexOptions);
		procedure ApplyRange;
		procedure CancelRange;
		procedure CreateTable;
		procedure DeleteIndex(const Name: string);
		procedure DeleteTable;
		procedure EditKey;
		procedure EditRangeEnd;
		procedure EditRangeStart;
		procedure EmptyTable;
		procedure FindNearest(const KeyValues: array of const);
		procedure GetIndexNames(List: TStrings);
		procedure GotoCurrent(Table: TTable);
		procedure GotoNearest;
		procedure LockTable(LockType: TLockType);
		procedure RenameTable(const NewTableName: string);
		procedure SetKey;
		procedure SetRange(const StartValues, EndValues: array of const);
		procedure SetRangeEnd;
		procedure SetRangeStart;
		procedure UnlockTable(LockType: TLockType);
		function BatchMove(ASource: TDataSet; AMode: TBatchMode): Longint;
		function FindKey(const KeyValues: array of const): Boolean;
		function GotoKey: Boolean;
		property IndexDefs: TIndexDefs read GetIndexDefs;
		property IndexFieldCount: Integer read GetIndexFieldCount;
		property IndexFields[Index: Integer]: TField read GetIndexField write SetIndexField;
		property KeyExclusive: Boolean read GetKeyExclusive write SetKeyExclusive;
		property KeyFieldCount: Integer read GetKeyFieldCount write SetKeyFieldCount;
{$IFDEF WIN32}
		procedure CloseIndexFile(const IndexName: string);
		procedure OpenIndexFile(const IndexName: string);
{$ENDIF}

		{// TQuery Emulation //////////////////////////////////////////////////}
		procedure ExecSQL;
		property Local: Boolean read GetLocal;
{$IFDEF WIN32}
		property Text: string read GetSQLText;
{$ELSE}
		property Text: pchar read GetSQLText;
{$ENDIF}
		property SQLBinary: PChar read GetSQLBinary write SetSQLBinary;
{$IFDEF WIN32}
		property RowsAffected: integer read GetRowsAffected;
{$ENDIF}

		{// TStoredProc Emulation /////////////////////////////////////////////}
		procedure CopyParams(Value: TParams);
		procedure ExecProc;
		procedure Prepare;
		procedure GetResults;
		procedure UnPrepare;
		function DescriptionsAvailable: Boolean;
		function ParamByName(const Value: string): TParam;
		property ParamCount: Word read GetParamsCount;
		property StmtHandle: HDBIStmt read GetStmtHandle;
		property Prepared: Boolean read GetPrepared write SetPrepared;

{$IFDEF INFPWR}
		{// TwwTable Emulation ////////////////////////////////////////////////}
		procedure RefreshLinks;
		procedure RemoveObsoleteLinks;
		procedure SyncSQLTable(lookupTable: TwwTable);
		procedure FreeLookupTables;
		procedure wwChangeIndex(a_indexItem: TIndexDef);
		procedure wwChangeIndexName(a_indexName: string);
		procedure addDependentTablePtr(a_value: PtrBoolean);
		procedure removeDependentTablePtr(a_value: PtrBoolean);
		procedure wwSetRangeStart(const startValues: Array of Const);
		function IsValidField(fieldName : string): boolean;
		function setToIndexContainingFields(selected: TStrings): boolean;
		function setToIndexContainingField(selected: string): boolean;
		function wwFindNearest(key: string; FieldNo: integer): boolean;
		function wwFindKey(const KeyValues: array of Const): Boolean;
		function Pack(var statusMsg: string): boolean;
		function setFilter(sel: string): boolean;
		function FilterString: string;
		function isParadoxTable: boolean;
		function isDBaseTable: boolean;
		function FilterActivate: boolean;
		function wwFilterField(AFieldName: string): TParam;
		property FilterCount: Longint read GetFilterCount;
		function wwFindRecord(KeyValue: string; LookupField: string; MatchType: TwwLocateMatchType; caseSensitive: boolean): boolean;
{$IFNDEF IP3}
		property inSetToIndexMethod: boolean read GetInSetToIndexMethod;
{$ENDIF}
		property lookupTables: TList read GetlookupTables;
		function isSequencable: boolean;
		function IndexToFields(aIndexName: string): string;
		function FieldsToIndex(aIndexFields: string): string;
		function GetDBPicture(curFieldName: string): string;
		procedure UpdateIndexes;
		property IndexFieldName: string read GetIndexFieldName write SetIndexFieldName;

		{// TwwQuery Emulation ////////////////////////////////////////////////}
		function SaveAnswerTable(tableName: string): boolean;

		{// TwwQBE Emulation //////////////////////////////////////////////////}
		procedure SetParam(paramName: string; paramValue: string);
		procedure ClearParams;
		function GetParam(paramName: string): string;

{$ENDIF}

	published
		{// TDataSorcerer /////////////////////////////////////////////////////}
		property Ability: TAbility read FAbility write DummyAbility stored False default Apprentice;
		property ApprenticeForms: TStrings read FFormList write SetFormList stored False;
		property DataSet: TDataSet read GetDataSet write SetDataSet stored IsSorcerer;
		property DataSetType: TDataSetType read FSetType write DummyDataSetType stored False;
		property SorcererForm: string read FSorcererForm write SetSorcererForm;
		property OnLinked: TNotifyEvent read FOnLinked write FOnLinked;
		property OnUnLinked: TNotifyEvent read FOnUnLinked write FOnUnLinked;

		{// TDataSet Emulation ////////////////////////////////////////////////}
		property Active: Boolean read GetActive write SetActive stored False;
		property AutoCalcFields: Boolean read GetAutoCalcFields write SetAutoCalcFields stored False;
{$IFDEF WIN32}
		property CachedUpdates: boolean read GetCachedUpdates write SetCachedUpdates stored False;
		property DataSource: TDataSource read GetDataSource write SetDataSource stored False;
		property Filter: string read GetFilter write SetFltr stored False;
		property Filtered: boolean read GetFiltered write SetFiltered stored False;
		property FilterOptions: TFilterOptions read GetFilterOptions write SetFilterOptions stored False;
		property UpdateObject: TDataSetUpdateObject read GetUpdateObject write SetUpdateObject stored False;
		property OnFilterRecord: TFilterRecordEvent read FOnFilterRecord write FOnFilterRecord;
		property OnServerYield: TOnServerYieldEvent read FOnServerYield write FOnServerYield;
		property OnUpdateError: TUpdateErrorEvent read FOnUpdateError write FOnUpdateError;
		property OnEditError: TDataSetErrorEvent read FOnEditError write FOnEditError;
		property OnPostError: TDataSetErrorEvent read FOnPostError write FOnPostError;
		property OnDeleteError: TDataSetErrorEvent read FOnDeleteError write FOnDeleteError;
{$ENDIF}

		{// TDBDataSet Emulation //////////////////////////////////////////////}
		property DatabaseName: TFileName read GetDatabaseName write SetDataBaseName stored False;
		property UpdateMode: TUpdateMode read GetUpdateMode write SetUpdateMode stored False;
{$IFDEF WIN32}
		property SessionName: string read GetSessionName write SetSessionName stored False;
{$ENDIF}

		{// TTable Emulation //////////////////////////////////////////////////}
		property Exclusive: Boolean read GetExclusive write SetExclusive stored False;
		property IndexFieldNames: string read GetIndexFieldNames write SetIndexFieldNames stored False;
		property IndexName: string read GetIndexName write SetIndexName stored False;
		property MasterFields: string read GetMasterFields write SetMasterFields stored False;
		property MasterSource: TDataSource read GetMasterSource write SetMasterSource stored False;
		property ReadOnly: Boolean read GetReadOnly write SetReadOnly stored False;
		property TableName: TFileName read GetTableName write SetTableName stored False;
		property TableType: TTableType read GetTableType write SetTableType stored False;

		{// TQuery Emulation //////////////////////////////////////////////////}
		property SQL: TStrings read GetSQL write SetSQL stored False;
		property UniDirectional: Boolean read GetUniDirectional write SetUniDirectional stored False;
		property RequestLive: Boolean read GetRequestLive write SetRequestLive stored False;
{$IFDEF WIN32}
		property Constrained: boolean read GetConstrained write SetConstrained stored False;
		property ParamCheck: boolean read GetParamCheck write SetParamCheck stored False;
{$ENDIF}

		{// TStoredProc Emulation /////////////////////////////////////////////}
		property StoredProcName: string read GetProcName write SetProcName stored False;
		property Overload: Word read GetOverload write SetOverload stored False;
		property Params: TParams read GetParamsList write SetParamsList stored False;
		property ParamBindMode: TParamBindMode read GetBindMode write SetBindMode stored False;

		{// TDataSet Events ///////////////////////////////////////////////////}
		property BeforeOpen: TDataSetNotifyEvent read FBeforeOpen write FBeforeOpen;
		property AfterOpen: TDataSetNotifyEvent read FAfterOpen write FAfterOpen;
		property BeforeClose: TDataSetNotifyEvent read FBeforeClose write FBeforeClose;
		property AfterClose: TDataSetNotifyEvent read FAfterClose write FAfterClose;
		property BeforeInsert: TDataSetNotifyEvent read FBeforeInsert write FBeforeInsert;
		property AfterInsert: TDataSetNotifyEvent read FAfterInsert write FAfterInsert;
		property BeforeEdit: TDataSetNotifyEvent read FBeforeEdit write FBeforeEdit;
		property AfterEdit: TDataSetNotifyEvent read FAfterEdit write FAfterEdit;
		property BeforePost: TDataSetNotifyEvent read FBeforePost write FBeforePost;
		property AfterPost: TDataSetNotifyEvent read FAfterPost write FAfterPost;
		property BeforeCancel: TDataSetNotifyEvent read FBeforeCancel write FBeforeCancel;
		property AfterCancel: TDataSetNotifyEvent read FAfterCancel write FAfterCancel;
		property BeforeDelete: TDataSetNotifyEvent read FBeforeDelete write FBeforeDelete;
		property AfterDelete: TDataSetNotifyEvent read FAfterDelete write FAfterDelete;
		property OnNewRecord: TDataSetNotifyEvent read FOnNewRecord write FOnNewRecord;
		property OnCalcFields: TDataSetNotifyEvent read FOnCalcFields write FOnCalcFields;

{$IFDEF INFPWR}
		{// TwwTable Emulation ////////////////////////////////////////////////}
		property LookupFields: TStrings read GetLookupFields write SetLookupFields stored False;
		property LookupLinks: TStrings read GetLookupLinks write SetLookupLinks stored False;
		property ControlType: TStrings read GetControlType write SetControltype stored False;
		property wwFilter: TStrings read GetFilt write SetFilt stored False;
		property SyncSQLByRange: boolean read GetSyncSQLByRange write SetSyncSQLByRange stored False;
		property NarrowSearch: boolean read GetNarrowSearch write SetNarrowSearch stored False;
		property OnFilter: TwwTableFilterEvent read FOnFilter write SetOnFilter stored False;
		property PictureMasks: TStrings read GetPictureMasks write SetPictureMasks stored False;
		property Query: TStrings read GetQuery write SetQuery stored False;
		property ValidateWithMask: boolean read GetValidateWithMask write SetValidateWithMask stored False;
		property OnInvalidValue: TwwInvalidValueEvent read FOnInvalidValue write SetOnInvalidValue stored False;
{$IFDEF IP3}
		property NarrowSearchUpperChar: word read GetNarrowSearchUpperChar write SetNarrowSearchUpperChar stored False;
		property OnFilterEscape: TDataSetNotifyEvent read FOnFilterEscape write SetOnFilterEscape stored False;
		property OnFilterOptions: TwwOnFilterOptions read GetOnFilterOptions write SetOnFilterOptions stored False;
{$ENDIF}

		{// TwwQBE Emulation //////////////////////////////////////////////////}
		property QBE: TStrings read GetQBE write SetQBE stored False;
		property AnswerTable: string read GetAnswerTable write SetAnswerTable stored False;
		property AuxiliaryTables: Boolean read GetAuxiliaryTables write SetAuxiliaryTables stored False;
		property BlankAsZero: Boolean read GetBlankAsZero write SetBlankAsZero stored False;
{$ENDIF}
	end;


var Stack: TStack;
procedure Register;
procedure SorcError(ErrStr: string);


implementation

uses
{$IFNDEF WIN32}
	DbiProcs,
{$ENDIF}
	Consts, WinProcs, Controls, StdCtrls, DBConsts, Dialogs;

{// Globals ///////////////////////////////////////////////////////////////////}
var
	Tricky: string;
	CopyrightNotice: string;
	SorcererList: TStrings;
	FEmptyStrings: TStrings;
	FEmptyParams: TParams;
	FEmptySource: TDataSource;

type
	TTrapInfo = class(TObject)
	protected
		Proc: TTrapProc;
		Sorc: TDataSorcerer;
		end;
	PFakeVariant = ^FakeVariant;
	FakeVariant = record
		case integer of
			0:	(Int: integer);
			1:	(Flt: double);
			2:	(PCh: pchar);
			3:	(Dtm: TDateTime);
			4:	(Wrd: word);
			5:	(Sml: smallint);
			6:	(Lng: longint);
		end;


{// Registration //////////////////////////////////////////////////////////////}
procedure Register;
	begin
	RegisterComponents('Data Access', [TDataSorcerer]);
	end;


{// Global Methods ////////////////////////////////////////////////////////////}
function Exists(Obj: TObject): boolean;
	begin
	Result := False;
	try
		if (Obj <> nil) and (Obj is TComponent) then
			Result := True;
	except
		end;
	end;


procedure SorcError(ErrStr: string);
	var
	s: string;
	begin
	FmtStr(s, 'Only available for a %s DataSet.', [ErrStr]);
	raise EDatabaseError.Create(s);
	end;


function OwnerName(Cmp: TComponent): string;
	begin
	if Exists(Cmp.Owner) then
		Result := Copy(Cmp.Owner.ClassName, 2, Length(Cmp.Owner.ClassName) - 1)
	else
		Result := '';
	end;


function GetDBErrString(Token: integer): string;
	var
	ps: array [0..DBIMAXMSGLEN] of char;
	begin
	try
		DbiGetErrorContext(Token, ps);
		Result := StrPas(ps);
	except
		Result := '';
		end;
	end;


{// TDataSorcerer /////////////////////////////////////////////////////////////}
constructor TDataSorcerer.Create(AOwner: TComponent);
	begin
	inherited Create(AOwner);
	FSetType := dtNone;
	FFormList := TStringList.Create;
	FTrapList := TStringList.Create;
	FSorcerer := nil;
	FAbility := Apprentice;
	FOwnerName := OwnerName(self);
	FHandlingException := False;
	FOldAppException := nil;
	SorcererLink;
	end;


destructor TDataSorcerer.Destroy;
	var
	i: integer;
	begin
	if Exists(FSorcerer) then
		FSorcerer.DeleteApprentice(self);
	i := SorcererList.IndexOfObject(self);
	if i <> -1 then
		SorcererList.Delete(i);
	SetDataSet(nil);
	for i := FTrapList.Count - 1 downto 0 do
		if (FTrapList.Objects[i] is TTrapInfo)
			and (TTrapInfo(FTrapList.Objects[i]).Sorc = self) then
			TTrapInfo(FTrapList.Objects[i]).Free;
	FFormList.Free;
	FTrapList.Free;
	inherited Destroy;
	end;


procedure TDataSorcerer.SorcererLink;
	var
	i: integer;
	Sorc: TDataSorcerer;
	begin
	if not ((csLoading in ComponentState) or (csDestroying in ComponentState)) then
		for i := 0 to SorcererList.Count - 1 do
			begin
			Sorc := TDataSorcerer(SorcererList.Objects[i]);
			if Exists(Sorc)
				and (Sorc.FAbility = Sorcerer)
				and (CompareText(Sorc.FOwnerName, FSorcererForm) = 0)
				and (CompareText(Sorc.Name, Name) = 0) then
				Sorc.SetFormList(nil);
			end;
	end;


procedure TDataSorcerer.Loaded;
	begin
	inherited Loaded;
	if SorcererList.IndexOfObject(self) = -1 then
		SorcererList.AddObject(FSorcererForm, self);
	SorcererLink;
	end;


procedure TDataSorcerer.AddTrapObject(ErrCode: integer; ErrProc: TTrapProc; Sorc: TDataSorcerer);
	var
	i: integer;
	SErrCode: string;
	TrapInfo: TTrapInfo;
	begin
	SErrCode := IntToStr(ErrCode);
	i := FTrapList.IndexOf(SErrCode);
	if i <> -1 then
		begin
		TrapInfo := TTrapInfo(FTrapList.Objects[i]);
		if (TrapInfo is TTrapInfo) and (TrapInfo.Sorc = self) then
			TrapInfo.Free;
		FTrapList.Delete(i);
		end;
	if (ErrCode <> 0) and Assigned(ErrProc) and Exists(Sorc) then
		begin
		TrapInfo := TTrapInfo.Create;
		TrapInfo.Proc := ErrProc;
		TrapInfo.Sorc := Sorc;
		FTrapList.AddObject(SErrCode, TrapInfo)
		end;
	if Exists(FSorcerer) then
		FSorcerer.AddTrapObject(ErrCode, ErrProc, Sorc);
	end;


procedure TDataSorcerer.AddTrap(ErrCode: integer; ErrProc: TTrapProc);
	begin
	AddTrapObject(ErrCode, ErrProc, self);
	end;


procedure TDataSorcerer.RemoveTrap(ErrCode: integer);
	begin
	AddTrap(ErrCode, nil);
	end;


procedure TDataSorcerer.SorcException(Sender: TObject; E: Exception);
	var
	i: integer;
	ps: array [0..DBIMAXMSGLEN] of char;
	TrapInfo: TTrapInfo;
	begin
	if FHandlingException then
		exit;
	FHandlingException := True;
	if (FAbility = Sorcerer) and (FTrapList.Count > 0) and (E is EDBEngineError) then
		begin
		i := FTrapList.IndexOf(IntToStr(EDBEngineError(E).Errors[0].ErrorCode));
		if i = -1 then
			i := FTrapList.IndexOf(IntToStr(-1));
		if i <> -1 then
			begin
			FEFieldName := GetDBErrString(ecFIELDNAME);
			FEToken := GetDBErrString(ecTOKEN);
			FETableName := GetDBErrString(ecTABLENAME);
			FEImageRow := GetDBErrString(ecIMAGEROW);
			FEUserName := GetDBErrString(ecUSERNAME);
			FEFileName := GetDBErrString(ecFILENAME);
			FEIndexName := GetDBErrString(ecINDEXNAME);
			FEDirName := GetDBErrString(ecDIRNAME);
			FEKeyName := GetDBErrString(ecKEYNAME);
			FEAlias := GetDBErrString(ecALIAS);
			FEDriveName := GetDBErrString(ecDRIVENAME);
			FENativeCode := GetDBErrString(ecNATIVECODE);
			FENativeMsg := GetDBErrString(ecNATIVEMSG);
			FELineNumber := GetDBErrString(ecLINENUMBER);
			FECapability := GetDBErrString(ecCAPABILITY);
{$IFDEF WIN32}
			FECDRName := GetDBErrString(ecCDRNAME);
			FEUserErrMsg := GetDBErrString(ecUSERERRMSG);
			FEInternalLimit := GetDBErrString(ecINTERNALLIMIT);
{$ENDIF}
			GetEFieldDetails;
			GetEFieldValChks;
			DbiGetErrorString(EDBEngineError(E).Errors[0].ErrorCode, ps);
			FEMessage := StrPas(ps);
			TrapInfo := TTrapInfo(FTrapList.Objects[i]);
			if (TrapInfo is TTrapInfo) and Assigned(TrapInfo.Proc) then
				TrapInfo.Proc(TrapInfo.Sorc, EDBEngineError(E).Errors[0].ErrorCode);
			FHandlingException := False;
			PopTrap;
			exit;
			end;
		end;
	Application.ShowException(E);
	PopTrap;
	FHandlingException := False;
	end;


function TDataSorcerer.ValidDataSet: boolean;
	begin
	if inherited DataSet = nil then
		Result := True
	else
		if Exists(FSorcerer) then
			Result := FSorcerer.IsSorcerer
		else
			Result := IsSorcerer;
	end;


function TDataSorcerer.IsSorcerer: boolean;
	var
	i: integer;
	Frm: TForm;
	begin
	Result := False;
	if Exists(Owner) and Exists(inherited DataSet) then
		begin
		Frm := TForm(Owner);
		for i := 0 to Frm.ComponentCount - 1 do
			if Frm.Components[i] = inherited DataSet then
				begin
				Result := True;
				break;
				end;
		end;
	end;


function TDataSorcerer.GetApprentice(const Index: integer): TDataSorcerer;
	begin
	Result := TDataSorcerer(FFormList.Objects[Index]);
	end;


function TDataSorcerer.GetApprenticeCount: integer;
	begin
	Result := FFormList.Count - 1;
	end;


procedure TDataSorcerer.DeleteApprentice(Appren: TDataSorcerer);
	var
	i: integer;
	begin
	UnLinkApprentice(Appren);
	for i := FApprentices downto 0 do
		if FApprentice[i] = Appren then
			FFormList.Delete(i);
	end;


procedure TDataSorcerer.AddApprenticeTraps(Appren: TDataSorcerer);
	var
	i: integer;
	begin
	for i := 0 to Appren.FTrapList.Count - 1 do
		AddTrapObject(StrToInt(Appren.FTrapList[i]), TTrapInfo(Appren.FTrapList.Objects[i]).Proc, Appren);
	end;


procedure TDataSorcerer.DeleteApprenticeTraps(Appren: TDataSorcerer);
	var
	i: integer;
	begin
	for i := FTrapList.Count - 1 downto 0 do
		if (FTrapList.Objects[i] is TTrapInfo)
			and (TTrapInfo(FTrapList.Objects[i]).Sorc = Appren) then
			FTrapList.Delete(i);
	end;


procedure TDataSorcerer.SetDataSet(Value: TDataSet);
	var
	i: integer;
	DS: TDataSorcerer;
	begin
	if Value <> inherited DataSet then
		begin
		if (FAbility = Sorcerer) and Exists(inherited DataSet) then
			begin
			inherited DataSet.AfterCancel := nil;
			inherited DataSet.AfterClose := nil;
			inherited DataSet.AfterDelete := nil;
			inherited DataSet.AfterEdit := nil;
			inherited DataSet.AfterInsert := nil;
			inherited DataSet.AfterOpen := nil;
			inherited DataSet.AfterPost := nil;
			inherited DataSet.BeforeCancel := nil;
			inherited DataSet.BeforeClose := nil;
			inherited DataSet.BeforeDelete := nil;
			inherited DataSet.BeforeEdit := nil;
			inherited DataSet.BeforeInsert := nil;
			inherited DataSet.BeforeOpen := nil;
			inherited DataSet.BeforePost := nil;
			inherited DataSet.OnCalcFields := nil;
			inherited DataSet.OnNewRecord := nil;
{$IFDEF WIN32}
			inherited DataSet.OnFilterRecord := nil;
			inherited DataSet.OnEditError := nil;
			inherited DataSet.OnPostError := nil;
			inherited DataSet.OnDeleteError := nil;
			inherited DataSet.OnServerYield := nil;
			inherited DataSet.OnUpdateError := nil;
{$ENDIF}
{$IFDEF INFPWR}
			if FSetType = dtwwTable then
				begin
				TwwTable(inherited DataSet).OnFilter := nil;
				TwwTable(inherited DataSet).OnInvalidValue := nil;
				end;
{$ENDIF}
			end;
		inherited DataSet := Value;
		SetAbility;
		SetDataSetType;
		if (FAbility = Sorcerer) and Exists(inherited DataSet) then
			begin
			inherited DataSet.AfterCancel := DoAfterCancel;
			inherited DataSet.AfterClose := DoAfterClose;
			inherited DataSet.AfterDelete := DoAfterDelete;
			inherited DataSet.AfterEdit := DoAfterEdit;
			inherited DataSet.AfterInsert := DoAfterInsert;
			inherited DataSet.AfterOpen := DoAfterOpen;
			inherited DataSet.AfterPost := DoAfterPost;
			inherited DataSet.BeforeCancel := DoBeforeCancel;
			inherited DataSet.BeforeClose := DoBeforeClose;
			inherited DataSet.BeforeDelete := DoBeforeDelete;
			inherited DataSet.BeforeEdit := DoBeforeEdit;
			inherited DataSet.BeforeInsert := DoBeforeInsert;
			inherited DataSet.BeforeOpen := DoBeforeOpen;
			inherited DataSet.BeforePost := DoBeforePost;
			inherited DataSet.OnCalcFields := DoOnCalcFields;
			inherited DataSet.OnNewRecord := DoOnNewRecord;
{$IFDEF WIN32}
			inherited DataSet.OnFilterRecord := DoOnFilterRecord;
			inherited DataSet.OnEditError := DoOnEditError;
			inherited DataSet.OnPostError := DoOnPostError;
			inherited DataSet.OnDeleteError := DoOnDeleteError;
			inherited DataSet.OnServerYield := DoOnServerYield;
			inherited DataSet.OnUpdateError := DoOnUpdateError;
{$ENDIF}
{$IFDEF INFPWR}
			if FSetType = dtwwTable then
				begin
				TwwTable(inherited DataSet).OnFilter := DoOnFilter;
				TwwTable(inherited DataSet).OnInvalidValue := DoOnInvalidValue;
{$IFDEF IP3}
				TwwTable(inherited DataSet).OnFilterEscape := DoOnFilterEscape;
{$ENDIF}
				end;
{$ENDIF}
			end;
		end;
	if not ValidDataSet then
		SetDataSet(nil);
	FindApprentices;
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			if Exists(FApprentice[i]) then
				begin
				DS := FApprentice[i];
				if DS.DataSet <> inherited Dataset then
					begin
					DS.FSorcerer := self;
					DS.DataSet := DataSet;
					if Assigned(DS.FOnLinked) then
						DS.FOnLinked(self);
					end
				else
					DS.FSorcerer := self;
				end;
	end;


procedure TDataSorcerer.SetAbility;
	var
	OAbility: TAbility;
	begin
	OAbility := FAbility;
	FAbility := Apprentice;
	if IsSorcerer then
		FAbility := Sorcerer;
	if (OAbility = Sorcerer) and (FAbility = Apprentice) then
		ClearApprentices;
	end;


procedure TDataSorcerer.SetDataSetType;
	begin
	FSetType := dtNone;
	if Exists(inherited DataSet) then
{$IFDEF INFPWR}
		if inherited DataSet is TwwTable then
			FSetType := dtwwTable
		else
			if inherited DataSet is TwwQuery then
				FSetType := dtwwQuery
			else
				if inherited DataSet is TwwQBE then
					FSetType := dtwwQBE
				else
{$ENDIF}
					if inherited DataSet is TTable then
						FSetType := dtTable
					else
						if inherited DataSet is TQuery then
							FSetType := dtQuery
						else
							if inherited DataSet is TStoredProc then
								FSetType := dtStoredProc;
	end;


procedure TDataSorcerer.ClearApprentices;
	var
	i: integer;
	begin
	for i := 0 to FApprentices do
		UnlinkApprentice(FApprentice[i]);
	FFormList.Clear;
	for i := FTrapList.Count - 1 downto 0 do
		if (FTrapList.Objects[i] is TTrapInfo)
			and (TTrapInfo(FTrapList.Objects[i]).Sorc <> self) then
			FTrapList.Delete(i);
	end;


procedure TDataSorcerer.FindApprentices;
	var
	i: integer;
	Appren: TDataSorcerer;
	SorcForm: string;
	begin
	for i := 0 to FApprentices do
		DeleteApprenticeTraps(FApprentice[i]);
	FFormList.Clear;
	if FAbility = Sorcerer then
		for i := 0 to SorcererList.Count - 1 do
			begin
			SorcForm := SorcererList[i];
			Appren := TDataSorcerer(SorcererList.Objects[i]);
			if (Appren.FAbility = Apprentice)
				and (FFormList.IndexOfObject(Appren) = -1)
				and (CompareText(SorcForm, FOwnerName) = 0)
				and (CompareText(Appren.Name, Name) = 0) then
				begin
				FFormList.AddObject(Appren.FOwnerName, Appren);
				AddApprenticeTraps(Appren);
				end;
			end;
	end;


procedure TDataSorcerer.UnLinkApprentice(Appren: TDataSorcerer);
	begin
	if Exists(Appren) then
		begin
		if Assigned(Appren.FOnUnLinked) and not (csDestroying in Appren.ComponentState) then
			Appren.FOnUnLinked(self);
		Appren.FSorcerer := nil;
		Appren.SetDataSet(nil);
		DeleteApprenticeTraps(Appren);
		end;
	end;


procedure TDataSorcerer.SetName(const Value: TComponentName);
	var
	i: integer;
	begin
	inherited SetName(Value);
	if FAbility = Sorcerer then
		begin
		for i := 0 to FApprentices do
			if Exists(FApprentice[i]) then
				FApprentice[i].Name := Value;
		end
	else
		begin
		if Exists(FSorcerer) then
			FSorcerer.DeleteApprentice(self);
		SorcererLink;
		end;
	end;


procedure TDataSorcerer.SetSorcererForm(Value: string);
	var
	i: integer;
	begin
	FSorcererForm := Value;
	if Exists(FSorcerer) then
		FSorcerer.DeleteApprentice(self);
	i := SorcererList.IndexOfObject(self);
	if i <> -1 then
		SorcererList[i] := FSorcererForm
	else
		if FSorcererForm <> '' then
			SorcererList.AddObject(FSorcererForm, self);
	SorcererLink;
	end;


procedure TDataSorcerer.SetFormList(const Value: TStrings);
	begin
	SetDataSet(inherited DataSet);
	end;


function TDataSorcerer.GetDataSet: TDataSet;
	begin
	if Exists(FSorcerer) then
		Result := FSorcerer.DataSet
	else
		Result := inherited DataSet;
	if not Exists(Result) then
		Result := nil;
	end;


class function TDataSorcerer.GetCopyright: string;
	begin
	Result := CopyrightNotice;
	end;


{// TDataSorcerer Dummy Methods ///////////////////////////////////////////////}
procedure TDataSorcerer.DummyAbility(Value: TAbility);
	begin
	end;


procedure TDataSorcerer.DummyDataSetType(Value: TDataSetType);
	begin
	end;


{// DataSet Properties With Exception Generation //////////////////////////////}
{$IFDEF INFPWR}
function TDataSorcerer.FwwTable: TwwTable;
	begin
	Result := TwwTable(GetDataSet);
	if not (Exists(Result) and (Result is TwwTable)) then
		begin
		Result := nil;
		SetDataSet(GetDataSet);
		SetDataSetType;
{$IFNDEF WIN32}
		if not (csDesigning in ComponentState) then
{$ENDIF}
			SorcError(SorcErrwwTable);
		end;
	end;


function TDataSorcerer.FwwQuery: TwwQuery;
	begin
	Result := TwwQuery(GetDataSet);
	if not (Exists(Result) and (Result is TwwQuery)) then
		begin
		Result := nil;
		SetDataSet(GetDataSet);
		SetDataSetType;
{$IFNDEF WIN32}
		if not (csDesigning in ComponentState) then
{$ENDIF}
			SorcError(SorcErrwwQuery);
		end;
	end;


function TDataSorcerer.FwwQBE: TwwQBE;
	begin
	Result := TwwQBE(GetDataSet);
	if not (Exists(Result) and (Result is TwwQBE)) then
		begin
		Result := nil;
		SetDataSet(GetDataSet);
		SetDataSetType;
{$IFNDEF WIN32}
		if not (csDesigning in ComponentState) then
{$ENDIF}
			SorcError(SorcErrwwQBE);
		end;
	end;
{$ENDIF}


function TDataSorcerer.FDataSet: TDataSet;
	begin
	Result := TDataSet(GetDataSet);
	if not (Exists(Result) and (Result is TDataSet)) then
		begin
		Result := nil;
		SetDataSet(GetDataSet);
		SetDataSetType;
{$IFNDEF WIN32}
		if not (csDesigning in ComponentState) then
{$ENDIF}
			SorcError(SorcErrNone);
		end;
	end;


function TDataSorcerer.FTable: TTable;
	begin
	Result := TTable(GetDataSet);
	if not (Exists(Result) and (Result is TTable)) then
		begin
		Result := nil;
		SetDataSet(GetDataSet);
		SetDataSetType;
{$IFNDEF WIN32}
		if not (csDesigning in ComponentState) then
{$ENDIF}
			SorcError(SorcErrTable);
		end;
	end;


function TDataSorcerer.FQuery: TQuery;
	begin
	Result := TQuery(GetDataSet);
	if not (Exists(Result) and (Result is TQuery)) then
		begin
		Result := nil;
		SetDataSet(GetDataSet);
		SetDataSetType;
{$IFNDEF WIN32}
		if not (csDesigning in ComponentState) then
{$ENDIF}
			SorcError(SorcErrQuery);
		end;
	end;


function TDataSorcerer.FProc: TStoredProc;
	begin
	Result := TStoredProc(GetDataSet);
	if not (Exists(Result) and (Result is TStoredProc)) then
		begin
		Result := nil;
		SetDataSet(GetDataSet);
		SetDataSetType;
{$IFNDEF WIN32}
		if not (csDesigning in ComponentState) then
{$ENDIF}
			SorcError(SorcErrProc);
		end;
	end;


function TDataSorcerer.FDBDataSet: TDBDataSet;
	begin
	Result := TDBDataSet(GetDataSet);
	if not (Exists(Result) and (Result is TDBDataSet)) then
		begin
		Result := nil;
		SetDataSet(GetDataSet);
		SetDataSetType;
{$IFNDEF WIN32}
		if not (csDesigning in ComponentState) then
{$ENDIF}
			SorcError(SorcErrNone);
		end;
	end;


{// TDBDataSet Emulation //////////////////////////////////////////////////////}
function TDataSorcerer.GetDatabase: TDataBase;
	begin
	Result := FDBDataSet.DataBase;
	end;


function TDataSorcerer.GetDBHandle: HDBIDB;
	begin
	Result := FDBDataSet.DBHandle;
	end;


function TDataSorcerer.GetDBLocale: TLocale;
	begin
	Result := FDBDataSet.DBLocale;
	end;


{$IFDEF WIN32}
function TDataSorcerer.CheckOpen(Status: DBIResult): boolean;
	begin
	Result := FDBDataSet.CheckOpen(Status);
	end;


function TDataSorcerer.GetDBSession: TSession;
	begin
	Result := FDBDataSet.DBSession;
	end;
{$ENDIF}


{// TDBDataSet Published Properties ///////////////////////////////////////////}
procedure TDataSorcerer.SetDatabaseName(FileName: TFileName);
	begin
	if FSetType <> dtNone then
		FDBDataSet.DatabaseName := FileName;
	end;


function TDataSorcerer.GetDatabaseName: TFileName;
	begin
	if FSetType <> dtNone then
		Result := FDBDataSet.DatabaseName
	else
		Result := '';
	end;

procedure TDataSorcerer.SetUpdateMode(Value: TUpdateMode);
	begin
	if FSetType <> dtNone then
		TSorcDBDataSet(FDBDataSet).UpdateMode := Value;
	end;


function TDataSorcerer.GetUpdateMode: TUpdateMode;
	begin
	if FSetType <> dtNone then
		Result := TSorcDBDataSet(FDBDataSet).UpdateMode
	else
		Result := upWhereAll;
	end;


{$IFDEF WIN32}
function TDataSorcerer.GetSessionName: string;
	begin
	if FSetType <> dtNone then
		Result := FDBDataSet.SessionName
	else
		Result := '';
	end;


procedure TDataSorcerer.SetSessionName(Value: string);
	begin
	if FSetType <> dtNone then
		FDBDataSet.SessionName := Value;
	end;
{$ENDIF}


{// TDataSet Emulation ////////////////////////////////////////////////////////}
procedure TDataSorcerer.Append;
	begin
	FDataSet.Append;
	end;


procedure TDataSorcerer.AppendRecord(const Values: array of const);
	begin
	FDataSet.AppendRecord(Values);
	end;


procedure TDataSorcerer.Cancel;
	begin
	FDataSet.Cancel;
	end;


procedure TDataSorcerer.CheckBrowseMode;
	begin
	FDataSet.CheckBrowseMode;
	end;


procedure TDataSorcerer.ClearFields;
	begin
	FDataSet.ClearFields;
	end;


procedure TDataSorcerer.Close;
	begin
	FDataSet.Close;
	end;


procedure TDataSorcerer.CursorPosChanged;
	begin
	FDataSet.CursorPosChanged;
	end;


procedure TDataSorcerer.Delete;
	begin
	FDataSet.Delete;
	end;


procedure TDataSorcerer.DisableControls;
	begin
	FDataSet.DisableControls;
	end;


procedure TDataSorcerer.Edit;
	begin
	FDataSet.Edit;
	end;


procedure TDataSorcerer.EnableControls;
	begin
	FDataSet.EnableControls;
	end;


procedure TDataSorcerer.First;
	begin
	FDataSet.First;
	end;


procedure TDataSorcerer.FreeBookmark(Bookmark: TBookmark);
	begin
	FDataSet.FreeBookmark(Bookmark);
	end;


procedure TDataSorcerer.GetFieldNames(List: TStrings);
	begin
	FDataSet.GetFieldNames(List);
	end;


procedure TDataSorcerer.GotoBookmark(Bookmark: TBookmark);
	begin
	FDataSet.GotoBookmark(Bookmark);
	end;


procedure TDataSorcerer.Insert;
	begin
	FDataSet.Insert;
	end;


procedure TDataSorcerer.InsertRecord(const Values: array of const);
	begin
	FDataSet.InsertRecord(Values);
	end;


procedure TDataSorcerer.Last;
	begin
	FDataSet.Last;
	end;


procedure TDataSorcerer.MoveBy(Distance: Integer);
	begin
	FDataSet.MoveBy(Distance);
	end;


procedure TDataSorcerer.Next;
	begin
	FDataSet.Next;
	end;


procedure TDataSorcerer.Open;
	begin
	FDataSet.Open;
	end;


procedure TDataSorcerer.Post;
	begin
	FDataSet.Post;
	end;


procedure TDataSorcerer.Prior;
	begin
	FDataSet.Prior;
	end;


procedure TDataSorcerer.Refresh;
	begin
	FDataSet.Refresh;
	end;


procedure TDataSorcerer.SetFields(const Values: array of const);
	begin
	FDataSet.SetFields(Values);
	end;


procedure TDataSorcerer.UpdateCursorPos;
	begin
	FDataSet.UpdateCursorPos;
	end;


procedure TDataSorcerer.UpdateRecord;
	begin
	FDataSet.UpdateRecord;
	end;


procedure TDataSorcerer.SetField(Index: integer; Value: TField);
	begin
	FDataSet.Fields[Index] := Value;
	end;


procedure TDataSorcerer.SetFieldDefs(Value: TFieldDefs);
	begin
	FDataSet.FieldDefs := Value;
	end;


function TDataSorcerer.GetFld(const Name: string): string;
	begin
	Result := FDataSet.FieldByName(Name).AsString;
	end;


procedure TDataSorcerer.SetFld(const Name, Value: string);
	begin
	FDataSet.FieldByName(Name).AsString := Value;
	end;


function TDataSorcerer.GetIntegerFld(const Name: string): longint;
	begin
	Result := FDataSet.FieldByName(Name).AsInteger;
	end;


procedure TDataSorcerer.SetIntegerFld(const Name: string; Value: longint);
	begin
	FDataSet.FieldByName(Name).AsInteger := Value;
	end;


function TDataSorcerer.GetFloatFld(const Name: string): double;
	begin
	Result := FDataSet.FieldByName(Name).AsFloat;
	end;


procedure TDataSorcerer.SetFloatFld(const Name: string; Value: double);
	begin
	FDataSet.FieldByName(Name).AsFloat := Value;
	end;


function TDataSorcerer.GetBooleanFld(const Name: string): boolean;
	begin
	Result := FDataSet.FieldByName(Name).AsBoolean;
	end;


procedure TDataSorcerer.SetBooleanFld(const Name: string; Value: boolean);
	begin
	FDataSet.FieldByName(Name).AsBoolean := Value;
	end;


function TDataSorcerer.GetDateTimeFld(const Name: string): TDateTime;
	begin
	Result := FDataSet.FieldByName(Name).AsDateTime;
	end;


procedure TDataSorcerer.SetDateTimeFld(const Name: string; Value: TDateTime);
	begin
	FDataSet.FieldByName(Name).AsDateTime := Value;
	end;


{$IFDEF WIN32}
function TDataSorcerer.GetCurrencyFld(const Name: string): Currency;
	begin
	Result := FDataSet.FieldByName(Name).AsCurrency;
	end;


procedure TDataSorcerer.SetCurrencyFld(const Name: string; Value: Currency);
	begin
	FDataSet.FieldByName(Name).AsCurrency := Value;
	end;


function TDataSorcerer.GetVariantFld(const Name: string): Variant;
	begin
	Result := FDataSet.FieldByName(Name).AsVariant;
	end;


procedure TDataSorcerer.SetVariantFld(const Name: string; Value: Variant);
	begin
	FDataSet.FieldByName(Name).AsVariant := Value;
	end;
{$ENDIF}


function TDataSorcerer.FieldByName(const FieldName: string): TField;
	begin
	Result := FDataSet.FieldByName(FieldName);
	end;


function TDataSorcerer.FindField(const FieldName: string): TField;
	begin
	Result := FDataSet.FindField(FieldName);
	end;


function TDataSorcerer.GetBookmark: TBookmark;
	begin
	Result := FDataSet.GetBookmark;
	end;


function TDataSorcerer.GetCurrentRecord(Buffer: PChar): Boolean;
	begin
	Result := FDataSet.GetCurrentRecord(Buffer);
	end;


function TDataSorcerer.GetBOF: boolean;
	begin
	Result := FDataSet.BOF;
	end;


function TDataSorcerer.GetCanModify: boolean;
	begin
	Result := FDataSet.CanModify;
	end;


function TDataSorcerer.GetEOF: boolean;
	begin
	Result := FDataSet.EOF;
	end;


function TDataSorcerer.GetFieldCount: integer;
	begin
	Result := FDataSet.FieldCount;
	end;


function TDataSorcerer.GetFieldDefs: TFieldDefs;
	begin
	Result := FDataSet.FieldDefs;
	end;


function TDataSorcerer.GetField(Index: integer): TField;
	begin
	Result := FDataSet.Fields[Index];
	end;


function TDataSorcerer.GetHandle: HDBICur;
	begin
	Result := FDataSet.Handle;
	end;


function TDataSorcerer.GetModified: boolean;
	begin
	Result := FDataSet.Modified;
	end;


function TDataSorcerer.GetRecordCount: longint;
	begin
	Result := FDataSet.RecordCount;
	end;


function TDataSorcerer.GetState: TDataSetState;
	begin
	Result := FDataSet.State;
	end;


function TDataSorcerer.GetLocale: TLocale;
	begin
	Result := FDataSet.Locale;
	end;


{$IFDEF WIN32}
function TDataSorcerer.ActiveBuffer: pchar;
	begin
	Result := FDataSet.ActiveBuffer;
	end;


function TDataSorcerer.ControlsDisabled: boolean;
	begin
	Result := FDataSet.ControlsDisabled;
	end;


procedure TDataSorcerer.FetchAll;
	begin
	FDataSet.FetchAll;
	end;


function TDataSorcerer.FindFirst: boolean;
	begin
	Result := FDataSet.FindFirst;
	end;


function TDataSorcerer.FindLast: boolean;
	begin
	Result := FDataSet.FindLast;
	end;


function TDataSorcerer.FindNext: boolean;
	begin
	Result := FDataSet.FindNext;
	end;


function TDataSorcerer.FindPrior: boolean;
	begin
	Result := FDataSet.FindPrior;
	end;


procedure TDataSorcerer.GetFieldList(List: TList; const FieldNames: string);
	begin
	FDataSet.GetFieldList(List, FieldNames);
	end;


function TDataSorcerer.IsLinkedTo(DataSource: TDataSource): boolean;
	begin
	Result := FDataSet.IsLinkedTo(DataSource);
	end;


function TDataSorcerer.Locate(const KeyFields: string; const KeyValues: variant; Options: TLocateOptions): boolean;
	begin
	Result := FDataSet.Locate(KeyFields, KeyValues, Options);
	end;


function TDataSorcerer.Lookup(const KeyFields: string; const KeyValues: variant; const ResultFields: string): variant;
	begin
	Result := FDataSet.Lookup(KeyFields, KeyValues, ResultFields);
	end;


procedure TDataSorcerer.Resync(Mode: TResyncMode);
	begin
	FDataSet.Resync(Mode);
	end;


procedure TDataSorcerer.SetDetailFields(MasterFields: TList);
	begin
	FDataSet.SetDetailFields(MasterFields);
	end;


procedure TDataSorcerer.ApplyUpdates;
	begin
	FDataSet.ApplyUpdates;
	end;


procedure TDataSorcerer.CommitUpdates;
	begin
	FDataSet.CommitUpdates;
	end;


procedure TDataSorcerer.CancelUpdates;
	begin
	FDataSet.CancelUpdates;
	end;


procedure TDataSorcerer.RevertRecord;
	begin
	FDataSet.RevertRecord;
	end;


function TDataSorcerer.UpdateStatus: TUpdateStatus;
	begin
	Result := FDataSet.UpdateStatus;
	end;


function TDataSorcerer.GetBookmarkStr: TBookmarkStr;
	begin
	Result := FDataSet.Bookmark;
	end;


procedure TDataSorcerer.SetBookmarkStr(Value: TBookmarkStr);
	begin
	FDataSet.Bookmark := Value;
	end;


function TDataSorcerer.GetDefaultFields: boolean;
	begin
	Result := FDataSet.DefaultFields;
	end;


function TDataSorcerer.GetDesigner: TDataSetDesigner;
	begin
	Result := FDataSet.Designer;
	end;


function TDataSorcerer.GetExpIndex: boolean;
	begin
	Result := FDataSet.ExpIndex;
	end;


function TDataSorcerer.GetFieldValues(const Name: string): variant;
	begin
	Result := FDataSet.FieldValues[Name];
	end;


procedure TDataSorcerer.SetFieldValues(const Name: string; Value: variant);
	begin
	FDataSet.FieldValues[Name] := Value;
	end;


function TDataSorcerer.GetFound: boolean;
	begin
	Result := FDataSet.Found;
	end;


function TDataSorcerer.GetKeySize: word;
	begin
	Result := FDataSet.KeySize;
	end;


function TDataSorcerer.GetRecNo: longint;
	begin
	Result := FDataSet.RecNo;
	end;


function TDataSorcerer.GetRecordSize: word;
	begin
	Result := FDataSet.RecordSize;
	end;


function TDataSorcerer.GetUpdateRecordTypes: TUpdateRecordTypes;
	begin
	Result := FDataSet.UpdateRecordTypes;
	end;


procedure TDataSorcerer.SetUpdateRecordTypes(Value: TUpdateRecordTypes);
	begin
	FDataSet.UpdateRecordTypes := Value;
	end;


function TDataSorcerer.GetUpdatesPending: boolean;
	begin
	Result := FDataSet.UpdatesPending;
	end;
{$ENDIF}


{// TDataSet Published Properties /////////////////////////////////////////////}
procedure TDataSorcerer.SetActive(Value: boolean);
	begin
	if FSetType <> dtNone then
		FDataSet.Active := Value;
	end;


procedure TDataSorcerer.SetAutoCalcFields(Value: boolean);
	begin
	if FSetType <> dtNone then
		FDataSet.AutoCalcFields := Value;
	end;


function TDataSorcerer.GetActive: boolean;
	begin
	if FSetType <> dtNone then
		Result := FDataSet.Active
	else
		Result := False;
	end;


function TDataSorcerer.GetAutoCalcFields: boolean;
	begin
	if FSetType <> dtNone then
		Result := FDataSet.AutoCalcFields
	else
		Result := False;
	end;


{$IFDEF WIN32}
function TDataSorcerer.GetUpdateObject: TDataSetUpdateObject;
	begin
	if FSetType <> dtNone then
		Result := FDataSet.UpdateObject
	else
		Result := nil;
	end;


procedure TDataSorcerer.SetUpdateObject(Value: TDataSetUpdateObject);
	begin
	if FSetType <> dtNone then
		FDataSet.UpdateObject := Value;
	end;


function TDataSorcerer.GetCachedUpdates: boolean;
	begin
	if FSetType <> dtNone then
		Result := FDataSet.CachedUpdates
	else
		Result := False;
	end;


procedure TDataSorcerer.SetCachedUpdates(Value: boolean);
	begin
	if FSetType <> dtNone then
		FDataSet.CachedUpdates := Value;
	end;


function TDataSorcerer.GetFilter: string;
	begin
	if FSetType <> dtNone then
		Result := FDataSet.Filter
	else
		Result := '';
	end;


procedure TDataSorcerer.SetFltr(Value: string);
	begin
	if FSetType <> dtNone then
		FDataSet.Filter := Value;
	end;


function TDataSorcerer.GetFiltered: boolean;
	begin
	if FSetType <> dtNone then
		Result := FDataSet.Filtered
	else
		Result := False;
	end;


procedure TDataSorcerer.SetFiltered(Value: boolean);
	begin
	if FSetType <> dtNone then
		FDataSet.Filtered := Value;
	end;


function TDataSorcerer.GetFilterOptions: TFilterOptions;
	begin
	if FSetType <> dtNone then
		Result := FDataSet.FilterOptions
	else
		Result := [];
	end;


procedure TDataSorcerer.SetFilterOptions(Value: TFilterOptions);
	begin
	if FSetType <> dtNone then
		FDataSet.FilterOptions := Value;
	end;


function TDataSorcerer.GetDataSource: TDataSource;
	begin
	if FSetType <> dtNone then
		Result := FDataSet.DataSource
	else
		Result := FEmptySource;
	end;

{$ENDIF}


{// TTable Emulation //////////////////////////////////////////////////////////}
procedure TDataSorcerer.AddIndex(const Name, Fields: string; Options: TIndexOptions);
	begin
	FTable.AddIndex(Name, Fields, Options);
	end;


procedure TDataSorcerer.ApplyRange;
	begin
	FTable.ApplyRange;
	end;


procedure TDataSorcerer.CancelRange;
	begin
	FTable.CancelRange;
	end;


procedure TDataSorcerer.CreateTable;
	begin
	FTable.CreateTable;
	end;


procedure TDataSorcerer.DeleteIndex(const Name: string);
	begin
	FTable.DeleteIndex(Name);
	end;


procedure TDataSorcerer.DeleteTable;
	begin
	FTable.DeleteTable;
	end;


procedure TDataSorcerer.EditKey;
	begin
	FTable.EditKey;
	end;


procedure TDataSorcerer.EditRangeEnd;
	begin
	FTable.EditRangeEnd;
	end;


procedure TDataSorcerer.EditRangeStart;
	begin
	FTable.EditRangeStart;
	end;


procedure TDataSorcerer.EmptyTable;
	begin
	FTable.EmptyTable;
	end;


procedure TDataSorcerer.FindNearest(const KeyValues: array of const);
	begin
	FTable.FindNearest(KeyValues);
	end;


procedure TDataSorcerer.GetIndexNames(List: TStrings);
	begin
	FTable.GetIndexNames(List);
	end;


procedure TDataSorcerer.GotoCurrent(Table: TTable);
	begin
	FTable.GotoCurrent(Table);
	end;


procedure TDataSorcerer.GotoNearest;
	begin
	FTable.GotoNearest;
	end;


procedure TDataSorcerer.LockTable(LockType: TLockType);
	begin
	FTable.LockTable(LockType);
	end;


procedure TDataSorcerer.RenameTable(const NewTableName: string);
	begin
	FTable.RenameTable(NewTableName);
	end;


procedure TDataSorcerer.SetKey;
	begin
	FTable.SetKey;
	end;


procedure TDataSorcerer.SetRange(const StartValues, EndValues: array of const);
	begin
	FTable.SetRange(StartValues, EndValues);
	end;


procedure TDataSorcerer.SetRangeEnd;
	begin
	FTable.SetRangeEnd;
	end;


procedure TDataSorcerer.SetRangeStart;
	begin
	FTable.SetRangeStart;
	end;


procedure TDataSorcerer.UnlockTable(LockType: TLockType);
	begin
	FTable.UnlockTable(LockType);
	end;


function TDataSorcerer.BatchMove(ASource: TDataSet; AMode: TBatchMode): Longint;
	begin
	Result := FTable.BatchMove(ASource, AMode);
	end;


function TDataSorcerer.FindKey(const KeyValues: array of const): Boolean;
	begin
	Result := FTable.FindKey(KeyValues);
	end;


function TDataSorcerer.GotoKey: Boolean;
	begin
	Result := FTable.GotoKey;
	end;


procedure TDataSorcerer.SetIndexField(Index: integer; Field: TField);
	begin
	FTable.IndexFields[Index] := Field;
	end;


procedure TDataSorcerer.SetKeyExclusive(Exclusive: boolean);
	begin
	FTable.KeyExclusive := Exclusive;
	end;


procedure TDataSorcerer.SetKeyFieldCount(Count: integer);
	begin
	FTable.KeyFieldCount := Count;
	end;


function TDataSorcerer.GetIndexDefs: TIndexDefs;
	begin
	Result := FTable.IndexDefs;
	end;


function TDataSorcerer.GetIndexFieldCount: Integer;
	begin
	Result := FTable.IndexFieldCount;
	end;


function TDataSorcerer.GetIndexField(Index: integer): TField;
	begin
	Result := FTable.IndexFields[Index];
	end;


function TDataSorcerer.GetKeyExclusive: boolean;
	begin
	Result := FTable.KeyExclusive;
	end;


function TDataSorcerer.GetKeyFieldCount: integer;
	begin
	Result := FTable.KeyFieldCount;
	end;


{$IFDEF WIN32}
procedure TDataSorcerer.CloseIndexFile(const IndexName: string);
	begin
	FTable.CloseIndexFile(IndexName);
	end;


procedure TDataSorcerer.OpenIndexFile(const IndexName: string);
	begin
	FTable.OpenIndexFile(IndexName);
	end;
{$ENDIF}


{// TTable Published Properties ///////////////////////////////////////////////}
procedure TDataSorcerer.SetExclusive(Value: boolean);
	begin
	if (FSetType = dtTable)
{$IFDEF INFPWR}
		or (FSetType = dtwwTable)
{$ENDIF}
		then
		FTable.Exclusive := Value;
	end;


procedure TDataSorcerer.SetIndexFieldNames(Value: string);
	begin
	if (FSetType = dtTable)
{$IFDEF INFPWR}
		or (FSetType = dtwwTable)
{$ENDIF}
		then
		FTable.IndexFieldNames := Value;
	end;


procedure TDataSorcerer.SetIndexName(Value: string);
	begin
	if (FSetType = dtTable)
{$IFDEF INFPWR}
		or (FSetType = dtwwTable)
{$ENDIF}
		then
		FTable.IndexName := Value;
	end;


procedure TDataSorcerer.SetMasterFields(Value: string);
	begin
	if (FSetType = dtTable)
{$IFDEF INFPWR}
		or (FSetType = dtwwTable)
{$ENDIF}
		then
		FTable.MasterFields := Value;
	end;


procedure TDataSorcerer.SetMasterSource(Value: TDataSource);
	begin
	if (FSetType = dtTable)
{$IFDEF INFPWR}
		or (FSetType = dtwwTable)
{$ENDIF}
		then
		FTable.MasterSource := Value;
	end;


procedure TDataSorcerer.SetReadOnly(Value: boolean);
	begin
	if (FSetType = dtTable)
{$IFDEF INFPWR}
		or (FSetType = dtwwTable)
{$ENDIF}
		then
		FTable.ReadOnly := Value;
	end;


procedure TDataSorcerer.SetTableName(Value: TFileName);
	begin
	if (FSetType = dtTable)
{$IFDEF INFPWR}
		or (FSetType = dtwwTable)
{$ENDIF}
		then
		FTable.TableName := Value;
	end;


procedure TDataSorcerer.SetTableType(Value: TTableType);
	begin
	if (FSetType = dtTable)
{$IFDEF INFPWR}
		or (FSetType = dtwwTable)
{$ENDIF}
		then
		FTable.TableType := Value;
	end;


function TDataSorcerer.GetExclusive: boolean;
	begin
	if (FSetType = dtTable)
{$IFDEF INFPWR}
		or (FSetType = dtwwTable)
{$ENDIF}
		then
		Result := FTable.Exclusive
	else
		Result := False;
	end;


function TDataSorcerer.GetIndexFieldNames: string;
	begin
	if (FSetType = dtTable)
{$IFDEF INFPWR}
		or (FSetType = dtwwTable)
{$ENDIF}
		then
		Result := FTable.IndexFieldNames
	else
		Result := '';
	end;


function TDataSorcerer.GetIndexName: string;
	begin
	if (FSetType = dtTable)
{$IFDEF INFPWR}
		or (FSetType = dtwwTable)
{$ENDIF}
		then
		Result := FTable.IndexName
	else
		Result := '';
	end;


function TDataSorcerer.GetMasterFields: string;
	begin
	if (FSetType = dtTable)
{$IFDEF INFPWR}
		or (FSetType = dtwwTable)
{$ENDIF}
		then
		Result := FTable.MasterFields
	else
		Result := '';
	end;


function TDataSorcerer.GetMasterSource: TDataSource;
	begin
	if (FSetType = dtTable)
{$IFDEF INFPWR}
		or (FSetType = dtwwTable)
{$ENDIF}
		then
		Result := FTable.MasterSource
	else
		Result := FEmptySource;
	end;


function TDataSorcerer.GetReadOnly: boolean;
	begin
	if (FSetType = dtTable)
{$IFDEF INFPWR}
		or (FSetType = dtwwTable)
{$ENDIF}
		then
		Result := FTable.ReadOnly
	else
		Result := False;
	end;


function TDataSorcerer.GetTableName: TFileName;
	begin
	if (FSetType = dtTable)
{$IFDEF INFPWR}
		or (FSetType = dtwwTable)
{$ENDIF}
		then
			Result := FTable.TableName
		else
			Result := '';
	end;


function TDataSorcerer.GetTableType: TTableType;
	begin
	if (FSetType = dtTable)
{$IFDEF INFPWR}
		or (FSetType = dtwwTable)
{$ENDIF}
		then
		Result := FTable.TableType
	else
		Result := ttDefault;
	end;


{// Dual TQuery and TStoredProc Emulation /////////////////////////////////////}
procedure TDataSorcerer.Prepare;
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		FQuery.Prepare
	else
		if FSetType = dtStoredProc then
			FProc.Prepare
		else
			SorcError(SorcErrQryProc);
	end;


procedure TDataSorcerer.UnPrepare;
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		FQuery.UnPrepare
	else
		if FSetType = dtStoredProc then
			FProc.UnPrepare
		else
			SorcError(SorcErrQryProc);
	end;


function TDataSorcerer.ParamByName(const Value: string): TParam;
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		Result := FQuery.ParamByName(Value)
	else
		if FSetType = dtStoredProc then
			Result := FProc.ParamByName(Value)
		else
			begin
			Result := nil;
			SorcError(SorcErrQryProc);
			end;
	end;


function TDataSorcerer.GetParamsCount: word;
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		Result := FQuery.ParamCount
	else
		if FSetType = dtStoredProc then
			Result := FProc.ParamCount
		else
			begin
			SorcError(SorcErrQryProc);
			Result := 0;
			end;
	end;


procedure TDataSorcerer.SetPrepared(Value: boolean);
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		FQuery.Prepared := Value
	else
		if FSetType = dtStoredProc then
			FProc.Prepared := Value
		else
			SorcError(SorcErrQryProc);
	end;


function TDataSorcerer.GetPrepared: boolean;
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		Result := FQuery.Prepared
	else
		if FSetType = dtStoredProc then
			Result := FProc.Prepared
		else
			begin
			SorcError(SorcErrQryProc);
			Result := False;
			end;
	end;


function TDataSorcerer.GetStmtHandle: HDBIStmt;
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		Result := FQuery.StmtHandle
	else
		if FSetType = dtStoredProc then
			Result := FProc.StmtHandle
		else
			begin
			Result := nil;
			SorcError(SorcErrQryProc);
			end;
	end;


{// TStoredProc Emulation /////////////////////////////////////////////////////}
procedure TDataSorcerer.CopyParams(Value: TParams);
	begin
	FProc.CopyParams(Value);
	end;


procedure TDataSorcerer.ExecProc;
	begin
	FProc.ExecProc;
	end;


procedure TDataSorcerer.GetResults;
	begin
	FProc.GetResults;
	end;


function TDataSorcerer.DescriptionsAvailable: Boolean;
	begin
	Result := FProc.DescriptionsAvailable;
	end;


{// TStoredProc Published Properties //////////////////////////////////////////}
procedure TDataSorcerer.SetProcName(Value: string);
	begin
	if FSetType = dtStoredProc then
		FProc.StoredProcName := Value;
	end;


procedure TDataSorcerer.SetOverload(Value: word);
	begin
	if FSetType = dtStoredProc then
		FProc.Overload := Value;
	end;


procedure TDataSorcerer.SetBindMode(Value: TParamBindMode);
	begin
	if FSetType = dtStoredProc then
		FProc.ParamBindMode := Value;
	end;


function TDataSorcerer.GetProcName: string;
	begin
	if FSetType = dtStoredProc then
		Result := FProc.StoredProcName
	else
		Result := '';
	end;


function TDataSorcerer.GetOverload: word;
	begin
	if FSetType = dtStoredProc then
		Result := FProc.Overload
	else
		Result := 0;
	end;


function TDataSorcerer.GetBindMode: TParamBindMode;
	begin
	if FSetType = dtStoredProc then
		Result := FProc.ParamBindMode
	else
		Result := pbByName;
	end;


{// TQuery Emulation //////////////////////////////////////////////////////////}
procedure TDataSorcerer.ExecSQL;
	begin
	FQuery.ExecSQL;
	end;


procedure TDataSorcerer.SetSQLBinary(Value: PChar);
	begin
	FQuery.SQLBinary := Value;
	end;


function TDataSorcerer.GetLocal: boolean;
	begin
	Result := FQuery.Local;
	end;


{$IFDEF WIN32}
function TDataSorcerer.GetSQLText: string;
	begin
	Result := FQuery.Text;
	end;
{$ELSE}
function TDataSorcerer.GetSQLText: PChar;
	begin
	Result := FQuery.Text;
	end;
{$ENDIF}


function TDataSorcerer.GetSQLBinary: PChar;
	begin
	Result := FQuery.SQLBinary;
	end;


{$IFDEF WIN32}
function TDataSorcerer.GetRowsAffected: integer;
	begin
	Result := FQuery.RowsAffected;
	end;
{$ENDIF}


{// TQuery Published Properties ///////////////////////////////////////////////}
procedure TDataSorcerer.SetParamsList(Value: TParams);
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		FQuery.Params := Value
	else
		if FSetType = dtStoredProc then
			FProc.Params := Value;
	end;


function TDataSorcerer.GetParamsList: TParams;
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		Result := FQuery.Params
	else
		if FSetType = dtStoredProc then
			Result := FProc.Params
		else
			Result := FEmptyParams;
	end;


procedure TDataSorcerer.SetSQL(Value: TStrings);
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		FQuery.SQL := Value;
	end;


function TDataSorcerer.GetSQL: TStrings;
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		Result := FQuery.SQL
	else
		Result := FEmptyStrings;
	end;


procedure TDataSorcerer.SetUniDirectional(Value: boolean);
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		FQuery.UniDirectional := Value;
	end;


procedure TDataSorcerer.SetRequestLive(Value: boolean);
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		FQuery.RequestLive := Value;
	end;


function TDataSorcerer.GetUniDirectional: boolean;
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		Result := FQuery.UniDirectional
	else
		Result := False;
	end;


function TDataSorcerer.GetRequestLive: boolean;
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		Result := FQuery.RequestLive
	else
		Result := False;
	end;


{$IFDEF WIN32}
function TDataSorcerer.GetConstrained: boolean;
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		Result := FQuery.Constrained
	else
		Result := False;
	end;


procedure TDataSorcerer.SetConstrained(Value: boolean);
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		FQuery.Constrained := Value;
	end;


procedure TDataSorcerer.SetDataSource(Value: TDataSource);
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		FQuery.DataSource := Value;
	end;


function TDataSorcerer.GetParamCheck: boolean;
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		Result := FQuery.ParamCheck
	else
		Result := False;
	end;


procedure TDataSorcerer.SetParamCheck(Value: boolean);
	begin
	if (FSetType = dtQuery)
{$IFDEF INFPWR}
		or (FSetType = dtwwQuery)
{$ENDIF}
		then
		FQuery.ParamCheck := Value;
	end;
{$ENDIF}


{// DataSet Events ////////////////////////////////////////////////////////////}
procedure TDataSorcerer.DoAfterCancel(Value: TDataSet);
	var
	i: integer;
	begin
	if Assigned(FAfterCancel) then
		FAfterCancel(Value);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoAfterCancel(Value);
	PopTrap;
	end;


procedure TDataSorcerer.DoAfterClose(Value: TDataSet);
	var
	i: integer;
	begin
	if Assigned(FAfterClose) then
		FAfterClose(Value);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoAfterClose(Value);
	PopTrap;
	end;


procedure TDataSorcerer.DoAfterDelete(Value: TDataSet);
	var
	i: integer;
	begin
	if Assigned(FAfterDelete) then
		FAfterDelete(Value);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoAfterDelete(Value);
	PopTrap;
	end;


procedure TDataSorcerer.DoAfterEdit(Value: TDataSet);
	var
	i: integer;
	begin
	if Assigned(FAfterEdit) then
		FAfterEdit(Value);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoAfterEdit(Value);
	PopTrap;
	end;


procedure TDataSorcerer.DoAfterInsert(Value: TDataSet);
	var
	i: integer;
	begin
	if Assigned(FAfterInsert) then
		FAfterInsert(Value);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoAfterInsert(Value);
	PopTrap;
	end;


procedure TDataSorcerer.DoAfterOpen(Value: TDataSet);
	var
	i: integer;
	begin
	if Assigned(FAfterOpen) then
		FAfterOpen(Value);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoAfterOpen(Value);
	PopTrap;
	end;


procedure TDataSorcerer.DoAfterPost(Value: TDataSet);
	var
	i: integer;
	begin
	DbiSaveChanges(Handle);
	if Assigned(FAfterPost) then
		FAfterPost(Value);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoAfterPost(Value);
	PopTrap;
	end;


procedure TDataSorcerer.DoBeforeCancel(Value: TDataSet);
	var
	i: integer;
	begin
	PushTrap;
	if Assigned(FBeforeCancel) then
		FBeforeCancel(Value);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoBeforeCancel(Value);
	end;


procedure TDataSorcerer.DoBeforeClose(Value: TDataSet);
	var
	i: integer;
	begin
	PushTrap;
	if Assigned(FBeforeClose) then
		FBeforeClose(Value);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoBeforeClose(Value);
	end;


procedure TDataSorcerer.DoBeforeDelete(Value: TDataSet);
	var
	i: integer;
	begin
	PushTrap;
	if Assigned(FBeforeDelete) then
		FBeforeDelete(Value);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoBeforeDelete(Value);
	end;


procedure TDataSorcerer.DoBeforeEdit(Value: TDataSet);
	var
	i: integer;
	begin
	PushTrap;
	if Assigned(FBeforeEdit) then
		FBeforeEdit(Value);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoBeforeEdit(Value);
	end;


procedure TDataSorcerer.DoBeforeInsert(Value: TDataSet);
	var
	i: integer;
	begin
	PushTrap;
	if Assigned(FBeforeInsert) then
		FBeforeInsert(Value);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoBeforeInsert(Value);
	end;


procedure TDataSorcerer.DoBeforeOpen(Value: TDataSet);
	var
	i: integer;
	begin
	PushTrap;
	if Assigned(FBeforeOpen) then
		FBeforeOpen(Value);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoBeforeOpen(Value);
	end;


procedure TDataSorcerer.DoBeforePost(Value: TDataSet);
	var
	i: integer;
	begin
	PushTrap;
	if Assigned(FBeforePost) then
		FBeforePost(Value);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoBeforePost(Value);
	end;


procedure TDataSorcerer.DoOnCalcFields(Value: TDataSet);
	var
	i: integer;
	begin
	if Assigned(FOnCalcFields) then
		FOnCalcFields(Value);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoOnCalcFields(Value);
	end;


procedure TDataSorcerer.DoOnNewRecord(Value: TDataSet);
	var
	i: integer;
	begin
	if Assigned(FOnNewRecord) then
		FOnNewRecord(Value);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoOnNewRecord(Value);
	end;


{$IFDEF IP3}
function TDataSorcerer.GetNarrowSearchUpperChar: word;
	begin
	Result := 0;
	if FSetType = dtwwTable then
		Result := FwwTable.NarrowSearchUpperChar
	end;


procedure TDataSorcerer.SetNarrowSearchUpperChar(value: word);
	begin
	if FSetType = dtwwTable then
		FwwTable.NarrowSearchUpperChar := value;
	end;


procedure TDataSorcerer.SetOnFilterEscape(value: TDataSetNotifyEvent);
	begin
	FOnFilterEscape := value;
	if FSetType = dtwwTable then
		TwwTable(inherited DataSet).OnFilterEscape := DoOnFilterEscape;
	end;


function TDataSorcerer.GetOnFilterOptions: TwwOnFilterOptions;
	begin
	Result := [];
	if FSetType = dtwwTable then
		Result := FwwTable.OnFilterOptions;
	end;


procedure TDataSorcerer.SetOnFilterOptions(value: TwwOnFilterOptions);
	begin
	if FSetType = dtwwTable then
		FwwTable.OnFilterOptions := value;
	end;


procedure TDataSorcerer.DoOnFilterEscape(DS: TDataSet);
	var
	i: integer;
	begin
	if Assigned(FOnFilterEscape) then
		FOnFilterEscape(DS);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoOnFilterEscape(DS);
	end;
{$ENDIF}


{$IFDEF WIN32}
procedure TDataSorcerer.DoOnFilterRecord(DS: TDataSet; var Accept: boolean);
	var
	i: integer;
	begin
	if Assigned(FOnFilterRecord) then
		FOnFilterRecord(DS, Accept);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoOnFilterRecord(DS, Accept);
	end;


procedure TDataSorcerer.DoOnServerYield(DS: TDataSet; var AbortQuery: boolean);
	var
	i: integer;
	begin
	if Assigned(FOnServerYield) then
		FOnServerYield(DS, AbortQuery);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoOnServerYield(DS, AbortQuery);
	end;


procedure TDataSorcerer.DoOnUpdateError(DS: TDataSet; E: EDatabaseError; UpdateKind: TUpdateKind;
										var UpdateAction: TUpdateAction);
	var
	i: integer;
	begin
	if Assigned(FOnUpdateError) then
		FOnUpdateError(DS, E, UpdateKind, UpdateAction);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoOnUpdateError(DS, E, UpdateKind, UpdateAction);
	end;


procedure TDataSorcerer.DoOnEditError(DS: TDataSet; E: EDatabaseError; var Action: TDataAction);
	var
	i: integer;
	begin
	if Assigned(FOnEditError) then
		FOnEditError(DS, E, Action);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoOnEditError(DS, E, Action);
	end;


procedure TDataSorcerer.DoOnPostError(DS: TDataSet; E: EDatabaseError; var Action: TDataAction);
	var
	i: integer;
	begin
	if Assigned(FOnPostError) then
		FOnPostError(DS, E, Action);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoOnPostError(DS, E, Action);
	end;


procedure TDataSorcerer.DoOnDeleteError(DS: TDataSet; E: EDatabaseError; var Action: TDataAction);
	var
	i: integer;
	begin
	if Assigned(FOnDeleteError) then
		FOnDeleteError(DS, E, Action);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoOnDeleteError(DS, E, Action);
	end;
{$ENDIF}


{$IFDEF INFPWR}
{// TwwTable Emulation ////////////////////////////////////////////////////////}
{$IFNDEF IP3}
function TDataSorcerer.GetInSetToIndexMethod: boolean;
	begin
	Result := False;
	if FSetType = dtwwTable then
		Result := FwwTable.InSetToIndexMethod
	else
		SorcError(SorcErrInfPwr);
	end;
{$ENDIF}


function TDataSorcerer.GetlookupTables: TList;
	begin
	Result := nil;
	if FSetType = dtwwTable then
		Result := FwwTable.LookupTables
	else
		SorcError(SorcErrInfPwr);
	end;


function TDataSorcerer.isSequencable: boolean;
	begin
	Result := FwwTable.isSequencable;
	end;


function TDataSorcerer.IndexToFields(aIndexName: string): string;
	begin
	Result := FwwTable.IndexToFields(aIndexName);
	end;


function TDataSorcerer.FieldsToIndex(aIndexFields: string): string;
	begin
	Result := FwwTable.FieldsToIndex(AIndexFields);
	end;


function TDataSorcerer.GetDBPicture(curFieldName: string): string;
	begin
	Result := FwwTable.GetDBPicture(curFieldName);
	end;


procedure TDataSorcerer.RefreshLinks;
	begin
	FwwTable.RefreshLinks;
	end;


procedure TDataSorcerer.UpdateIndexes;
	begin
	FwwTable.UpdateIndexes;
	end;


procedure TDataSorcerer.RemoveObsoleteLinks;
	begin
	case FSetType of
		dtwwTable:
			FwwTable.RemoveObsoleteLinks;
		dtwwQuery:
			FwwQuery.RemoveObsoleteLinks;
		dtwwQBE:
			FwwQBE.RemoveObsoleteLinks;
		else
			SorcError(SorcErrInfPwr);
		end;
	end;


procedure TDataSorcerer.syncSQLTable(lookupTable: TwwTable);
	begin
	FwwTable.syncSQLTable(lookupTable);
	end;


procedure TDataSorcerer.FreeLookupTables;
	begin
	case FSetType of
		dtwwTable:
			FwwTable.FreeLookupTables;
		dtwwQuery:
			FwwQuery.FreeLookupTables;
		dtwwQBE:
			FwwQBE.FreeLookupTables;
		else
			SorcError(SorcErrInfPwr);
		end;
	end;


procedure TDataSorcerer.wwChangeIndex(a_indexItem: TIndexDef);
	begin
	FwwTable.wwChangeIndex(a_indexItem);
	end;


procedure TDataSorcerer.wwChangeIndexName(a_indexName: string);
	begin
	FwwTable.wwChangeIndexName(a_IndexName);
	end;


procedure TDataSorcerer.addDependentTablePtr(a_value: PtrBoolean);
	begin
	FwwTable.addDependentTablePtr(a_value);
	end;


procedure TDataSorcerer.removeDependentTablePtr(a_value: PtrBoolean);
	begin
	FwwTable.removeDependentTablePtr(a_value);
	end;


procedure TDataSorcerer.wwSetRangeStart(const startValues: Array of Const);
	begin
	FwwTable.wwSetRangeStart(startValues);
	end;


function TDataSorcerer.GetIndexFieldName: string;
	begin
	Result := '';
	if FSetType = dtwwTable then
		Result := FwwTable.IndexFieldName
	else
		SorcError(SorcErrInfPwr);
	end;


procedure TDataSorcerer.SetIndexFieldName(IndexFieldName: string);
	begin
	if FSetType = dtwwTable then
		FwwTable.IndexFieldName := IndexFieldName
	else
		SorcError(SorcErrInfPwr);
	end;


function TDataSorcerer.IsValidField(fieldName : string): boolean;
	begin
	Result := False;
	case FSetType of
		dtwwTable:
			Result := FwwTable.IsValidField(fieldName);
		dtwwQuery:
			Result := FwwQuery.IsValidField(fieldName);
		dtwwQBE:
			Result := FwwQBE.IsValidField(fieldName);
		else
			SorcError(SorcErrInfPwr);
		end;
	end;


function TDataSorcerer.setToIndexContainingFields(selected: TStrings): boolean;
	begin
	Result := FwwTable.setToIndexContainingFields(selected);
	end;


function TDataSorcerer.setToIndexContainingField(selected: string): boolean;
	begin
	Result := FwwTable.setToIndexContainingField(selected);
	end;


function TDataSorcerer.wwFindNearest(key: string; FieldNo: integer): boolean;
	begin
	Result := FwwTable.wwFindNearest(key, FieldNo);
	end;


function TDataSorcerer.wwFindKey(const KeyValues: array of Const): Boolean;
	begin
	Result := FwwTable.wwFindKey(KeyValues);
	end;


function TDataSorcerer.Pack(var statusMsg: string): boolean;
	begin
	Result := FwwTable.Pack(statusMsg);
	end;


function TDataSorcerer.SetFilter(sel: string): boolean;
	begin
	Result := FwwTable.SetFilter(sel);
	end;


function TDataSorcerer.FilterString: string;
	begin
	Result := FwwTable.FilterString;
	end;


function TDataSorcerer.isParadoxTable: boolean;
	begin
	Result := FwwTable.isParadoxTable;
	end;


function TDataSorcerer.isDBaseTable: boolean;
	begin
	Result := FwwTable.isDBaseTable;
	end;


function TDataSorcerer.FilterActivate: boolean;
	begin
	Result := FwwTable.FilterActivate;
	end;


function TDataSorcerer.wwFilterField(AFieldName: string): TParam;
	begin
	Result := FwwTable.wwFilterField(AFieldName);
	end;


function TDataSorcerer.GetFilterCount: longint;
	begin
	Result := FwwTable.FilterCount;
	end;


function TDataSorcerer.wwFindRecord(KeyValue: string; LookupField: string; MatchType: TwwLocateMatchType;
									caseSensitive: boolean): boolean;
	begin
	Result := FwwTable.wwFindRecord(KeyValue, LookupField, MatchType, caseSensitive);
	end;


{// TwwTable Published Properties /////////////////////////////////////////////}
function TDataSorcerer.GetQuery: TStrings;
	begin
	if FSetType = dtwwTable then
		Result := FwwTable.Query
	else
		Result := FEmptyStrings;
	end;


procedure TDataSorcerer.SetQuery(Qry: TStrings);
	begin
	if FSetType = dtwwTable then
		FwwTable.Query := Qry;
	end;


function TDataSorcerer.GetValidateWithMask: boolean;
	begin
	if FSetType = dtwwTable then
		Result := FwwTable.ValidateWithMask
	else
		Result := False;
	end;


procedure TDataSorcerer.SetValidateWithMask(Flag: boolean);
	begin
	if FSetType = dtwwTable then
		FwwTable.ValidateWithMask := Flag;
	end;


procedure TDataSorcerer.SetPictureMasks(PictureMask: TStrings);
	begin
	case FSetType of
		dtwwTable:
			FwwTable.PictureMasks := PictureMask;
		dtwwQuery:
			FwwQuery.PictureMasks := PictureMask;
		dtwwQBE:
			FwwQBE.PictureMasks := PictureMask;
		end;
	end;



procedure TDataSorcerer.SetLookupFields(Value: TStrings);
	begin
	case FSetType of
		dtwwTable:
			FwwTable.LookupFields := Value;
		dtwwQuery:
			FwwQuery.LookupFields := Value;
		dtwwQBE:
			FwwQBE.LookupFields := Value;
		end;
	end;


procedure TDataSorcerer.SetLookupLinks(Value: TStrings);
	begin
	case FSetType of
		dtwwTable:
			FwwTable.LookupLinks := Value;
		dtwwQuery:
			FwwQuery.LookupLinks := Value;
		dtwwQBE:
			FwwQBE.LookupLinks := Value;
		end;
	end;


procedure TDataSorcerer.SetControltype(Value: TStrings);
	begin
	case FSetType of
		dtwwTable:
			FwwTable.ControlType := Value;
		dtwwQuery:
			FwwQuery.ControlType := Value;
		dtwwQBE:
			FwwQBE.ControlType := Value;
		end;
	end;


procedure TDataSorcerer.SetFilt(Value: TStrings);
	begin
	if FSetType = dtwwTable then
		FwwTable.wwFilter := Value;
	end;


procedure TDataSorcerer.SetSyncSQLByRange(Value: boolean);
	begin
	if FSetType = dtwwTable then
		FwwTable.SyncSQLByRange := Value;
	end;


procedure TDataSorcerer.SetNarrowSearch(Value: boolean);
	begin
	if FSetType = dtwwTable then
		FwwTable.NarrowSearch := Value;
	end;


procedure TDataSorcerer.SetOnInvalidValue(Value: TwwInvalidValueEvent);
	begin
	FOnInvalidValue := Value;
	if FSetType = dtwwTable then
		TwwTable(inherited DataSet).OnInvalidValue := DoOnInvalidValue;
	end;


procedure TDataSorcerer.SetOnFilter(Value: TwwTableFilterEvent);
	begin
	FOnFilter := Value;
	if FSetType = dtwwTable then
		TwwTable(inherited DataSet).OnFilter := DoOnFilter;
	end;


function TDataSorcerer.GetPictureMasks: TStrings;
	begin
	Result := FEmptyStrings;
	case FSetType of
		dtwwTable:
			Result := FwwTable.PictureMasks;
		dtwwQuery:
			Result := FwwQuery.PictureMasks;
		dtwwQBE:
			Result := FwwQBE.PictureMasks;
		end;
	end;


function TDataSorcerer.GetLookupFields: TStrings;
	begin
	Result := FEmptyStrings;
	case FSetType of
		dtwwTable:
			Result := FwwTable.LookupFields;
		dtwwQuery:
			Result := FwwQuery.LookupFields;
		dtwwQBE:
			Result := FwwQBE.LookupFields;
		end;
	end;


function TDataSorcerer.GetLookupLinks: TStrings;
	begin
	Result := FEmptyStrings;
	case FSetType of
		dtwwTable:
			Result := FwwTable.LookupLinks;
		dtwwQuery:
			Result := FwwQuery.LookupLinks;
		dtwwQBE:
			Result := FwwQBE.LookupLinks;
		end;
	end;


function TDataSorcerer.GetControlType: TStrings;
	begin
	Result := FEmptyStrings;
	case FSetType of
		dtwwTable:
			Result := FwwTable.ControlType;
		dtwwQuery:
			Result := FwwQuery.ControlType;
		dtwwQBE:
			Result := FwwQBE.ControlType;
		end;
	end;


function TDataSorcerer.GetFilt: TStrings;
	begin
	if FSetType = dtwwTable then
		Result := FwwTable.wwFilter
	else
		Result := FEmptyStrings;
	end;


function TDataSorcerer.GetSyncSQLByRange: boolean;
	begin
	if FSetType = dtwwTable then
		Result := FwwTable.SyncSQLByRange
	else
		Result := False;
	end;


function TDataSorcerer.GetNarrowSearch: boolean;
	begin
	if FSetType = dtwwTable then
		Result := FwwTable.NarrowSearch
	else
		Result := False;
	end;


{// TwwTable Events ///////////////////////////////////////////////////////////}
{$IFDEF IP3}
procedure TDataSorcerer.DoOnFilter(table: TwwTable; var accept: Boolean);
	var
	i: integer;
	begin
	accept := True;
	if Assigned(FOnFilter) then
		FOnFilter(table, accept);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			if accept then
        FApprentice[i].DoOnFilter(table, accept);
	end;
{$ELSE}
function TDataSorcerer.DoOnFilter(table: TwwTable): boolean;
	var
	i: integer;
	begin
	Result := True;
	if Assigned(FOnFilter) then
		Result := FOnFilter(table);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			Result := Result and FApprentice[i].DoOnFilter(table);
	end;
{$ENDIF}


procedure TDataSorcerer.DoOnInvalidValue(DataSet: TDataSet; Field: TField);
	var
	i: integer;
	begin
	if Assigned(FOnInvalidValue) then
		FOnInvalidValue(DataSet, Field);
	if FAbility = Sorcerer then
		for i := 0 to FApprentices do
			FApprentice[i].DoOnInvalidValue(DataSet, Field);
	end;


{// TwwQuery Emulation ////////////////////////////////////////////////////////}
function TDataSorcerer.SaveAnswerTable(tableName: string): boolean;
	begin
	Result := False;
	case FSetType of
		dtwwQuery:
			Result := FwwQuery.SaveAnswerTable(tableName);
		dtwwQBE:
			Result := FwwQBE.SaveAnswerTable(tableName);
		else
			SorcError(SorcErrwwQryQBE);
		end;
	end;


{// TwwQuery Properties ///////////////////////////////////////////////////////}
procedure TDataSorcerer.SetAnswerTable(Value: string);
	begin
	case FSetType of
		dtwwQuery:
			FwwQuery.AnswerTable := Value;
		dtwwQBE:
			FwwQBE.AnswerTable := Value;
		end;
	end;


function TDataSorcerer.GetAnswerTable: string;
	begin
	case FSetType of
		dtwwQuery:
			Result := FwwQuery.AnswerTable;
		dtwwQBE:
			Result := FwwQBE.AnswerTable;
		else
			Result := '';
		end;
	end;


{// TwwQBE Emulation //////////////////////////////////////////////////////////}
function TDataSorcerer.GetParam(paramName: string): string;
	begin
	Result := FwwQBE.GetParam(paramName);
	end;


procedure TDataSorcerer.SetParam(paramName: string; paramValue: string);
	begin
	FwwQBE.SetParam(paramName, paramValue);
	end;


procedure TDataSorcerer.ClearParams;
	begin
	FwwQBE.ClearParams;
	end;


{// TwwQBE Published Properties ///////////////////////////////////////////////}
procedure TDataSorcerer.SetQBE(Value: TStrings);
	begin
	if FSetType = dtwwQBE then
		FwwQBE.QBE := Value;
	end;


procedure TDataSorcerer.SetAuxiliaryTables(Value: boolean);
	begin
	if FSetType = dtwwQBE then
		FwwQBE.AuxiliaryTables := Value;
	end;


procedure TDataSorcerer.SetBlankAsZero(Value: boolean);
	begin
	if FSetType = dtwwQBE then
		FwwQBE.BlankAsZero := Value;
	end;


function TDataSorcerer.GetQBE: TStrings;
	begin
	if FSetType = dtwwQBE then
		Result := FwwQBE.QBE
	else
		Result := FEmptyStrings;
	end;


function TDataSorcerer.GetAuxiliaryTables: boolean;
	begin
	if FSetType = dtwwQBE then
		Result := FwwQBE.AuxiliaryTables
	else
		Result := False;
	end;


function TDataSorcerer.GetBlankAsZero: boolean;
	begin
	if FSetType = dtwwQBE then
		Result := FwwQBE.BlankAsZero
	else
		Result := False;
	end;
{$ENDIF}


{// Trap Property Functions ///////////////////////////////////////////////////}
function TDataSorcerer.GetEMessage: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEMessage
	else
		Result := FEMessage;
	end;


function TDataSorcerer.GetEToken: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEToken
	else
		Result := FEToken;
	end;


function TDataSorcerer.GetETableName: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FETableName
	else
		Result := FETableName;
	end;


function TDataSorcerer.GetEFieldName: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEFieldName
	else
		Result := FEFieldName;
	end;


function TDataSorcerer.GetEImageRow: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEImageRow
	else
		Result := FEImageRow;
	end;


function TDataSorcerer.GetEUserName: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEUserName
	else
		Result := FEUserName;
	end;


function TDataSorcerer.GetEFileName: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEFileName
	else
		Result := FEFileName;
	end;


function TDataSorcerer.GetEIndexName: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEIndexName
	else
		Result := FEIndexName;
	end;


function TDataSorcerer.GetEDirName: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEDirName
	else
		Result := FEDirName;
	end;


function TDataSorcerer.GetEKeyName: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEKeyName
	else
		Result := FEKeyName;
	end;


function TDataSorcerer.GetEAlias: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEAlias
	else
		Result := FEAlias;
	end;


function TDataSorcerer.GetEDriveName: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEDriveName
	else
		Result := FEDriveName;
	end;


function TDataSorcerer.GetENativeCode: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FENativeCode
	else
		Result := FENativeCode;
	end;


function TDataSorcerer.GetENativeMsg: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FENativeMsg
	else
		Result := FENativeMsg;
	end;


function TDataSorcerer.GetELineNumber: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FELineNumber
	else
		Result := FELineNumber;
	end;


function TDataSorcerer.GetECapability: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FECapability
	else
		Result := FECapability;
	end;


function TDataSorcerer.GetEFieldDisplayName: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEFieldDisplayName
	else
		Result := FEFieldDisplayName;
	end;


function TDataSorcerer.GetEFieldNo: integer;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEFieldNo
	else
		Result := FEFieldNo;
	end;


function TDataSorcerer.GetEField: TField;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEField
	else
		Result := FEField;
	end;


function TDataSorcerer.GetEFieldMinValue: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEFieldMinValue
	else
		Result := FEFieldMinValue;
	end;


function TDataSorcerer.GetEFieldMaxValue: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEFieldMaxValue
	else
		Result := FEFieldMaxValue;
	end;


function TDataSorcerer.GetEFieldDefValue: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEFieldDefValue
	else
		Result := FEFieldDefValue;
	end;


function TDataSorcerer.GetEFieldRequired: boolean;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEFieldRequired
	else
		Result := FEFieldRequired;
	end;


{$IFDEF WIN32}
function TDataSorcerer.GetECDRName: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FECDRName
	else
		Result := FECDRName;
	end;


function TDataSorcerer.GetEUserErrMsg: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEUserErrMsg
	else
		Result := FEUserErrMsg;
	end;


function TDataSorcerer.GetEInternalLimit: string;
	begin
	if (FAbility = Apprentice) and Exists(FSorcerer) then
		Result := FSorcerer.FEInternalLimit
	else
		Result := FEInternalLimit;
	end;
{$ENDIF}


procedure TDataSorcerer.GetEFieldDetails;
	var
	i: integer;
	begin
	FEFieldNo := -1;
	FEField := nil;
	FEFieldDisplayName := '';
	if FEFieldName <> '' then
		for i := 0 to (inherited DataSet.FieldCount - 1) do
			if (inherited DataSet.Fields[i].FieldName = FEFieldName) then
				begin
				FEFieldNo := i;
				break;
				end;
	if FEFieldNo <> -1 then
		begin
		FEField := inherited DataSet.Fields[FEFieldNo];
		FEFieldDisplayName := FEField.DisplayLabel;
		end;
	end;


function TDataSorcerer.StringFromPFV(Ptr: pointer): string;
	var
	PFV: PFakeVariant;
	begin
	Result := '';
	PFV := ptr;
	if FEField is TIntegerField then
		Result := IntToStr(PFV^.Int);
	if FEField is TSmallIntField then
		Result := IntToStr(PFV^.Sml);
	if FEField is TWordField then
		Result := IntToStr(PFV^.Wrd);
	if FEField is TFloatField then
		Result := FloatToStr(PFV^.Flt);
	if FEField is TCurrencyField then
		Result := FloatToStrF(PFV^.Flt, ffCurrency, 15, 2);
	if FEField is TDateTimeField then
		Result := DateTimeToStr(PFV^.Dtm);
	if FEField is TDateField then
		Result := DateToStr(PFV^.Dtm);
	if FEField is TTimeField then
		Result := TimeToStr(PFV^.Dtm);
	end;


procedure TDataSorcerer.GetEFieldValChks;
	var
	VChk: VCHKDesc;
	begin
	FEFieldMinValue := '';
	FEFieldMaxValue := '';
	FEFieldDefValue := '';
	FEFieldRequired := False;
	if GetEValChkDesc(VChk) then
		begin
		if VChk.bHasMinVal then
			FEFieldMinValue := StringFromPFV(@VChk.aMinVal);
		if VChk.bHasMaxVal then
			FEFieldMaxValue := StringFromPFV(@VChk.aMaxVal);
		if VChk.bHasDefVal then
			FEFieldDefValue := StringFromPFV(@VChk.aDefVal);
		FEFieldRequired := VChk.bRequired;
		end;
	end;


function TDataSorcerer.GetEValChkDesc(var ValChk: VCHKDesc): boolean;
	var
	i: integer;
	Props: CURProps;
	begin
	Result := False;
	if FEFieldNo = -1 then
		exit;
	if DbiGetCursorProps(inherited DataSet.Handle, Props) = DBIERR_NONE then
		for i := 1 to Props.iValChecks do
			if (DbiGetVchkDesc(inherited DataSet.Handle, i, @ValChk) = DBIERR_NONE)
				and (ValChk.iFldNum = (FEFieldNo + 1)) then
				begin
				Result := True;
				exit;
				end;
	end;


procedure TDataSorcerer.PushTrap;
	var
	s: StackTrick;
	begin
	if (FAbility <> Sorcerer) or (ComponentState <> []) then
		exit;
	s.Prc := Application.OnException;
	try
		Stack.Insert(0, s.Ptr);
		Application.OnException := SorcException;
	except
		raise EStackException.Create('Stack is full');
		end;
	end;


procedure TDataSorcerer.PopTrap;
	var
	s: StackTrick;
	begin
	if (FAbility <> Sorcerer) or (ComponentState <> []) then
		exit;
	try
		s.Ptr := Stack.Items[0];
		Stack.Delete(0);
		Application.OnException := s.Prc;
	except
		raise EStackException.Create('Stack is empty');
		end;
	end;


{// Termination ///////////////////////////////////////////////////////////////}
procedure Termination; far;
	begin
	FEmptySource.Free;
	FEmptyParams.Free;
	FEmptyStrings.Free;
	SorcererList.Free;
	Stack.free;
	end;


{// Initialization ////////////////////////////////////////////////////////////}
initialization
	begin
	Stack := TStack.Create;
	SorcererList := TStringList.Create;
	FEmptyStrings := TStringList.Create;
	FEmptyParams := TParams.Create;
	FEmptySource := TDataSource.Create(nil);
{$IFNDEF WIN32}
	AddExitProc(Termination);
{$ENDIF}
	Tricky := 'DataSorcerer Copyright  1996-1999 Steve Flynn, All Rights Reserved.'#0#0#0#0;
	CopyrightNotice := StrPas(@Tricky[1]) + #13#13;
{$IFDEF WIN32}
	CopyrightNotice := CopyrightNotice + ' 32Bit';
{$ELSE}
	CopyrightNotice := CopyrightNotice + ' 16Bit';
{$ENDIF}
	CopyrightNotice := CopyrightNotice + ' Version 3.1 ';
{$IFDEF INFPWR}
	CopyrightNotice := CopyrightNotice + '(InfoPower)';
{$ELSE}
	CopyrightNotice := CopyrightNotice + '(Standard)';
{$ENDIF}
	CopyrightNotice := CopyrightNotice + #13#13'By using this Software you agree to be bound to the terms';
	CopyrightNotice := CopyrightNotice + #13'of the License Agreement provided with this Software.';
	end;


{// Finalization //////////////////////////////////////////////////////////////}
{$IFDEF WIN32}
Finalization;
	begin
	Termination;
	end;
{$ENDIF}

end.

