(*
////////////////////////////////////////////////////////////////////////////////
// DATAPROP.PAS : DATASORCERER PROPERTY EDITORS                               //
// Copyright  1996-1999 Steve Flynn. All Rights Reserved                     //
//----------------------------------------------------------------------------//
// By using this source code you agree to be bound by the terms of the        //
// following Software License Agreement. Any breach of this agreement will be //
// prosecuted to the full extent of the law.                                  //
////////////////////////////////////////////////////////////////////////////////

LICENSE AGREEMENT - MARCH 1999

USE OF THE SOFTWARE

Steven M. Flynn (the "Author") grants you, the end user, a non-exclusive
single-user license to use the supplied software program and all associated
materials including the Source Code (the "Software"). The Software and all
Intellectual Property embodied in the Software always remains the property of
the Author. Your use of the Software indicates your acceptance in full of the
terms and conditions of this agreement.


COPYING THE SOFTWARE

You may freely copy the Software provided that such copies do not infringe upon
any other part of this agreement.


DISTRIBUTION OF THE SOFTWARE

The Software may be re-distributed royalty free providing that it is not
modified in any way and that no charge is made for the Software itself. Only a
nominal fee for media and/or copying services is allowed. All files, including
the License Agreement, that are supplied by the Author with the Software must
also be included in any such distribution.


DERIVED WORKS

You may NOT use the Software to derive any works which are based substantially
in part or in full on the Software or any portion of the Software. Any such
derived works will remain the property of the Author.


MODIFIED VERSIONS OF THE SOFTWARE

All updated, revised, modified or improved versions of the Software are also
subject to the conditions of this license agreement and shall remain the
property of the Author. You are required under the terms of this agreement to
submit to the Author any and all improvements or additions made by you to the 
Software for future inclusion in the general distribution of the Software by
the Author.


TERMINATION OF THIS AGREEMENT

You may terminate this License Agreement at any time by destroying all copies
of the Software in your possession.


LIMITED WARRANTY

The Software is distributed and licensed "AS IS". The Author specifically
disclaims all other warranties, express or implied, including but not limited
to, implied warranties of merchantability and fitness for a particular purpose,
with regard to the Software.


DAMAGES

By using the Software you do so at your own risk. In no event shall the Author
be responsible for any damages whatsoever (including but not limited to,
damages for loss of business profits, business interruption, loss of business
information, or any other pecuniary loss or any other real or consequential 
damages) arising out of the use or inability to use this product.


LIABILITY

In the event of failure of the Software, for any reason, the Author's sole
liability shall be to refund to you the amount paid by you to the Author for
the use of the Software.


COPYRIGHT

The Software and the Intellectual Property embodied in the Software shall
always remain the property of the Author and is protected by Australian
Copyright Law and International Treaty Provisions.


AGREEMENT

Your use of the Software indicates your agreement with the above terms and
conditions. If you do not agree with these terms and conditions then you must
destroy all copies of the software in your possession.


CONSUMER RIGHTS

If any clause in the above Software License Agreement is in violation of your
rights under your local laws then you must cease using the Software
immediately. It is your own responsibility to be aware of your legal rights
under your own local laws.


END OF LICENSE AGREEMENT
*)

{$A-,B-,D-,F-,G+,I-,L-,M-,N+,O+,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y-,Z-}
{$IFDEF WIN32}
{$H+,J+}
{$M 16384,1048576}
{$IMAGEBASE $00400000}
{$ELSE}
{$K-}
{$M 16384,8192}
{$ENDIF}
{$C DEMANDLOAD}

{$I DATASORC.INC}

unit DataProp;

interface

uses
	DataSorc;


procedure Register;

implementation

uses
{$IFDEF INFPWR}
	wwcommon, wwTable, wwQuery, wwQBE, wwPrpEdt, wwselFld, Dialogs,
{$ENDIF}
{$IFDEF WIN32}
	DbXplor,
{$ENDIF}
	DSDesign, QBE, QBindDlg, ProcDlg, FldLinks, StrEdit,
	WinTypes, WinProcs, Controls, DB, DBTables, DBConsts, SysUtils,
	Classes, DsgnIntf, Forms;

var
	FEmptyTable: TTable;

type
	Sorc = class(TDataSorcerer);
	SmallString = string[64];

const
	SorcererAbout = 'About DataSorcerer...';


{$IFDEF INFPWR}
{// DataSorcerer wwTable Properties ///////////////////////////////////////////}
type
	TSorcTableDisplayProperty = class(TwwTableDisplayProperty)
		procedure Edit; override;
		end;


procedure GetComponentData(AComponent: TComponent; var ASelected: TStrings; var ADataSet: TDataSet);
	begin
	if AComponent is TwwTable then
		ADataSet:= AComponent as TwwTable
	else
		if AComponent is TwwQuery then
			ADataSet:= AComponent as TwwQuery
		else
			if AComponent is TwwQBE then
				ADataSet:= AComponent as TwwQBE
	end;

{$IFDEF IP3}
function EditSelectedFieldsProperty(ListHandle: TStrings; DataSet: TDataSet;
			Designer: TFormDesigner; ReadFromTableComponent: Boolean;
			var UseTFields: boolean; PropertyType: TwwSelectedPropertyType): boolean;
{$ELSE}
function EditSelectedFieldsProperty(ListHandle: TStrings; DataSet: TDataSet;
			Designer: TFormDesigner; ReadFromTableComponent: Boolean): boolean;
{$ENDIF}
	var
	i: integer;
	CalcString : string[3]; {Yes, No}
	begin
	Result:= False;
	if ReadFromTableComponent then
		begin
		ListHandle.clear;
		with DataSet do
			begin
			if not Active then
				begin
				MessageDlg('DataSet for this component must be active to edit design.', mtInformation, [mbok], 0);
				exit;
				end;
			for i:= 0 to FieldCount - 1 do
				begin
				if (Fields[i].Visible) then
					begin
					if Fields[i].Calculated then
						CalcString:= 'Yes'
					else
						CalcString:= 'No';
					ListHandle.add(Fields[i].FieldName +
									#9 + IntToStr(Fields[i].DisplayWidth) +
									#9 + Fields[i].DisplayLabel +
									#9 + CalcString);
					end
				end;
			end;
		end;
{$IFDEF IP3}
	if wwSelectTableFields(DataSet, ListHandle, UseTFields, Designer, PropertyType) then
		begin
		Designer.Modified;
		wwDataModuleChanged(Dataset);
		if DataSet is TwwTable then
		if TwwTable(Dataset).Query.Count = 0 then
			DataSet.Refresh;
		Result:= True;
	   end
{$ELSE}
	if wwSelectTableFields(DataSet, listHandle, Designer) then
		begin
		Designer.modified;
		if DataSet is TwwTable then
			DataSet.refresh;
		Result:= True;
		end
{$ENDIF}
	end;


procedure TSorcTableDisplayProperty.Edit;
	var
	ListHandle : TStrings;
	DataSet: TDataSet;
{$IFDEF IP3}
	UseTFields: boolean;
{$ENDIF}
	begin
	GetComponentData(Sorc(GetComponent(0)).DataSet, ListHandle, DataSet);
	ListHandle:= TStringList.Create;
	if (DataSet = nil) then
		begin
		MessageDlg('Missing TableName property', mtInformation, [mbOK], 0);
		exit;
		end;
{$IFDEF IP3}
	UseTFields := True;
	if (EditSelectedFieldsProperty(ListHandle, DataSet, Designer, True, UseTFields, sptDataSetType)) then
		wwDataSetUpdateFieldProperties(DataSet, ListHandle);
{$ELSE}
	if (EditSelectedFieldsProperty(ListHandle, DataSet, Designer, True)) then
		wwDataSetUpdateFieldProperties(DataSet, ListHandle);
{$ENDIF}
	ListHandle.free;
	end;
{$ENDIF}


{// TDataSorcererEditor ///////////////////////////////////////////////////////}
type
	TDataSorcererEditor = class(TDefaultEditor)
	public
		procedure ExecuteVerb(Index: Integer); override;
		function GetVerb(Index: Integer): string; override;
		function GetVerbCount: Integer; override;
		end;

procedure TDataSorcererEditor.ExecuteVerb(Index: Integer);
	var
	Query: TQuery;
	SProc: TStoredProc;
	List: TParams;
	ps: array [0..255] of char;
	begin
	case Index of
		0:
			MessageBox(0, StrPCopy(ps, TDataSorcerer.GetCopyright), SorcererAbout, MB_OK);
		1:
			begin
			try
				ShowDatasetDesigner(Designer, TTable(Sorc(Component).FDBDataSet));
			except
				end;
			end;
		2:
			begin
			if (Sorc(Component).DataSetType = dtNone)
				or (Sorc(Component).DataSetType = dtTable)
{$IFDEF INFPWR}
				or (Sorc(Component).DataSetType = dtwwTable)
				or (Sorc(Component).DataSetType = dtwwQBE)
{$ENDIF}
				then
{$IFDEF INFPWR}
				SorcError(SorcErrwwQryProc);
{$ELSE}
				SorcError(SorcErrQryProc);
{$ENDIF}
			if Sorc(Component).DataSetType = dtQuery then
				begin
				try
					Query := Sorc(Component).FQuery;
					List := TParams.Create;
					try
						List.Assign(Query.Params);
						if EditQueryParams(Query, List) then
							begin
							Query.Params := List;
							if Designer <> nil then
								Designer.Modified;
							end;
					finally
						List.Free;
						end;
				except
					end;
				end
			else
				if Sorc(Component).DataSetType = dtStoredProc then
					begin
					try
						SProc := Sorc(Component).FProc;
						List := TParams.Create;
						try
							SProc.CopyParams(List);
							if EditProcParams(SProc, List) then
								begin
								SProc.UnPrepare;
								SProc.Params := List;
								if Designer <> nil then
									Designer.Modified;
								end;
						finally
							List.Free;
							end;
					except
						end;
					end;
			end;
		3:
{$IFDEF WIN32}
			ExploreDataset(Sorc(Component).FDBDataSet);
{$ELSE}
			exit;
{$ENDIF}
		4:
			begin
			Query := Sorc(Component).FQuery;
			ExecBuilder(Query);
			end;
		end;
	end;


function TDataSorcererEditor.GetVerb(Index: Integer): string;
	begin
	case Index of
		0:
			Result := SorcererAbout;
		1:
			Result := LoadStr(SDatasetDesigner);
		2:
			Result := LoadStr(SBindVerb);
		3:
{$IFDEF WIN32}
			Result := LoadStr(SExplore);
{$ELSE}
			Result := '(Only Available in Delphi 2.0)';
{$ENDIF}
		4:
			Result := LoadStr(SQBEVerb);
		end;
	end;


function TDataSorcererEditor.GetVerbCount: Integer;
	begin
	if not VQBLoadAttempted then
		InitVQB;
	if VQBLoaded then
		Result := 5
	else
		Result := 4;
	end;


{// TDummyProperty ////////////////////////////////////////////////////////////}
type
	TDummyProperty = class(TEnumProperty)
	public
		function GetAttributes: TPropertyAttributes; override;
		end;


function TDummyProperty.GetAttributes: TPropertyAttributes;
	begin
	Result := [paReadOnly];
	end;


{// TDBStringProperty /////////////////////////////////////////////////////////}
type
	TDBStringProperty = class(TStringProperty)
	public
		function GetAttributes: TPropertyAttributes; override;
		procedure GetValueList(List: TStrings); virtual; abstract;
		procedure GetValues(Proc: TGetStrProc); override;
		end;


function TDBStringProperty.GetAttributes: TPropertyAttributes;
	begin
	Result := [paValueList, paSortList, paMultiSelect];
	end;


procedure TDBStringProperty.GetValues(Proc: TGetStrProc);
	var
	I: Integer;
	Values: TStringList;
	begin
	Values := TStringList.Create;
	try
		GetValueList(Values);
		for I := 0 to Values.Count - 1 do
			Proc(Values[I]);
	finally
		Values.Free;
		end;
	end;


{// TDBNameProperty /////////////////////////////////////////////////////}
type
	TDBNameProperty = class(TDBStringProperty)
	public
		procedure GetValueList(List: TStrings); override;
		end;


procedure TDBNameProperty.GetValueList(List: TStrings);
	begin
	Session.GetDatabaseNames(List);
	end;


{// TTblNameProperty ////////////////////////////////////////////////////////}
type
	TTblNameProperty = class(TDBStringProperty)
	public
		procedure GetValueList(List: TStrings); override;
		end;

procedure TTblNameProperty.GetValueList(List: TStrings);
	const
	Masks: array[TTableType] of string[5] = ('', '*.DB', '*.DBF', '*.TXT');
	var
	Table: TTable;
	begin
	try
		Table := Sorc(GetComponent(0)).FTable;
		Session.GetTableNames(Table.DatabaseName, Masks[Table.TableType], Table.TableType = ttDefault, False, List);
	except
		end;
	end;


{// TIndxNameProperty ////////////////////////////////////////////////////////}
type
	TIndxNameProperty = class(TDBStringProperty)
	public
		procedure GetValueList(List: TStrings); override;
		end;


procedure TIndxNameProperty.GetValueList(List: TStrings);
	begin
	try
		Sorc(GetComponent(0)).FTable.GetIndexNames(List);
	except
		end;
	end;


{// TProcNameProperty ////////////////////////////////////////////////////}
type
	TProcNameProperty = class(TDBStringProperty)
	public
		procedure GetValueList(List: TStrings); override;
		end;


procedure TProcNameProperty.GetValueList(List: TStrings);
	begin
	try
		Session.GetStoredProcNames(Sorc(GetComponent(0)).FDBDataSet.DatabaseName, List);
	except
		end;
	end;


{// TIndxFieldNamesProperty //////////////////////////////////////////////////}
type
	TIndxFieldNamesProperty = class(TDBStringProperty)
	public
		procedure GetValueList(List: TStrings); override;
		end;


procedure TIndxFieldNamesProperty.GetValueList(List: TStrings);
	var
	i: integer;
	begin
	try
		with Sorc(GetComponent(0)).FTable do
			begin
			IndexDefs.Update;
			for i := 0 to IndexDefs.Count - 1 do
				with IndexDefs[i] do
					if not (ixExpression in Options) then
						List.Add(Fields);
			end;
	except
		end;
	end;


{// TParamsProperty ///////////////////////////////////////////////////////////}
type
	TParamsProperty = class(TPropertyEditor)
	public
		function GetValue: string; override;
		function GetAttributes: TPropertyAttributes; override;
		end;


function TParamsProperty.GetValue: string;
	begin
	Result := Format('(%s)', [TParams.ClassName]);
	end;


function TParamsProperty.GetAttributes: TPropertyAttributes;
	begin
	Result := [paMultiSelect, paDialog];
	end;


{// TEdParamsProperty //////////////////////////////////////////////////////}
type
	TEdParamsProperty = class(TParamsProperty)
		procedure Edit; override;
		end;


procedure TEdParamsProperty.Edit;
	var
	List: TParams;
	Query: TQuery;
	SProc: TStoredProc;
	begin
	List := TParams.Create;
	try
	if (Sorc(GetComponent(0)).DataSetType = dtQuery)
{$IFDEF INFPWR}
		or (Sorc(GetComponent(0)).DataSetType = dtwwQuery)
{$ENDIF}
		then
		begin
		Query := Sorc(GetComponent(0)).FQuery;
		List.Assign(Query.Params);
		if EditQueryParams(Query, List) then
			begin
			Query.Params := List;
			if Designer <> nil then
				Designer.Modified;
			end;
		end
	else
		if Sorc(GetComponent(0)).DataSetType = dtStoredProc then
			begin
			SProc := Sorc(GetComponent(0)).FProc;
			SProc.CopyParams(List);
			if EditProcParams(SProc, List) then
				begin
				SProc.UnPrepare;
				SProc.Params := List;
				if Designer <> nil then
					Designer.Modified;
				end;
			end
		else
			SorcError(SorcErrQryProc);
	finally
		List.Free;
		end;
	end;


{// TMasterFieldsProperty /////////////////////////////////////////////////////}
type
	TMasterFieldsProperty = class(TFieldLinkProperty)
	private
		procedure SorcPropList;

	public
		procedure Initialize; override;
		procedure Activate; override;
		function GetValue: string; override;
		procedure GetValues(Proc: TGetStrProc); override;
		end;

	TSorcPropertyEditor = class
	private
		FDesigner: TFormDesigner;
		FPropList: PInstPropList;
		FPropCount: Integer;
		end;


function TMasterFieldsProperty.GetValue: string;
	begin
	SorcPropList;
	Result := inherited GetValue;
	end;


procedure TMasterFieldsProperty.GetValues(Proc: TGetStrProc);
	begin
	SorcPropList;
	inherited GetValues(Proc);
	end;


procedure TMasterFieldsProperty.SorcPropList;
	var
	i: integer;
	SorcProp: TSorcPropertyEditor;
	begin
	try
		SorcProp := TSorcPropertyEditor(self);
		for i := 0 to PropCount - 1 do
			if (SorcProp.FPropList^[i].Instance <> nil) and (SorcProp.FPropList^[i].Instance is TDataSorcerer) then
				if Sorc(SorcProp.FPropList^[i].Instance).DataSetType <> dtTable then
					SorcProp.FPropList^[i].Instance := FEmptyTable
				else
					SorcProp.FPropList^[i].Instance := Sorc(SorcProp.FPropList^[i].Instance).FTable;
	except
		end;
	end;


procedure TMasterFieldsProperty.Activate;
	begin
	SorcPropList;
	inherited Activate;
	end;


procedure TMasterFieldsProperty.Initialize;
	begin
	inherited Initialize;
	SorcPropList;
	end;


{// TSorcererProperty /////////////////////////////////////////////////////////}
type
	TSorcererProperty = class(TDBStringProperty)
	public
		procedure GetValueList(List: TStrings); override;
		end;


procedure TSorcererProperty.GetValueList(List: TStrings);
	var
	tWnd: HWnd;
	Frm: TForm;
	i: integer;
	AName, CName, OName: string;
	begin
	CName := GetComponent(0).Name;
	OName := GetComponent(0).Owner.Name;
	tWnd := GetWindow(Application.Handle, GW_HWNDFIRST);
	while (tWnd <> 0) do
		begin
		Frm := TForm(FindControl(tWnd));
		if (Frm <> nil) and (Frm is TForm) and (Frm.ComponentCount > 0) and (CompareText(Frm.Name, OName) <> 0) then
			for i := 0 to Frm.ComponentCount - 1 do
				if (Frm.Components[i] is TDataSorcerer)
					and (CompareText(Frm.Components[i].Name, CName) = 0)
					and (TDataSorcerer(Frm.Components[i]).Ability = Sorcerer) then
					begin
					AName := Copy(Frm.ClassName, 2, Length(Frm.ClassName) - 1);
					if List.IndexOf(AName) = -1 then
						List.Add(AName);
					end;
		tWnd := GetWindow(tWnd, GW_HWNDNEXT);
		end;
	end;


{// Registration //////////////////////////////////////////////////////////////}
procedure Register;
	begin
	RegisterPropertyEditor(TypeInfo(TFileName), TDataSorcerer, 'DatabaseName', TDBNameProperty);
	RegisterPropertyEditor(TypeInfo(TFileName), TDataSorcerer, 'TableName', TTblNameProperty);
	RegisterPropertyEditor(TypeInfo(string), TDataSorcerer, 'IndexName', TIndxNameProperty);
	RegisterPropertyEditor(TypeInfo(string), TDataSorcerer, 'IndexFieldNames', TIndxFieldNamesProperty);
	RegisterPropertyEditor(TypeInfo(string), TDataSorcerer, 'MasterFields', TMasterFieldsProperty);
	RegisterPropertyEditor(TypeInfo(string), TDataSorcerer, 'StoredProcName', TProcNameProperty);
	RegisterPropertyEditor(TypeInfo(string), TDataSorcerer, 'SorcererForm', TSorcererProperty);
	RegisterPropertyEditor(TypeInfo(TParams), TDataSorcerer, 'Params', TEdParamsProperty);
	RegisterPropertyEditor(TypeInfo(TAbility), TDataSorcerer, 'Ability', TDummyProperty);
	RegisterPropertyEditor(TypeInfo(TDataSetType), TDataSorcerer, 'DataSetType', TDummyProperty);
	RegisterComponentEditor(TDataSorcerer, TDataSorcererEditor);
{$IFDEF INFPWR}
	RegisterPropertyEditor(TypeInfo(TwwTableDisplayType), TDataSorcerer, 'LookupFields', TSorcTableDisplayProperty);
	RegisterPropertyEditor(TypeInfo(TwwTableDisplayType), TDataSorcerer, 'LookupLinks', TSorcTableDisplayProperty);
	RegisterPropertyEditor(TypeInfo(TwwTableDisplayType), TDataSorcerer, 'ControlType', TSorcTableDisplayProperty);
{$ENDIF}
	end;


{// Termination ///////////////////////////////////////////////////////////////}
procedure Termination; far;
	begin
	FEmptyTable.Free;
	end;


{// Initialization ////////////////////////////////////////////////////////////}
initialization
	begin
	FEmptyTable := TTable.Create(nil);
	FEmptyTable.Name := 'Unassigned';
{$IFNDEF WIN32}
	AddExitProc(Termination);
{$ENDIF}
	end;


{// Finalization //////////////////////////////////////////////////////////////}
{$IFDEF WIN32}
Finalization;
	begin
	Termination;
	end;
{$ENDIF}

end.

