unit Memoform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Menus, Buttons, ExtCtrls;

type
  TFieldAssign = class(TForm)
    ConvFields: TMemo;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Load1: TMenuItem;
    Save1: TMenuItem;
    Exit1: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Cancel1: TMenuItem;
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure Save1Click(Sender: TObject);
    procedure Load1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Cancel1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FieldAssign: TFieldAssign;

implementation

uses dbftosql, progform;

{$R *.DFM}

procedure TFieldAssign.Save1Click(Sender: TObject);
begin
   SaveDialog1.Execute;
   if SaveDialog1.FileName > '' then
     ConvFields.Lines.SaveToFile(SaveDialog1.FileName);
end;

procedure TFieldAssign.Load1Click(Sender: TObject);
begin
   OpenDialog1.Execute;
   if OpenDialog1.FileName > '' then
     ConvFields.Lines.LoadFromFile(OpenDialog1.FileName);
end;

procedure TFieldAssign.Exit1Click(Sender: TObject);
begin
   ModalResult := IDOK;
end;

procedure TFieldAssign.Cancel1Click(Sender: TObject);
begin
   ModalResult := IDCANCEL;
end;

procedure TFieldAssign.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
   ModalResult := IDCancel;
end;

procedure TFieldAssign.BitBtn1Click(Sender: TObject);
var lastcount, ProcCount, ChangeCount, KeyCount, ConvCount : longint;
   text : string;
begin

   with Dbf2Sql do begin

      DestTable.Active := False;

      Dbf2Sql.Abort := False;

      DestTable.TableName := DestTableName.Text;

      try
         chdir( DestPath.Text );
      except
         Application.HandleException( self );
      end;

      DestDataBase.Connected := True;

      ConvForm.Gauge1.MinValue := 0;
      ConvForm.Gauge1.MaxValue := SrcTable.RecordCount;

      str( SrcTable.RecordCount : 8, text );
      ConvForm.TotalCount.Caption := text;

      ConvForm.Gauge1.Progress := 0;

      BatchMove.Mappings := FieldAssign.ConvFields.Lines;

   { The 50 in the following line means it will do 2% at a time.
     For better speed, this can be changed to a lower number, OR
     BatchMove.RecordCount can be assigned to 0 - that way it will
     convert the whole table at once. }

      BatchMove.RecordCount := trunc(ConvForm.Gauge1.MaxValue / 50);

      if BatchMove.RecordCount < 5 then
         BatchMove.RecordCount := 5;

      ConvForm.BitBtn1.Caption := 'Abort';

      LastCount := 1;
      ProcCount := 0;
      ChangeCount := 0;
      Keycount := 0;
      ConvCount := 0;

      ConvForm.Show;

      try

         while (LastCount > 0) and not (SrcTable.EOF) and not (dbf2sql.abort) do begin

            DestTable.Active := False;

            BatchMove.Execute;

            LastCount := BatchMove.MovedCount;

            ProcCount := ProcCount + LastCount;
            ChangeCount := ChangeCount + BatchMove.ChangedCount;
            KeyCount := KeyCount + BatchMove.KeyViolCount;
            ConvCount := ConvCount + BatchMove.ProblemCount;

            str( ProcCount : 8, text );
            ConvForm.ProcCount.Caption := text;

            str( KeyCount : 8, text );
            ConvForm.KeyCount.Caption := text;

            str( ConvCount : 8, text );
            ConvForm.ConvCount.Caption := text;

            ConvForm.Gauge1.Progress := ConvForm.Gauge1.Progress + lastCount;

            ConvForm.ConvCount.Refresh;
            ConvForm.KeyCount.Refresh;
            ConvForm.ProcCount.Refresh;
            ConvForm.Gauge1.Refresh;

            SrcTable.MoveBy(LastCount);
            Application.ProcessMessages;

         end;

      except

         Application.HandleException( self );

      end;

      ConvForm.BitBtn1.Caption := 'Done';

      if dbf2sql.abort then
         ShowMessage('Conversion Aborted!');

      ConvForm.Hide;
      ConvForm.ShowModal;
   end;

end;

end.
