{ TTrayIcon Component for Delphi 1 !
  requires Windows95 for function
  written by Bauer Karl (c)1998}

{Version 2.0}

unit TrayIcon;

interface

uses
  WinTypes, WinProcs, Messages, Dialogs,
  Classes, Graphics, Controls, Forms, SysUtils;

const
 WM_TRAYICON = WM_USER+1;

{ Tray notification definitions }
const
  NIM_ADD         = $00000000;
  NIM_MODIFY      = $00000001;
  NIM_DELETE      = $00000002;

  NIF_MESSAGE     = $00000001;
  NIF_ICON        = $00000002;
  NIF_TIP         = $00000004;

type
 TNotifyIconData = record
   cbSize: Longint;
   Wnd: Longint;
   uID: Longint;
   uFlags: Longint;
   uCallbackMessage: Longint;
   hIcon: Longint;
   szTip: array [0..63] of Char;
  end;
PNotifyIconData=^TNotifyIconData;

type
  TTrayIcon = class(TComponent)
  private
    {Field variables}
    tnid: TNOTIFYICONDATA;
    fActive: boolean;
    fIcon: TIcon;
    fTip: string;
    fTrayIconID: Longint;
    fOnClick: TNotifyEvent;
    fOnDblClick: TNotifyEvent;
    fOnRightClick: TMouseEvent;
    fOnRightDblClick: TNotifyEvent;
    procedure SetActive(Value : boolean);
    procedure SetIcon(Value : TIcon);
    procedure SetTip(Value : String);
    procedure SetTrayIconID(Value : Longint);
    procedure WndProc(var msg : TMessage);
  protected
  public
    constructor Create(aOwner : TComponent); override;
    destructor Destroy; override;
    function MakeIcon(sender : TObject) : boolean;
    function KillIcon(sender : TObject) : boolean;
    function ChangeIcon(Sender : TObject) : boolean;
  published
    property Enabled: boolean read fActive write SetActive;
    property Icon: TIcon read fIcon write SetIcon;
    property Tip: string read fTip write SetTip;
    property TrayIconID: Longint read fTrayIconID write SetTrayIconID;
    property OnClick: TNotifyEvent read FOnClick write FOnClick;
    property OnDblClick: TNotifyEvent read FOnDblClick write FOnDblClick;
    property OnRightClick: TMouseEvent  read FOnRightClick write FonRightClick;
    property OnRightDblClick: TNotifyEvent read fOnRightDblClick
                                                write fOnRightDblClick;
  end;

type
  TShellAbout32 = class(TComponent)
  private
    fCaption, fText: String;
    fIcon: TIcon;
    fOnShow, fOnDestroy: TNotifyEvent;
    procedure SetDlgText(Value : String);
    procedure SetDlgCaption(Value : String);
    procedure SetDlgIcon(Value : TIcon);
  protected
  public
    constructor Create(aOwner : TComponent); override;
    destructor Destroy; override;
    procedure Execute;
  published
    property Icon: TIcon read fIcon write SetDlgIcon;
    property DlgCaption: String read fCaption write SetDlgCaption;
    property DlgText: String read fText write SetDlgText;
    property OnShow: TNotifyEvent read FOnShow write FOnShow;
    property OnDestroy: TNotifyEvent read FOnDestroy write FOnDestroy;
  end;

procedure Register;

var
 id_Shell_NotifyIconW32,
 id_ShellAboutW32: Longint;

ShellAboutW32: function(hWnd: Longint; szApp, szOtherStuff: PChar;
  Icon, id: Longint): Longint;

Shell_NotifyIconW32: function(dwMessage: Longint;
      lpData: PNotifyIconData; id: Longint): LongBool;

implementation

uses Call32NT;

function TTrayIcon.MakeIcon(sender : TObject) : boolean;
begin
 with tnid do
  begin
   cbSize := sizeof(TNOTIFYICONDATA);
   wnd := AllocateHWnd(WndProc);
   uID := fTrayIconID;
   uFlags := NIF_MESSAGE+NIF_ICON+NIF_TIP;
   hIcon := fIcon.Handle;
   StrPCopy(szTip, fTip);
   uCallbackMessage := WM_TrayIcon;
   result := Shell_NotifyIconW32(NIM_ADD,@tnid, id_Shell_NotifyIconW32);
  end;
end;

function TTrayIcon.ChangeIcon(sender : TObject) : boolean;
var tnid : TNOTIFYICONDATA;
begin
 with tnid do
  begin
   cbSize := sizeof(TNOTIFYICONDATA);
   wnd := AllocateHWnd(WndProc);
   uID := fTrayIconID;
   uFlags := NIF_MESSAGE+NIF_ICON+NIF_TIP;
   hIcon := fIcon.Handle;
   StrPCopy(szTip, fTip);
   uCallbackMessage := WM_TrayIcon;
  end;
  result := Shell_NotifyIconW32(NIM_MODIFY,@tnid, id_Shell_NotifyIconW32);
end;

function TTrayIcon.KillIcon(sender : Tobject) : boolean;
begin
 DeAllocateHWnd(tnid.wnd);
 result := Shell_NotifyIconW32(NIM_DELETE,@tnid, id_Shell_NotifyIconW32);
end;

procedure TTrayIcon.SetActive(Value : boolean);
begin
  if value <> fActive then
  begin
   if Value = true then
   begin
    if MakeIcon(self) then
     fActive := true
   end
   else if KillIcon(self) then
   FActive := false;
  end;
end;

procedure TTrayIcon.SetIcon(Value : Ticon);
begin
 if Value <> fIcon then
  begin
   fIcon.Assign(value);
   if fActive = true then CHangeIcon(Self);
  end;
end;

procedure TTrayIcon.SetTip(Value : String);
begin
fTip:=Value;
end;

procedure TTrayIcon.SetTrayIconID(Value : Longint);
begin
 if Value <> fTrayIconID then
  begin
   fTrayIconID := value;
   if fActive = true then ChangeIcon(Self);
  end;
end;

procedure TTrayIcon.WndProc(var msg : TMessage);
var MouseCo: Tpoint;
begin
 with msg do begin
  if (msg = WM_QUERYENDSESSION) then SetActive(False);
  if (msg = WM_TrayIcon) then begin
  case lParam of
  WM_LBUTTONDBLCLK : if assigned (FOnDblClick) then FOnDblClick(self);
  WM_LBUTTONUP     : if assigned (FOnClick) then FOnClick(self);
  WM_RBUTTONDBLCLK : if assigned (fOnRightDblClick) then fOnRightDblClick(self);
  WM_RBUTTONUP     : if assigned (FOnRightClick) then
                          begin
                           GetCursorPos(MouseCo);
                           FOnRightClick(self,mbRight,[],MouseCo.x,MouseCo.y);
                          end;

end;
end;
end;
end;

constructor TTrayIcon.Create(aOwner : Tcomponent);
begin
 inherited create(aOwner);
 FIcon := TIcon.Create;
end;


destructor TTrayIcon.Destroy;
begin
 if fActive = true then SetActive(False);
 FIcon.Free;
 inherited destroy;
end;


{==================================================================}
constructor TShellAbout32.Create(aOwner : Tcomponent);
begin
 inherited create(aOwner);
 FIcon := TIcon.Create;
end;


destructor TShellAbout32.Destroy;
begin
 FIcon.Free;
 inherited destroy;
end;

procedure TShellAbout32.SetDlgCaption(Value : String);
begin
 fCaption:=Value;
end;

procedure TShellAbout32.SetDlgText(Value : String);
begin
 fText:=Value;
end;

procedure TShellAbout32.SetDlgIcon(Value : TIcon);
begin
 fIcon.Assign(value);
end;

procedure TShellAbout32.Execute;
var
  CapT, TTx: array[0..79] of Char;
begin
 if assigned (FOnShow) then FOnShow(self);
if csDesigning in ComponentState then
   ShowMessage('The Shell About Box cant Show at Design time') else begin
     StrPCopy(CapT, fCaption);
     StrPCopy(TTx, fText);
ShellAboutW32(Application.Handle, CapT, TTx,
 fIcon.Handle, id_ShellAboutW32);
  end;
 if assigned (FOnDestroy) then FOnDestroy(self);
end;


procedure Register;
begin
 RegisterComponents('Win95', [TTrayIcon]);
 RegisterComponents('Win95', [TShellAbout32]);
end;

begin
@ShellAboutW32:=@Call32;
@Shell_NotifyIconW32:=@Call32;
id_ShellAboutW32:=Declare32('ShellAbout', 'shell32', 'wppi');
id_Shell_NotifyIconW32:=Declare32('Shell_NotifyIcon', 'shell32', 'ip');
end.

