unit Parento2;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Grids, Outline;

type
  TFrmInfo = class(TForm)
    OutlineParent: TOutline;
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    BtnExpand: TBitBtn;
    BtnCollapse: TBitBtn;
    procedure OutlineParentDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure BtnExpandClick(Sender: TObject);
    procedure BtnCollapseClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmInfo: TFrmInfo;

implementation

{$R *.DFM}

procedure TFrmInfo.OutlineParentDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  Bitmap: TBitmap;
  bmpptr : pointer;
  offs : integer;

begin
  if index = 0 then exit;
  with (Control as TOutline).Canvas do	begin
    FillRect(Rect);
    bmpptr := OutlineParent.items[Index].data;
    offs := 5;
    if (bmpptr <> nil) then begin
      Bitmap := TBitmap(bmpptr);
      draw( (Rect.Left), (Rect.Top), bitmap);
      offs := (bitmap.width+5);
    end;
    TextOut((Rect.Left + offs), (Rect.Top + 2), OutlineParent[Index].text);
  end;
end;

procedure TFrmInfo.BtnExpandClick(Sender: TObject);
begin
  OutlineParent.fullexpand
end;

procedure TFrmInfo.BtnCollapseClick(Sender: TObject);
begin
OutlineParent.fullcollapse;
end;

end.
