unit Cfrminfo;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, buttons, TabNotBk, outline, extctrls;

type
 { tintctrls = (tgrphcontrols, twincontrols, tdatasets, tdatasources, tfields);}
  tComponentAllocRec = record
    posn : integer;
    spare : byte;
    allocated : boolean;
  end;

  tCybFrmInfo = class(TControl)
  private
    { Private declarations }
   fwincontrolist : tlist;
   alloced : integer;

  protected
    { Protected declarations }
   constructor Create(AOwner: TComponent); override;
   destructor Destroy; override;
   function oktoproceed : boolean;
   Procedure HandleTabbedNoteBook(outlinendx, ctrlndx : integer);
   Procedure HandleNoteBook(outlinendx, ctrlndx : integer);
   FUNCTION AddNode(addoutline : toutline; outlinendx : integer;
                    ctrl : twincontrol; bmpname : string;addaschild : boolean) : integer;
   Procedure AddControlsForParent ( Parentindex :integer; SearchParent : tWinControl);
   function NodeID(ctrl : twincontrol) : string;
   procedure AllocControl(Parentindex,ndx : integer;var ComponentAllocRec :tComponentAllocRec; acontrol : twincontrol);

   Property wincontrolist : tlist Read fwincontrolist Write fwincontrolist;

  public
    { Public declarations }
   Procedure DoWinControls;
   Procedure categorisecontrols;

  published
    { Published declarations }

  end;

var
  CybFrmInfo : tCybFrmInfo;

procedure showparentage(ctrl : twincontrol);

implementation

uses
  Parento2;

procedure showparentage(ctrl : twincontrol);

Begin
  CybFrmInfo := tCybFrmInfo.create(application);
  with CybFrmInfo DO BEGIN
try
    parent := ctrl;
    categorisecontrols;
    DoWinControls;
    frminfo.caption := 'Parentage for '+nodeid(ctrl);
    frminfo.outlineparent.fullexpand;
    FrmInfo.SHOWMODAL;
finally
    free;
end;
  END;
End;

constructor tCybFrmInfo.Create(AOwner: TComponent);

Begin
   inherited Create(AOwner);
   fwincontrolist := tlist.create;
   FrmInfo := TFrmInfo.create(self);
   alloced := 0;
End;

destructor tCybFrmInfo.Destroy;

Begin
   fwincontrolist.free;
   FrmInfo.free;
   inherited Destroy;
End;

function tCybFrmInfo.oktoproceed : boolean;

Begin
  result := (Parent <> nil) and (parent is twincontrol);
End;


Procedure tCybFrmInfo.HandleTabbedNoteBook(outlinendx, ctrlndx : integer);
var
  TabbedNoteBook : tTabbedNoteBook;
  pageptr : Pointer;  {tTabpage}
  dum,lc,mc   : Integer;

Begin
   TabbedNoteBook := tTabbedNoteBook(Parent.Components[ctrlndx]);
   with TabbedNoteBook do begin
        mc := pred(pages.count);
        for lc := 0 to mc do begin
            pageptr := pointer(pages.objects[lc]);
            dum := AddNode(FrmInfo.OutlineParent,outlinendx,twincontrol(pageptr),'TTABBEDNOTEBOOK',true);
            AddControlsForParent(dum, pageptr);
        end;
   end;
End;

Procedure tCybFrmInfo.HandleNoteBook(outlinendx, ctrlndx : integer);
var
   NoteBook : tNoteBook;
  pageptr : Pointer;  {tTabpage}
  dum,lc,mc   : Integer;

Begin
   NoteBook := tNoteBook(Parent.Components[ctrlndx]);
   with NoteBook do begin
        mc := pred(pages.count);
        for lc := 0 to mc do begin
            pageptr := pointer(pages.objects[lc]);
            dum := AddNode(FrmInfo.OutlineParent,outlinendx,twincontrol(pageptr),'TNOTEBOOK',true);
            AddControlsForParent(dum, pageptr);
        end;
   end;
End;

function tCybFrmInfo.NodeID(ctrl : twincontrol) : string;

Begin
  with ctrl do begin
    result := name+' : '+classname+';';
  end;
End;


FUNCTION tCybFrmInfo.AddNode(addoutline : toutline; outlinendx : integer;
                    ctrl : twincontrol; bmpname : string;addaschild : boolean) : integer;
var
   pbmp : tbitmap;
   pc : pchar;
   ni : string;

Begin
{  pbmp := tbitmap.create;
  pc := stralloc(80);
  strpcopy( pc ,uppercase(bmpname));
  pbmp.handle := loadbitmap(HInstance, pc);
  ni := nodeid(ctrl);
  if addaschild then result := addoutline.addchildobject(outlinendx, nodeid(ctrl), pointer(pbmp))
                else result := addoutline.addobject(outlinendx, nodeid(ctrl), pointer(pbmp));
  strdispose(pc);}
  if addaschild then result := addoutline.addchild(outlinendx, nodeid(ctrl))
                else result := addoutline.add(outlinendx, nodeid(ctrl));
End;

procedure tCybFrmInfo.AllocControl(Parentindex,ndx : integer;
                               var ComponentAllocRec :tComponentAllocRec;
                                   acontrol : twincontrol);
var
  dum : integer;
begin
    inc(alloced);
    dum := AddNode(FrmInfo.OutlineParent,Parentindex,acontrol,acontrol.classname,true);
    ComponentAllocRec.allocated := true;
    fwincontrolist[ndx] := pointer(ComponentAllocRec);
    if (acontrol is tnotebook) then HandleNoteBook(dum,ComponentAllocRec.posn);
    if (acontrol is ttabbednotebook) then HandleTabbedNoteBook(dum,ComponentAllocRec.posn);
end;


Procedure tCybFrmInfo.AddControlsForParent ( Parentindex :integer; SearchParent : tWinControl);
Var
   lc,mc   : Integer;
   lControl : twinControl;
   ComponentAllocRec :tComponentAllocRec;
   dp : pointer;

Begin
     mc := pred(fwincontrolist.Count);
     For lc := 0 to mc Do begin
       dp := fwincontrolist[lc];
       ComponentAllocRec := tComponentAllocRec(dp);
       if not(ComponentAllocRec.allocated) then begin
         lcontrol := twincontrol(Parent.Components[ComponentAllocRec.posn]);
         if (lcontrol.parent = SearchParent) then AllocControl(Parentindex,lc, ComponentAllocRec, lcontrol);
       end;
     end;
End;

Procedure tCybFrmInfo.DoWinControls;
var
   iterations, dum,lc,mc   : Integer;
   done : boolean;
   ComponentAllocRec :tComponentAllocRec;
   lcontrol : twincontrol;
   dp : pointer;

const
  maxiterate : integer = 10;

Begin
  if not(oktoproceed) then exit;
  dum := AddNode(FrmInfo.OutlineParent,0,Parent,Parent.classname,false);
  AddControlsForParent ( dum, parent);
  mc := pred(fwincontrolist.count);
  lc := 0;
  iterations := 0;
  repeat
     dp := fwincontrolist[lc];
     ComponentAllocRec := tComponentAllocRec(dp);
     if not(ComponentAllocRec.allocated) then begin
           lcontrol := twincontrol(Parent.Components[ComponentAllocRec.posn]);
           dum := FrmInfo.OutlineParent.gettextitem(nodeid(lcontrol.parent));
           if (dum <> 0) then AllocControl(dum, lc, ComponentAllocRec, lcontrol);
     end;
     inc(lc);
     done := (alloced = mc);
     if (lc = mc) and not(done) then begin
       lc := 0;
       inc(iterations);
     end;
     done := done or (iterations = maxiterate);
  until done;
  if (iterations = maxiterate) then showmessage('WinControls unallocated after '+inttostr(maxiterate)+' iterations');
End;


Procedure tCybFrmInfo.categorisecontrols;
var
   dum,lc,mc   : Integer;
   ComponentAllocRec :tComponentAllocRec;
   tp : pointer;

Begin
 if not(oktoproceed) then exit;
 fwincontrolist.clear;
 With Parent do begin
    mc := pred(ComponentCount);
    For lc := 0 to mc do begin
       If (Components[lc] is twinControl) and (Components[lc] <> self) then begin
          with ComponentAllocRec do begin
               posn:= lc;
               spare := 0;
               allocated := false;
          end;
          tp := pointer(ComponentAllocRec);
          fwincontrolist.add(tp);
       End;
    end;   {for}
 end;{with}
End;{proc}

end.
