unit Secur;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,  DB, DBSecur, ExtCtrls, DBCtrls, Grids,
  DBTables,  qu_sec, DBGrids;

type
  TfrmTestSecurity = class(TForm)
    DBNavigator1: TDBNavigator;
    dbsecSA: TDBSecurity;
    dbSA: TDatabase;
    qryCustomers: TSecurityQuery;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    procedure dbsecSALoadTableSecurity(Sender: TObject);
    procedure dbsecSALoadColumnSecurity(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmTestSecurity: TfrmTestSecurity;

implementation

{$R *.DFM}

procedure TfrmTestSecurity.dbsecSALoadTableSecurity(Sender: TObject);
var MyQuery : TQuery;
   MySecurity : TDBSecurity;
begin
   MyQuery := TQuery.Create(Self);
   MySecurity := (Sender as TDBSecurity);
   with MyQuery do begin
      DataBaseName := 'SA';
     sql.add('call Public.UserTablePermission(''' +MySecurity.LoggedUser+ ''')');
     open;
     first;
     while not eof do begin
     {only include the tables with select authority}
      if FieldByName('SelectAuth').AsInteger = 1 then
         MySecurity.InsertTable(Fields[0].AsString+'.'+Fields[1].AsString,
            boolean(FieldByName('SelectAuth').AsInteger),
            boolean(FieldByName('InsertAuth').AsInteger),
            boolean(FieldByName('DeleteAuth').AsInteger),
            boolean(FieldByName('UpdateAuth').AsInteger),
            boolean(FieldByName('UpdateCols').AsInteger));
      next;
     end;  {while not eof}
     close;
   end;
   MyQuery.free;
end;

procedure TfrmTestSecurity.dbsecSALoadColumnSecurity(Sender: TObject);
var MyQuery : TQuery;
   MySecurity : TDBSecurity;
begin
   MyQuery := TQuery.Create(Self);
   MySecurity := (Sender as TDBSecurity);
   with MyQuery do begin
      DataBaseName := 'SA';
     sql.add('call Public.UserColumnPermission(''' +MySecurity.LoggedUser+ ''')');
     open;
     first;
     while not eof do begin
         MySecurity.InsertColumn(Fields[0].AsString);
         next;
     end;
     close;
   end;
   MyQuery.free;
end;

procedure TfrmTestSecurity.FormActivate(Sender: TObject);
begin
   try
      qryCustomers.open;
   except
   end;
end;

end.
