unit CRCDemo;

{Simple demo program for the TChecksum component.
 For details see CHECKSUM.WRI.}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Checksum, StdCtrls, ExtCtrls, FileCtrl;

type
  TCRCForm = class(TForm)
    Button1: TButton;
    FileListBox1: TFileListBox;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    Bevel1: TBevel;
    Label1: TLabel;
    Checksum1: TChecksum;
    Label2: TLabel;
    BGPCheck: TCheckBox;
    LFNCheck: TCheckBox;
    procedure Button1Click(Sender: TObject);
    procedure BGPCheckClick(Sender: TObject);
    procedure LFNCheckClick(Sender: TObject);
    procedure FileListBox1DblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Checksum1FileOpenError(Sender: TObject);
    procedure Checksum1MemAllocError(Sender: TObject);
    procedure FileListBox1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  CRCForm: TCRCForm;

implementation

{$R *.DFM}

procedure TCRCForm.Button1Click(Sender: TObject);
begin
  if FileListBox1.ItemIndex > -1 then
   Label1.Caption := Checksum1.CRCFile
   (ExpandFileName(FileListBox1.Items[FileListBox1.ItemIndex]));
end;

procedure TCRCForm.BGPCheckClick(Sender: TObject);
begin
  Checksum1.Background := BGPCheck.Checked;
end;

procedure TCRCForm.LFNCheckClick(Sender: TObject);
begin
  Checksum1.UseLFNs := LFNCheck.Checked;
end;

procedure TCRCForm.FileListBox1DblClick(Sender: TObject);
begin
  Button1Click(Sender);
end;

procedure TCRCForm.FormCreate(Sender: TObject);
begin
  LFNCheck.Checked := Checksum1.UseLFNs;
  BGPCheck.Checked := Checksum1.Background;
end;

procedure TCRCForm.Checksum1FileOpenError(Sender: TObject);
begin
  ShowMessage('File open error!');
end;

procedure TCRCForm.Checksum1MemAllocError(Sender: TObject);
begin
  ShowMessage('Memory Allocation Error!');
end;

procedure TCRCForm.FileListBox1Click(Sender: TObject);
begin
  Label1.Caption := '';
end;

end.
