unit Options;
(*
    File: OPTIONS.PAS for Project COPYTEST.DPR
*)

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, SysUtils;

type
  TOptionsDlg = class(TForm)
    OKBtn: TBitBtn;
    TimeStampGroup: TRadioGroup;
    Source: TRadioButton;
    Current: TRadioButton;
    Preset: TRadioButton;
    HourBar: TScrollBar;
    MinuteBar: TScrollBar;
    HourEdit: TEdit;
    MinuteEdit: TEdit;
    DefaultBtn: TButton;
    ReadOnlyOption: TRadioGroup;
    MatchSource: TRadioButton;
    SetROon: TRadioButton;
    SetROoff: TRadioButton;
    procedure PresetClick(Sender: TObject);
    procedure SourceClick(Sender: TObject);
    procedure HourBarChange(Sender: TObject);
    procedure MinuteBarChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure UpDateHour;
    procedure UpdateMinute;
    procedure FormActivate(Sender: TObject);
    procedure DefaultBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  OptionsDlg: TOptionsDlg;

implementation

{$R *.DFM}

procedure TOptionsDlg.PresetClick(Sender: TObject);
begin
  HourBar.Enabled := True;
  MinuteBar.Enabled := True;
  HourEdit.Enabled := True;
  MinuteEdit.Enabled := True;
end;

procedure TOptionsDlg.SourceClick(Sender: TObject);
begin
  HourBar.Enabled := False;
  MinuteBar.Enabled := False;
  HourEdit.Enabled := False;
  MinuteEdit.Enabled := False;
end;

procedure TOptionsDlg.UpDateHour;
begin
  HourEdit.Text := Format('Hour: %.2d',[HourBar.Position]);
end;

procedure TOptionsDlg.UpdateMinute;
begin
  MinuteEdit.Text := Format('Minute: %.2d',[MinuteBar.Position]);
end;

procedure TOptionsDlg.HourBarChange(Sender: TObject);
begin
  UpDateHour;
end;

procedure TOptionsDlg.MinuteBarChange(Sender: TObject);
begin
  UpdateMinute;
end;

procedure TOptionsDlg.FormCreate(Sender: TObject);
begin
  HourBar.Enabled := False;
  MinuteBar.Enabled := False;
  UpDateHour;
  UpdateMinute;
end;

procedure TOptionsDlg.FormActivate(Sender: TObject);
begin
  if not Preset.Checked then
  begin
    HourEdit.Enabled := False;
    MinuteEdit.Enabled := False;
  end
end;

procedure TOptionsDlg.DefaultBtnClick(Sender: TObject);
begin
  Source.Checked := True;
  HourBar.Position := 1;
  MinuteBar.Position := 0;
  HourEdit.Enabled := False;
  MinuteEdit.Enabled := False;
  MatchSource.Checked := True;
end;

end.
