{--------------------------------------------------------------------------
                         Flickerless Sprite Animation
                                    with
                               Borland Delphi

                               Copyright 1995
                             David R. McDermitt

 This little ditty is intended to share with others the techniques I
 have learned for achieving flicker free sprite animation. These techniques
 are adapted from use of the Windows API BitBlt function, but utilize Delphi's
 encapsulation of BitBlt, CopyRect. In my experience and some very brief tests
 I have found no performance advantage in using BitBlt over CopyRect.

 I have attempted to document the code by using descriptive variable names
 wherever possible. It should be noted that it would be possible to
 accomplish the outcome of this program with fewer lines of code by doing away
 with the intermediary Rect structures, these have been included for clarity.

 Feel free to address questions, comments, praise or criticism to:
                             CIS : 73512,2101
                             AOL : drmcderm
-----------------------------------------------------------------------------}
unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, About, Menus;

type
  TfrmMain = class(TForm)
    imgBackground: TImage;
    bbtnAnimate: TBitBtn;
    imgSave: TImage;
    imgWork: TImage;
    imgSeal: TImage;
    imgMask: TImage;
    Timer1: TTimer;
    ScrollBar1: TScrollBar;
    PopupMenu1: TPopupMenu;
    About1: TMenuItem;
    procedure FormActivate(Sender: TObject);
    procedure bbtnAnimateClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;
  SpriteX : Integer;

implementation

{$R *.DFM}

procedure TfrmMain.FormActivate(Sender: TObject);
var
  DestRect : TRect;
  SourceRect : TRect;
begin
  {Save the background}
  with imgBackground do
    SourceRect := Rect(0, (imgBackground.Height - imgSave.Height),
                       imgSave.Width, imgBackground.Height);
  with imgSave do
    begin
      DestRect := Rect(0, 0, imgSave.Width, imgSave.Height);
      Canvas.CopyMode :=cmSrcCopy;
      Canvas.CopyRect(DestRect, imgBackground.Canvas, SourceRect);
    end;
  {Put up the initial image - Start with the Mask}
  with imgBackground do
    begin
      DestRect := Rect(0, (imgBackground.Height - imgWork.Height),
                       imgMask.Width, (imgBackground.Height - 4));
      SourceRect := Rect(0, 0, imgMask.Width, imgMask.Height);
      Canvas.CopyMode := cmSrcAnd;
      Canvas.CopyRect(DestRect, imgMask.Canvas, SourceRect);
                             {Finish with the image}
      Canvas.CopyMode := cmSrcPaint;
      Canvas.CopyRect(DestRect, imgSeal.Canvas, SourceRect);
    end;
  SpriteX := 0;
end;

procedure TfrmMain.bbtnAnimateClick(Sender: TObject);
begin
  Timer1.Enabled := not Timer1.Enabled;
end;

procedure TfrmMain.About1Click(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TfrmMain.Timer1Timer(Sender: TObject);
var
  SRect : TRect;
  DRect : TRect;
  SpriteInc : Integer;
  Counter : Integer;
begin
  SpriteInc := ScrollBar1.Position;
  with imgWork do
    begin
      {Get the work buffer}
      DRect := Rect(0, 0, imgWork.Width, imgWork.Height);
      SRect := Rect(SpriteX, (imgBackground.Height - imgWork.Height),
                   (SpriteX + imgWork.Width), imgBackground.Height);
      Canvas.CopyMode := cmSrcCopy;
      Canvas.CopyRect(DRect, imgBackground.Canvas, SRect);
      {Restore background to work buffer, erasing the seal}
      DRect := Rect(0, 0, imgSave.Width, imgSave.Height);
      SRect := Rect(0, 0, imgSave.Width, imgSave.Height);
      Canvas.CopyRect(DRect, imgSave.Canvas, SRect);
      {Save the new background from the work buffer}
      DRect := Rect(0, 0, imgSave.Width, imgSave.Height);
      SRect := Rect(SpriteInc, 0, (imgSave.Width + SpriteInc), imgSave.Height);
      imgSave.Canvas.CopyRect(DRect, imgWork.Canvas, SRect);
      {Pop the Mask into the work buffer}
      SRect := Rect(0, 0, imgMask.Width, imgMask.Height);
      DRect := Rect(SpriteInc, 0, (imgMask.Width + SpriteInc), imgMask.Height);
      Canvas.CopyMode := cmSrcAnd;
      Canvas.CopyRect(DRect, imgMask.Canvas, SRect);
      {Place the sprite in the mask}
      SRect := Rect(0, 0, imgMask.Width, imgMask.Height);
      DRect := Rect(SpriteInc, 0, (imgMask.Width + SpriteInc), imgMask.Height);
      Canvas.CopyMode := cmSrcPaint;
      Canvas.CopyRect(DRect, imgSeal.Canvas, SRect);
      {Place the work buffer on the screen}
      SRect := Rect(0, 0, imgWork.Width, imgWork.Height);
      DRect := Rect(SpriteX, (imgBackground.Height - imgWork.Height),
                   (SpriteX + imgWork.Width), imgBackground.Height);
      imgBackground.Canvas.CopyMode := cmSrcCopy;
      imgBackground.Canvas.CopyRect(DRect, imgWork.Canvas, SRect);
      SpriteX := SpriteX + SpriteInc;
    end;
  if SpriteX > imgBackground.Width then
    SpriteX := -(imgWork.Width);
end;

end.
