unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Grids, DBGrids, DB, DBTables, Ftable;

type
  TForm1 = class(TForm)
    Button1: TButton;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    Edit1: TEdit;
    Label1: TLabel;
    DestinationTable: TTable;
    SourceTable: TTableCopy;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  screen.cursor := crHourGlass;
  SourceTable.DisableControls;
  try
    { Close table if it is open }
    DestinationTable.Close;
    { Attempt to copy the table to the specified name in the Edit box }
    SourceTable.CopyTable(Edit1.Text);
    { Set the name to the newly created table }
    DestinationTable.TableName := Edit1.Text;
    { Open and display the table }
    DestinationTable.Open;
  except
    { If the file already exists, give the user an option to overwrite }
    on EMyDB_FileExists do
    begin
      screen.cursor := crDefault;
      if MessageDlg('Table already exists.  Overwrite', mtConfirmation,
                    [mbYes, mbNo], 0) = mrYes then
      try
        screen.cursor := crHourGlass;
        { Set the overwrite property to false so it can overwrite the table }
        SourceTable.Overwrite := True;
        { Attempt to copy the table to the specified name in the Edit box }
        SourceTable.CopyTable(Edit1.Text);
        { Set the overwrite property back to true }
        SourceTable.Overwrite := False;
        { Set the name to the newly created table }
        DestinationTable.TableName := Edit1.Text;
        { Open and display the table }
        DestinationTable.Open;
      except
        screen.cursor := crDefault;
        MessageDlg(Exception(ExceptObject).Message, mtError, [mbOk], 0);
      end;
    end
    else
    begin
      { catch all other exceptions and display the error }
      screen.cursor := crDefault;
      MessageDlg(Exception(ExceptObject).Message, mtError, [mbOk], 0);
    end;
  end;
  SourceTable.EnableControls;
  screen.cursor := crDefault;
end;

end.
