unit Ftable;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, DBTables, DbiProcs, DbiTypes, DbiErrs;

type
  { dbiCopyTable }
  EMyDBError = class(Exception);

  EMyDB_InvalidHndl = class(EMyDBError);
  EMyDB_InvalidParam = class(EMyDBError);
  EMyDB_InvalidFileName = class(EMyDBError);
  EMyDB_FileExists = class(EMyDBError);
  EMyDB_FamFileInvalid = class(EMyDBError);
  EMyDB_NoSuchTable = class(EMyDBError);
  EMyDB_NotSuffTableRights = class(EMyDBError);
  EMyDB_NotSuffFamilyRights = class(EMyDBError);
  EMyDB_Locked = class(EMyDBError);


  TTableCopy = class(TTable)
  private
    { Private declarations }
    FOverWrite: Boolean;
  protected
    { Protected declarations }
    function Chk(rslt: DbiResult): DbiResult;
  public
    { Public declarations }
    procedure CopyTable(DName: String);
  published
    { Published declarations }
    property Overwrite: Boolean read FOverwrite write FOverwrite default False;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Data Access', [TTableCopy]);
end;

procedure TTableCopy.CopyTable(DName: String);
var
 pSName: pChar;
 pDName: pChar;

begin
  pSName := nil; pDName := nil;
  { Allocate a buffers to hold the null terminated strings }
  try
    GetMem(pSName, Length(TableName) + 1);
    GetMem(pDName, Length(DName) + 1);
  except
    MessageDlg('Could not allocate memory for buffer', mtError, [mbOk], 0);
    Exit;
  end;
  { Copy table names into pchar variables that the Dbi call uses }
  StrPCopy(pSName, TableName);
  StrPCopy(pDName, DName);
  { Copy the table }
  Chk(DbiCopyTable(DBHandle, FOverwrite, pSName, nil, pDName));

  if pSName <> nil then
    FreeMem(pSName, Length(TableName) + 1);
  if pDName <> nil then
    FreeMem(pDName, Length(DName) + 1);
end;

function TTableCopy.Chk(rslt: DbiResult): DbiResult;
var
  ErrInfo: DbiErrInfo;
  ErrStr: string;
  pErr: array[0..dbiMaxMsgLen] of char;

begin
  { Only enter the error routine if an error has occured }
  if rslt <> dbiErr_None then
  begin
    { Get information on the error that occured.  ALWAYSE DO THIS FIRST!! }
    DbiGetErrorInfo(False, ErrInfo);
    if ErrInfo.iError = rslt then
    begin
      ErrStr := Format('%s  ', [ErrInfo.szErrCode]);
      if StrComp(ErrInfo.szContext[1], '') = 0 then
        ErrStr := Format('%s  %s', [ErrStr, ErrInfo.szContext[1]]);
      if StrComp(ErrInfo.szContext[2], '') = 0 then
        ErrStr := Format('%s  %s', [ErrStr, ErrInfo.szContext[2]]);
      if StrComp(ErrInfo.szContext[3], '') = 0 then
        ErrStr := Format('%s  %s', [ErrStr, ErrInfo.szContext[3]]);
      if StrComp(ErrInfo.szContext[4], '') = 0 then
        ErrStr := Format('%s  %s', [ErrStr, ErrInfo.szContext[4]]);
    end
    else
    begin
      DbiGetErrorString(rslt, pErr);
      ErrStr := StrPas(pErr);
    end;
    ErrStr := Format('Table Error: %d.  %s', [rslt, ErrStr]);

    MessageBeep(mb_IconExclamation);
    { Raise the corrisponding exception }
    case rslt of
      dbiErr_InvalidHndl:
        raise EMyDB_InvalidHndl.Create(ErrStr);
      dbiErr_InvalidParam:
        raise EMyDB_InvalidParam.Create(ErrStr);
      dbiErr_InvalidFileName:
        raise EMyDB_InvalidFileName.Create(ErrStr);
      dbiErr_FileExists:
        raise EMyDB_FileExists.Create(ErrStr);
      dbiErr_FamFileInvalid:
        raise EMyDB_FamFileInvalid.Create(ErrStr);
      dbiErr_NoSuchTable:
        raise EMyDB_NoSuchTable.Create(ErrStr);
      dbiErr_NotSuffTableRights:
        raise EMyDB_NotSuffTableRights.Create(ErrStr);
      dbiErr_NotSuffFamilyRights:
        raise EMyDB_NotSuffFamilyRights.Create(ErrStr);
      dbiErr_Locked:
        raise EMyDB_Locked.Create(ErrStr)
      else
        raise EMyDBError.Create(ErrStr);
    end;
  end;
end;



end.
