{
*-------------------------------------------------------------------------*
| file    : StrmSamp
| date    : 09-01-97
| time    : 12:29:40

This unit contains the TSample and TSampleList classes which demonstrate the
use of Containers (TCollection ect.) and the TFilter / TStreamable base classes.

*-------------------------------------------------------------------------*
}

unit StrmSamp;

interface

uses Classes, Filters, Containr;

type
  TSampleOrder = (soName, soValue);
  
  TSample = class (TStreamable)
  private
    FName: PString;
    FValue: LongInt;
  protected
    function GetName: String;
    procedure SetName(const Value: String);
  public
    constructor Create;
    constructor Load(Filter: TFilter); override;
    destructor Destroy; override;
    procedure Store(Filter: TFilter); override;
    property Name: String read GetName write SetName;
    property Value: LongInt read FValue write FValue;
  end;

  TSampleList = class (TCollection)
  private
    FSortOn: TSampleOrder;
  protected
    function Compare(Key1, Key2: Pointer): Integer; override;
    procedure SetSortOn(Value: TSampleOrder);
  public
    constructor Create;
    property SortOn: TSampleOrder read FSortOn write SetSortOn;
  end;


implementation

uses SysUtils, StrUtils, NumUtils;

{
*********************************** TSample ************************************
}
constructor TSample.Create;
  const InstanceCnt: Integer = 0;
begin
  inherited Create;
  Name := 'Default';
  Inc(InstanceCnt);
  Value := InstanceCnt;
end;

constructor TSample.Load(Filter: TFilter);
begin
  inherited Load(Filter);
  FName := NewStr(Filter.ReadStr);
  Filter.Read(FValue, SizeOf(FValue));
  { TFilter and unit FILTERS contain methods and procedure to
    load and store strings, PChars, TStrings etc from a TFilter }
end;

destructor TSample.Destroy;
begin
  DisposeStr(FName);
  inherited Destroy;
end;

function TSample.GetName: String;
begin
  Result := StringValue(FName);
end;

procedure TSample.SetName(const Value: String);
begin
  AssignStr(FName, Value);
end;

procedure TSample.Store(Filter: TFilter);
begin
  inherited Store(Filter);
  Filter.WriteStr(StringValue(FName));
  Filter.Write(FValue, SizeOf(FValue));
end;

{
********************************* TSampleList **********************************
}
constructor TSampleList.Create;
begin
  inherited Create;
  CanSort := True;
  Sorted := True;
  Duplicates := CONTAINR.dupAccept;
end;

function TSampleList.Compare(Key1, Key2: Pointer): Integer;
var
  N, V: Integer;
begin
  N := CompareText(TSample(Key1).Name, TSample(Key2).Name);
  V := CompareInt(TSample(Key1).Value, TSample(Key2).Value);
  if FSortOn = soName then
    if N <> 0 then
      Result := N
    else
      Result := V
  else
    if V <> 0 then
      Result := V
    else
      Result := N;
end;

procedure TSampleList.SetSortOn(Value: TSampleOrder);
begin
  if FSortOn <> Value then
  begin
    FSortOn := Value;
    { Since we changed the sorting conditions we need to re-sort the
      collection. Toggling Sorted will do this }
    Sorted := False;
    Sorted := True;
  end;
end;


initialization
  RegisterStreamable(TSample);
  RegisterStreamable(TSampleList);
end.

