unit Mainfrm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, ExtCtrls, StdCtrls, Menus, StrmSamp;

type
  TMainForm = class(TForm)
    ListBox: TListBox;
    Toolbar: TPanel;
    AddBtn: TSpeedButton;
    EditBtn: TSpeedButton;
    DelBtn: TSpeedButton;
    OpenBtn: TSpeedButton;
    SaveBtn: TSpeedButton;
    NewBtn: TSpeedButton;
    MainMenu: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    New1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Edit1: TMenuItem;
    Add1: TMenuItem;
    Change1: TMenuItem;
    Delete1: TMenuItem;
    SortNameBtn: TSpeedButton;
    SortValueBtn: TSpeedButton;
    Header: THeader;
    SaveDialog: TSaveDialog;
    OpenDialog: TOpenDialog;
    procedure FormCreate(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure ListBoxDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure HeaderSized(Sender: TObject; ASection, AWidth: Integer);
    procedure EditBtnClick(Sender: TObject);
    procedure SamplesChange(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure DelBtnClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SortOnChange(Sender: TObject);
    procedure NewBtnClick(Sender: TObject);
    procedure OpenBtnClick(Sender: TObject);
    procedure SaveBtnClick(Sender: TObject);
  private
    FSamples: TSampleList;
    function EditSample(Sample: TSample): Boolean;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses EditFrm, Filters;

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  { fix up scaling problems }
  Font.Size := Font.Size;
  { create a 'long term' collection which will contain our samples.
    Note TSampleList sets OwnesItems := True in it's constructor }
  FSamples := TSampleList.Create;
  { wire the OnChange event to synchronize the GUI with the sample list }
  FSamples.OnChange := SamplesChange;
end;

function TMainForm.EditSample(Sample: TSample): Boolean;
begin
  SampleForm.Sample := Sample;
  Result := SampleForm.Execute;
end;

procedure TMainForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.ListBoxDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var Sample: TSample;
begin
  { use owner draw style to draw sample on listboxes canvas, note that
    the ListBox.Items property is ignored }
  with ListBox.Canvas do
  begin
    Sample := FSamples[Index];
    FillRect(Rect);
    TextOut(Rect.Left + 2, Rect.Top, Sample.Name);
    Inc(Rect.Left, Header.SectionWidth[0]);
    FillRect(Rect);
    TextOut(Rect.Left + 2, Rect.Top, IntToStr(Sample.Value));
  end;
end;

procedure TMainForm.HeaderSized(Sender: TObject; ASection,
  AWidth: Integer);
begin
  ListBox.Invalidate;
end;

procedure TMainForm.EditBtnClick(Sender: TObject);
var Idx: Integer;
begin
  Idx := ListBox.ItemIndex;
  if EditSample(FSamples[Idx]) then
  { put back the edited and maybe changed sample, this will re-order it
    and notify the GUI through OnChange }
    FSamples[Idx] := FSamples[Idx];
end;

procedure TMainForm.SamplesChange(Sender: TObject);
var I: Integer;
begin
  ListBox.Items.BeginUpdate;
  try
    { Synchronize listbox.items with number of items in list, simply
      add an empty string to the listbox. routine could be optimized
      e.g. by using a listbox which does not store it's strings
      or using the Delphi 2.0 ListViewer class }
    ListBox.Items.Clear;
    for I := 0 to FSamples.Count - 1 do
      ListBox.Items.Add('');
  finally
    ListBox.Items.EndUpdate;
  end;
end;

procedure TMainForm.AddBtnClick(Sender: TObject);
var Sample: TSample;
begin
  { Create a sample, if the user cancel the operation, free it again }
  Sample := TSample.Create;
  if EditSample(Sample) then
    { this will add sample to FSamples and also dispatch OnChange }
    FSamples.Add(Sample)
  else
    Sample.Free;
end;

procedure TMainForm.DelBtnClick(Sender: TObject);
begin
  { Since FSample owns it's items, the TSample at Index is also free-ed }
  FSamples.Delete(ListBox.ItemIndex);
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  { do not forget to clean - up }
  FSamples.Free;
end;

procedure TMainForm.SortOnChange(Sender: TObject);
begin
  { See TSampleList.Compare for SortOn property }
  if SortNameBtn.Down then FSamples.SortOn := soName else FSamples.SortOn := soValue;
end;

procedure TMainForm.NewBtnClick(Sender: TObject);
begin
  { Just free the samples, not the sample list }
  FSamples.Clear;
end;

procedure TMainForm.OpenBtnClick(Sender: TObject);
var F: TFilter;
    Temp: TSampleList;
begin
  if OpenDialog.Execute then
  begin
    { TBufFileStream is a TFilter descendant which owns a TFileStream and
      buffers it's IO. You need to pass the buf size as additional parameter }
    F := TBufFileStream.Create(OpenDialog.FileName, fmOpenRead, 4096);
    try
      { This is the famous F.Get call. F.Get will read a TStreamable from Filter
        therefore typecast it to TSampleList. See TSample.Load, TContainer.Load etc. }
      Temp := F.Get as TSampleList;
      if Assigned(Temp) then
      begin
        { free old list, which ownes it's sample instances }
        FSamples.Free;
        { now assign loaded samples to FSamples }
        FSamples := Temp;
        { assign the event handler again }
        FSamples.OnChange := SamplesChange;
        { we have manually switched samples, so notify GUI }
        SamplesChange(Self);
        { list always loaded as sorted on name }
        SortnameBtn.Down := True;
      end;
    finally
      { since the BufFileStream filter owns it's base stream. it will automatically
        free it's filestream }
      F.Free;
    end;
  end;
end;

procedure TMainForm.SaveBtnClick(Sender: TObject);
var F: TFilter;
begin
  if SaveDialog.Execute then
  begin
    F := TBufFileStream.Create(SaveDialog.FileName, fmCreate, 4096);
    try
      { This is the famous Filter.Put method, which will
        write a TStreamable descendant to F, See TSample.Store, TContainer.Store etc. }
      F.Put(FSamples);
    finally
      F.Free;
    end;
  end;
end;

end.
