unit EDITFRM;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  StdCtrls, ExtCtrls, Forms, Buttons, Spin, StrmSamp;

type
  TSampleForm = class (TForm)
    Bevel1: TBevel;
    CancelBtn: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    SampleNameEdit: TEdit;
    OKBtn: TBitBtn;
    ValueEdit: TSpinEdit;
    procedure FormCreate(Sender: TObject);
  private
    FSample: TSample;
  protected
    function GetSampleName: String;
    function GetValue: LongInt;
    procedure SetSampleName(Value: String);
    procedure SetSample(AValue: TSample);
    procedure SetValue(Value: LongInt);
  public
    function Execute: Boolean;
    property SampleName: String read GetSampleName write SetSampleName;
    property Sample: TSample read FSample write SetSample;
    property Value: LongInt read GetValue write SetValue;
  end;



var
  SampleForm: TSampleForm;

implementation

uses
  NumUtils;

{$R *.DFM}


{
********************************* TSampleForm **********************************
}
function TSampleForm.Execute: Boolean;
begin
  Result := (ShowModal = mrOk) and Assigned(FSample);
  if Result then
  begin
    FSample.Name := SampleName;
    FSample.Value := Value;
  end;
end;

function TSampleForm.GetSampleName: String;
begin
  Result := SampleNameEdit.Text;
end;

function TSampleForm.GetValue: LongInt;
begin
  Result := ValueEdit.Value;
end;

procedure TSampleForm.SetSampleName(Value: String);
begin
  SampleNameEdit.Text := Value;
end;

procedure TSampleForm.SetSample(AValue: TSample);
begin
  FSample := AValue;
  if Assigned(FSample) then
  begin
    SampleName := FSample.Name;
    Value := FSample.Value;
  end;
end;

procedure TSampleForm.SetValue(Value: LongInt);
begin
  ValueEdit.Value := Value;
end;

procedure TSampleForm.FormCreate(Sender: TObject);
begin
  Font.Size := Font.Size;
end;

end.
