unit Unit1;

interface

uses WinTypes, WinProcs, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Console, ExtCtrls, dialogs, typinfo;

type
  TForm1 = class(TForm)
    Colors: TButton;
    Fonts: TButton;
    Size: TEdit;
    LazyWrite: TCheckBox;
    Clear: TButton;
    P1: TPanel;
    L1: TLabel;
    Terminal1: TColorConsole;
    procedure ShowTestPattern(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ClearClick(Sender: TObject);
    procedure ColorsClick(Sender: TObject);
    procedure LazyWriteClick(Sender: TObject);
    procedure SizeLostFocus(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ShowTestPattern(Sender: TObject);
var
  T: TTextMetric;
  X: Integer;
  Norm, Test: TFont;
begin
  Terminal1.Font.Name := 'Courier New';
  Norm := TFont.Create;
  Norm.Assign(Terminal1.Font);
  Test := TFont.Create;
  Cursor := crHourGlass;
  try
    Terminal1.Font.BkColor := clBlue;
    writeln('Name':22,'Ave':5,'Max':5,'Ovr':5);
    for X := 0 to Screen.Fonts.Count - 1 do
    with Terminal1 do
    try
      Font.Assign(Norm);
      Font.Name := Screen.Fonts[x];   { Exceptions }
      Test.Assign(Font);
      Canvas.Font := Test;
      GetTextMetrics(Canvas.Handle, T);
      Font.Assign(Norm);
      Font.BkColor := clBlue;
      write(Screen.Fonts[x]:22,T.tmAveCharWidth:5,
            T.tmMaxCharWidth:5,T.tmOverhang:5);
      Font.Assign(Test);
      Font.BkColor := clBlack;
      write('This is some sample text. T');
      Font.Assign(Norm);
      Font.BkColor := clBlue;
      writeln('T');

      Test.Style := [fsBold];
      Canvas.Font := Test;
      GetTextMetrics(Canvas.Handle, T);
      write(Screen.Fonts[x]:22,T.tmAveCharWidth:5,
            T.tmMaxCharWidth:5,T.tmOverhang:5);
      Font.Assign(Test);
      Font.BkColor := clBlack;
      write('This is some sample text. T');
      Font.Assign(Norm);
      Font.BkColor := clBlue;
      writeln('T');

      Test.Style := [fsItalic];
      Canvas.Font := Test;
      GetTextMetrics(Canvas.Handle, T);
      write(Screen.Fonts[x]:22,T.tmAveCharWidth:5,
            T.tmMaxCharWidth:5,T.tmOverhang:5);
      Font.Assign(Test);
      Font.BkColor := clBlack;
      write('This is some sample text. T');
      Font.Assign(Norm);
      Font.BkColor := clBlue;
      writeln('T');
    except
      on EInvalidFont do ;  { nothing }
    end;
  finally
    Terminal1.Font.Assign(Norm);
    Terminal1.Font.BkColor := clBlue;
    Norm.Free;
    Test.Free;
    Cursor := crDefault;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  P: Pointer;
begin
  Size.Text := IntToStr(Terminal1.Font.Size);
  LazyWrite.Checked := coLazyWrite in Terminal1.Options;
  writeln('TColorTerminal demo');
end;

procedure TForm1.ClearClick(Sender: TObject);
begin
  Terminal1.ClrScr;
end;

procedure TForm1.ColorsClick(Sender: TObject);
const
  Colors: array [1..8] of TColor =
    (clBlack, clBlue, clGreen, clRed, clYellow, clAqua, clFuchsia, clWhite);
  ColorNames: array [1..8] of String[7] =
    ('Black','Blue','Green','Red','Yellow','Aqua','Fuchsia','White');
var
  X, Y: Integer;
begin
  with Terminal1 do
  try
    Cursor := crHourGlass;
    Font.Name := 'Courier New';
    Font.Color := clYellow;
    Font.BkColor := clBlue;
    writeln('Courier New');
    write('This is a sample of ');
    Font.Color := clRed;
    write('multi');
    Font.Color := clLime;
    write('-');
    Font.Color := clAqua;
    write('color');
    Font.BkColor := clFuchsia;
    writeln(' text.');
    for X := 1 to 8 do
    begin
      Font.Color := Colors[x];
      for Y := 1 to 8 do
      begin
        Font.BkColor := Colors[Y];
        if Odd(X+Y) then
        begin
          Font.Style := [fsBold];
          write('Bold ');
        end;
        write(ColorNames[X],' on ',ColorNames[Y]);
        Font.Style := [];
        if Y = 4 then Writeln;
      end;
      writeln;
    end;
    Font.BkColor := clBlue;
    Font.Color := clYellow;
    Font.Style := [];
  finally
    Cursor := crDefault;
  end;
end;

procedure TForm1.LazyWriteClick(Sender: TObject);
begin
  if LazyWrite.Checked then
    Terminal1.Options := Terminal1.Options + [coLazyWrite]
  else
    Terminal1.Options := Terminal1.Options - [coLazyWrite];
end;

procedure TForm1.SizeLostFocus(Sender: TObject);
begin
  Terminal1.Font.Size := StrToInt(Size.Text);
end;

end.
