unit Hello;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,compound, StdCtrls;

type
(*
   To create a component that works inside the IDE use TForm here.
   To create a component that does not work in the IDE use TCompoundForm here
*)
  THelloForm = class(TForm)
    Label1: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  end;


  (*
  // This is the actual compound component. We have to create a FForm variable
  // and the GetForm member function, that returns the form. GetForm will be called
  // by the creator to "move" all the controls to the panel.
  // We can use the form property ourselfs to access the members stored in the
  // THelloForm.
*)
  THelloPanel = class(TCompountPanel)
  private
     FForm : THelloForm;
     procedure SetText(value : string);
     function GetText : string;
  public
    Constructor Create(AOwner : TComponent ); override;
     property form : THelloForm read FForm;
  published
     property Text : string read GetText write SetText;
  end;

  THelloGroupBox = class(TCompountGroupBox)
  private
     FForm : THelloForm;
  public
    Constructor Create(AOwner : TComponent ); override;
     property form : THelloForm read FForm;

  end;

  THelloScrollBox = class(TCompountScrollBox)
  private
     FForm : THelloForm;
  public
    Constructor Create(AOwner : TComponent ); override;
     property form : THelloForm read FForm;

  end;

var
  HelloForm: THelloForm;  (* // Not used, except by Delphis Form editor *)


procedure Register;

implementation

{$R *.DFM}

(*
// ------------------------------------------------------------------------
// constructor THello Create(AOwner : TComponent )
// Created : Thomas Quester 05.07.98
//
// Parameters:
// AOwner :
// ------------------------------------------------------------------------
*)
Constructor THelloScrollBox.Create(AOwner : TComponent );
begin
  inherited Create(AOwner);
  FForm := MoveControls(THelloForm.Create(NIL));
end;

procedure THelloPanel.SetText(value : string);
begin
  if form <> NIL then form.Label1.caption := value;
end;

function THelloPanel.GetText : string;
begin
  if form <> NIL then  result := form.label1.caption
             else result := 'form is nil';
end;



Constructor THelloGroupBox.Create(AOwner : TComponent );
begin
  inherited Create(AOwner);
  FForm := MoveControls(THelloForm.Create(NIL));
end;

Constructor THelloPanel.Create(AOwner : TComponent );
begin
  inherited Create(AOwner);
  FForm := MoveControls(THelloForm.Create(NIL));
end;

(*
// -----------------------------------------------------------------------------
// the forms procedures start here:
// -----------------------------------------------------------------------------
*)

procedure THelloForm.Button1Click(Sender: TObject);
var s : string;
    buf : array[0..255] of char;
    i   : integer;
begin
   s := 'hello '+edit1.text;
   for i := 1 to length(s) do buf[i-1] := s[i];
   buf[length(s)] := chr(0);
  Application.MessageBox(buf,'Welcome',MB_OK);
end;
procedure Register;
begin
   RegisterComponents('Compound Example',[THelloScrollBox,THelloPanel,THelloGroupBox]);
end;

end.










