(*******************************************************************************
**
**  COMCHEK
**
**  Test code written to return which COM ports are available from windows.
**
**  Originally written by Andy Strong - Compuserve ID   : 100716,3015
**                                      Internet Address: andrews@nbaqsl.co.uk
**
**  Released into the public domain 24/11/95
**
**  Controls:
**  This code may be used, modified, included in applications without any
**  license agreements as long as the disclaimers are accepted, and the
**  comments are left intact ( Some Hope! <g> ),
**
**  Disclaimer:
**  This software is released into the public domain on the strict understanding
**  that neither myself nor any associates or companies I work for have any
**  liability explictly or implied.
**
*******************************************************************************)
unit Comchek;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ListBox1: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    function GetComAvailable: byte;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
  ComAvail: byte;
begin
  ComAvail := GetComAvailable;
  ListBox1.Clear;               { Clear out old settings }
  if (ComAvail AND 1) = 1 then
    ListBox1.Items.Add('COM1 available');
  if (ComAvail AND 2) = 2 then
    ListBox1.Items.Add('COM2 available');
  if (ComAvail AND 4) = 4 then
    ListBox1.Items.Add('COM3 available');
  if (ComAvail AND 8) = 8 then
    ListBox1.Items.Add('COM4 available');

  Label1.Caption := 'Return Value: '+IntToStr(ComAvail);
end;

function TForm1.GetComAvailable: byte; assembler;
const
  BiosSeg = $0040;
  DPMIInt = $31;
  SegSel = $02;
  Com1Off = 0;
  Com2Off = 2;
  Com3Off = 4;
  Com4Off = 6;
(*
**  Routine to return a 4-bit pattern to determine which COM ports are available
**  for use as far as Windows was concerned at startup.  I.E any device drivers
**  loaded at windows boot time which lock a COM port (eg mouse driver) will be
**  invisible to this routine.
**  Bit set means COM port available, unset means not available.
**  bit    8    4    2    1
**       COM4 COM3 COM2 COM1
**  E.G. If COM1 and COM3 are available, then 5 would be returned (0101)
**  INT 31h Sub finction 02h is a Windows DPMI call to convert the passed segment
**  address (0040 - The PC's Bios storage segment) to a DPMI selector handle.
**  This enables us to read the Windows copy of the PC's hardware configuration.
**  At address 0040:0000 is the port address of COM1.
**  At address 0040:0002 is the port address of COM2.
**  At address 0040:0004 is the port address of COM3.
**  At address 0040:0006 is the port address of COM4.
**  If Windows knows that a particular COM port is in use, it will return 0 for
**  the port address when read.
**  Routine relies on the fact that a compare sets the Carry flag if true, then
**  rotates the carry into bit zero of the DX register.
**  Watch out for the fact that the port address is zero if not available,
**  and DI (the offset) is also zero.  The routine uses the fact that DI is zero
**  to check for a returned port address as being zero.
*)
asm
  push es                     { Save Extra Segment register }
  mov ax,SegSel               { DPMI Subfunction to convert SEG to SELECTOR }
  mov bx,BiosSeg              { BIOS Segment }
  int DPMIInt                 { DPMI Interupt }
  mov dx,0                    { Set COM port bits to zero }
  jc  @Error                  { If DPMI Call failed return no COM ports available }
  mov es,ax                   { Put Selector returned in ES register }
  mov di,0                    { SET offset to ZERO ES:DI -> 00040:0000 }
  cmp di,es:[di+Com4Off]      { Compare COM4 port address with zero }
  rcl dx,1                    { Put Carry in BIT zero of DX }
  cmp di,es:[di+Com3Off]      { Compare COM3 port address with zero }
  rcl dx,1                    { Put Carry in BIT zero of DX }
  cmp di,es:[di+Com2Off]      { Compare COM2 port address with zero }
  rcl dx,1                    { Put Carry in BIT zero of DX }
  cmp di,es:[di+Com1Off]      { Compare COM1 port address with zero }
  rcl dx,1                    { Put Carry in BIT zero of DX }
@Error:
  mov ax,dx                   { Return DL to the Result byte (DH = 0)}
  pop es                      { Restore Extra Segment Register }
end;

end.
